/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.io.IOException;
import java.io.InputStream;
import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassModel;
import java.lang.classfile.Superclass;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.FileStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.Builder;
import org.xvm.javajit.ModuleLoader;
import org.xvm.javajit.TypeSystem;
import org.xvm.javajit.Xvm;
import org.xvm.javajit.builders.AugmentingBuilder;
import org.xvm.javajit.builders.BoolBuilder;
import org.xvm.javajit.builders.Int64Builder;
import org.xvm.javajit.builders.StringBuilder;
import org.xvm.util.Auto;
import org.xvm.util.Handy;

public class NativeTypeSystem
extends TypeSystem {
    private final ClassLoader bridgeLoader;
    public final Map<TypeConstant, String> nativeByType = new ConcurrentHashMap<TypeConstant, String>();
    public final Map<String, TypeConstant> nativeByName = new ConcurrentHashMap<String, TypeConstant>();
    public final Map<TypeConstant, Class> nativeBuilders = new ConcurrentHashMap<TypeConstant, Class>();

    private NativeTypeSystem(Xvm xvm, ModuleLoader[] shared, ModuleStructure[] owned) {
        super(xvm, shared, owned);
        URL javatoolsURL = ConstantPool.class.getProtectionDomain().getCodeSource().getLocation();
        Path javatoolsPath = Paths.get(javatoolsURL.getPath(), new String[0]);
        Path bridgePath = Files.isDirectory(javatoolsPath, new LinkOption[0]) ? Paths.get(javatoolsPath.toString().replace("javatools", "javatools_jitbridge"), new String[0]) : javatoolsPath.resolveSibling("javatools-jitbridge.jar");
        try {
            this.bridgeLoader = new URLClassLoader(new URL[]{bridgePath.toUri().toURL()});
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid path: " + String.valueOf(bridgePath));
        }
        this.registerNativeClasses();
    }

    static NativeTypeSystem create(Xvm xvm, ModuleRepository repo) {
        Handy.require("xvm", xvm);
        Handy.require("repo", repo);
        ModuleStructure ecstasy = repo.loadModule("ecstasy.xtclang.org");
        ModuleStructure turtle = repo.loadModule("mack.xtclang.org");
        ModuleStructure _native = repo.loadModule("_native.xtclang.org");
        if (ecstasy == null || turtle == null || _native == null) {
            throw new IllegalStateException("missing core module");
        }
        if (!(ecstasy.isRefined() && turtle.isRefined() && _native.isRefined())) {
            throw new IllegalStateException("unrefined core module");
        }
        FileStructure fs = new FileStructure(ecstasy, true);
        fs.merge(turtle, true, false);
        fs.merge(_native, true, false);
        ModuleConstant missing = fs.linkModules(repo, true);
        if (missing != null) {
            throw new IllegalStateException("missing core module: " + missing.getName());
        }
        ConstantPool pool = fs.getConstantPool();
        try (Auto ignore = ConstantPool.withPool(pool);){
            if (pool.getNakedRefType() == null) {
                turtle = fs.getChild("mack.xtclang.org");
                ClassStructure clzNakedRef = (ClassStructure)turtle.getChild("NakedRef");
                pool.setNakedRefType(clzNakedRef.getFormalType());
            }
        }
        ArrayList<? extends ModuleStructure> list = new ArrayList<ModuleStructure>(fs.children());
        list.sort(Xvm.StructureByModuleId);
        ModuleLoader[] shared = new ModuleLoader[]{};
        ModuleStructure[] owned = list.toArray(new ModuleStructure[0]);
        return new NativeTypeSystem(xvm, shared, owned);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] genClass(ModuleLoader moduleLoader, String name) {
        String className = moduleLoader.prefix + name;
        String classPath = className.replace('.', '/') + ".class";
        try (InputStream in = this.bridgeLoader.getResourceAsStream(classPath);){
            if (in == null) return super.genClass(moduleLoader, name);
            byte[] classBytes = in.readAllBytes();
            String simpleName = name.substring(name.lastIndexOf(46) + 1);
            if (simpleName.startsWith("x")) {
                byte[] byArray = classBytes;
                return byArray;
            }
            ClassModel model = ClassFile.of().parse(classBytes);
            String path = className.substring(moduleLoader.prefix.length()).replace('$', '.');
            ClassStructure struct = (ClassStructure)moduleLoader.module.getChildByPath(path);
            if (struct == null) {
                throw new RuntimeException("Structure is missing for " + moduleLoader.prefix + name);
            }
            byte[] byArray = this.augmentNativeClass(model, className, struct.getCanonicalType());
            return byArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.genClass(moduleLoader, name);
    }

    private byte[] augmentNativeClass(ClassModel model, String className, TypeConstant type) {
        Builder builder = this.ensureBuilder(type, model);
        return ClassFile.of().transformClass(model, (classBuilder, element) -> {
            classBuilder.with(element);
            if (element instanceof Superclass) {
                builder.assembleImpl(className, (ClassBuilder)classBuilder);
            }
        });
    }

    protected Builder ensureBuilder(TypeConstant type, ClassModel model) {
        assert (model != null);
        Class clazz = this.nativeBuilders.get(type);
        if (clazz instanceof Class) {
            Class builderClass = clazz;
            try {
                return (Builder)builderClass.getDeclaredConstructor(TypeSystem.class, TypeConstant.class, ClassModel.class).newInstance(this, type, model);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new AugmentingBuilder(this, type, model);
    }

    private void registerNativeClasses() {
        ConstantPool pool = this.pool();
        this.nativeByType.put(pool.typeModule(), "org.xtclang.ecstasy.xModule");
        this.nativeByType.put(pool.typeObject(), "org.xtclang.ecstasy.xObj");
        this.nativeByType.put(pool.typeService(), "org.xtclang.ecstasy.xService");
        this.nativeByType.put(pool.typeType(), "org.xtclang.ecstasy.xType");
        for (Map.Entry<TypeConstant, String> entry : this.nativeByType.entrySet()) {
            this.nativeByName.put(entry.getValue(), entry.getKey());
        }
        this.nativeBuilders.put(pool.typeBoolean(), BoolBuilder.class);
        this.nativeBuilders.put(pool.typeInt64(), Int64Builder.class);
        this.nativeBuilders.put(pool.typeModule(), AugmentingBuilder.class);
        this.nativeBuilders.put(pool.typeObject(), AugmentingBuilder.class);
        this.nativeBuilders.put(pool.typeService(), AugmentingBuilder.class);
        this.nativeBuilders.put(pool.typeString(), StringBuilder.class);
        this.xvm.createUniqueSuffix("");
        String f0 = this.ensureJitClassName(pool.buildFunctionType(TypeConstant.NO_TYPES, TypeConstant.NO_TYPES));
        assert (f0.equals("org.xtclang.ecstasy.xFunction$$0"));
    }
}

