/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.util.Iterator;
import java.util.List;
import org.xvm.asm.Version;
import org.xvm.asm.VersionTree;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.util.Handy;

public class Refiner {
    public static final Refiner DefaultRefiner = new Refiner();

    public Version whichVersion(ModuleConstant module, VersionTree versions, List<Version> prefs) {
        Handy.require("module", module);
        Handy.require("versions", versions);
        Handy.require("prefs", prefs);
        Version ver2 = versions.findHighestVersion();
        if (ver2.isGARelease()) {
            return ver2;
        }
        Version[] best = new Version[6];
        Iterator<Version> iter = versions.iterator();
        while (iter.hasNext()) {
            best[-ver2.getReleaseCategory()] = ver2 = iter.next();
        }
        for (Version ver2 : best) {
            if (ver2 == null) continue;
            return ver2;
        }
        throw new IllegalStateException();
    }

    public boolean shouldDefine(String name) {
        Handy.require("name", name);
        return false;
    }

    public boolean shouldUse(ModuleConstant module, boolean desired) {
        Handy.require("module", module);
        return desired;
    }
}

