/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.classfile.CodeBuilder;
import java.lang.classfile.Label;
import java.lang.classfile.TypeKind;
import org.xvm.javajit.BuildContext;

public class Scope {
    private final BuildContext bctx;
    private final CodeBuilder code;
    private Scope parent;
    public final Label startLabel;
    public final Label endLabel;
    public int startLocal;
    public int topLocal;
    public int topVar;

    public Scope(BuildContext bctx, CodeBuilder code) {
        this.bctx = bctx;
        this.code = code;
        this.startLocal = -1;
        this.topLocal = -1;
        this.topVar = -1;
        this.startLabel = code.newLabel();
        this.endLabel = code.newLabel();
    }

    private Scope(Scope parent) {
        this(parent.bctx, parent.code);
        this.parent = parent;
        this.startLocal = parent.startLocal;
        this.topLocal = parent.topLocal;
        this.topVar = parent.topVar;
    }

    public Scope enter() {
        return new Scope(this);
    }

    public int allocateLocal(int varIndex, TypeKind kind) {
        int slot;
        if (this.topLocal >= this.bctx.maxLocal || this.startLocal == -1) {
            slot = this.code.allocateLocal(kind);
            if (this.startLocal == -1) {
                this.startLocal = slot;
            }
            this.bctx.maxLocal = this.topLocal = slot + kind.slotSize();
        } else {
            slot = this.topLocal;
            this.topLocal += kind.slotSize();
            if (this.topLocal > this.bctx.maxLocal) {
                this.bctx.maxLocal = this.code.allocateLocal(TypeKind.REFERENCE) + 1;
                assert (this.bctx.maxLocal == this.topLocal);
            }
        }
        assert (this.parent == null || varIndex > this.parent.topVar);
        this.topVar = Math.max(this.topVar, varIndex);
        return slot;
    }

    public Scope exit() {
        if (this.parent == null) {
            throw new IllegalStateException();
        }
        if (this.parent.startLocal == -1) {
            this.parent.startLocal = this.parent.topLocal = this.startLocal;
        }
        this.code.labelBinding(this.endLabel);
        return this.parent;
    }
}

