/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.ClassHierarchyResolver;
import java.lang.classfile.attribute.SourceFileAttribute;
import java.lang.constant.ClassDesc;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.Builder;
import org.xvm.javajit.Linker;
import org.xvm.javajit.ModuleLoader;
import org.xvm.javajit.NativeTypeSystem;
import org.xvm.javajit.TypeSystemLoader;
import org.xvm.javajit.Xvm;
import org.xvm.javajit.builders.CommonBuilder;
import org.xvm.javajit.builders.FunctionBuilder;
import org.xvm.javajit.builders.ModuleBuilder;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;

public class TypeSystem {
    public final Xvm xvm;
    public final String name;
    public final TypeSystemLoader loader;
    public final ModuleLoader[] shared;
    public final ModuleLoader[] owned;
    protected final Map<TypeConstant, String> functionClasses = new ConcurrentHashMap<TypeConstant, String>();
    protected final Map<String, TypeConstant> functionTypes = new ConcurrentHashMap<String, TypeConstant>();
    protected final ListMap<Constant, Integer> constantsRegistry = new ListMap(1024);

    TypeSystem(Xvm xvm, ModuleLoader[] shared, ModuleStructure[] owned) {
        Handy.require("xvm", xvm);
        Handy.require("shared", shared);
        Handy.require("owned", owned);
        this.xvm = xvm;
        this.name = xvm.generateTypeSystemName(shared, owned, this instanceof NativeTypeSystem);
        this.loader = new TypeSystemLoader(this, this.name, shared, owned);
        this.shared = this.loader.shared;
        this.owned = this.loader.owned;
    }

    public ConstantPool pool() {
        return this.owned.length == 0 ? this.xvm.ecstasyPool : this.owned[0].module.getConstantPool();
    }

    public ConstantPool findOwnerPool(SignatureConstant sig) {
        ConstantPool thisPool = this.pool();
        for (ModuleLoader loader : this.shared) {
            ConstantPool thatPool = loader.module.getConstantPool();
            if (thatPool == thisPool || !sig.isShared(thatPool)) continue;
            return loader.typeSystem.findOwnerPool(sig);
        }
        assert (sig.isShared(thisPool));
        return thisPool;
    }

    public ModuleLoader findOwnerLoader(TypeConstant type) {
        ConstantPool thisPool = this.pool();
        for (ModuleLoader loader : this.shared) {
            ConstantPool thatPool = loader.module.getConstantPool();
            if (thatPool == thisPool || !type.isShared(thatPool)) continue;
            return loader.typeSystem.findOwnerLoader(type);
        }
        assert (type.isShared(thisPool));
        IdentityConstant id = type.getSingleUnderlyingClass(true);
        ModuleConstant module = id.getModuleConstant();
        for (ModuleLoader loader : this.owned) {
            if (!loader.module.getIdentityConstant().equals(module)) continue;
            return loader;
        }
        throw new IllegalStateException("No owner loader for " + String.valueOf(type));
    }

    public ModuleLoader findOwnerLoader(String name) {
        for (ModuleLoader loader : this.owned) {
            if (!name.startsWith(loader.prefix)) continue;
            return loader;
        }
        for (ModuleLoader loader : this.shared) {
            if (!name.startsWith(loader.prefix)) continue;
            return loader;
        }
        return null;
    }

    public ModuleStructure mainModule() {
        return this.owned.length == 0 ? null : this.owned[0].module;
    }

    public Linker create() {
        return this.xvm.createLinker().addSharedModules(this);
    }

    public byte[] genClass(ModuleLoader moduleLoader, String name) {
        Component component;
        String className = moduleLoader.prefix + name;
        if (className.startsWith("org.xtclang.ecstasy.xFunction")) {
            TypeConstant fnType = this.functionTypes.get(className.substring("org.xtclang.ecstasy.xFunction".length() + 1));
            assert (fnType != null);
            return ClassFile.of().build(ClassDesc.of(className), classBuilder -> new FunctionBuilder(this, fnType).assemblePure(className, (ClassBuilder)classBuilder));
        }
        Artifact art = this.deduceArtifact(moduleLoader.module, name);
        if (art != null && (component = art.id.getComponent()) instanceof ClassStructure) {
            ClassStructure clz = (ClassStructure)component;
            TypeConstant type = clz.getCanonicalType();
            Builder builder = this.ensureBuilder(type);
            Consumer<ClassBuilder> handler = classBuilder -> {
                classBuilder.with((ClassFileElement)SourceFileAttribute.of((String)clz.getSourceFileName()));
                switch (art.shape.ordinal()) {
                    case 5: {
                        builder.assembleImpl(className, (ClassBuilder)classBuilder);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            };
            ClassFile classFile = ClassFile.of((ClassFile.Option[])new ClassFile.Option[]{ClassFile.ClassHierarchyResolverOption.of((ClassHierarchyResolver)ClassHierarchyResolver.ofClassLoading((ClassLoader)this.loader)), ClassFile.ShortJumpsOption.FIX_SHORT_JUMPS});
            return classFile.build(ClassDesc.of(className), handler);
        }
        return null;
    }

    protected Builder ensureBuilder(TypeConstant type) {
        ConstantPool pool = this.pool();
        if (type.isA(pool.typeModule())) {
            assert (!type.equals(pool.typeModule()));
            return new ModuleBuilder(this, type);
        }
        return new CommonBuilder(this, type);
    }

    public Artifact deduceArtifact(ModuleStructure module, String name) {
        if (name.equals("$module")) {
            return new Artifact(module.getIdentityConstant(), ClassfileShape.Impl);
        }
        for (ClassfileShape shape : ClassfileShape.values()) {
            Component component;
            if (!name.startsWith(shape.prefix)) continue;
            if (shape != ClassfileShape.Impl) {
                name = name.substring(2);
            }
            if (!((component = module.getChildByPath(name.replace('$', '.'))) instanceof ClassStructure)) continue;
            ClassStructure struct = (ClassStructure)component;
            return new Artifact(struct.getIdentityConstant(), shape);
        }
        return null;
    }

    public Artifact deduceArtifact(ModuleStructure module, String prefix, String name) {
        return null;
    }

    public Set<ClassfileShape> expectedClassfileShape(Component component) {
        return null;
    }

    public ModuleLoader loaderForComponent(IdentityConstant id) {
        return null;
    }

    public String classfileNameForComponent(IdentityConstant id, ClassfileShape shape) {
        return null;
    }

    public String ensureJitClassName(TypeConstant type) {
        if (type.isSingleUnderlyingClass(true)) {
            if (type.isA(this.pool().typeFunction())) {
                String name = this.functionClasses.computeIfAbsent(type, t -> {
                    String suffix = t.getParamTypesArray().length == 0 ? "$0" : this.xvm.createUniqueSuffix("");
                    this.functionTypes.putIfAbsent(suffix, type);
                    return "org.xtclang.ecstasy.xFunction$" + suffix;
                });
                return name;
            }
            ConstantPool pool = this.pool();
            if (type.isTypeOfType()) {
                return pool.typeType().ensureJitClassName(this);
            }
            if (type.isA(pool.typeClass())) {
                return pool.typeClass().ensureJitClassName(this);
            }
            ClassStructure structure = (ClassStructure)type.getSingleUnderlyingClass(true).getComponent();
            List<Component.Contribution> condIncorporates = structure.collectConditionalIncorporates(type);
            TypeConstant canonicalType = condIncorporates == null ? structure.getCanonicalType() : structure.getCanonicalType();
            return canonicalType.ensureJitClassName(this);
        }
        throw new IllegalArgumentException("No JIT class for " + type.getValueString());
    }

    public synchronized int registerConstant(Constant constant) {
        ListMap<Constant, Integer> registry = this.constantsRegistry;
        Integer index = registry.get(constant);
        if (index == null) {
            int size = registry.size();
            registry.put(constant, size);
            return size;
        }
        return index;
    }

    public Constant getConstant(int index) {
        return this.constantsRegistry.entryAt(index).getKey();
    }

    public record Artifact(IdentityConstant id, ClassfileShape shape) {
    }

    public static enum ClassfileShape {
        Pure("i$"),
        Proxy("p$"),
        Duck("d$"),
        Mask("m$"),
        Future("f$"),
        Impl("");

        public final String prefix;

        private ClassfileShape(String prefix) {
            this.prefix = prefix;
        }
    }
}

