/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.util.Arrays;
import org.xvm.asm.ModuleStructure;
import org.xvm.javajit.ModuleLoader;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.Handy;

public class TypeSystemLoader
extends ClassLoader {
    public final TypeSystem typeSystem;
    public final ModuleLoader[] shared;
    public final ModuleLoader[] owned;

    TypeSystemLoader(TypeSystem typeSystem, String name, ModuleLoader[] shared, ModuleStructure[] owned) {
        super("xvm:" + name, TypeSystemLoader.class.getClassLoader());
        Handy.require("typeSystem", typeSystem);
        Handy.require("name", name);
        Handy.require("shared", shared);
        Handy.require("owned", owned);
        assert (shared.length > 0 || Arrays.stream(owned).anyMatch(m -> m.getName().equals("ecstasy.xtclang.org")));
        this.typeSystem = typeSystem;
        this.shared = shared;
        this.owned = new ModuleLoader[owned.length];
        for (int i = 0; i < owned.length; ++i) {
            this.owned[i] = typeSystem.xvm.createModuleLoader(this, owned[i]);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ModuleLoader loader : this.owned) {
            if (!name.startsWith(loader.prefix)) continue;
            return loader.findClass(name);
        }
        for (ModuleLoader loader : this.shared) {
            if (!name.startsWith(loader.prefix)) continue;
            return loader.findClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    public void dump() {
        Arrays.stream(this.owned).forEach(ModuleLoader::dump);
    }
}

