/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.javajit.Container;
import org.xvm.javajit.Injector;
import org.xvm.javajit.Linker;
import org.xvm.javajit.ModuleLoader;
import org.xvm.javajit.NativeTypeSystem;
import org.xvm.javajit.Refiner;
import org.xvm.javajit.TypeSystem;
import org.xvm.javajit.TypeSystemLoader;
import org.xvm.util.Handy;

public class Xvm {
    private static final Injector FailEverythingInjector = new Injector();
    public final ModuleRepository systemRepo;
    public final NativeTypeSystem nativeTypeSystem;
    public final Container nativeContainer;
    public final ModuleLoader ecstasyLoader;
    public final ModuleLoader bridgeLoader;
    public final ConstantPool ecstasyPool;
    private final ConcurrentHashMap<Long, WeakReference<Container>> containers = new ConcurrentHashMap();
    private final AtomicLong containerCount = new AtomicLong(-1L);
    private final ConcurrentHashMap<String, WeakReference<TypeSystem>> typeSystems = new ConcurrentHashMap();
    private int tsMapModCount;
    private final ConcurrentHashMap<String, WeakReference<ModuleLoader>> moduleLoaders = new ConcurrentHashMap();
    private int mlMapModCount;
    private final ConcurrentHashMap<String, String[]> packagesByModule = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> nameCounters = new ConcurrentHashMap();
    static final Comparator<ModuleStructure> StructureByModuleId = Comparator.comparing(ModuleStructure::getIdentityConstant);
    static final Comparator<ModuleLoader> LoaderByModuleId = Comparator.comparing(l -> l.module.getIdentityConstant());
    private final Object[] locks = new Object[61];

    public Xvm(ModuleRepository repo) {
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new Object();
        }
        this.systemRepo = repo;
        this.nativeTypeSystem = NativeTypeSystem.create(this, repo);
        this.register(this.nativeTypeSystem);
        this.nativeContainer = this.createContainer(null, this.nativeTypeSystem, FailEverythingInjector);
        ModuleLoader ecstasy = null;
        ModuleLoader _native = null;
        for (ModuleLoader loader : this.nativeTypeSystem.loader.owned) {
            if (loader.module.getName().equals("ecstasy.xtclang.org")) {
                assert (ecstasy == null);
                ecstasy = loader;
                continue;
            }
            if (!loader.module.getName().equals("_native.xtclang.org")) continue;
            assert (_native == null);
            _native = loader;
        }
        assert (ecstasy != null && _native != null);
        this.ecstasyLoader = ecstasy;
        this.bridgeLoader = _native;
        this.ecstasyPool = ecstasy.module.getConstantPool();
    }

    public Linker createLinker() {
        return new Linker(this).addSharedModule(this.ecstasyLoader);
    }

    public TypeSystem createTypeSystem(ModuleRepository repo, String module, Version ver, Refiner refiner) {
        ModuleStructure moduleStructure;
        Handy.require("module", module);
        if (repo == null) {
            repo = this.systemRepo;
        }
        return (moduleStructure = repo.loadModule(module, ver, false)) == null ? null : this.createTypeSystem(repo, moduleStructure, refiner);
    }

    public TypeSystem createTypeSystem(ModuleRepository repo, ModuleStructure module, Refiner refiner) {
        Handy.require("module", module);
        if (refiner == null) {
            refiner = Refiner.DefaultRefiner;
        }
        Linker linker = this.nativeTypeSystem.create();
        if (repo != null) {
            linker = linker.withRepo(repo);
        }
        return (linker = linker.withRefiner(refiner).withMain(module)).isBad() ? null : linker.link();
    }

    public Container createContainer(TypeSystem typeSystem, Injector injector) {
        return this.createContainer(this.nativeContainer, typeSystem, injector);
    }

    public Container getContainer(long id) {
        if (id < 0L) {
            if (id == -1L) {
                return this.nativeContainer;
            }
            throw new IllegalArgumentException("illegal container id: " + id);
        }
        WeakReference<Container> ref = this.containers.get(id);
        if (ref != null) {
            return (Container)ref.get();
        }
        return null;
    }

    public String createUniqueSuffix(String name) {
        int count = this.nameCounters.compute(name, (k, v) -> v == null ? -1 : v + 1);
        return count == -1 ? "" : "$" + count;
    }

    Container createContainer(Container parent, TypeSystem typeSystem, Injector injector) {
        assert (typeSystem != null && injector != null);
        long id = this.containerCount.getAndIncrement();
        assert (id >= 0L && parent != null || id == -1L && parent == null);
        Container container = new Container(parent, id, typeSystem, injector);
        if (this.containers.putIfAbsent(id, new WeakReference<Container>(container)) != null) {
            throw new IllegalStateException();
        }
        if ((id & 0x3FFL) == 0L) {
            this.containers.entrySet().removeIf(e -> ((WeakReference)e.getValue()).get() == null);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeSystem ensureTypeSystem(ModuleLoader[] shared, ModuleStructure[] owned) {
        assert (shared != null && owned != null);
        String moduleName = (owned.length > 0 ? owned[0] : shared[shared.length - 1].module).getName();
        shared = Handy.sorted(shared, LoaderByModuleId);
        owned = Handy.sorted(owned, StructureByModuleId);
        Object object = this.mutex(this.typeSystemKey(owned.length > 0 ? owned : this.modulesOf(shared)));
        synchronized (object) {
            String[] pkgNames = this.packagesByModule.get(moduleName);
            if (pkgNames != null) {
                for (String pkgName : pkgNames) {
                    TypeSystem ts;
                    ModuleLoader loader;
                    WeakReference<ModuleLoader> ref;
                    if (pkgName == null || (ref = this.moduleLoaders.get(pkgName)) == null || (loader = (ModuleLoader)ref.get()) == null || !loader.module.getName().equals(moduleName) || !this.sameTypeSystem(ts = loader.typeSystem, shared, owned)) continue;
                    return ts;
                }
            }
            TypeSystem ts = new TypeSystem(this, shared, owned);
            this.register(ts);
            return ts;
        }
    }

    void register(TypeSystem ts) {
        if (this.typeSystems.putIfAbsent(ts.name, new WeakReference<TypeSystem>(ts)) != null) {
            throw new IllegalStateException();
        }
    }

    String generateTypeSystemName(ModuleLoader[] shared, ModuleStructure[] owned, boolean nativeTS) {
        assert (shared != null && owned != null);
        if ((++this.tsMapModCount & 0x3FF) == 0) {
            this.typeSystems.entrySet().removeIf(e -> ((WeakReference)e.getValue()).get() == null);
        }
        if (owned.length == 0) {
            assert (shared.length > 0);
            String allNames = this.typeSystemKey(this.modulesOf(shared));
            String name = "shared:" + allNames;
            int count = 1;
            while (this.typeSystems.containsKey(name) && this.typeSystems.get(name).get() != null) {
                name = "shared_" + ++count + ":" + allNames;
            }
            return name;
        }
        ModuleStructure module = owned[0];
        String pkg = Xvm.moduleToPackageName(module, nativeTS);
        Object name = pkg;
        int count = 1;
        while (this.typeSystems.containsKey(name) && this.typeSystems.get(name).get() != null) {
            name = pkg + ".alt" + ++count;
        }
        return name;
    }

    boolean sameTypeSystem(TypeSystem ts, ModuleLoader[] shared, ModuleStructure[] owned) {
        int i;
        if (shared.length != ts.shared.length || owned.length != ts.owned.length) {
            return false;
        }
        for (i = 0; i < owned.length; ++i) {
            if (this.sameModule(owned[i], ts.owned[i].module)) continue;
            return false;
        }
        for (i = 0; i < shared.length; ++i) {
            if (this.sameModule(shared[i].module, ts.shared[i].module)) continue;
            return false;
        }
        return true;
    }

    boolean sameModule(ModuleStructure module1, ModuleStructure module2) {
        return module1.isRefined() && module2.isRefined() && module1.getName().equals(module2.getName()) && Arrays.equals(module1.getDigest(), module2.getDigest());
    }

    ModuleStructure[] modulesOf(ModuleLoader[] loaders) {
        ModuleStructure[] modules = new ModuleStructure[loaders.length];
        for (int i = 0; i < loaders.length; ++i) {
            modules[i] = loaders[i].module;
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModuleLoader createModuleLoader(TypeSystemLoader tsl, ModuleStructure module) {
        assert (tsl != null && module != null);
        if ((++this.mlMapModCount & 0xFF) == 0) {
            this.loadersGc();
        }
        ConcurrentHashMap<String, WeakReference<ModuleLoader>> concurrentHashMap = this.moduleLoaders;
        synchronized (concurrentHashMap) {
            String[] packages;
            String moduleName = module.getName();
            String pkg = Xvm.moduleToPackageName(moduleName, tsl.typeSystem instanceof NativeTypeSystem ? null : module.getVersion());
            Object unique = pkg;
            int count = 1;
            while (this.moduleLoaders.containsKey(unique)) {
                unique = pkg + ".alt" + ++count;
            }
            ModuleLoader loader = new ModuleLoader(tsl, module, (String)unique);
            String[] original = packages = this.packagesByModule.get(moduleName);
            if (packages == null) {
                packages = new String[4];
                index = 0;
            } else {
                index = Handy.scan(packages, unique);
                if (index < 0 && (index = Handy.scan(packages, null)) < 0) {
                    index = packages.length;
                    packages = Arrays.copyOf(packages, packages.length * 2);
                }
            }
            packages[index] = unique;
            if (packages != original) {
                this.packagesByModule.put(moduleName, packages);
            }
            this.moduleLoaders.put((String)unique, new WeakReference<ModuleLoader>(loader));
            return loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadersGc() {
        ConcurrentHashMap<String, WeakReference<ModuleLoader>> concurrentHashMap = this.moduleLoaders;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, WeakReference<ModuleLoader>> entry : this.moduleLoaders.entrySet()) {
                String pkg = entry.getKey();
                WeakReference<ModuleLoader> ref = entry.getValue();
                if (ref == null || ref.get() != null) continue;
                this.moduleLoaders.remove(pkg, ref);
            }
            Iterator<Map.Entry<String, String[]>> iter = this.packagesByModule.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, WeakReference<ModuleLoader>> entry;
                entry = iter.next();
                String module = entry.getKey();
                String[] pkgs = (String[])entry.getValue();
                boolean any = false;
                for (int i = 0; i < pkgs.length; ++i) {
                    ModuleLoader loader;
                    String pkg = pkgs[i];
                    if (pkg == null) continue;
                    WeakReference<ModuleLoader> ref = this.moduleLoaders.get(pkg);
                    if (ref != null && (loader = (ModuleLoader)ref.get()) != null && loader.module.getName().equals(module)) {
                        any = true;
                        continue;
                    }
                    pkgs[i] = null;
                }
                if (any) continue;
                iter.remove();
            }
        }
    }

    static String moduleToPackageName(String module, Version ver) {
        assert (module != null && !module.isEmpty() && module.indexOf(47) < 0);
        StringBuilder buf = new StringBuilder();
        String[] parts = Handy.parseDelimitedString(module, '.');
        if (parts.length <= 1) {
            buf.append("anon");
        }
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            if (part.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (!buf.isEmpty()) {
                buf.append('.');
            }
            buf.append(part);
        }
        if (ver != null) {
            String s = ver.normalize().withoutBuildString().toString().replace('.', '_');
            if (Handy.isDigit(s.charAt(0))) {
                buf.append("_v");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    static String moduleToPackageName(ModuleStructure module, boolean nativeTS) {
        return Xvm.moduleToPackageName(module.getName(), nativeTS ? null : module.getVersion());
    }

    String typeSystemKey(ModuleStructure module) {
        assert (module != null);
        return module.getName();
    }

    String typeSystemKey(ModuleStructure[] modules) {
        assert (modules != null);
        Handy.checkElementsNonNull(modules);
        int count = modules.length;
        assert (count > 0);
        if (count == 1) {
            return this.typeSystemKey(modules[0]);
        }
        modules = Handy.sorted(modules, StructureByModuleId);
        StringBuilder buf = new StringBuilder();
        buf.append('{').append(modules[0].getName());
        for (int i = 1; i < count; ++i) {
            buf.append(',').append(modules[i].getName());
        }
        return buf.append('}').toString();
    }

    Object mutex(String s) {
        return this.locks[(s.hashCode() & Integer.MAX_VALUE) % this.locks.length];
    }
}

