/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit.builders;

import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassModel;
import java.lang.classfile.FieldModel;
import java.lang.classfile.MethodModel;
import java.lang.classfile.constantpool.ClassEntry;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.TypeSystem;
import org.xvm.javajit.builders.CommonBuilder;

public class AugmentingBuilder
extends CommonBuilder {
    public final ClassModel model;

    public AugmentingBuilder(TypeSystem typeSystem, TypeConstant type, ClassModel model) {
        super(typeSystem, type);
        this.model = model;
    }

    @Override
    protected ClassDesc getSuperDesc() {
        return ((ClassEntry)this.model.superclass().get()).asSymbol();
    }

    @Override
    public void assembleImplClass(String className, ClassBuilder classBuilder) {
        int flags = this.model.flags().flagsMask();
        if ((flags & 0x400) != 0 && !this.typeInfo.isAbstract()) {
            classBuilder.withFlags(flags & 0xFFFFFBFF);
        }
        this.assembleImplInterfaces(classBuilder);
    }

    @Override
    protected void assembleField(String className, ClassBuilder classBuilder, PropertyInfo prop) {
        String jitName = prop.getIdentity().ensureJitPropertyName(this.typeSystem);
        if (this.findField(jitName) == null) {
            super.assembleField(className, classBuilder, prop);
        }
    }

    @Override
    protected void assembleMethod(String className, ClassBuilder classBuilder, MethodInfo method, String jitName, MethodTypeDesc md, boolean isOptimized) {
        MethodModel mm = this.findMethod(jitName, md, isOptimized);
        if (mm != null && ((mm.flags().flagsMask() & 0x400) == 0 || method.isAbstract() || method.isNative())) {
            return;
        }
        if (method.getHead().isNative()) {
            System.err.println("*** Native implementation is missing " + className + "#" + jitName + " for " + method.getSignature().getValueString());
            return;
        }
        super.assembleMethod(className, classBuilder, method, jitName, md, isOptimized);
    }

    protected FieldModel findField(String jitName) {
        for (FieldModel fm : this.model.fields()) {
            if (!fm.fieldName().equalsString(jitName)) continue;
            return fm;
        }
        return null;
    }

    protected MethodModel findMethod(String jitName, MethodTypeDesc md, boolean isOptimized) {
        for (MethodModel mm : this.model.methods()) {
            if (!mm.methodName().equalsString(jitName) || !mm.methodTypeSymbol().descriptorString().equals(md.descriptorString())) continue;
            return mm;
        }
        return null;
    }
}

