/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit.builders;

import java.lang.classfile.ClassBuilder;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.Label;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.Builder;
import org.xvm.javajit.Ctx;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitParamDesc;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.ShallowSizeOf;

public class CommonBuilder
extends Builder {
    protected final TypeInfo typeInfo;
    protected final TypeInfo structInfo;
    protected final ClassStructure classStruct;
    protected final IdentityConstant thisId;
    protected long implSize;
    private static final String[] TEST_SET = new String[]{"Test", "test", "tck"};
    private static final HashSet<String> SKIP_SET = new HashSet();

    public CommonBuilder(TypeSystem typeSystem, TypeConstant type) {
        super(typeSystem);
        assert (type.isSingleUnderlyingClass(true));
        ConstantPool pool = typeSystem.pool();
        this.typeInfo = pool.ensureAccessTypeConstant(type, Constants.Access.PRIVATE).ensureTypeInfo();
        this.structInfo = pool.ensureAccessTypeConstant(type, Constants.Access.STRUCT).ensureTypeInfo();
        this.classStruct = this.typeInfo.getClassStructure();
        this.thisId = this.classStruct.getIdentityConstant();
    }

    @Override
    public void assembleImpl(String className, ClassBuilder classBuilder) {
        this.implSize = ShallowSizeOf.align(this.computeInstanceSize());
        this.assembleImplClass(className, classBuilder);
        this.assembleImplProperties(className, classBuilder);
        this.assembleImplMethods(className, classBuilder);
    }

    @Override
    public void assemblePure(String className, ClassBuilder classBuilder) {
    }

    protected int computeInstanceSize() {
        int size = 0;
        block3: for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.structInfo.getProperties().entrySet()) {
            PropertyInfo infoProp = entry.getValue();
            if (!infoProp.hasField()) continue;
            PropertyConstant idProp = entry.getKey();
            if (!idProp.isTopLevel()) {
                IdentityConstant idParent = idProp.getParentConstant();
                switch (idParent.getFormat()) {
                    case Property: {
                        if (this.structInfo.getClassChain().containsKey(infoProp.getIdentity().getClassIdentity())) break;
                        continue block3;
                    }
                }
            }
            size += this.computePropertySize(infoProp);
        }
        return size;
    }

    protected int computePropertySize(PropertyInfo prop) {
        if (prop.isRefAnnotated()) {
            return ShallowSizeOf.fieldOf(Object.class);
        }
        TypeConstant type = prop.getType();
        ClassDesc cd = type.isPrimitive() ? JitTypeDesc.getPrimitiveClass(type) : null;
        return cd == null ? ShallowSizeOf.fieldOf(Object.class) : ShallowSizeOf.fieldOf(cd);
    }

    protected ClassDesc getSuperDesc() {
        TypeConstant superType = this.typeInfo.getExtends();
        return superType == null ? CD_xObj : ClassDesc.of(this.typeSystem.ensureJitClassName(superType));
    }

    protected void assembleImplClass(String className, ClassBuilder classBuilder) {
        int flags = 1;
        switch (this.classStruct.getFormat()) {
            case CLASS: 
            case CONST: 
            case SERVICE: 
            case ENUMVALUE: {
                flags |= 0x20;
                classBuilder.withSuperclass(this.getSuperDesc());
                break;
            }
            case INTERFACE: 
            case MIXIN: 
            case ENUM: {
                flags |= 0x600;
                break;
            }
            default: {
                throw new RuntimeException("Not implemented " + String.valueOf(this.typeInfo.getType()));
            }
        }
        classBuilder.withFlags(flags);
        this.assembleImplInterfaces(classBuilder);
    }

    protected void assembleImplInterfaces(ClassBuilder classBuilder) {
        boolean isInterface = this.classStruct.getFormat() == Component.Format.INTERFACE;
        for (Component.Contribution contrib : this.typeInfo.getContributionList()) {
            switch (contrib.getComposition()) {
                case Implements: {
                    TypeConstant contribType = contrib.getTypeConstant().removeAccess();
                    if (!isInterface && contribType.equals(contribType.getConstantPool().typeObject())) break;
                    classBuilder.withInterfaceSymbols(new ClassDesc[]{ClassDesc.of(this.typeSystem.ensureJitClassName(contribType))});
                }
            }
        }
    }

    protected void assembleImplProperties(String className, ClassBuilder classBuilder) {
        ArrayList<PropertyInfo> constProps = new ArrayList<PropertyInfo>();
        ArrayList<PropertyInfo> initProps = new ArrayList<PropertyInfo>();
        for (PropertyInfo prop : this.structInfo.getProperties().values()) {
            if (!prop.hasField() && !prop.isInjected() || !prop.getFieldIdentity().getNamespace().equals(this.thisId)) continue;
            this.assembleField(className, classBuilder, prop);
            if (prop.isConstant()) {
                constProps.add(prop);
                continue;
            }
            if (!prop.isInitialized()) continue;
            initProps.add(prop);
        }
        boolean isSingleton = this.typeInfo.isSingleton();
        if (isSingleton) {
            classBuilder.withField("$INSTANCE", ClassDesc.of(className), 25);
        }
        if (!constProps.isEmpty() || isSingleton) {
            this.assembleStaticInitializer(className, classBuilder, constProps);
        }
        switch (this.classStruct.getFormat()) {
            case CLASS: 
            case CONST: 
            case SERVICE: 
            case ENUMVALUE: 
            case MODULE: {
                this.assembleInitializer(className, classBuilder, initProps);
            }
        }
        for (PropertyInfo prop : this.typeInfo.getProperties().values()) {
            if (!prop.getIdentity().getNamespace().equals(this.thisId)) continue;
            this.assembleImplProperty(className, classBuilder, prop);
        }
    }

    protected void assembleField(String className, ClassBuilder classBuilder, PropertyInfo prop) {
        String jitName = prop.getIdentity().ensureJitPropertyName(this.typeSystem);
        JitTypeDesc jtd = prop.getType().getJitDesc(this.typeSystem);
        int flags = 1;
        if (prop.isConstant()) {
            flags |= 8;
        }
        switch (jtd.flavor) {
            case Specific: 
            case Widened: 
            case Primitive: {
                classBuilder.withField(jitName, jtd.cd, flags);
                break;
            }
            case MultiSlotPrimitive: {
                classBuilder.withField(jitName, jtd.cd, flags);
                classBuilder.withField(jitName + "$ext", ConstantDescs.CD_boolean, flags);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported property flavor: " + String.valueOf((Object)jtd.flavor));
            }
        }
    }

    protected void assembleStaticInitializer(String className, ClassBuilder classBuilder, List<PropertyInfo> props) {
        ClassDesc CD_this = ClassDesc.of(className);
        classBuilder.withMethod("<clinit>", MethodTypeDesc.of(ConstantDescs.CD_void), 9, methodBuilder -> methodBuilder.withCode(code -> {
            Label startScope = code.newLabel();
            Label endScope = code.newLabel();
            code.labelBinding(startScope);
            int ctxSlot = code.allocateLocal(TypeKind.REFERENCE);
            code.localVariable(ctxSlot, "ctx", CD_Ctx, startScope, endScope).invokestatic(CD_Ctx, "get", MethodTypeDesc.of(CD_Ctx)).astore(0);
            TypeSystem ts = this.typeSystem;
            for (PropertyInfo prop : props) {
                if (prop.getInitializer() == null) {
                    BuildContext.Slot slot = this.loadConstant((CodeBuilder)code, prop.getInitialValue());
                    String jitName = prop.getIdentity().ensureJitPropertyName(ts);
                    if (slot instanceof BuildContext.DoubleSlot) {
                        BuildContext.DoubleSlot doubleSlot = (BuildContext.DoubleSlot)slot;
                        assert (doubleSlot.flavor() == JitFlavor.MultiSlotPrimitive);
                        Label ifTrue = code.newLabel();
                        Label endIf = code.newLabel();
                        code.iconst_0().if_icmpne(ifTrue);
                        code.putstatic(CD_this, jitName + "$ext", ConstantDescs.CD_boolean);
                        code.goto_(endIf).labelBinding(ifTrue);
                        CommonBuilder.pop(code, doubleSlot.cd());
                        code.putstatic(CD_this, jitName, slot.cd());
                        code.labelBinding(endIf);
                        continue;
                    }
                    assert (slot.isSingle());
                    code.putstatic(CD_this, jitName, slot.cd());
                    continue;
                }
                throw new UnsupportedOperationException("Static field initializer");
            }
            if (this.typeInfo.isSingleton()) {
                MethodConstant ctorId = this.typeInfo.findConstructor(TypeConstant.NO_TYPES);
                String jitInit = ctorId.ensureJitMethodName(ts).replace("construct", "$init");
                this.invokeDefaultConstructor(className, (CodeBuilder)code);
                code.dup().putstatic(CD_this, "$INSTANCE", CD_this).aload(ctxSlot).ldc((ConstantDesc)Long.valueOf(this.implSize)).invokevirtual(CD_Ctx, "allocated", MethodTypeDesc.of(ConstantDescs.CD_void, ConstantDescs.CD_long)).aload(ctxSlot).invokevirtual(CD_this, jitInit, MethodTypeDesc.of(CD_this, CD_Ctx)).pop();
            }
            code.labelBinding(endScope).return_();
        }));
    }

    protected void invokeDefaultConstructor(String className, CodeBuilder code) {
        ClassDesc CD_this = ClassDesc.of(className);
        code.new_(CD_this).dup().aload(0).invokespecial(CD_this, "<init>", MethodTypeDesc.of(ConstantDescs.CD_void, CD_Ctx));
    }

    protected void assembleInitializer(String className, ClassBuilder classBuilder, List<PropertyInfo> props) {
        ClassDesc CD_this = ClassDesc.of(className);
        classBuilder.withMethod("<init>", MD_Initializer, 1, methodBuilder -> methodBuilder.withCode(code -> {
            Label startScope = code.newLabel();
            Label endScope = code.newLabel();
            code.labelBinding(startScope);
            int ctxSlot = code.parameterSlot(0);
            code.localVariable(ctxSlot, "$ctx", CD_Ctx, startScope, endScope);
            code.aload(0).aload(ctxSlot).invokespecial(this.getSuperDesc(), "<init>", MD_Initializer);
            for (PropertyInfo prop : props) {
                if (prop.getInitializer() == null) {
                    code.aload(0);
                    BuildContext.Slot slot = this.loadConstant((CodeBuilder)code, prop.getInitialValue());
                    String jitName = prop.getIdentity().ensureJitPropertyName(this.typeSystem);
                    if (slot instanceof BuildContext.DoubleSlot) {
                        BuildContext.DoubleSlot doubleSlot = (BuildContext.DoubleSlot)slot;
                        assert (doubleSlot.flavor() == JitFlavor.MultiSlotPrimitive);
                        Label ifTrue = code.newLabel();
                        Label endIf = code.newLabel();
                        code.iconst_0().if_icmpne(ifTrue).putfield(CD_this, jitName + "$ext", ConstantDescs.CD_boolean);
                        code.goto_(endIf).labelBinding(ifTrue);
                        CommonBuilder.pop(code, doubleSlot.cd());
                        code.putfield(CD_this, jitName, doubleSlot.cd());
                        code.labelBinding(endIf);
                        continue;
                    }
                    assert (slot.isSingle());
                    code.putfield(CD_this, jitName, slot.cd());
                    continue;
                }
                throw new UnsupportedOperationException("Field initializer");
            }
            code.labelBinding(endScope).return_();
        }));
    }

    protected void assembleImplProperty(String className, ClassBuilder classBuilder, PropertyInfo prop) {
        MethodInfo setterInfo;
        MethodInfo getterInfo = this.typeInfo.getMethodById(prop.getGetterId());
        if (getterInfo == null) {
            if (prop.hasField() && prop.getFieldIdentity().getNamespace().equals(this.thisId)) {
                if (prop.isInjected()) {
                    this.generateInjected(className, classBuilder, prop);
                } else {
                    this.generateTrivialGetter(className, classBuilder, prop);
                }
            }
        } else {
            switch (getterInfo.getHead().getImplementation()) {
                case Field: {
                    this.generateTrivialGetter(className, classBuilder, prop);
                    break;
                }
                case Explicit: {
                    MethodTypeDesc md;
                    Object jitName = prop.getGetterId().ensureJitMethodName(this.typeSystem);
                    JitMethodDesc jmDesc = prop.getGetterJitDesc(this.typeSystem);
                    boolean isOpt = jmDesc.isOptimized;
                    MethodTypeDesc methodTypeDesc = md = isOpt ? jmDesc.optimizedMD : jmDesc.standardMD;
                    if (isOpt) {
                        jitName = (String)jitName + "$p";
                    }
                    this.assemblePropertyAccessor(className, classBuilder, prop, (String)jitName, md, isOpt, true);
                }
            }
        }
        if ((setterInfo = this.typeInfo.getMethodById(prop.getSetterId())) == null) {
            if (prop.hasField() && prop.getFieldIdentity().getNamespace().equals(this.thisId)) {
                this.generateTrivialSetter(className, classBuilder, prop);
            }
        } else {
            switch (getterInfo.getHead().getImplementation()) {
                case Field: {
                    this.generateTrivialSetter(className, classBuilder, prop);
                    break;
                }
                case Explicit: {
                    MethodTypeDesc md;
                    Object jitName = prop.getSetterId().ensureJitMethodName(this.typeSystem);
                    JitMethodDesc jmDesc = prop.getSetterJitDesc(this.typeSystem);
                    boolean isOpt = jmDesc.isOptimized;
                    MethodTypeDesc methodTypeDesc = md = isOpt ? jmDesc.optimizedMD : jmDesc.standardMD;
                    if (isOpt) {
                        jitName = (String)jitName + "$p";
                    }
                    this.assemblePropertyAccessor(className, classBuilder, prop, (String)jitName, md, isOpt, false);
                }
            }
        }
    }

    private void generateTrivialGetter(String className, ClassBuilder classBuilder, PropertyInfo prop) {
        String jitGetterName = prop.getGetterId().ensureJitMethodName(this.typeSystem);
        String jitFieldName = prop.getIdentity().ensureJitPropertyName(this.typeSystem);
        ClassDesc CD_this = ClassDesc.of(className);
        int flags = 1;
        if (prop.isConstant()) {
            flags |= 8;
        }
        JitMethodDesc jmd = prop.getGetterJitDesc(this.typeSystem);
        boolean isOpt = jmd.isOptimized;
        MethodTypeDesc md = isOpt ? jmd.optimizedMD : jmd.standardMD;
        Object jitName = isOpt ? jitGetterName + "$p" : jitGetterName;
        classBuilder.withMethodBody((String)jitName, md, flags, code -> {
            if (isOpt) {
                JitParamDesc pdOpt = jmd.optimizedReturns[0];
                ClassDesc cdOpt = pdOpt.cd;
                switch (pdOpt.flavor) {
                    case Specific: 
                    case Widened: 
                    case Primitive: {
                        if (prop.isConstant()) {
                            code.getstatic(CD_this, jitFieldName, cdOpt);
                        } else {
                            code.aload(0).getfield(CD_this, jitFieldName, cdOpt);
                        }
                        CommonBuilder.addReturn(code, cdOpt);
                        break;
                    }
                    case MultiSlotPrimitive: {
                        if (prop.isConstant()) {
                            code.getstatic(CD_this, jitFieldName, cdOpt).getstatic(CD_this, jitFieldName + "$ext", ConstantDescs.CD_boolean);
                        } else {
                            code.aload(0).getfield(CD_this, jitFieldName, cdOpt).getfield(CD_this, jitFieldName + "$ext", ConstantDescs.CD_boolean);
                        }
                        CommonBuilder.storeToContext(code, ConstantDescs.CD_boolean, 0);
                        CommonBuilder.addReturn(code, cdOpt);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported property flavor: " + String.valueOf((Object)pdOpt.flavor));
                    }
                }
            } else {
                JitParamDesc pdStd = jmd.standardReturns[0];
                if (prop.isConstant()) {
                    code.getstatic(CD_this, jitFieldName, pdStd.cd);
                } else {
                    code.aload(0).getfield(CD_this, jitFieldName, pdStd.cd);
                }
                code.areturn();
            }
        });
        if (isOpt) {
            this.assembleMethodWrapper(className, classBuilder, jitGetterName, jmd, prop.isConstant(), false);
        }
    }

    private void generateTrivialSetter(String className, ClassBuilder classBuilder, PropertyInfo prop) {
        String jitSetterName = prop.getSetterId().ensureJitMethodName(this.typeSystem);
        String jitFieldName = prop.getIdentity().ensureJitPropertyName(this.typeSystem);
        ClassDesc CD_this = ClassDesc.of(className);
        int flags = 1;
        if (prop.isConstant()) {
            flags |= 8;
        }
        JitMethodDesc jmd = prop.getSetterJitDesc(this.typeSystem);
        boolean isOpt = jmd.isOptimized;
        MethodTypeDesc md = isOpt ? jmd.optimizedMD : jmd.standardMD;
        Object jitName = isOpt ? jitSetterName + "$p" : jitSetterName;
        classBuilder.withMethodBody((String)jitName, md, flags, code -> {
            int argSlot = code.parameterSlot(1);
            if (isOpt) {
                JitParamDesc pdOpt = jmd.optimizedParams[0];
                ClassDesc cdOpt = pdOpt.cd;
                switch (pdOpt.flavor) {
                    case Specific: 
                    case Widened: 
                    case Primitive: {
                        if (prop.isConstant()) {
                            CommonBuilder.load(code, cdOpt, argSlot);
                            code.putstatic(CD_this, jitFieldName, cdOpt);
                            break;
                        }
                        code.aload(0);
                        CommonBuilder.load(code, cdOpt, argSlot);
                        code.putfield(CD_this, jitFieldName, cdOpt);
                        break;
                    }
                    case MultiSlotPrimitive: {
                        int extSlot = argSlot + CommonBuilder.toTypeKind(cdOpt).slotSize();
                        if (prop.isConstant()) {
                            CommonBuilder.load(code, cdOpt, argSlot);
                            code.putstatic(CD_this, jitFieldName, cdOpt).iload(extSlot).putstatic(CD_this, jitFieldName + "$ext", ConstantDescs.CD_boolean);
                            break;
                        }
                        code.aload(0);
                        CommonBuilder.load(code, cdOpt, argSlot);
                        code.putfield(CD_this, jitFieldName, cdOpt).iload(extSlot).putfield(CD_this, jitFieldName + "$ext", ConstantDescs.CD_boolean);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported property flavor: " + String.valueOf((Object)pdOpt.flavor));
                    }
                }
            } else {
                JitParamDesc pdStd = jmd.standardParams[0];
                if (prop.isConstant()) {
                    code.aload(argSlot);
                    code.putstatic(CD_this, jitFieldName, pdStd.cd);
                } else {
                    code.aload(0).aload(argSlot).putfield(CD_this, jitFieldName, pdStd.cd);
                }
            }
            code.return_();
        });
        if (isOpt) {
            this.assembleMethodWrapper(className, classBuilder, jitSetterName, jmd, prop.isConstant(), false);
        }
    }

    private void generateInjected(String className, ClassBuilder classBuilder, PropertyInfo prop) {
        RegisterConstant regConst;
        String resourceName;
        Constant optsConst;
        assert (!prop.isConstant());
        String jitGetterName = prop.getGetterId().ensureJitMethodName(this.typeSystem);
        String jitFieldName = prop.getIdentity().ensureJitPropertyName(this.typeSystem);
        ClassDesc CD_this = ClassDesc.of(className);
        int flags = 1;
        JitMethodDesc jmd = prop.getGetterJitDesc(this.typeSystem);
        boolean isOpt = jmd.isOptimized;
        MethodTypeDesc md = isOpt ? jmd.optimizedMD : jmd.standardMD;
        Object jitName = isOpt ? jitGetterName + "$p" : jitGetterName;
        TypeConstant resourceType = prop.getType();
        Annotation anno = prop.getRefAnnotations()[0];
        Constant[] params = anno.getParams();
        int paramCount = params.length;
        Constant nameConst = paramCount > 0 ? params[0] : null;
        Constant constant = optsConst = paramCount > 1 ? params[1] : null;
        if (nameConst instanceof StringConstant) {
            StringConstant stringConst = (StringConstant)nameConst;
            v1 = stringConst.getValue();
        } else {
            v1 = resourceName = prop.getName();
        }
        if (!(optsConst == null || optsConst instanceof RegisterConstant && (regConst = (RegisterConstant)optsConst).getRegisterIndex() == -4)) {
            throw new UnsupportedOperationException("retrieve opts");
        }
        classBuilder.withMethodBody((String)jitName, md, flags, code -> {
            int typeIndex = this.typeSystem.registerConstant(resourceType);
            if (isOpt) {
                JitParamDesc pdOpt = jmd.optimizedReturns[0];
                ClassDesc cdOpt = pdOpt.cd;
                switch (pdOpt.flavor) {
                    case Primitive: {
                        code.aload(0).getfield(CD_this, jitFieldName, cdOpt);
                        throw new UnsupportedOperationException("Primitive injection");
                    }
                    case MultiSlotPrimitive: {
                        code.aload(0).getfield(CD_this, jitFieldName, cdOpt).getfield(CD_this, jitFieldName + "$ext", ConstantDescs.CD_boolean);
                        throw new UnsupportedOperationException("MultiSlotPrimitive injection");
                    }
                }
                throw new IllegalStateException("Unsupported property flavor: " + String.valueOf((Object)pdOpt.flavor));
            }
            JitParamDesc pdStd = jmd.standardReturns[0];
            Label endLbl = code.newLabel();
            int valueSlot = code.allocateLocal(TypeKind.REFERENCE);
            code.aload(0).getfield(CD_this, jitFieldName, pdStd.cd).dup().astore(valueSlot).ifnonnull(endLbl).aload(1).dup().loadConstant(typeIndex).invokevirtual(CD_Ctx, "getConstant", Ctx.MD_getConstant).checkcast(CD_TypeConstant).ldc((ConstantDesc)((Object)resourceName)).aconst_null().invokevirtual(CD_Ctx, "inject", Ctx.MD_inject).checkcast(pdStd.cd).dup().astore(valueSlot).aload(0).swap().putfield(CD_this, jitFieldName, pdStd.cd).labelBinding(endLbl).aload(valueSlot).areturn();
        });
        if (isOpt) {
            this.assembleMethodWrapper(className, classBuilder, jitGetterName, jmd, false, false);
        }
    }

    protected void assembleImplMethods(String className, ClassBuilder classBuilder) {
        for (MethodInfo method : this.typeInfo.getMethods().values()) {
            if (!method.getIdentity().getNamespace().equals(this.thisId)) continue;
            this.assembleImplMethod(className, classBuilder, method);
        }
    }

    protected void assembleImplMethod(String className, ClassBuilder classBuilder, MethodInfo method) {
        MethodBody[] chain;
        int depth;
        boolean cap = method.isCapped();
        boolean router = false;
        String jitName = method.getIdentity().ensureJitMethodName(this.typeSystem);
        if (!cap && (depth = (chain = method.ensureOptimizedMethodChain(this.typeInfo)).length) > 0) {
            if (chain[0].getImplementation() == MethodBody.Implementation.Delegating) {
                router = true;
            } else if (depth > 1) {
                String nextJitName = chain[1].getIdentity().ensureJitMethodName(this.typeSystem);
                boolean bl = router = !jitName.equals(nextJitName);
            }
        }
        if (cap || router) {
            MethodInfo targetMethod;
            MethodInfo methodInfo = targetMethod = cap ? this.typeInfo.getNarrowingMethod(method) : method;
            assert (targetMethod != null);
            this.assembleRoutingMethod(className, classBuilder, method, targetMethod);
        } else {
            JitMethodDesc jmDesc = method.getJitDesc(this.typeSystem);
            if (jmDesc.isOptimized) {
                this.assembleMethod(className, classBuilder, method, jitName + "$p", jmDesc.optimizedMD, true);
                this.assembleMethodWrapper(className, classBuilder, jitName, jmDesc, method.isFunction(), method.isConstructor());
            } else {
                this.assembleMethod(className, classBuilder, method, jitName, jmDesc.standardMD, false);
            }
            if (method.isConstructor()) {
                String newName = jitName.replace("construct", this.typeInfo.isSingleton() ? "$init" : "$new");
                JitMethodDesc newDesc = Builder.convertConstructToNew(this.typeInfo, className, jmDesc);
                if (newDesc.isOptimized) {
                    this.assembleNew(className, classBuilder, method, newName + "$p", newDesc.optimizedMD, true);
                    this.assembleMethodWrapper(className, classBuilder, newName, newDesc, true, false);
                } else {
                    this.assembleNew(className, classBuilder, method, newName, newDesc.standardMD, false);
                }
            }
        }
    }

    protected void assembleMethodWrapper(String className, ClassBuilder classBuilder, String jitName, JitMethodDesc jmDesc, boolean isStatic, boolean isConstructor) {
        ClassDesc CD_this = ClassDesc.of(className);
        int flags = 1;
        if (isStatic) {
            flags |= 8;
        }
        classBuilder.withMethodBody(jitName, jmDesc.standardMD, flags, code -> {
            if (!isStatic) {
                code.aload(0);
            }
            int extraCount = jmDesc.getImplicitParamCount();
            for (int i = 0; i < extraCount; ++i) {
                code.aload(code.parameterSlot(i));
            }
            JitParamDesc[] optParams = jmDesc.optimizedParams;
            int c = optParams.length;
            block15: for (int i = 0; i < c; ++i) {
                JitParamDesc optParamDesc = optParams[i];
                int stdParamIx = optParamDesc.index;
                int stdParamSlot = code.parameterSlot(extraCount + stdParamIx);
                TypeConstant stdParamType = optParamDesc.type;
                switch (optParamDesc.flavor) {
                    case Specific: 
                    case Widened: {
                        code.aload(stdParamSlot);
                        continue block15;
                    }
                    case SpecificWithDefault: 
                    case WidenedWithDefault: {
                        code.aload(stdParamSlot);
                        continue block15;
                    }
                    case Primitive: {
                        code.aload(stdParamSlot);
                        this.unbox((CodeBuilder)code, stdParamType, optParamDesc.cd);
                        continue block15;
                    }
                    case PrimitiveWithDefault: {
                        Label ifNotNull = code.newLabel();
                        Label endIf = code.newLabel();
                        code.aload(stdParamSlot).ifnonnull(ifNotNull);
                        Builder.defaultLoad(code, optParamDesc.cd);
                        code.iconst_1();
                        code.goto_(endIf).labelBinding(ifNotNull).aload(stdParamSlot);
                        this.unbox((CodeBuilder)code, stdParamType, optParamDesc.cd);
                        code.iconst_0();
                        code.labelBinding(endIf);
                        ++i;
                        continue block15;
                    }
                    case MultiSlotPrimitive: {
                        assert (stdParamType.isNullable());
                        TypeConstant primitiveType = stdParamType.getUnderlyingType();
                        Label ifNotNull = code.newLabel();
                        Label endIf = code.newLabel();
                        code.aload(stdParamSlot);
                        Builder.loadNull(code);
                        code.if_acmpne(ifNotNull);
                        Builder.defaultLoad(code, optParamDesc.cd);
                        code.iconst_1();
                        code.goto_(endIf).labelBinding(ifNotNull).aload(stdParamSlot);
                        this.unbox((CodeBuilder)code, primitiveType, optParamDesc.cd);
                        code.iconst_0();
                        code.labelBinding(endIf);
                        ++i;
                        continue block15;
                    }
                    case AlwaysNull: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (isStatic) {
                code.invokestatic(CD_this, jitName + "$p", jmDesc.optimizedMD);
            } else {
                code.invokevirtual(CD_this, jitName + "$p", jmDesc.optimizedMD);
            }
            JitParamDesc[] optReturns = jmDesc.optimizedReturns;
            int optReturnCount = optReturns.length;
            JitParamDesc[] stdReturns = jmDesc.standardReturns;
            int stdReturnCount = stdReturns.length;
            if (optReturnCount == 0) {
                code.return_();
                return;
            }
            int stdIx = stdReturnCount - 1;
            block16: for (int optIx = optReturnCount - 1; optIx >= 0; --optIx) {
                JitParamDesc optDesc = optReturns[optIx];
                if (optDesc.extension) continue;
                ClassDesc optCD = optDesc.cd;
                TypeConstant optType = optDesc.type;
                int optRetIx = optDesc.altIndex;
                JitParamDesc stdDesc = stdReturns[stdIx--];
                ClassDesc stdCD = stdDesc.cd;
                TypeConstant stdType = stdDesc.type;
                int stdRetIx = stdDesc.altIndex;
                switch (optDesc.flavor) {
                    case Specific: 
                    case Widened: {
                        if (optIx == 0) {
                            code.areturn();
                            continue block16;
                        }
                        if (optRetIx == stdRetIx) continue block16;
                        CommonBuilder.loadFromContext(code, optCD, optRetIx);
                        CommonBuilder.storeToContext(code, stdCD, stdRetIx);
                        continue block16;
                    }
                    case Primitive: {
                        if (optIx == 0) {
                            this.box((CodeBuilder)code, optType, optCD);
                            code.areturn();
                            continue block16;
                        }
                        CommonBuilder.loadFromContext(code, optCD, optRetIx);
                        this.box((CodeBuilder)code, optType, optCD);
                        CommonBuilder.storeToContext(code, stdCD, stdRetIx);
                        continue block16;
                    }
                    case MultiSlotPrimitive: {
                        assert (stdType.isNullable());
                        Label ifNull = code.newLabel();
                        Label endIf = code.newLabel();
                        JitParamDesc optExt = optReturns[optIx + 1];
                        CommonBuilder.loadFromContext(code, ConstantDescs.CD_boolean, optExt.altIndex);
                        code.iconst_1().if_icmpeq(ifNull);
                        this.box((CodeBuilder)code, optType, optCD);
                        if (optIx == 0) {
                            code.areturn();
                        } else {
                            CommonBuilder.storeToContext(code, stdCD, stdIx);
                            code.goto_(endIf);
                        }
                        code.labelBinding(ifNull);
                        Builder.loadNull(code);
                        if (optIx == 0) {
                            code.areturn();
                            continue block16;
                        }
                        CommonBuilder.storeToContext(code, stdCD, stdIx);
                        code.labelBinding(endIf);
                        continue block16;
                    }
                    case SpecificWithDefault: 
                    case WidenedWithDefault: 
                    case PrimitiveWithDefault: 
                    case AlwaysNull: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        });
    }

    protected void assembleRoutingMethod(String className, ClassBuilder classBuilder, MethodInfo srcMethod, MethodInfo dstMethod) {
    }

    protected void assembleNew(String className, ClassBuilder classBuilder, MethodInfo constructor, String jitName, MethodTypeDesc md, boolean isOptimized) {
        boolean isSingleton = this.typeInfo.isSingleton();
        ClassDesc CD_this = ClassDesc.of(className);
        int flags = 1;
        if (!isSingleton) {
            flags |= 8;
        }
        classBuilder.withMethodBody(jitName, md, flags, code -> {
            MethodTypeDesc ctorMd;
            JitParamDesc[] ctorPds;
            int thisSlot;
            Label startScope = code.newLabel();
            Label endScope = code.newLabel();
            code.labelBinding(startScope);
            int ctxSlot = code.parameterSlot(0);
            code.localVariable(ctxSlot, "$ctx", CD_Ctx, startScope, endScope);
            if (isSingleton) {
                thisSlot = 0;
            } else {
                code.aload(ctxSlot).ldc((ConstantDesc)Long.valueOf(this.implSize)).invokevirtual(CD_Ctx, "alloc", MethodTypeDesc.of(ConstantDescs.CD_void, ConstantDescs.CD_long));
                thisSlot = code.allocateLocal(TypeKind.REFERENCE);
                code.localVariable(thisSlot, "thi$", CD_this, startScope, endScope);
                this.invokeDefaultConstructor(className, (CodeBuilder)code);
                code.astore(thisSlot);
            }
            int cctxSlot = code.allocateLocal(TypeKind.REFERENCE);
            code.localVariable(cctxSlot, "cctx", CD_CtorCtx, startScope, endScope);
            code.aload(ctxSlot).invokevirtual(CD_Ctx, "ctorCtx", MethodTypeDesc.of(CD_CtorCtx)).astore(cctxSlot);
            Object ctorName = constructor.getIdentity().ensureJitMethodName(this.typeSystem);
            JitMethodDesc ctorDesc = constructor.getJitDesc(this.typeSystem);
            code.aload(ctxSlot).aload(cctxSlot).aload(thisSlot);
            assert (isOptimized == ctorDesc.isOptimized);
            if (isOptimized) {
                ctorName = (String)ctorName + "$p";
                ctorPds = ctorDesc.optimizedParams;
                ctorMd = ctorDesc.optimizedMD;
            } else {
                ctorPds = ctorDesc.standardParams;
                ctorMd = ctorDesc.standardMD;
            }
            int c = ctorPds.length;
            for (int i = 0; i < c; ++i) {
                JitParamDesc pd = ctorPds[i];
                CommonBuilder.load(code, pd.cd, code.parameterSlot(1 + i));
            }
            code.invokestatic(CD_this, (String)ctorName, ctorMd);
            code.labelBinding(endScope).aload(thisSlot).areturn();
        });
    }

    protected void assemblePropertyAccessor(String className, ClassBuilder classBuilder, PropertyInfo prop, String jitName, MethodTypeDesc md, boolean isOptimized, boolean isGetter) {
        int flags = 1;
        if (prop.isAbstract()) {
            flags |= 0x400;
        }
        BuildContext bctx = new BuildContext(this, this.typeInfo, prop, isGetter);
        classBuilder.withMethod(jitName, md, flags, methodBuilder -> {
            if (!prop.isAbstract()) {
                methodBuilder.withCode(code -> this.generateCode(className, md, bctx, (CodeBuilder)code));
            }
        });
    }

    protected void assembleMethod(String className, ClassBuilder classBuilder, MethodInfo method, String jitName, MethodTypeDesc md, boolean isOptimized) {
        int flags = 1;
        if (method.isAbstract()) {
            flags |= 0x400;
        }
        if (method.isFunction() || method.isConstructor()) {
            flags |= 8;
        }
        BuildContext bctx = new BuildContext(this, this.typeInfo, method);
        classBuilder.withMethod(jitName, md, flags, methodBuilder -> {
            if (!method.isAbstract()) {
                methodBuilder.withCode(code -> this.generateCode(className, md, bctx, (CodeBuilder)code));
            }
        });
    }

    protected void generateCode(String className, MethodTypeDesc md, BuildContext bctx, CodeBuilder code) {
        bctx.enterMethod(code);
        if (Arrays.stream(TEST_SET).anyMatch(name -> className.toLowerCase().contains((CharSequence)name))) {
            Op[] ops = bctx.methodStruct.getOps();
            int c = ops.length;
            for (int iPC = 0; iPC < c; ++iPC) {
                try {
                    ops[iPC].build(bctx, code);
                    continue;
                }
                catch (Throwable e) {
                    MethodStructure struct = bctx.methodStruct;
                    StringBuilder sb = new StringBuilder();
                    sb.append(className).append('.').append(struct.getIdentityConstant().getName()).append('(').append(struct.getContainingClass().getSourceFileName());
                    int nLine = struct.calculateLineNumber(iPC);
                    if (nLine > 0) {
                        sb.append(':').append(nLine);
                    } else {
                        sb.append(" iPC=").append(iPC);
                    }
                    sb.append(')');
                    throw new RuntimeException("Failed to generate code for op=" + Op.toName(ops[iPC].getOpCode()) + "\n" + String.valueOf(sb), e);
                }
            }
        } else {
            if (SKIP_SET.add(className)) {
                System.err.println("*** Skipping code gen for " + className);
            }
            CommonBuilder.defaultLoad(code, md.returnType());
            CommonBuilder.addReturn(code, md.returnType());
        }
        bctx.exitMethod(code);
    }
}

