/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit.builders;

import java.lang.classfile.ClassBuilder;
import java.lang.constant.MethodTypeDesc;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.Builder;
import org.xvm.javajit.TypeSystem;

public class FunctionBuilder
extends Builder {
    protected final TypeConstant functionType;

    public FunctionBuilder(TypeSystem typeSystem, TypeConstant functionType) {
        super(typeSystem);
        this.functionType = functionType;
    }

    @Override
    public void assemblePure(String className, ClassBuilder classBuilder) {
        ConstantPool pool = this.typeSystem.pool();
        TypeConstant[] paramTypes = pool.extractFunctionParams(this.functionType);
        TypeConstant[] returnTypes = pool.extractFunctionReturns(this.functionType);
        MethodTypeDesc callMD = this.computeMethodDesc(paramTypes, returnTypes);
        MethodTypeDesc invokeMD = this.computeMethodDesc(paramTypes, returnTypes);
        classBuilder.withSuperclass(CD_xFunction).withMethod("$call", callMD, 1025, methodBuilder -> {}).withMethodBody("$invoke", invokeMD, 1, code -> {
            Builder.defaultLoad(code, callMD.returnType());
            Builder.addReturn(code, callMD.returnType());
        });
    }
}

