/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;

public class CallChain {
    protected final MethodBody[] f_aMethods;
    private Boolean m_FAtomic;

    public CallChain(MethodBody[] aMethods) {
        this.f_aMethods = aMethods == null ? MethodBody.NO_BODIES : aMethods;
    }

    public CallChain(MethodStructure method) {
        this.f_aMethods = new MethodBody[]{new MethodBody(method)};
    }

    public int getDepth() {
        return this.f_aMethods.length;
    }

    public boolean isEmpty() {
        return this.f_aMethods.length == 0;
    }

    public boolean isAtomic() {
        if (this.m_FAtomic != null) {
            return this.m_FAtomic;
        }
        if (this.f_aMethods.length > 0 && this.f_aMethods[0].getImplementation() == MethodBody.Implementation.Delegating) {
            PropertyConstant idDelegate = this.f_aMethods[0].getPropertyConstant();
            PropertyStructure propDelegate = (PropertyStructure)idDelegate.getComponent();
            this.m_FAtomic = propDelegate != null && propDelegate.isAtomic();
            return this.m_FAtomic;
        }
        this.m_FAtomic = Boolean.FALSE;
        return this.m_FAtomic;
    }

    public MethodStructure getMethod(int nDepth) {
        return nDepth < this.f_aMethods.length ? this.f_aMethods[nDepth].getMethodStructure() : null;
    }

    public MethodStructure getTop() {
        return this.f_aMethods.length == 0 ? null : this.f_aMethods[0].getMethodStructure();
    }

    public int getMaxVars() {
        MethodStructure method = this.getTop();
        return method == null ? 0 : method.getMaxVars();
    }

    public MethodStructure getSuper(Frame frame) {
        return this.getMethod(frame.m_nChainDepth + 1);
    }

    public boolean isNative() {
        return this.f_aMethods.length == 0 || this.f_aMethods[0].getImplementation() == MethodBody.Implementation.Native;
    }

    public boolean isField() {
        return this.f_aMethods.length > 0 && this.f_aMethods[0].getImplementation() == MethodBody.Implementation.Field;
    }

    public boolean isExplicit() {
        return this.f_aMethods.length > 0 && this.f_aMethods[0].getImplementation() == MethodBody.Implementation.Explicit;
    }

    public PropertyStructure getProperty() {
        return (PropertyStructure)this.f_aMethods[0].getIdentity().getNamespace().getComponent();
    }

    public int invoke(Frame frame, ObjectHandle hTarget, int iReturn) {
        if (this.isNative()) {
            return hTarget.getTemplate().invokeNativeN(frame, this.getTop(), hTarget, Utils.OBJECTS_NONE, iReturn);
        }
        ObjectHandle[] ahVar = new ObjectHandle[this.getMaxVars()];
        return hTarget.getTemplate().invoke1(frame, this, hTarget, ahVar, iReturn);
    }

    public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        if (this.isNative()) {
            return hTarget.getTemplate().invokeNative1(frame, this.getTop(), hTarget, hArg, iReturn);
        }
        ObjectHandle[] ahVar = new ObjectHandle[Math.max(this.getMaxVars(), 1)];
        ahVar[0] = hArg;
        return hTarget.getTemplate().invoke1(frame, this, hTarget, ahVar, iReturn);
    }

    public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
        if (this.isNative()) {
            return hTarget.getTemplate().invokeNativeNN(frame, this.getTop(), hTarget, new ObjectHandle[]{hArg}, aiReturn);
        }
        ObjectHandle[] ahVar = new ObjectHandle[Math.max(this.getMaxVars(), 1)];
        ahVar[0] = hArg;
        return hTarget.getTemplate().invokeN(frame, this, hTarget, ahVar, aiReturn);
    }

    public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        if (this.isNative()) {
            ClassTemplate template = hTarget.getTemplate();
            return ahArg.length == 1 ? template.invokeNative1(frame, this.getTop(), hTarget, ahArg[0], iReturn) : template.invokeNativeN(frame, this.getTop(), hTarget, ahArg, iReturn);
        }
        ObjectHandle[] ahVar = Utils.ensureSize(ahArg, this.getMaxVars());
        return hTarget.getTemplate().invoke1(frame, this, hTarget, ahVar, iReturn);
    }

    public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        if (this.isNative()) {
            return hTarget.getTemplate().invokeNativeNN(frame, this.getTop(), hTarget, ahArg, aiReturn);
        }
        ObjectHandle[] ahVar = Utils.ensureSize(ahArg, this.getMaxVars());
        return hTarget.getTemplate().invokeN(frame, this, hTarget, ahVar, aiReturn);
    }

    public int invokeT(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        if (this.isNative()) {
            return hTarget.getTemplate().invokeNativeT(frame, this.getTop(), hTarget, new ObjectHandle[]{hArg}, iReturn);
        }
        ObjectHandle[] ahVar = new ObjectHandle[Math.max(this.getMaxVars(), 1)];
        ahVar[0] = hArg;
        return hTarget.getTemplate().invokeT(frame, this, hTarget, ahVar, iReturn);
    }

    public int invokeT(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        if (this.isNative()) {
            return hTarget.getTemplate().invokeNativeT(frame, this.getTop(), hTarget, ahArg, iReturn);
        }
        ObjectHandle[] ahVar = Utils.ensureSize(ahArg, this.getMaxVars());
        return hTarget.getTemplate().invokeT(frame, this, hTarget, ahVar, iReturn);
    }

    public int bindTarget(Frame frame, ObjectHandle hTarget, int iReturn) {
        return frame.assignValue(iReturn, hTarget.isService() ? xRTFunction.makeAsyncHandle(frame, this).bindTarget(frame, hTarget) : xRTFunction.makeHandle(frame, this, 0).bindTarget(frame, hTarget));
    }

    public static CallChain createPropertyCallChain(MethodBody[] aMethods) {
        return aMethods.length == 1 && aMethods[0].getImplementation() == MethodBody.Implementation.Field ? new FieldAccessChain(aMethods) : new CallChain(aMethods);
    }

    public int callSuper01(Frame frame, int iReturn) {
        int nDepth = frame.m_nChainDepth + 1;
        if (nDepth >= this.f_aMethods.length) {
            return this.missingSuper(frame);
        }
        ObjectHandle hThis = frame.getThis();
        MethodBody bodySuper = this.f_aMethods[nDepth];
        switch (bodySuper.getImplementation()) {
            case Field: {
                return hThis.getComposition().getFieldValue(frame, hThis, bodySuper.getPropertyConstant(), iReturn);
            }
            case Native: {
                ClassTemplate template = hThis.getTemplate();
                MethodStructure method = bodySuper.getMethodStructure();
                Component container = method.getParent().getParent();
                return container instanceof PropertyStructure ? template.invokeNativeGet(frame, container.getName(), hThis, iReturn) : template.invokeNativeN(frame, method, hThis, Utils.OBJECTS_NONE, iReturn);
            }
            case Default: 
            case Explicit: {
                MethodStructure methodSuper = bodySuper.getMethodStructure();
                ObjectHandle[] ahVar = new ObjectHandle[methodSuper.getMaxVars()];
                return frame.invoke1(this, nDepth, hThis, ahVar, iReturn);
            }
            case Delegating: {
                SignatureConstant sig = bodySuper.getSignature();
                PropertyConstant idProp = bodySuper.getPropertyConstant();
                switch (hThis.getTemplate().getPropertyValue(frame, hThis, idProp, -1)) {
                    case -1: {
                        return this.completeDelegate(frame, frame.popStack(), sig, iReturn);
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> this.completeDelegate(frameCaller, frameCaller.popStack(), sig, iReturn));
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private int completeDelegate(Frame frame, ObjectHandle hTarget, SignatureConstant sig, int iReturn) {
        CallChain chain = hTarget.getComposition().getMethodCallChain(sig);
        return chain.isEmpty() ? this.missingSuper(frame) : chain.invoke(frame, hTarget, iReturn);
    }

    public int callSuper11(Frame frame, ObjectHandle hArg, int iReturn) {
        int nDepth = frame.m_nChainDepth + 1;
        if (nDepth >= this.f_aMethods.length) {
            return this.missingSuper(frame);
        }
        ObjectHandle hThis = frame.getThis();
        MethodBody bodySuper = this.f_aMethods[nDepth];
        switch (bodySuper.getImplementation()) {
            case Field: {
                return hThis.getComposition().setFieldValue(frame, hThis, bodySuper.getPropertyConstant(), hArg);
            }
            case Native: {
                return hThis.getTemplate().invokeNative1(frame, bodySuper.getMethodStructure(), hThis, hArg, iReturn);
            }
            case Default: 
            case Explicit: {
                MethodStructure methodSuper = bodySuper.getMethodStructure();
                ObjectHandle[] ahVar = new ObjectHandle[Math.max(methodSuper.getMaxVars(), 1)];
                ahVar[0] = hArg;
                return frame.invoke1(this, nDepth, hThis, ahVar, iReturn);
            }
            case Delegating: {
                SignatureConstant sig = bodySuper.getSignature();
                PropertyConstant idProp = bodySuper.getPropertyConstant();
                switch (hThis.getTemplate().getPropertyValue(frame, hThis, idProp, -1)) {
                    case -1: {
                        return this.completeDelegate(frame, frame.popStack(), sig, hArg, iReturn);
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> this.completeDelegate(frameCaller, frameCaller.popStack(), sig, hArg, iReturn));
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private int completeDelegate(Frame frame, ObjectHandle hTarget, SignatureConstant sig, ObjectHandle hArg, int iReturn) {
        CallChain chain = hTarget.getComposition().getMethodCallChain(sig);
        return chain.isEmpty() ? this.missingSuper(frame) : chain.invoke(frame, hTarget, hArg, iReturn);
    }

    public int callSuperN1(Frame frame, ObjectHandle[] ahArg, int iReturn, boolean fReturnTuple) {
        int nDepth = frame.m_nChainDepth + 1;
        if (nDepth >= this.f_aMethods.length) {
            return this.missingSuper(frame);
        }
        ObjectHandle hThis = frame.getThis();
        MethodBody bodySuper = this.f_aMethods[nDepth];
        MethodStructure methodSuper = bodySuper.getMethodStructure();
        switch (bodySuper.getImplementation()) {
            case Native: {
                ClassTemplate template = hThis.getTemplate();
                return fReturnTuple ? template.invokeNativeT(frame, methodSuper, hThis, ahArg, iReturn) : (ahArg.length == 1 ? template.invokeNative1(frame, methodSuper, hThis, ahArg[0], iReturn) : template.invokeNativeN(frame, methodSuper, hThis, ahArg, iReturn));
            }
            case Default: 
            case Explicit: {
                ObjectHandle[] ahVar = Utils.ensureSize(ahArg, methodSuper.getMaxVars());
                return fReturnTuple ? frame.invokeT(this, nDepth, hThis, ahVar, iReturn) : frame.invoke1(this, nDepth, hThis, ahVar, iReturn);
            }
            case Delegating: {
                SignatureConstant sig = bodySuper.getSignature();
                PropertyConstant idProp = bodySuper.getPropertyConstant();
                switch (hThis.getTemplate().getPropertyValue(frame, hThis, idProp, -1)) {
                    case -1: {
                        return this.completeDelegate(frame, frame.popStack(), sig, ahArg, iReturn, fReturnTuple);
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> this.completeDelegate(frameCaller, frameCaller.popStack(), sig, ahArg, iReturn, fReturnTuple));
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private int completeDelegate(Frame frame, ObjectHandle hTarget, SignatureConstant sig, ObjectHandle[] ahArg, int iReturn, boolean fReturnTuple) {
        CallChain chain = hTarget.getComposition().getMethodCallChain(sig);
        return chain.isEmpty() ? this.missingSuper(frame) : (fReturnTuple ? chain.invokeT(frame, hTarget, ahArg, iReturn) : chain.invoke(frame, hTarget, ahArg, iReturn));
    }

    public int callSuperNN(Frame frame, ObjectHandle[] ahArg, int[] aiReturn) {
        int nDepth = frame.m_nChainDepth + 1;
        if (nDepth >= this.f_aMethods.length) {
            return this.missingSuper(frame);
        }
        ObjectHandle hThis = frame.getThis();
        MethodBody bodySuper = this.f_aMethods[nDepth];
        MethodStructure methodSuper = bodySuper.getMethodStructure();
        switch (bodySuper.getImplementation()) {
            case Native: {
                return hThis.getTemplate().invokeNativeNN(frame, methodSuper, hThis, ahArg, aiReturn);
            }
            case Default: 
            case Explicit: {
                return frame.invokeN(this, nDepth, hThis, Utils.ensureSize(ahArg, methodSuper.getMaxVars()), aiReturn);
            }
            case Delegating: {
                SignatureConstant sig = bodySuper.getSignature();
                PropertyConstant idProp = bodySuper.getPropertyConstant();
                switch (hThis.getTemplate().getPropertyValue(frame, hThis, idProp, -1)) {
                    case -1: {
                        return this.completeDelegate(frame, frame.popStack(), sig, ahArg, aiReturn);
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> this.completeDelegate(frameCaller, frameCaller.popStack(), sig, ahArg, aiReturn));
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private int completeDelegate(Frame frame, ObjectHandle hTarget, SignatureConstant sig, ObjectHandle[] ahArg, int[] aiReturn) {
        CallChain chain = hTarget.getComposition().getMethodCallChain(sig);
        return chain.isEmpty() ? this.missingSuper(frame) : chain.invoke(frame, hTarget, ahArg, aiReturn);
    }

    private int missingSuper(Frame frame) {
        SignatureConstant sig = this.f_aMethods[0].getSignature().removeAutoNarrowing();
        return frame.raiseException(xException.makeHandle(frame, "Missing super() implementation for \"" + sig.getValueString() + "\" on \"" + frame.getThis().getType().removeAccess().getValueString() + "\""));
    }

    public String toString() {
        return this.f_aMethods.length == 0 ? "empty" : this.f_aMethods[0].getIdentity().getSignature().getValueString() + (String)(this.isNative() ? "; native" : "; depth=" + this.getDepth());
    }

    public static class FieldAccessChain
    extends CallChain {
        public FieldAccessChain(MethodBody[] aMethods) {
            super(aMethods);
            assert (this.isField());
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, int iReturn) {
            return hTarget.getTemplate().getFieldValue(frame, hTarget, this.f_aMethods[0].getPropertyConstant(), iReturn);
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
            assert (iReturn == -2);
            return hTarget.getTemplate().setFieldValue(frame, hTarget, this.f_aMethods[0].getPropertyConstant(), hArg);
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
            assert (ahArg.length > 1 && iReturn == -2);
            return hTarget.getTemplate().setFieldValue(frame, hTarget, this.f_aMethods[0].getPropertyConstant(), ahArg[0]);
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invokeT(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invokeT(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int bindTarget(Frame frame, ObjectHandle hTarget, int iReturn) {
            throw new IllegalStateException();
        }
    }

    public static class ExceptionChain
    extends CallChain {
        private final ObjectHandle.ExceptionHandle f_hException;

        public ExceptionChain(ObjectHandle.ExceptionHandle hException) {
            super(MethodBody.NO_BODIES);
            this.f_hException = hException;
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, int iReturn) {
            return this.throwException(frame);
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
            return this.throwException(frame);
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
            return this.throwException(frame);
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
            return this.throwException(frame);
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
            return this.throwException(frame);
        }

        @Override
        public int invokeT(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
            return this.throwException(frame);
        }

        @Override
        public int invokeT(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
            return this.throwException(frame);
        }

        @Override
        public int bindTarget(Frame frame, ObjectHandle hTarget, int iReturn) {
            return this.throwException(frame);
        }

        private int throwException(Frame frame) {
            return frame.raiseException(this.f_hException);
        }
    }

    public static class VirtualConstructorChain
    extends CallChain {
        private final MethodConstant f_idConstructor;
        private final MethodStructure f_constructor;
        private final TypeConstant f_typeCtor;
        private final TypeComposition f_clzTarget;

        public VirtualConstructorChain(ConstantPool pool, MethodConstant idConstructor, ObjectHandle hTarget) {
            super((MethodBody[])null);
            TypeComposition clzTarget = hTarget.getComposition();
            TypeConstant typeTarget = clzTarget.getType();
            this.f_idConstructor = idConstructor;
            this.f_clzTarget = clzTarget;
            TypeInfo infoTarget = typeTarget.ensureTypeInfo();
            MethodInfo infoCtor = infoTarget.findVirtualConstructor(idConstructor.getSignature());
            if (infoCtor == null) {
                this.f_constructor = null;
                this.f_typeCtor = null;
            } else {
                MethodStructure constructor = infoCtor.getTopmostMethodStructure(infoTarget);
                TypeConstant[] atypeParam = constructor.getIdentityConstant().getSignature().resolveGenericTypes(pool, typeTarget).getRawParams();
                this.f_constructor = constructor;
                this.f_typeCtor = pool.buildFunctionType(atypeParam, typeTarget);
            }
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, int iReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invoke(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invokeT(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int invokeT(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
            throw new IllegalStateException();
        }

        @Override
        public int bindTarget(Frame frame, ObjectHandle hTarget, int iReturn) {
            if (this.f_constructor == null) {
                return frame.raiseException("Failed to find a virtual constructor " + this.f_idConstructor.getValueString() + " at " + this.f_clzTarget.getType().getValueString());
            }
            ObjectHandle hCtor = xRTFunction.makeConstructorHandle(frame, this.f_constructor, this.f_typeCtor, this.f_clzTarget, this.f_constructor.getParamArray(), false);
            if (hTarget instanceof xService.ServiceHandle) {
                xService.ServiceHandle hService = (xService.ServiceHandle)hTarget;
                if (Op.isDeferred(hCtor)) {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xRTFunction.makeAsyncDelegatingHandle(hService, (xRTFunction.FunctionHandle)frameCaller.popStack())));
                    return -5;
                }
                return frame.assignValue(iReturn, xRTFunction.makeAsyncDelegatingHandle(hService, (xRTFunction.FunctionHandle)hCtor));
            }
            return frame.assignDeferredValue(iReturn, hCtor);
        }
    }
}

