/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xvm.asm.Annotation;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.AccessTypeConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.CanonicalizedTypeComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.OpSupport;
import org.xvm.runtime.PropertyComposition;
import org.xvm.runtime.ProxyComposition;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.VarSupport;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.text.xString;
import org.xvm.util.ListMap;

public class ClassComposition
implements TypeComposition {
    private final Container f_container;
    private final ClassTemplate f_template;
    private final ClassComposition f_clzInception;
    private final TypeConstant f_typeInception;
    private final TypeConstant f_typeStructure;
    private final TypeConstant f_typeRevealed;
    private final boolean f_fStruct;
    private volatile Map<Object, FieldInfo> m_mapFields;
    private int m_cRegularFields;
    private boolean m_fHasOuter;
    private boolean m_fHasSpecial;
    private final Map<TypeConstant, TypeComposition> f_mapCompositions;
    private final Map<TypeConstant, ProxyComposition> f_mapProxies;
    private final Map<PropertyConstant, PropertyComposition> f_mapProperties;
    private final Map<Object, CallChain> f_mapMethods;
    private final Map<PropertyConstant, CallChain> f_mapGetters;
    private final Map<PropertyConstant, CallChain> f_mapSetters;
    private xString.StringHandle[] m_ashFieldNames;
    private MethodStructure m_methodInit;
    private static final CallChain NIL_CHAIN = new CallChain(MethodBody.NO_BODIES);

    public ClassComposition(Container container, ClassTemplate template, TypeConstant typeInception) {
        assert (typeInception.isSingleDefiningConstant());
        assert (typeInception.getAccess() == Constants.Access.PUBLIC);
        ConstantPool pool = container.getConstantPool();
        this.f_clzInception = this;
        this.f_container = container;
        this.f_template = template;
        this.f_typeInception = pool.ensureAccessTypeConstant(typeInception, Constants.Access.PRIVATE);
        this.f_typeStructure = pool.ensureAccessTypeConstant(typeInception, Constants.Access.STRUCT);
        this.f_typeRevealed = typeInception;
        this.f_fStruct = typeInception.getAccess() == Constants.Access.STRUCT;
        this.f_mapCompositions = new ConcurrentHashMap<TypeConstant, TypeComposition>();
        this.f_mapProxies = new ConcurrentHashMap<TypeConstant, ProxyComposition>();
        this.f_mapProperties = new ConcurrentHashMap<PropertyConstant, PropertyComposition>();
        this.f_mapMethods = new ConcurrentHashMap<Object, CallChain>();
        this.f_mapGetters = new ConcurrentHashMap<PropertyConstant, CallChain>();
        this.f_mapSetters = new ConcurrentHashMap<PropertyConstant, CallChain>();
    }

    private ClassComposition(ClassComposition clzInception, TypeConstant typeRevealed) {
        this.f_clzInception = clzInception;
        this.f_container = clzInception.f_container;
        this.f_template = clzInception.f_template;
        this.f_typeInception = clzInception.f_typeInception;
        this.f_typeStructure = clzInception.f_typeStructure;
        this.f_typeRevealed = typeRevealed;
        this.f_fStruct = typeRevealed.getAccess() == Constants.Access.STRUCT;
        this.f_mapCompositions = this.f_clzInception.f_mapCompositions;
        this.f_mapProxies = this.f_clzInception.f_mapProxies;
        this.f_mapProperties = this.f_clzInception.f_mapProperties;
        this.f_mapMethods = this.f_clzInception.f_mapMethods;
        this.f_mapGetters = this.f_clzInception.f_mapGetters;
        this.f_mapSetters = this.f_clzInception.f_mapSetters;
        this.m_mapFields = this.f_clzInception.m_mapFields;
        this.m_cRegularFields = this.f_clzInception.m_cRegularFields;
        this.m_fHasOuter = this.f_clzInception.m_fHasOuter;
        this.m_fHasSpecial = this.f_clzInception.m_fHasSpecial;
        this.m_methodInit = this.f_clzInception.m_methodInit;
    }

    public ProxyComposition ensureProxyComposition(TypeConstant typeProxy) {
        return this.f_mapProxies.computeIfAbsent(typeProxy, type -> new ProxyComposition(this, this.register(type)));
    }

    public CanonicalizedTypeComposition ensureCanonicalizedComposition(TypeConstant typeActual) {
        assert (typeActual.isShared(this.getContainer().getConstantPool()));
        return (CanonicalizedTypeComposition)this.f_mapCompositions.computeIfAbsent(typeActual, type -> new CanonicalizedTypeComposition(this, this.register(type)));
    }

    public PropertyComposition ensurePropertyComposition(PropertyInfo infoProp) {
        return this.f_mapProperties.computeIfAbsent(infoProp.getIdentity(), idProp -> new PropertyComposition(this.f_clzInception, infoProp));
    }

    @Override
    public Container getContainer() {
        return this.f_container;
    }

    @Override
    public OpSupport getSupport() {
        return this.f_template;
    }

    @Override
    public ClassTemplate getTemplate() {
        return this.f_template;
    }

    @Override
    public TypeConstant getType() {
        return this.f_typeRevealed;
    }

    @Override
    public TypeConstant getInceptionType() {
        return this.f_typeInception;
    }

    @Override
    public TypeConstant getBaseType() {
        return this.getType().removeAccess();
    }

    @Override
    public TypeComposition maskAs(TypeConstant type) {
        return type.equals(this.f_typeRevealed) ? this : (this.f_typeRevealed.isA(type) ? this.f_mapCompositions.computeIfAbsent(type, typeR -> new ClassComposition(this, this.register(typeR))) : null);
    }

    @Override
    public TypeComposition revealAs(TypeConstant type) {
        return type.equals(this.f_typeRevealed) ? this : (this.f_typeStructure.isA(type) ? this.ensureAccess(Constants.Access.STRUCT) : (this.f_typeInception.isA(type) ? this.f_mapCompositions.computeIfAbsent(type, typeR -> new ClassComposition(this.f_clzInception, this.register(typeR))) : null));
    }

    @Override
    public ObjectHandle ensureOrigin(ObjectHandle handle) {
        assert (handle.getComposition() == this);
        return this.isInception() ? handle : handle.cloneAs(this.f_clzInception).ensureAccess(handle.getType().getAccess());
    }

    @Override
    public ObjectHandle ensureAccess(ObjectHandle handle, Constants.Access access) {
        assert (handle.getComposition() == this);
        return access == this.f_typeRevealed.getAccess() ? handle : handle.cloneAs(this.ensureAccess(access));
    }

    @Override
    public TypeComposition ensureAccess(Constants.Access access) {
        TypeConstant typeTarget;
        TypeConstant typeCurrent = this.f_typeRevealed;
        Constants.Access accessCurrent = typeCurrent.getAccess();
        if (accessCurrent == access) {
            return this;
        }
        if (typeCurrent instanceof AccessTypeConstant) {
            typeCurrent = typeCurrent.getUnderlyingType();
        }
        ConstantPool pool = this.getContainer().getConstantPool();
        switch (access) {
            case PUBLIC: {
                typeTarget = typeCurrent;
                if (!typeTarget.equals(this.f_clzInception.f_typeRevealed)) break;
                return this.f_clzInception;
            }
            case PROTECTED: {
                typeTarget = pool.ensureAccessTypeConstant(typeCurrent, Constants.Access.PROTECTED);
                break;
            }
            case PRIVATE: {
                typeTarget = pool.ensureAccessTypeConstant(typeCurrent, Constants.Access.PRIVATE);
                break;
            }
            case STRUCT: {
                typeTarget = pool.ensureAccessTypeConstant(typeCurrent, Constants.Access.STRUCT);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.f_mapCompositions.computeIfAbsent(typeTarget, typeR -> new ClassComposition(this.f_clzInception, this.register(typeR)));
    }

    @Override
    public boolean isStruct() {
        return this.f_fStruct;
    }

    @Override
    public MethodStructure ensureAutoInitializer() {
        if (this.m_mapFields.isEmpty()) {
            return null;
        }
        MethodStructure method = this.m_methodInit;
        if (method == null) {
            ConstantPool pool = this.getContainer().getConstantPool();
            this.m_methodInit = method = this.f_template.getStructure().createInitializer(pool, this.f_typeStructure, this.m_mapFields);
        }
        return method.isAbstract() ? null : method;
    }

    @Override
    public boolean isInjected(PropertyConstant idProp) {
        PropertyInfo infoProp = this.f_typeInception.ensureTypeInfo().findProperty(idProp, true);
        return infoProp != null && infoProp.isInjected();
    }

    @Override
    public boolean isAtomic(PropertyConstant idProp) {
        PropertyInfo infoProp = this.f_typeInception.ensureTypeInfo().findProperty(idProp, true);
        return infoProp != null && (infoProp.isAtomic() || infoProp.isNative());
    }

    @Override
    public CallChain getMethodCallChain(Object nidMethod) {
        CallChain chain = this.f_mapMethods.get(nidMethod);
        return chain == null ? this.ensureMethodChain(nidMethod) : chain;
    }

    private CallChain ensureMethodChain(Object nidMethod) {
        ConstantPool pool = this.getConstantPool();
        boolean fCache = true;
        if (nidMethod instanceof SignatureConstant) {
            SignatureConstant sig = (SignatureConstant)nidMethod;
            if (sig.getConstantPool() != pool) {
                if (sig.isShared(pool)) {
                    nidMethod = pool.register(sig);
                } else {
                    fCache = false;
                    System.err.println("WARNING: Foreign method chain for " + String.valueOf(sig));
                }
            }
        } else {
            IdentityConstant.NestedIdentity idNested = (IdentityConstant.NestedIdentity)nidMethod;
            IdentityConstant idParent = idNested.getIdentityConstant();
            if (idParent.getConstantPool() != pool) {
                if (idParent.isShared(pool)) {
                    idParent = (IdentityConstant)pool.register(idParent);
                    nidMethod = idParent.appendNestedIdentity(pool, idNested);
                } else {
                    fCache = false;
                    System.err.println("WARNING: Foreign nested method " + String.valueOf(idNested) + " for " + String.valueOf(idParent));
                }
            }
        }
        return fCache ? this.f_mapMethods.computeIfAbsent(nidMethod, this::computeMethodChain) : this.computeMethodChain(nidMethod);
    }

    private CallChain computeMethodChain(Object nidMethod) {
        TypeInfo info = this.isStruct() ? this.f_typeStructure.ensureTypeInfo() : this.f_typeInception.ensureTypeInfo();
        return new CallChain(info.getOptimizedMethodChain(nidMethod));
    }

    @Override
    public CallChain getPropertyGetterChain(PropertyConstant idProp) {
        CallChain chain = this.f_mapGetters.get(idProp);
        return chain == null ? this.ensureGetterChain(idProp) : (chain == NIL_CHAIN ? null : chain);
    }

    private CallChain ensureGetterChain(PropertyConstant idProp) {
        ConstantPool pool = this.getConstantPool();
        boolean fShared = true;
        if (idProp.getConstantPool() != pool && idProp.getConstantPool() != pool) {
            if (idProp.isShared(pool)) {
                idProp = (PropertyConstant)pool.register(idProp);
            } else {
                fShared = false;
            }
        }
        CallChain chain = fShared ? this.f_mapGetters.computeIfAbsent(idProp, this::computeGetterChain) : this.computeGetterChain(idProp);
        return chain == NIL_CHAIN ? null : chain;
    }

    private CallChain computeGetterChain(PropertyConstant id) {
        MethodBody[] aBody = this.f_typeInception.ensureTypeInfo().getOptimizedGetChain(id);
        return aBody == null ? NIL_CHAIN : CallChain.createPropertyCallChain(aBody);
    }

    @Override
    public CallChain getPropertySetterChain(PropertyConstant idProp) {
        CallChain chain = this.f_mapSetters.get(idProp);
        return chain == null ? this.ensurePropertySetterChain(idProp) : (chain == NIL_CHAIN ? null : chain);
    }

    private CallChain ensurePropertySetterChain(PropertyConstant idProp) {
        ConstantPool pool = this.getConstantPool();
        boolean fShared = true;
        if (idProp.getConstantPool() != pool) {
            if (idProp.isShared(pool)) {
                idProp = (PropertyConstant)pool.register(idProp);
            } else {
                fShared = false;
            }
        }
        CallChain chain = fShared ? this.f_mapSetters.computeIfAbsent(idProp, this::computeSetterChain) : this.computeSetterChain(idProp);
        return chain == NIL_CHAIN ? null : chain;
    }

    private CallChain computeSetterChain(PropertyConstant id) {
        MethodBody[] aBody = this.f_typeInception.ensureTypeInfo().getOptimizedSetChain(id);
        return aBody == null ? NIL_CHAIN : CallChain.createPropertyCallChain(aBody);
    }

    @Override
    public Map<Object, FieldInfo> getFieldLayout() {
        return this.m_mapFields;
    }

    @Override
    public xString.StringHandle[] getFieldNameArray() {
        xString.StringHandle[] ashNames = this.m_ashFieldNames;
        if (ashNames == null) {
            ashNames = new xString.StringHandle[this.m_cRegularFields];
            int i = 0;
            for (Map.Entry<Object, FieldInfo> entry : this.getFieldLayout().entrySet()) {
                Object enid = entry.getKey();
                FieldInfo field = entry.getValue();
                if (enid instanceof IdentityConstant.NestedIdentity || !field.isRegular()) continue;
                ashNames[i++] = xString.makeHandle(field.getName());
            }
            assert (i == this.m_cRegularFields);
            this.m_ashFieldNames = ashNames;
        }
        return ashNames;
    }

    @Override
    public ObjectHandle[] getFieldValueArray(Frame frame, ObjectHandle.GenericHandle hValue) {
        Map<Object, FieldInfo> mapLayout = this.getFieldLayout();
        if (mapLayout.isEmpty()) {
            return Utils.OBJECTS_NONE;
        }
        ObjectHandle[] ahFields = new ObjectHandle[this.m_cRegularFields];
        int i = 0;
        for (Map.Entry<Object, FieldInfo> entry : mapLayout.entrySet()) {
            Object enid = entry.getKey();
            FieldInfo field = entry.getValue();
            if (enid instanceof IdentityConstant.NestedIdentity || !field.isRegular()) continue;
            ahFields[i++] = hValue.getField(frame, field);
        }
        assert (i == this.m_cRegularFields);
        return ahFields;
    }

    @Override
    public ObjectHandle[] initializeStructure() {
        Map<Object, FieldInfo> mapFields = this.m_mapFields;
        int cSize = mapFields.size();
        if (cSize == 0) {
            return Utils.OBJECTS_NONE;
        }
        ObjectHandle[] aFields = new ObjectHandle[cSize];
        if (this.m_fHasSpecial) {
            for (FieldInfo field : mapFields.values()) {
                if (field.isTransient()) {
                    aFields[field.getIndex()] = new ObjectHandle.TransientId();
                    continue;
                }
                if (!field.isInflated()) continue;
                aFields[field.getIndex()] = field.createRefHandle(null);
            }
        }
        return aFields;
    }

    @Override
    public FieldInfo getFieldInfo(Object id) {
        PropertyConstant idProp;
        if (id instanceof PropertyConstant && (idProp = (PropertyConstant)id).getComponent().getAccess() != Constants.Access.PRIVATE) {
            id = idProp.getNestedIdentity();
        }
        return this.m_mapFields.get(id);
    }

    @Override
    public boolean hasOuter() {
        return this.m_fHasOuter;
    }

    @Override
    public boolean makeStructureImmutable(ObjectHandle[] ahField) {
        for (FieldInfo field : this.m_mapFields.values()) {
            ObjectHandle hValue = ahField[field.getIndex()];
            if (hValue == null || !hValue.isMutable() || hValue.isService() || field.isLazy() || hValue.makeImmutable()) continue;
            return false;
        }
        return true;
    }

    private <T extends Constant> T register(T type) {
        Container container = this.getContainer();
        ConstantPool poolThis = container.getConstantPool();
        ConstantPool poolThat = type.getConstantPool();
        if (poolThat == poolThis) {
            return type;
        }
        while ((container = container.f_parent) != null) {
            if (poolThat != container.getConstantPool()) continue;
            return type;
        }
        return (T)poolThis.register(type);
    }

    public boolean isInception() {
        return this == this.f_clzInception;
    }

    public void ensureFieldLayout(Container container) {
        if (this.m_mapFields == null) {
            this.ensureFieldLayoutImpl(container);
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void ensureFieldLayoutImpl(Container container) {
        if (this.m_mapFields != null) {
            return;
        }
        if (!this.f_template.isGenericHandle()) {
            this.m_mapFields = Collections.emptyMap();
            return;
        }
        typePublic = this.f_typeInception.getUnderlyingType();
        if (typePublic instanceof PropertyClassTypeConstant) {
            this.m_mapFields = Collections.emptyMap();
            return;
        }
        pool = this.getContainer().getConstantPool();
        typeStruct = pool.ensureAccessTypeConstant(typePublic, Constants.Access.STRUCT);
        infoStruct = typeStruct.ensureTypeInfo();
        mapFields = new ListMap<Object, FieldInfo>();
        cRegular = 0;
        nIndex = 0;
        for (String sField : this.f_template.getImplicitFields()) {
            if (sField.equals("$outer")) {
                this.m_fHasOuter = true;
            }
            mapFields.put(sField, new FieldInfo(sField, nIndex++, pool.typeObject(), null, true, false, false, false));
        }
        block4: for (Map.Entry<PropertyConstant, PropertyInfo> entry : infoStruct.sortedProperties()) {
            idProp = (PropertyConstant)entry.getKey();
            infoProp = (PropertyInfo)entry.getValue();
            fField = infoProp.hasField();
            if (!fField || idProp.isTopLevel()) ** GOTO lbl-1000
            idParent = idProp.getParentConstant();
            switch (1.$SwitchMap$org$xvm$asm$Constant$Format[idParent.getFormat().ordinal()]) {
                case 1: {
                    if (!infoStruct.getClassChain().containsKey(infoProp.getIdentity().getClassIdentity())) continue block4;
                }
                default: lbl-1000:
                // 2 sources

                {
                    clzRef = null;
                    if (infoProp.isRefAnnotated()) {
                        v0 = clzRef = infoProp.isCustomLogic() != false ? this.ensurePropertyComposition(infoProp) : container.resolveClass(infoProp.getBaseRefType());
                        if (clzRef != null && !infoProp.isNative()) {
                            block5: for (Annotation anno : infoProp.getRefAnnotations()) {
                                infoAnno = anno.getAnnotationType().ensureTypeInfo();
                                cArgs = anno.getParams().length;
                                setConstrId = infoAnno.findMethods("construct", cArgs, TypeInfo.MethodKind.Constructor);
                                for (MethodConstant idConstruct : setConstrId) {
                                    method = infoAnno.getMethodById(idConstruct, true).getTopmostMethodStructure(infoAnno);
                                    if (method.isSynthetic() && method.isNoOp()) continue;
                                    clzRef = clzRef.ensureAccess(Constants.Access.STRUCT);
                                    break block5;
                                }
                            }
                        }
                    }
                    if (fField) {
                        fTransient = infoProp.isTransient();
                        fPrivate = infoProp.getRefAccess() == Constants.Access.PRIVATE;
                        v1 = enid = fPrivate != false ? idProp : idProp.getNestedIdentity();
                        if (!ClassComposition.$assertionsDisabled && !(fPrivate == false ? infoStruct.findPropertyByNid(enid) != null : idProp.getComponent() != null)) {
                            throw new AssertionError();
                        }
                        if (!ClassComposition.$assertionsDisabled && mapFields.containsKey(enid)) {
                            throw new AssertionError();
                        }
                        type = infoProp.getType();
                        if (type.containsFormalType(true)) {
                            type = type.resolveConstraints();
                        }
                        field = new FieldInfo(enid, nIndex++, type, clzRef, infoProp.isInjected(), fTransient, infoProp.isImplicitlyAssigned(), infoProp.isLazy());
                        mapFields.put(enid, field);
                        this.m_fHasSpecial |= fTransient | clzRef != null;
                        if (enid instanceof IdentityConstant.NestedIdentity || !field.isRegular()) continue block4;
                        ++cRegular;
                        continue block4;
                    }
                    if (!ClassComposition.$assertionsDisabled && clzRef != null) {
                        throw new AssertionError();
                    }
                    continue block4;
                }
            }
        }
        this.m_cRegularFields = cRegular;
        this.m_mapFields = mapFields.isEmpty() != false ? Collections.emptyMap() : (mapFields.size() > 8 ? new LinkedHashMap<K, V>(mapFields) : mapFields);
    }

    public TypeConstant getFieldType(Object nid) {
        PropertyInfo propertyInfo;
        TypeConstant type = this.getInceptionType();
        TypeInfo infoType = type.ensureTypeInfo();
        if (nid instanceof PropertyConstant) {
            PropertyConstant idProp = (PropertyConstant)nid;
            propertyInfo = infoType.findProperty(idProp, true);
        } else {
            propertyInfo = infoType.findProperty((String)nid);
        }
        PropertyInfo infoProp = propertyInfo;
        return infoProp == null ? null : infoProp.inferImmutable(type);
    }

    public PropertyInfo getPropertyInfo(PropertyConstant idProp) {
        return this.getInceptionType().ensureTypeInfo().findProperty(idProp, true);
    }

    public int hashCode() {
        return this.f_typeRevealed.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return this.f_typeRevealed.getValueString();
    }

    public static class FieldInfo {
        private final Object f_enid;
        private final int f_nIndex;
        private final TypeConstant f_type;
        private final TypeComposition f_clzRef;
        private final boolean f_fSynthetic;
        private final boolean f_fTransient;
        private final boolean f_fUnassigned;
        private final boolean f_fLazy;
        public Constant constInit;

        protected FieldInfo(Object enid, int nIndex, TypeConstant type, TypeComposition clzRef, boolean fSynthetic, boolean fTransient, boolean fUnassigned, boolean fLazy) {
            this.f_enid = enid;
            this.f_nIndex = nIndex;
            this.f_type = type;
            this.f_clzRef = clzRef;
            this.f_fSynthetic = fSynthetic;
            this.f_fTransient = fTransient;
            this.f_fUnassigned = fUnassigned;
            this.f_fLazy = fLazy;
        }

        public String getName() {
            String string;
            Object object = this.f_enid;
            if (object instanceof PropertyConstant) {
                PropertyConstant idProp = (PropertyConstant)object;
                string = idProp.getPathString();
            } else {
                string = this.f_enid.toString();
            }
            return string;
        }

        public int getIndex() {
            return this.f_nIndex;
        }

        public TypeConstant getType() {
            return this.f_type;
        }

        public boolean isInflated() {
            return this.f_clzRef != null;
        }

        public boolean isSynthetic() {
            return this.f_fSynthetic;
        }

        public boolean isTransient() {
            return this.f_fTransient;
        }

        public boolean isUnassigned() {
            return this.f_fUnassigned;
        }

        public boolean isLazy() {
            return this.f_fLazy;
        }

        public boolean isAllowedUnassigned() {
            return this.isSynthetic() || this.isTransient() || this.isUnassigned();
        }

        public boolean isRegular() {
            return !this.isSynthetic() && !this.isTransient() && !this.isUnassigned() && !this.isLazy();
        }

        public xRef.RefHandle createRefHandle(Frame frame) {
            return ((VarSupport)this.f_clzRef.getSupport()).createRefHandle(frame, this.f_clzRef, this.getName());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append('@').append(this.getIndex());
            if (this.isSynthetic()) {
                sb.append(" synthetic");
            }
            if (this.isTransient()) {
                sb.append(" transient");
            }
            if (this.isInflated()) {
                sb.append(" inflated");
            }
            return sb.toString();
        }
    }
}

