/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TerminalTypeConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.OpSupport;
import org.xvm.runtime.PropertyComposition;
import org.xvm.runtime.ProxyComposition;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.Proxy;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.annotations.xFuture;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.reflect.xVar;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xObject;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.Handy;

public abstract class ClassTemplate
implements OpSupport {
    public static String[] VOID = new String[0];
    public static String[] THIS = new String[]{"this"};
    public static String[] OBJECT = new String[]{"Object"};
    public static String[] INT = new String[]{"numbers.Int64"};
    public static String[] STRING = new String[]{"text.String"};
    public static String[] BOOLEAN = new String[]{"Boolean"};
    public static String[] BYTES = new String[]{"collections.Array<numbers.UInt8>"};
    public final Container f_container;
    public final String f_sName;
    protected final ClassStructure f_struct;
    protected final ClassStructure f_structSuper;
    protected ClassTemplate m_templateSuper;
    protected final String[] f_asFieldsImplicit;
    protected ClassComposition m_clazzCanonical;

    public ClassTemplate(Container container, ClassStructure structClass) {
        this.f_container = container;
        this.f_struct = structClass;
        this.f_sName = structClass.getIdentityConstant().getPathString();
        ClassStructure structSuper = null;
        Component.Contribution contribExtend = structClass.findContribution(Component.Composition.Extends);
        if (contribExtend != null) {
            IdentityConstant idExtend = (IdentityConstant)contribExtend.getTypeConstant().getDefiningConstant();
            structSuper = (ClassStructure)idExtend.getComponent();
        }
        this.f_structSuper = structSuper;
        Set<String> setFieldsImplicit = this.registerImplicitFields(null);
        this.f_asFieldsImplicit = setFieldsImplicit == null ? Utils.NO_NAMES : setFieldsImplicit.toArray(Utils.NO_NAMES);
    }

    protected Set<String> registerImplicitFields(Set<String> setFields) {
        if (this.f_struct.isInstanceChild()) {
            if (setFields == null) {
                setFields = new HashSet<String>();
            }
            setFields.add("$outer");
        }
        return setFields;
    }

    public void registerNativeTemplates() {
    }

    protected void registerNativeTemplate(ClassTemplate template) {
        ((NativeContainer)this.f_container).registerNativeTemplate(template.getCanonicalType(), template);
    }

    public void initNative() {
    }

    public ClassStructure getStructure() {
        return this.f_struct;
    }

    public TypeConstant getCanonicalType() {
        return this.f_struct.getCanonicalType();
    }

    public IdentityConstant getClassConstant() {
        return this.f_struct.getIdentityConstant();
    }

    protected IdentityConstant getInceptionClassConstant() {
        return this.getClassConstant();
    }

    public ClassTemplate getSuper() {
        ClassTemplate templateSuper = this.m_templateSuper;
        if (templateSuper == null) {
            if (this.f_structSuper == null) {
                if ("Object".equals(this.f_sName)) {
                    return null;
                }
                templateSuper = this.m_templateSuper = xObject.INSTANCE;
            } else {
                templateSuper = this.m_templateSuper = this.f_container.getTemplate(this.f_structSuper.getIdentityConstant());
            }
        }
        return templateSuper;
    }

    public ClassComposition getCanonicalClass() {
        ClassComposition clz = this.m_clazzCanonical;
        if (clz == null) {
            this.m_clazzCanonical = clz = this.getCanonicalClass(this.f_container);
        }
        return clz;
    }

    public ClassComposition getCanonicalClass(Container container) {
        TypeConstant typeCanonical = this.getCanonicalType();
        return (ClassComposition)this.ensureClass(container, this.computeInceptionType(typeCanonical), typeCanonical);
    }

    public TypeComposition ensureParameterizedClass(Container container, TypeConstant ... atypeParams) {
        ConstantPool pool = container.getConstantPool();
        TypeConstant typeInception = pool.ensureParameterizedTypeConstant(this.getInceptionClassConstant().getType(), atypeParams).normalizeParameters();
        TypeConstant typeMask = this.getCanonicalType().adoptParameters(pool, atypeParams);
        return this.ensureClass(container, typeInception, typeMask);
    }

    public TypeComposition ensureClass(Container container, TypeConstant typeActual) {
        return this.ensureClass(container, this.computeInceptionType(typeActual), typeActual);
    }

    private TypeConstant computeInceptionType(final TypeConstant typeActual) {
        final IdentityConstant constInception = this.getInceptionClassConstant();
        if (typeActual.getDefiningConstant().equals(constInception)) {
            return typeActual.isAccessSpecified() ? typeActual.getUnderlyingType() : typeActual;
        }
        Function<TypeConstant, TypeConstant> transformer = new Function<TypeConstant, TypeConstant>(this){

            @Override
            public TypeConstant apply(TypeConstant type) {
                return type instanceof TerminalTypeConstant ? constInception.getType() : type.replaceUnderlying(typeActual.getConstantPool(), this);
            }
        };
        return (TypeConstant)transformer.apply(typeActual);
    }

    public TypeComposition ensureClass(Container container, TypeConstant typeInception, TypeConstant typeMask) {
        ClassComposition clz = container.ensureClassComposition(typeInception, this);
        assert (typeMask.normalizeParameters().equals(typeMask));
        return typeMask.equals(typeInception) ? clz : clz.maskAs(typeMask);
    }

    public int hashCode() {
        return this.f_sName.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return this.f_struct.toString();
    }

    public boolean isGenericHandle() {
        return true;
    }

    public int createConstHandle(Frame frame, Constant constant) {
        return frame.raiseException("Unknown constant: " + String.valueOf(constant));
    }

    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        ObjectHandle hStruct = this.createStruct(frame, clazz);
        if (hParent != null) {
            ((ObjectHandle.GenericHandle)hStruct).setField(frame, "$outer", hParent);
        }
        return this.proceedConstruction(frame, constructor, true, hStruct, ahVar, iReturn);
    }

    public ObjectHandle createStruct(Frame frame, TypeComposition clazz) {
        assert (clazz.getTemplate() == this);
        return new ObjectHandle.GenericHandle(clazz.ensureAccess(Constants.Access.STRUCT));
    }

    public int proceedConstruction(Frame frame, MethodStructure constructor, boolean fInitStruct, ObjectHandle hStruct, ObjectHandle[] ahVar, int iReturn) {
        assert (fInitStruct || constructor == null);
        return new Construct(constructor, fInitStruct, hStruct, ahVar, iReturn).proceed(frame);
    }

    protected int postValidate(Frame frame, ObjectHandle hStruct) {
        TypeConstant type = hStruct.getType().removeAccess();
        if (!type.isConst() && type.isImmutable()) {
            hStruct.makeImmutable();
        }
        return -1;
    }

    protected boolean makeImmutable(ObjectHandle hTarget) {
        return !hTarget.isMutable() || hTarget.makeImmutable();
    }

    public int createProxyHandle(Frame frame, ServiceContext ctxTarget, ObjectHandle hTarget, TypeConstant typeProxy) {
        TypeComposition typeComposition;
        TypeConstant typeTarget = hTarget.getType();
        if (!hTarget.isMutable()) {
            ProxyComposition clzProxy = new ProxyComposition(hTarget.getComposition(), typeTarget);
            return frame.assignValue(-1, Proxy.makeHandle(clzProxy, ctxTarget, hTarget, false));
        }
        if (typeProxy != null && typeProxy.isInterfaceType() && (typeComposition = hTarget.getComposition()) instanceof ClassComposition) {
            ClassComposition clzTarget = (ClassComposition)typeComposition;
            if (typeProxy.containsGenericType(true)) {
                typeProxy = typeProxy.resolveGenerics(frame.poolContext(), typeTarget);
            }
            if (!typeTarget.isA(typeProxy)) {
                return frame.raiseException("Failed to resolve a proxy type " + typeProxy.getValueString() + " to match the proxied object " + typeTarget.getValueString());
            }
            try {
                ProxyComposition clzProxy = clzTarget.ensureProxyComposition(typeProxy);
                return frame.assignValue(-1, Proxy.makeHandle(clzProxy, ctxTarget, hTarget, false));
            }
            catch (Throwable e) {
                return frame.raiseException("Failed to create a proxy for " + typeTarget.getValueString());
            }
        }
        return frame.raiseException(xException.mutableObject(frame, typeTarget));
    }

    public int invoke1(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        return frame.invoke1(chain, 0, hTarget, ahVar, iReturn);
    }

    public int invokeT(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        return frame.invokeT(chain, 0, hTarget, ahVar, iReturn);
    }

    public int invokeN(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
        return frame.invokeN(chain, 0, hTarget, ahVar, aiReturn);
    }

    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return frame.raiseException("Unknown native(1) method: \"" + String.valueOf(method) + "\" on " + String.valueOf(this));
    }

    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (ahArg.length) {
            case 0: {
                switch (method.getName()) {
                    case "toString": {
                        return this.buildStringValue(frame, hTarget, iReturn);
                    }
                    case "makeImmutable": {
                        return this.makeImmutable(hTarget) ? frame.assignValue(iReturn, hTarget) : frame.raiseException(xException.unsupported(frame, "makeImmutable"));
                    }
                }
                break;
            }
            case 3: {
                if (!"equals".equals(method.getName())) break;
                return frame.assignValue(iReturn, xBoolean.makeHandle(ahArg[1] == ahArg[2]));
            }
        }
        return frame.raiseException("Unknown native(N) method: \"" + String.valueOf(method) + "\" on " + String.valueOf(this));
    }

    public int invokeNativeT(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        if (method.getParamCount() == 1) {
            switch (method.getReturnCount()) {
                case 0: {
                    return switch (this.invokeNative1(frame, method, hTarget, ahArg[0], -2)) {
                        case -1 -> frame.assignValue(iReturn, xTuple.H_VOID);
                        case -5 -> {
                            frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xTuple.H_VOID));
                            yield -5;
                        }
                        case -3 -> -3;
                        default -> throw new IllegalStateException();
                    };
                }
                case 1: {
                    return switch (this.invokeNative1(frame, method, hTarget, ahArg[0], -1)) {
                        case -1 -> frame.assignTuple(iReturn, frame.popStack());
                        case -5 -> {
                            frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignTuple(iReturn, frameCaller.popStack()));
                            yield -5;
                        }
                        case -3 -> -3;
                        default -> throw new IllegalStateException();
                    };
                }
            }
            throw new UnsupportedOperationException();
        }
        return switch (method.getReturnCount()) {
            case 0 -> {
                switch (this.invokeNativeN(frame, method, hTarget, ahArg, -2)) {
                    case -1: {
                        yield frame.assignValue(iReturn, xTuple.H_VOID);
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xTuple.H_VOID));
                        yield -5;
                    }
                    case -3: {
                        yield -3;
                    }
                }
                throw new IllegalStateException();
            }
            case 1 -> {
                switch (this.invokeNativeN(frame, method, hTarget, ahArg, -1)) {
                    case -1: {
                        yield frame.assignTuple(iReturn, frame.popStack());
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, frameCaller.popStack()));
                        yield -5;
                    }
                    case -3: {
                        yield -3;
                    }
                }
                throw new IllegalStateException();
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        return frame.raiseException("Unknown native(NN) method: \"" + String.valueOf(method) + "\" on " + String.valueOf(this));
    }

    public String[] getImplicitFields() {
        return this.f_asFieldsImplicit;
    }

    public int getPropertyValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        CallChain chain;
        TypeComposition clzTarget;
        block12: {
            block14: {
                Component clzProp2;
                block13: {
                    PropertyComposition clzProp2;
                    assert (idProp != null);
                    clzTarget = hTarget.getComposition();
                    chain = clzTarget.getPropertyGetterChain(idProp);
                    if (chain != null) break block12;
                    if (!(hTarget instanceof xRef.RefHandle)) break block13;
                    xRef.RefHandle hRef = (xRef.RefHandle)hTarget;
                    if (!hRef.isProperty() || !(clzTarget instanceof PropertyComposition) || (chain = (clzTarget = (clzProp2 = (PropertyComposition)clzTarget).getParentComposition()).getPropertyGetterChain(idProp)) == null) break block14;
                    hTarget = hRef.getReferentHolder();
                    break block12;
                }
                if (!frame.isNative() && (clzProp2 = frame.f_function.getParent().getParent()) instanceof PropertyStructure) {
                    PropertyStructure prop = (PropertyStructure)clzProp2;
                    switch (this.createPropertyRef(frame, hTarget, prop.getIdentityConstant(), !prop.isVarAccessible(Constants.Access.PUBLIC), -1)) {
                        case -1: {
                            xRef.RefHandle hRef = (xRef.RefHandle)frame.popStack();
                            return hRef.getTemplate().getPropertyValue(frame, hRef, idProp, iReturn);
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> {
                                xRef.RefHandle hRef = (xRef.RefHandle)frameCaller.popStack();
                                return hRef.getTemplate().getPropertyValue(frameCaller, hRef, idProp, iReturn);
                            });
                            return -5;
                        }
                        case -3: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
            return frame.raiseException(xException.unknownProperty(frame, idProp.getName(), hTarget.getType()));
        }
        if (chain.isNative()) {
            return this.invokeNativeGet(frame, idProp.getName(), hTarget, iReturn);
        }
        if (chain.isField()) {
            return clzTarget.getFieldValue(frame, hTarget, idProp, iReturn);
        }
        if (clzTarget.isStruct()) {
            return frame.raiseException("Invalid property \"" + idProp.getName() + "\" access from " + clzTarget.getType().getValueString());
        }
        MethodStructure method = chain.getTop();
        ObjectHandle[] ahVar = new ObjectHandle[method.getMaxVars()];
        ClassComposition.FieldInfo field = clzTarget.getFieldInfo(idProp);
        if (field != null && field.isInflated()) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, field);
            if (hRef.getComposition().isStruct()) {
                CallChain chain0 = chain;
                Frame.Continuation stepNext = frameCaller -> frameCaller.invoke1(chain0, 0, frameCaller.popStack(), ahVar, iReturn);
                return this.finishRefConstruction(frame, hRef, hThis, idProp, stepNext);
            }
            hTarget = hRef;
        }
        return frame.invoke1(chain, 0, hTarget, ahVar, iReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        xRef.RefHandle hRef;
        ObjectHandle hValue;
        assert (idProp != null);
        if (!this.isGenericHandle()) {
            return frame.raiseException("Not supported property: " + idProp.getName() + " for " + hTarget.getType().getValueString());
        }
        ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
        ClassComposition.FieldInfo field = hThis.getFieldInfo(idProp);
        ObjectHandle objectHandle = hValue = field.isTransient() ? hThis.getTransientField(frame, field) : hThis.getField(field.getIndex());
        if (hValue == null) {
            Constant contInit;
            if (hThis.isInjected(idProp)) {
                ObjectHandle.GenericHandle genericHandle = hThis;
                synchronized (genericHandle) {
                    hValue = hThis.getField(field.getIndex());
                    if (hValue == null) {
                        return this.getInjectedProperty(frame, hThis, idProp, iReturn);
                    }
                }
                if (Op.isDeferred(hValue)) {
                    return this.waitForInjectedProperty(frame, hThis, idProp, iReturn);
                }
            } else if (field.isTransient() && (contInit = field.constInit) != null) {
                ObjectHandle.TransientId hId = (ObjectHandle.TransientId)hThis.getField(field.getIndex());
                hValue = frame.getConstHandle(contInit);
                if (Op.isDeferred(hValue)) {
                    return hValue.proceed(frame, frameCaller -> {
                        ObjectHandle hV = frameCaller.popStack();
                        frameCaller.f_context.setTransientValue(hId, hV);
                        return frameCaller.assignValue(iReturn, hV);
                    });
                }
                frame.f_context.setTransientValue(hId, hValue);
            } else {
                String sErr = hThis.containsField(idProp) ? "Un-initialized property \"" : "Invalid property \"";
                return frame.raiseException(xException.illegalState(frame, sErr + String.valueOf(idProp) + "\""));
            }
        }
        if (field.isInflated() && !((hRef = (xRef.RefHandle)hValue) instanceof xFuture.FutureHandle)) {
            if (hRef.getComposition().isStruct()) {
                Frame.Continuation stepNext = frameCaller -> {
                    xRef.RefHandle hR = (xRef.RefHandle)frameCaller.popStack();
                    return ((xRef)hR.getTemplate()).getReferent(frameCaller, hR, iReturn);
                };
                return this.finishRefConstruction(frame, hRef, hThis, idProp, stepNext);
            }
            return ((xRef)hRef.getTemplate()).getReferent(frame, hRef, iReturn);
        }
        return frame.assignValue(iReturn, hValue);
    }

    private int getInjectedProperty(Frame frame, ObjectHandle.GenericHandle hThis, PropertyConstant idProp, int iReturn) {
        xEnum.EnumHandle hOpts;
        String string;
        Constant constName;
        TypeInfo info = hThis.getType().ensureAccess(Constants.Access.PRIVATE).ensureTypeInfo();
        PropertyInfo prop = info.findProperty(idProp, true);
        Annotation anno = prop.getRefAnnotations()[0];
        Constant[] aParams = anno.getParams();
        Constant constant = constName = aParams.length == 0 ? null : aParams[0];
        if (constName instanceof StringConstant) {
            StringConstant constString = (StringConstant)constName;
            string = constString.getValue();
        } else {
            string = prop.getName();
        }
        String sResource = string;
        ObjectHandle objectHandle = hOpts = aParams.length < 2 ? xNullable.NULL : frame.getConstHandle(aParams[1]);
        if (Op.isDeferred(hOpts)) {
            return hOpts.proceed(frame, frameCaller -> this.getInjectedProperty(frameCaller, hThis, idProp, iReturn));
        }
        ObjectHandle hValue = frame.getInjected(sResource, prop.getType(), hOpts);
        if (hValue == null) {
            return frame.raiseException(xException.unknownInjectable(frame, prop.getType(), sResource));
        }
        hThis.setField(frame, idProp, hValue);
        if (Op.isDeferred(hValue)) {
            return hValue.proceed(frame, frameCaller -> {
                ObjectHandle hVal = frameCaller.popStack();
                hThis.setField(frameCaller, idProp, hVal);
                return frameCaller.assignValue(iReturn, hVal);
            });
        }
        return frame.assignValue(iReturn, hValue);
    }

    private int waitForInjectedProperty(Frame frame, final ObjectHandle.GenericHandle hThis, final PropertyConstant idProp, int iReturn) {
        Op[] aOpCheckAndPause = new Op[]{new Op(this){

            @Override
            public int process(Frame frame, int iPC) {
                ObjectHandle hValue = hThis.getField(frame, idProp);
                return 2.isDeferred(hValue) ? -9 : frame.returnValue(hValue, false);
            }

            @Override
            public String toString() {
                return "CheckAndYield";
            }
        }};
        Frame frameWait = frame.createNativeFrame(aOpCheckAndPause, Utils.OBJECTS_NONE, iReturn, null);
        return frame.call(frameWait);
    }

    public int setPropertyValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        assert (idProp != null);
        if (hTarget.isStruct()) {
            return this.setFieldValue(frame, hTarget, idProp, hValue);
        }
        TypeComposition clzTarget = hTarget.getComposition();
        CallChain chain = clzTarget.getPropertySetterChain(idProp);
        if (chain == null) {
            PropertyComposition clzProp;
            xRef.RefHandle hRef;
            if (hTarget instanceof xRef.RefHandle && (hRef = (xRef.RefHandle)hTarget).isProperty() && clzTarget instanceof PropertyComposition && (chain = (clzTarget = (clzProp = (PropertyComposition)clzTarget).getParentComposition()).getPropertySetterChain(idProp)) != null) {
                hTarget = hRef.getReferentHolder();
            } else {
                return frame.raiseException(xException.unknownProperty(frame, idProp.getName(), hTarget.getType()));
            }
        }
        if (chain.isNative()) {
            return this.invokeNativeSet(frame, hTarget, idProp.getName(), hValue);
        }
        if (chain.isField()) {
            return clzTarget.setFieldValue(frame, hTarget, idProp, hValue);
        }
        MethodStructure method = chain.getTop();
        ObjectHandle[] ahVar = new ObjectHandle[method.getMaxVars()];
        ahVar[0] = hValue;
        ClassComposition.FieldInfo field = clzTarget.getFieldInfo(idProp);
        if (field != null && field.isInflated()) {
            hTarget = ((ObjectHandle.GenericHandle)hTarget).getField(frame, field);
            assert (hTarget instanceof xRef.RefHandle);
        }
        return frame.invoke1(chain, 0, hTarget, ahVar, -2);
    }

    public int setFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        assert (idProp != null);
        ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
        if (!hThis.containsField(idProp)) {
            return frame.raiseException("Property is missing: " + idProp.getValueString());
        }
        ClassComposition.FieldInfo field = hThis.getFieldInfo(idProp);
        if (!hThis.isMutable() && !field.isTransient()) {
            return frame.raiseException(xException.immutableObjectProperty(frame, idProp.getName(), hThis.getType()));
        }
        if (!(hValue instanceof ObjectHandle.InitializingHandle) && !hValue.getUnsafeType().isA(field.getType())) {
            return frame.raiseException(xException.typeMismatch(frame, hValue.getType().getValueString()));
        }
        if (field.isInflated()) {
            xRef.RefHandle hRef = (xRef.RefHandle)(field.isTransient() ? hThis.getTransientField(frame, field) : hThis.getField(field.getIndex()));
            xVar template = (xVar)hRef.getTemplate();
            if (hThis.isStruct()) {
                template.setNativeReferent(frame, hRef, hValue);
            } else {
                template.setReferent(frame, hRef, hValue);
            }
        } else if (field.isTransient()) {
            hThis.setTransientField(frame, field.getIndex(), hValue);
        } else {
            hThis.setField(field.getIndex(), hValue);
        }
        return -1;
    }

    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        TypeConstant typeTarget = hTarget.getType();
        if (typeTarget.containsGenericParam(sPropName)) {
            TypeConstant type = typeTarget.resolveGenericType(sPropName);
            return frame.assignValue(iReturn, type.ensureTypeHandle(frame.f_context.f_container));
        }
        return frame.raiseException("Unknown native property: \"" + sPropName + "\" on " + String.valueOf(this));
    }

    public int invokeNativeSet(Frame frame, ObjectHandle hTarget, String sPropName, ObjectHandle hValue) {
        return frame.raiseException("Unknown native property: \"" + sPropName + "\" on " + String.valueOf(this));
    }

    public int invokePreInc(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarPreInc(frame, hRef, iReturn);
        }
        return new Utils.InPlacePropertyUnary(Utils.UnaryAction.INC, this, hTarget, idProp, false, iReturn).doNext(frame);
    }

    public int invokePostInc(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarPostInc(frame, hRef, iReturn);
        }
        return new Utils.InPlacePropertyUnary(Utils.UnaryAction.INC, this, hTarget, idProp, true, iReturn).doNext(frame);
    }

    public int invokePreDec(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarPreDec(frame, hRef, iReturn);
        }
        return new Utils.InPlacePropertyUnary(Utils.UnaryAction.DEC, this, hTarget, idProp, false, iReturn).doNext(frame);
    }

    public int invokePostDec(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarPostDec(frame, hRef, iReturn);
        }
        return new Utils.InPlacePropertyUnary(Utils.UnaryAction.DEC, this, hTarget, idProp, true, iReturn).doNext(frame);
    }

    public int invokePropertyAdd(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarAdd(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.ADD, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertySub(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarSub(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.SUB, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyMul(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarMul(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.MUL, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyDiv(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarDiv(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.DIV, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyMod(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarMod(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.MOD, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyShl(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarShl(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.SHL, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyShr(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarShr(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.SHR, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyShrAll(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarShrAll(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.USHR, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyAnd(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarAnd(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.AND, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyOr(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarOr(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.OR, this, hTarget, idProp, hArg).doNext(frame);
    }

    public int invokePropertyXor(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        if (hTarget.isInflated(idProp)) {
            ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)hTarget;
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            return hRef.getVarSupport().invokeVarXor(frame, hRef, hArg);
        }
        return new Utils.InPlacePropertyBinary(Utils.BinaryAction.XOR, this, hTarget, idProp, hArg).doNext(frame);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int createPropertyRef(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, boolean fRO, int iReturn) {
        ObjectHandle.GenericHandle hThis;
        ClassComposition clzThis;
        TypeComposition clzTarget = hTarget.getComposition();
        if (clzTarget instanceof ClassComposition) {
            ClassComposition clz;
            clzThis = clz = (ClassComposition)clzTarget;
            hThis = (ObjectHandle.GenericHandle)hTarget;
        } else {
            if (!(clzTarget instanceof PropertyComposition)) return frame.raiseException("Invalid Ref for " + idProp.getName() + " at " + String.valueOf(hTarget.getType()));
            PropertyComposition clzProp = (PropertyComposition)clzTarget;
            if (!(hTarget instanceof xRef.RefHandle)) return frame.raiseException("Invalid Ref for " + idProp.getName() + " at " + String.valueOf(hTarget.getType()));
            xRef.RefHandle hRef = (xRef.RefHandle)hTarget;
            clzThis = clzProp.getParentComposition();
            hThis = (ObjectHandle.GenericHandle)hRef.getReferentHolder();
        }
        if (!hThis.containsField(idProp) && clzThis.getPropertyGetterChain(idProp) == null) {
            return frame.raiseException(xException.unknownProperty(frame, idProp.getName(), hThis.getType()));
        }
        if (hThis.isInflated(idProp)) {
            xRef.RefHandle hRef = (xRef.RefHandle)hThis.getField(frame, idProp);
            if (!hRef.getComposition().isStruct()) return frame.assignValue(iReturn, hRef);
            Frame.Continuation stepNext = frameCaller -> frameCaller.assignValue(iReturn, frameCaller.popStack());
            return this.finishRefConstruction(frame, hRef, hThis, idProp, stepNext);
        }
        PropertyInfo infoProp = clzThis.getPropertyInfo(idProp);
        if (infoProp == null) {
            return frame.raiseException(xException.unknownProperty(frame, idProp.getName(), hThis.getType()));
        }
        PropertyComposition clzRef = clzThis.ensurePropertyComposition(infoProp);
        xRef.RefHandle hRef = new xRef.RefHandle(clzRef, frame, hThis, idProp);
        return frame.assignValue(iReturn, hRef);
    }

    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        if (hValue1 == hValue2) {
            return frame.assignValue(iReturn, xBoolean.TRUE);
        }
        CallChain chain = clazz.getMethodCallChain(clazz.getConstantPool().sigEquals());
        if (chain != null && !chain.isNative()) {
            ObjectHandle[] ahVars = new ObjectHandle[chain.getMaxVars()];
            ahVars[0] = clazz.getType().ensureTypeHandle(frame.f_context.f_container);
            ahVars[1] = hValue1;
            ahVars[2] = hValue2;
            return frame.call1(chain.getTop(), null, ahVars, iReturn);
        }
        return this.callEqualsImpl(frame, clazz, hValue1, hValue2, iReturn);
    }

    protected int callEqualsImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        ClassTemplate template;
        TypeConstant type;
        if (!hValue1.isMutable() && !hValue2.isMutable() && (type = hValue1.getType()).equals(hValue2.getType()) && (template = hValue1.getTemplate()) == hValue2.getTemplate() && template instanceof xConst) {
            clazz = template.ensureClass(frame.f_context.f_container, type);
            return template.callEquals(frame, clazz, hValue1, hValue2, iReturn);
        }
        return frame.assignValue(iReturn, xBoolean.FALSE);
    }

    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        if (hValue1 == hValue2) {
            return frame.assignValue(iReturn, xOrdered.EQUAL);
        }
        CallChain chain = clazz.getMethodCallChain(clazz.getConstantPool().sigCompare());
        if (chain != null && !chain.isNative()) {
            ObjectHandle[] ahVars = new ObjectHandle[chain.getMaxVars()];
            ahVars[0] = clazz.getType().ensureTypeHandle(frame.f_context.f_container);
            ahVars[1] = hValue1;
            ahVars[2] = hValue2;
            return frame.call1(chain.getTop(), null, ahVars, iReturn);
        }
        return this.callCompareImpl(frame, clazz, hValue1, hValue2, iReturn);
    }

    protected int callCompareImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.raiseException(xException.abstractMethod(frame, this.f_sName + ".compare()"));
    }

    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        return hValue1 == hValue2;
    }

    @Override
    public ClassTemplate getTemplate(TypeConstant type) {
        if (type instanceof AnnotatedTypeConstant) {
            TypeConstant typeBase;
            AnnotatedTypeConstant typeAnno = (AnnotatedTypeConstant)type;
            while ((typeBase = typeAnno.getUnderlyingType()) instanceof AnnotatedTypeConstant) {
                AnnotatedTypeConstant typeAnnoBase;
                typeAnno = typeAnnoBase = (AnnotatedTypeConstant)typeBase;
            }
            return this.f_container.getTemplate(typeBase);
        }
        return this;
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "add", "+", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "sub", "-", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "mul", "*", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "div", "/", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeMod(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "mod", "%", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeShl(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "shiftLeft", "<<", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeShr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "shiftRight", ">>", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeShrAll(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "shiftAllRight", ">>>", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeAnd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "and", "&", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeOr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "or", "|", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeXor(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "xor", "^", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeDivRem(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
        return this.getOpChain(frame, hTarget, "divrem", "/%", hArg).invoke(frame, hTarget, hArg, aiReturn);
    }

    @Override
    public int invokeIRangeI(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "to", "..", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeERangeI(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "exTo", ">..", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeIRangeE(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "toEx", "..<", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeERangeE(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.getOpChain(frame, hTarget, "exToEx", ">..<", hArg).invoke(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNeg(Frame frame, ObjectHandle hTarget, int iReturn) {
        return this.getOpChain(frame, hTarget, "neg", null, null).invoke(frame, hTarget, iReturn);
    }

    @Override
    public int invokeCompl(Frame frame, ObjectHandle hTarget, int iReturn) {
        return this.getOpChain(frame, hTarget, "not", "~", null).invoke(frame, hTarget, iReturn);
    }

    @Override
    public int invokeNext(Frame frame, ObjectHandle hTarget, int iReturn) {
        return this.getOpChain(frame, hTarget, "nextValue", null, null).invoke(frame, hTarget, iReturn);
    }

    @Override
    public int invokePrev(Frame frame, ObjectHandle hTarget, int iReturn) {
        return this.getOpChain(frame, hTarget, "prevValue", null, null).invoke(frame, hTarget, iReturn);
    }

    protected CallChain getOpChain(Frame frame, ObjectHandle hTarget, String sName, String sOp, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, sName, sOp, hArg);
        if (chain == null) {
            chain = new CallChain.ExceptionChain(xException.makeHandle(frame, "Missing operation \"" + sOp + "\" on " + hTarget.getType().getValueString()));
        }
        return chain;
    }

    public CallChain findOpChain(ObjectHandle hTarget, String sName, String sOp, ObjectHandle hArg) {
        TypeInfo info = hTarget.getType().ensureTypeInfo();
        Set<MethodConstant> setMethods = info.findOpMethods(sName, sOp, hArg == null ? 0 : 1);
        switch (setMethods.size()) {
            case 0: {
                return null;
            }
            case 1: {
                TypeConstant typeParam;
                TypeConstant typeArg;
                MethodConstant idMethod = setMethods.iterator().next();
                SignatureConstant sig = idMethod.getSignature();
                if (hArg != null && !(typeArg = hArg.getType()).isA(typeParam = sig.getRawParams()[0])) {
                    System.err.println("Invalid argument type \"" + typeArg.getValueString() + "\" for \"" + sName + "\" operation on " + hTarget.getType().getValueString());
                    return null;
                }
                return hTarget.getComposition().getMethodCallChain(sig);
            }
        }
        if (hArg != null) {
            SignatureConstant sigBest = null;
            TypeConstant typeArg = hArg.getType();
            for (MethodConstant idMethod : setMethods) {
                SignatureConstant sig = idMethod.getSignature();
                TypeConstant typeParam = sig.getRawParams()[0];
                if (!typeArg.isA(typeParam)) continue;
                if (sigBest == null) {
                    sigBest = sig;
                    continue;
                }
                if (sigBest.equals(sig)) continue;
                int nBestDepth = sigBest.getRawParams()[0].getTypeDepth();
                int nParamDepth = typeParam.getTypeDepth();
                if (nParamDepth < nBestDepth) {
                    sigBest = sig;
                    continue;
                }
                if (nParamDepth != nBestDepth) continue;
                sigBest = null;
                break;
            }
            if (sigBest != null) {
                return hTarget.getComposition().getMethodCallChain(sigBest);
            }
        }
        System.err.println("Ambiguous \"" + sName + "\" operation on " + hTarget.getType().getValueString());
        return null;
    }

    public CallChain findOpChain(ObjectHandle hTarget, String sOp, ObjectHandle[] ahArg) {
        TypeInfo info = hTarget.getType().ensureTypeInfo();
        int cArgs = ahArg.length;
        Set<MethodConstant> setMethods = info.findOpMethods(sOp, sOp, cArgs);
        switch (setMethods.size()) {
            case 0: {
                return null;
            }
            case 1: {
                MethodConstant idMethod = setMethods.iterator().next();
                return hTarget.getComposition().getMethodCallChain(idMethod.getSignature());
            }
        }
        block4: for (MethodConstant idMethod : setMethods) {
            SignatureConstant sig = idMethod.getSignature();
            for (int i = 0; i < cArgs; ++i) {
                TypeConstant typeParam;
                ObjectHandle hArg = ahArg[i];
                TypeConstant typeArg = hArg.getType();
                if (!typeArg.isA(typeParam = sig.getRawParams()[i])) continue block4;
            }
            return hTarget.getComposition().getMethodCallChain(sig);
        }
        System.err.println("Ambiguous \"" + sOp + "\" operation on " + hTarget.getType().getValueString());
        return null;
    }

    protected int callValidator(final Frame frame, final ObjectHandle hStruct) {
        TypeComposition clz = hStruct.getComposition();
        final CallChain chain = clz.getMethodCallChain(clz.getConstantPool().sigValidator());
        if (chain.isNative()) {
            return -1;
        }
        MethodStructure method = chain.getTop();
        Frame frameTop = frame.createFrame1(method, hStruct, new ObjectHandle[method.getMaxVars()], -2);
        if (chain.getDepth() > 1) {
            Frame.Continuation nextStep = new Frame.Continuation(){
                private int index = 1;

                @Override
                public int proceed(Frame frameCaller) {
                    MethodStructure methodNext = chain.getMethod(this.index);
                    Frame frameNext = frameCaller.createFrame1(methodNext, hStruct, new ObjectHandle[methodNext.getMaxVars()], -2);
                    if (++this.index < chain.getDepth()) {
                        frameNext.addContinuation(this);
                    }
                    return frame.callInitialized(frameNext);
                }
            };
            frameTop.addContinuation(nextStep);
        }
        return frame.callInitialized(frameTop);
    }

    protected int finishRefConstruction(Frame frame, xRef.RefHandle hRef, ObjectHandle.GenericHandle hOuter, PropertyConstant idProp, Frame.Continuation continuation) {
        AnnotatedTypeConstant constAnno = (AnnotatedTypeConstant)hRef.getComposition().getBaseType();
        TypeConstant typeAnno = constAnno.getAnnotationType();
        ClassTemplate anno = frame.f_context.f_container.getTemplate(typeAnno);
        switch (anno.proceedConstruction(frame, null, true, hRef, Utils.OBJECTS_NONE, -1)) {
            case -1: {
                hRef = (xRef.RefHandle)frame.peekStack();
                hRef.setField(frame, "$outer", (ObjectHandle)hOuter);
                hOuter.setField(frame, idProp, (ObjectHandle)hRef);
                return continuation.proceed(frame);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    xRef.RefHandle hRefPublic = (xRef.RefHandle)frameCaller.peekStack();
                    hRefPublic.setField(frameCaller, "$outer", (ObjectHandle)hOuter);
                    hOuter.setField(frameCaller, idProp, (ObjectHandle)hRefPublic);
                    return continuation.proceed(frameCaller);
                });
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    public int overflow(Frame frame) {
        return frame.raiseException(xException.outOfBounds(frame, this.f_sName + " overflow"));
    }

    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        return frame.assignValue(iReturn, xString.makeHandle(hTarget.toString()));
    }

    protected void invalidateTypeInfo() {
        this.getStructure().getCanonicalType().invalidateTypeInfo();
    }

    public ConstantPool pool() {
        return this.f_container.getConstantPool();
    }

    public void markNativeMethod(String sName, String[] asParamType, String[] asRetType) {
        TypeConstant[] atypeParam = this.getTypeConstants(this, asParamType);
        TypeConstant[] atypeReturn = this.getTypeConstants(this, asRetType);
        MethodStructure method = this.getStructure().findMethodDeep(sName, m -> {
            int i;
            if (atypeParam != null) {
                TypeConstant[] atypeParamTest = m.getIdentityConstant().getRawParams();
                int cParams = atypeParamTest.length;
                if (cParams != atypeParam.length) {
                    return false;
                }
                for (i = 0; i < cParams; ++i) {
                    if (atypeParamTest[i].isA(atypeParam[i])) continue;
                    return false;
                }
            }
            if (atypeReturn != null) {
                TypeConstant[] atypeReturnTest = m.getIdentityConstant().getRawReturns();
                int cReturns = atypeReturnTest.length;
                if (cReturns != atypeReturn.length) {
                    return false;
                }
                for (i = 0; i < cReturns; ++i) {
                    if (atypeReturnTest[i].isA(atypeReturn[i])) continue;
                    return false;
                }
            }
            return true;
        });
        if (method == null) {
            System.err.println("Missing method " + this.f_sName + "." + sName + " " + Arrays.toString(asParamType) + "->" + Arrays.toString(asRetType));
        } else if (!method.isNative()) {
            ClassStructure clz = method.getContainingClass();
            if (clz != this.f_struct) {
                if (method.isFunction()) {
                    throw new IllegalStateException("Native function " + method.getIdentityConstant().getValueString() + " at " + this.f_sName);
                }
                Constants.Access access = method.getAccess();
                if (access == Constants.Access.PRIVATE) {
                    throw new IllegalStateException("Inaccessible method " + method.getIdentityConstant().getValueString() + " at " + this.f_sName);
                }
                ConstantPool pool = this.pool();
                Annotation annoOverride = pool.ensureAnnotation(pool.clzOverride(), new Constant[0]);
                method = this.f_struct.createMethod(false, access, new Annotation[]{annoOverride}, method.getReturnArray(), method.getName(), method.getParamArray(), false, false);
                method.setSynthetic(true);
            }
            method.markNative();
        }
    }

    private TypeConstant[] getTypeConstants(ClassTemplate template, String[] asType) {
        if (asType == null) {
            return null;
        }
        int cTypes = asType.length;
        TypeConstant[] aType = new TypeConstant[cTypes];
        for (int i = 0; i < cTypes; ++i) {
            aType[i] = this.getClassType(asType[i].trim(), template);
        }
        return aType;
    }

    private TypeConstant getClassType(String sName, ClassTemplate template) {
        ConstantPool pool = template.pool();
        if (sName.startsWith("immutable ")) {
            return this.getClassType(sName.substring("immutable ".length()), template).freeze();
        }
        if (sName.startsWith("@")) {
            int ofEnd = sName.indexOf(" ", 1);
            if (ofEnd < 0) {
                throw new IllegalArgumentException("Invalid annotation: " + sName);
            }
            TypeConstant typeAnno = this.getClassType(sName.substring(1, ofEnd), template);
            TypeConstant typeMain = this.getClassType(sName.substring(ofEnd + 1), template);
            return pool.ensureAnnotatedTypeConstant(typeAnno.getDefiningConstant(), null, typeMain);
        }
        boolean fNullable = sName.endsWith("?");
        if (fNullable) {
            sName = sName.substring(0, sName.length() - 1);
        }
        TypeConstant constType = null;
        int ofTypeParam = sName.indexOf(60);
        if (ofTypeParam >= 0) {
            ClassConstant idClass;
            String sParam = sName.substring(ofTypeParam + 1, sName.length() - 1);
            String sSimpleName = sName.substring(0, ofTypeParam);
            if (sSimpleName.endsWith("!")) {
                sSimpleName = sSimpleName.substring(0, sSimpleName.length() - 1);
            }
            if ((idClass = pool.ensureEcstasyClassConstant(sSimpleName)) != null) {
                String[] asType = Handy.parseDelimitedString(sParam, ',');
                TypeConstant[] acType = this.getTypeConstants(template, asType);
                constType = pool.ensureClassTypeConstant(idClass, null, acType);
            }
        } else {
            if ("this".equals(sName)) {
                IdentityConstant constId = template == null ? pool.clzObject() : template.getClassConstant();
                return pool.ensureThisTypeConstant(constId, null);
            }
            ClassStructure struct = template.getStructure();
            if (template != null && struct.indexOfGenericParameter(sName) >= 0) {
                PropertyStructure prop = (PropertyStructure)struct.getChild(sName);
                return pool.ensureTerminalTypeConstant(prop.getIdentityConstant());
            }
            ClassStructure component = this.f_container.getClassStructure(sName);
            if (component != null) {
                IdentityConstant constId = component.getIdentityConstant();
                switch (constId.getFormat()) {
                    case Module: 
                    case Package: 
                    case Class: {
                        TypeConstant typeConstant = constId.getType();
                        break;
                    }
                    case Typedef: {
                        TypeConstant typeConstant = ((TypedefStructure)((Object)component)).getType();
                        break;
                    }
                    default: {
                        TypeConstant typeConstant = constType = constType;
                    }
                }
            }
        }
        if (constType == null) {
            throw new IllegalArgumentException("ClassTypeConstant is not defined: " + sName);
        }
        return fNullable ? constType.ensureNullable() : constType;
    }

    public void markNativeProperty(String sPropName) {
        PropertyStructure prop = this.getStructure().findPropertyDeep(sPropName);
        if (prop == null) {
            System.err.println("Missing property " + this.f_sName + "." + sPropName);
        } else {
            Constants.Access accessRef = prop.getAccess();
            if (!prop.isNative()) {
                ClassStructure clz = prop.getContainingClass();
                if (clz == this.f_struct) {
                    MethodStructure methSetter;
                    MethodStructure methGetter = prop.getGetter();
                    if (methGetter != null) {
                        methGetter.markNative();
                    }
                    if ((methSetter = prop.getSetter()) != null) {
                        methSetter.markNative();
                    }
                    if (!(methGetter != null || methSetter != null || prop.isExplicitReadOnly() || prop.isExplicitOverride() || prop.isRefAnnotated())) {
                        prop.addAnnotation(this.pool().clzUnassigned(), new Constant[0]);
                    }
                    prop.markNative();
                } else if (accessRef != Constants.Access.PRIVATE) {
                    if (prop.isStatic()) {
                        throw new IllegalStateException("Native static property " + sPropName + " at " + this.f_sName);
                    }
                    Constants.Access accessVar = prop.getVarAccess();
                    if (accessVar == Constants.Access.PRIVATE) {
                        throw new IllegalStateException("Inaccessible property " + sPropName + " at " + this.f_sName);
                    }
                    ConstantPool pool = this.pool();
                    PropertyStructure propOver = this.f_struct.createProperty(false, accessRef, accessVar, prop.getType(), sPropName);
                    if (prop.containsPropertyAnnotation(pool.clzRO())) {
                        propOver.addAnnotation(pool.clzRO(), new Constant[0]);
                    }
                    propOver.addAnnotation(pool.clzOverride(), new Constant[0]);
                    propOver.setSynthetic(true);
                    propOver.markNative();
                    if (prop.getGetter() != null) {
                        Parameter[] aParams = Parameter.NO_PARAMS;
                        Parameter[] aReturns = new Parameter[]{new Parameter(pool, prop.getType(), null, null, true, 0, false)};
                        MethodStructure methodGet = propOver.createMethod(false, accessRef, null, aReturns, "get", aParams, false, false);
                        methodGet.addAnnotation(pool.clzOverride(), new Constant[0]);
                        methodGet.setSynthetic(true);
                        methodGet.markNative();
                    }
                }
            }
        }
    }

    protected class Construct
    implements Frame.Continuation {
        private final MethodStructure constructor;
        private final ObjectHandle hStruct;
        private final ObjectHandle[] ahVar;
        private final int iReturn;
        private final Annotation[] aAnnoMixin;
        private final boolean fAnonymous;
        private int ixAnno;
        private List<Frame> listFinalizable;
        private int ixStep;

        public Construct(MethodStructure constructor, boolean fInitStruct, ObjectHandle hStruct, ObjectHandle[] ahVar, int iReturn) {
            this.constructor = constructor;
            this.hStruct = hStruct;
            this.ahVar = ahVar;
            this.iReturn = iReturn;
            TypeComposition composition = hStruct.getComposition();
            assert (composition.isStruct());
            assert (fInitStruct || constructor == null);
            this.aAnnoMixin = composition.getBaseType().ensureTypeInfo().getMixinAnnotations();
            this.ixStep = fInitStruct ? 0 : 2;
            this.ixAnno = 0;
            this.fAnonymous = constructor != null && constructor.isAnonymousClassWrapperConstructor();
        }

        @Override
        public int proceed(Frame frameCaller) {
            block15: while (true) {
                int iResult;
                switch (this.ixStep++) {
                    case 0: {
                        if (this.fAnonymous) {
                            this.ixStep = 2;
                            iResult = frameCaller.call1(this.constructor, this.hStruct, this.ahVar, -2);
                            break;
                        }
                        ++this.ixStep;
                    }
                    case 1: {
                        MethodStructure methodAI = this.hStruct.getComposition().ensureAutoInitializer();
                        if (methodAI != null) {
                            iResult = frameCaller.call1(methodAI, this.hStruct, Utils.OBJECTS_NONE, -2);
                            break;
                        }
                        ++this.ixStep;
                    }
                    case 2: {
                        if (this.aAnnoMixin.length > 0) {
                            Annotation anno = this.aAnnoMixin[this.ixAnno++];
                            Constant[] aconstArgs = anno.getParams();
                            int cArgs = aconstArgs.length;
                            ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
                            ClassStructure structAnno = (ClassStructure)idAnno.getComponent();
                            MethodStructure ctorAnno = structAnno.findMethod("construct", cArgs, new TypeConstant[0]);
                            if (structAnno.isVirtualChild() && !this.hStruct.getComposition().hasOuter()) {
                                return frameCaller.raiseException("Annotation \"" + idAnno.getValueString() + "\" requires a parent, which is missing");
                            }
                            if (ctorAnno.isNoOp()) {
                                iResult = -1;
                            } else {
                                ObjectHandle[] ahArgs = new ObjectHandle[ctorAnno.getMaxVars()];
                                Frame frameCtor = frameCaller.createFrame1(ctorAnno, this.hStruct, ahArgs, -2);
                                for (int i = 0; i < cArgs; ++i) {
                                    ObjectHandle objectHandle;
                                    Constant constArg = aconstArgs[i];
                                    if (constArg instanceof RegisterConstant) {
                                        RegisterConstant constReg = (RegisterConstant)constArg;
                                        objectHandle = constReg.getHandle(frameCaller);
                                    } else {
                                        objectHandle = frameCtor.getConstHandle(constArg);
                                    }
                                    ahArgs[i] = objectHandle;
                                }
                                this.prepareFinalizer(frameCtor, ctorAnno, ahArgs);
                                iResult = frameCaller.callInitialized(frameCtor);
                            }
                            if (this.ixAnno >= this.aAnnoMixin.length) break;
                            this.ixStep = 2;
                            break;
                        }
                        ++this.ixStep;
                    }
                    case 3: {
                        if (this.constructor != null && !this.constructor.isNoOp() && !this.fAnonymous) {
                            Frame frameCD = frameCaller.createFrame1(this.constructor, this.hStruct, this.ahVar, -2);
                            this.prepareFinalizer(frameCD, this.constructor, this.ahVar);
                            iResult = frameCaller.callInitialized(frameCD);
                            break;
                        }
                        ++this.ixStep;
                    }
                    case 4: {
                        iResult = ClassTemplate.this.callValidator(frameCaller, this.hStruct);
                        break;
                    }
                    case 5: {
                        List<String> listUnassigned = this.hStruct.validateFields();
                        if (listUnassigned != null) {
                            return frameCaller.raiseException(xException.unassignedFields(frameCaller, this.hStruct.getType().getValueString(), listUnassigned));
                        }
                        ++this.ixStep;
                    }
                    case 6: {
                        iResult = ClassTemplate.this.postValidate(frameCaller, this.hStruct);
                        break;
                    }
                    case 7: {
                        ObjectHandle hPublic = this.hStruct.ensureAccess(Constants.Access.PUBLIC);
                        List<Frame> listFinalize = this.listFinalizable;
                        if (listFinalize == null) {
                            return frameCaller.assignValue(this.iReturn, hPublic);
                        }
                        int cFn = listFinalize.size();
                        xRTFunction.FullyBoundHandle hfnFinally = listFinalize.get((int)(cFn - 1)).m_hfnFinally;
                        for (int i = cFn - 2; i >= 0; --i) {
                            hfnFinally = listFinalize.get((int)i).m_hfnFinally.chain(hfnFinally);
                        }
                        return hfnFinally.callChain(frameCaller, hPublic, frame_ -> frame_.assignValue(this.iReturn, hPublic));
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                switch (iResult) {
                    case -1: {
                        continue block15;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }

        private void prepareFinalizer(Frame frame, MethodStructure ctor, ObjectHandle[] ahVar) {
            xRTFunction.FullyBoundHandle hfn;
            if (this.listFinalizable == null) {
                this.listFinalizable = new ArrayList<Frame>();
            }
            if ((hfn = Utils.makeFinalizer(frame, ctor, ahVar)) == null) {
                hfn = xRTFunction.FullyBoundHandle.NO_OP;
            }
            frame.m_hfnFinally = hfn;
            this.listFinalizable.add(frame);
        }
    }
}

