/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.FrameDependentConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;

public class ConstHeap {
    protected final Container f_container;
    private final Map<Constant, ObjectHandle> f_mapConstants = new ConcurrentHashMap<Constant, ObjectHandle>();

    public ConstHeap(Container container) {
        this.f_container = container;
    }

    protected ObjectHandle ensureConstHandle(Frame frame, Constant constValue) {
        if (constValue instanceof FrameDependentConstant) {
            FrameDependentConstant constFrame = (FrameDependentConstant)constValue;
            return constFrame.getHandle(frame);
        }
        ObjectHandle hValue = this.getConstHandle(constValue);
        if (hValue != null) {
            return hValue;
        }
        if (constValue instanceof SingletonConstant) {
            Container containerThis;
            Container containerOrig;
            SingletonConstant constSingle = (SingletonConstant)constValue;
            hValue = constSingle.getHandle();
            if (hValue != null) {
                return this.saveConstHandle(constValue, hValue);
            }
            ConstantPool pooThis = frame.poolContext();
            if (constSingle.getConstantPool() != pooThis && (hValue = (constSingle = (SingletonConstant)(containerOrig = (containerThis = frame.f_context.f_container).getOriginContainer(constSingle)).getConstantPool().register(constSingle)).getHandle()) != null) {
                return this.saveConstHandle(constSingle, hValue);
            }
            return new ObjectHandle.DeferredSingletonHandle(constSingle);
        }
        if (constValue instanceof PropertyConstant) {
            PropertyConstant idProp = (PropertyConstant)constValue;
            assert (!idProp.isConstant());
            ConstantPool pooThis = frame.poolContext();
            if (idProp.getConstantPool() != pooThis) {
                idProp = (PropertyConstant)pooThis.register(idProp);
            }
            return this.saveConstHandle(constValue, new ObjectHandle.DeferredPropertyHandle(idProp));
        }
        switch (this.f_container.getTemplate(constValue).createConstHandle(frame, constValue)) {
            case -1: {
                hValue = frame.popStack();
                return constValue.isValueCacheable() ? this.saveConstHandle(constValue, hValue) : hValue;
            }
            case -5: {
                Frame frameNext = frame.m_frameNext;
                if (constValue.isValueCacheable()) {
                    frameNext.addContinuation(frameCaller -> {
                        this.saveConstHandle(constValue, frameCaller.peekStack());
                        return -1;
                    });
                }
                return new ObjectHandle.DeferredCallHandle(frameNext);
            }
            case -3: {
                return new ObjectHandle.DeferredCallHandle(frame.clearException());
            }
        }
        throw new IllegalStateException();
    }

    public ObjectHandle getConstHandle(Constant constValue) {
        Container containerParent;
        ObjectHandle hValue = this.f_mapConstants.get(constValue);
        if (hValue == null && (containerParent = this.f_container.f_parent) != null && (hValue = containerParent.f_heap.getConstHandle(constValue)) != null && hValue.isShared(this.f_container, null)) {
            this.saveConstHandle(constValue, hValue);
        }
        return hValue;
    }

    public ObjectHandle saveConstHandle(Constant constValue, ObjectHandle hValue) {
        ObjectHandle hValue0;
        if (hValue instanceof ObjectHandle.InitializingHandle) {
            ObjectHandle.InitializingHandle hInit = (ObjectHandle.InitializingHandle)hValue;
            ObjectHandle hConst = hInit.getInitialized();
            if (hConst == null) {
                return hValue;
            }
            hValue = hConst;
        }
        ConstantPool pool = this.f_container.getConstantPool();
        if (constValue.getConstantPool() != pool) {
            constValue = pool.register(constValue);
        }
        return (hValue0 = this.f_mapConstants.putIfAbsent(constValue, hValue)) == null ? hValue : hValue0;
    }

    public ObjectHandle relocateConst(ObjectHandle hConst, Constant constant) {
        Container parent = this.f_container.f_parent;
        if (parent != null && hConst.isShared(parent, null)) {
            ObjectHandle hNew = parent.f_heap.relocateConst(hConst, constant);
            this.f_mapConstants.remove(constant);
            return hNew;
        }
        ObjectHandle hPrev = this.getConstHandle(constant);
        if (hPrev != null) {
            return hPrev;
        }
        ConstantPool pool = this.f_container.getConstantPool();
        if (constant.getConstantPool() != pool) {
            constant = pool.register(constant);
        }
        return this.f_mapConstants.computeIfAbsent(constant, c -> {
            ObjectHandle hNew;
            ObjectHandle objectHandle = hNew = hConst.getComposition().getContainer() == this.f_container ? hConst : hConst.cloneAs(hConst.getTemplate().ensureClass(this.f_container, hConst.getType()));
            if (c instanceof SingletonConstant) {
                SingletonConstant constSingleton = (SingletonConstant)c;
                constSingleton.setHandle(hNew);
            }
            return hNew;
        });
    }
}

