/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.FileStructure;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.ConstHeap;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Runtime;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.Child;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.reflect.xModule;
import org.xvm.runtime.template.reflect.xPackage;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xObject;
import org.xvm.runtime.template.xService;
import org.xvm.util.Auto;
import org.xvm.util.concurrent.ConcurrentWeakHasherMap;

public abstract class Container
implements LinkerContext {
    public final Runtime f_runtime;
    public final ConstHeap f_heap;
    public final Container f_parent;
    protected final ModuleConstant f_idModule;
    protected ServiceContext m_contextMain;
    protected ObjectHandle m_hTypeSystem;
    private final AtomicLong f_pendingWorkCount = new AtomicLong();
    protected final AtomicLong f_callbackCount = new AtomicLong();
    private final Set<ServiceContext> f_setServices = Collections.newSetFromMap(new ConcurrentWeakHasherMap());
    private final Map<TypeConstant, ClassComposition> f_mapCompositions = new ConcurrentHashMap<TypeConstant, ClassComposition>();
    protected final Map<TypeConstant, ClassTemplate> f_mapTemplatesByType = new ConcurrentHashMap<TypeConstant, ClassTemplate>();
    private long m_cFrozen;
    private long m_ldtFrozen;

    protected Container(Runtime runtime, Container containerParent, ModuleConstant idModule) {
        this.f_runtime = runtime;
        this.f_parent = containerParent;
        this.f_heap = new ConstHeap(this);
        this.f_idModule = idModule;
        if (containerParent != null) {
            this.f_runtime.registerContainer(this);
        }
    }

    public ServiceContext getServiceContext() {
        return this.m_contextMain;
    }

    public ModuleConstant getModule() {
        return this.f_idModule;
    }

    public ConstantPool getConstantPool() {
        return this.f_idModule.getConstantPool();
    }

    public ServiceContext ensureServiceContext() {
        ServiceContext ctx = this.m_contextMain;
        if (ctx == null) {
            try (Auto ignore = ConstantPool.withPool(this.getConstantPool());){
                this.m_contextMain = ctx = this.createServiceContext(this.getModule().getName());
                xService.INSTANCE.createServiceHandle(ctx, xService.INSTANCE.getCanonicalClass(), xService.INSTANCE.getCanonicalType());
            }
        }
        return ctx;
    }

    public ServiceContext createServiceContext(String sName) {
        ServiceContext service = new ServiceContext(this, sName, this.f_runtime.makeUniqueId());
        this.f_setServices.add(service);
        return service;
    }

    public Set<ServiceContext> getServices() {
        return this.f_setServices;
    }

    public void schedule(ServiceContext service) {
        this.f_pendingWorkCount.incrementAndGet();
        this.f_runtime.submitService(() -> {
            try {
                service.execute(true);
            }
            catch (Throwable e) {
                System.err.println("Unexpected service scheduling failure: " + service.f_sName);
                e.printStackTrace(System.err);
            }
            finally {
                this.f_pendingWorkCount.decrementAndGet();
            }
        });
    }

    public void terminate(ServiceContext service) {
        this.f_setServices.remove(service);
    }

    public <R> CompletableFuture<R> scheduleIO(Callable<R> task) {
        CompletableFuture cf = new CompletableFuture();
        this.f_runtime.submitIO(() -> {
            try {
                cf.complete(task.call());
            }
            catch (Throwable e) {
                cf.completeExceptionally(e);
            }
        });
        return cf;
    }

    public MethodConstant findModuleMethod(String sMethod, ObjectHandle[] ahArg) {
        TypeConstant[] atypeArg;
        TypeInfo infoModule = this.getModule().getType().ensureTypeInfo();
        if (ahArg.length == 0) {
            atypeArg = TypeConstant.NO_TYPES;
        } else {
            int cArgs = ahArg.length;
            atypeArg = new TypeConstant[cArgs];
            for (int i = 0; i < cArgs; ++i) {
                atypeArg[i] = ahArg[i].getType();
            }
        }
        return infoModule.findCallable(sMethod, true, false, TypeConstant.NO_TYPES, atypeArg);
    }

    public abstract ObjectHandle getInjectable(Frame var1, String var2, TypeConstant var3, ObjectHandle var4);

    public ObjectHandle ensureConstHandle(Frame frame, Constant constValue) {
        return this.f_heap.ensureConstHandle(frame, constValue);
    }

    public ClassTemplate getTemplate(TypeConstant type) {
        if (this.f_parent != null && type.isShared(this.f_parent.getConstantPool())) {
            return this.f_parent.getTemplate(type);
        }
        ClassTemplate template = this.f_mapTemplatesByType.get(type);
        if (template == null) {
            if (type.isSingleUnderlyingClass(true)) {
                type = (TypeConstant)this.getConstantPool().register(type);
                IdentityConstant idClass = type.getSingleUnderlyingClass(true);
                template = this.getTemplate(idClass);
                if (type.isShared(template.f_container.getConstantPool())) {
                    template = template.getTemplate(type);
                }
                this.f_mapTemplatesByType.put(type, template);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return template;
    }

    public ClassTemplate getTemplate(IdentityConstant idClass) {
        if (this.f_parent != null && idClass.isShared(this.f_parent.getConstantPool())) {
            return this.f_parent.getTemplate(idClass);
        }
        ClassTemplate template = this.f_mapTemplatesByType.get(idClass.getType());
        if (template != null) {
            return template;
        }
        idClass = (IdentityConstant)this.getConstantPool().register(idClass);
        ClassStructure structClass = (ClassStructure)idClass.getComponent();
        if (structClass == null) {
            throw new RuntimeException("Missing class structure: " + String.valueOf(idClass));
        }
        return this.f_mapTemplatesByType.computeIfAbsent(idClass.getType(), type -> {
            ClassTemplate temp;
            switch (structClass.getFormat()) {
                case ENUMVALUE: 
                case ENUM: {
                    temp = new xEnum(this, structClass, false);
                    temp.initNative();
                    break;
                }
                case ANNOTATION: 
                case MIXIN: 
                case CLASS: 
                case INTERFACE: {
                    temp = structClass.isInstanceChild() ? new Child(this, structClass) : new xObject(this, structClass, false);
                    break;
                }
                case SERVICE: {
                    temp = new xService(this, structClass, false);
                    break;
                }
                case CONST: {
                    temp = structClass.isException() ? new xException(this, structClass, false) : new xConst(this, structClass, false);
                    break;
                }
                case MODULE: {
                    temp = new xModule(this, structClass, false);
                    break;
                }
                case PACKAGE: {
                    temp = new xPackage(this, structClass, false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Format is not supported: " + String.valueOf(structClass));
                }
            }
            return temp;
        });
    }

    public ClassTemplate getTemplate(Constant constValue) {
        return this.getTemplate(this.getType(constValue));
    }

    public TypeConstant getType(Constant constValue) {
        if (constValue.getConstantPool() == this.getConstantPool() && constValue instanceof SingletonConstant) {
            SingletonConstant constSingleton = (SingletonConstant)constValue;
            return constSingleton.getType();
        }
        return this.getNativeContainer().getConstType(constValue);
    }

    public TypeComposition resolveClass(TypeConstant type) {
        if (type instanceof PropertyClassTypeConstant) {
            PropertyClassTypeConstant typeProp = (PropertyClassTypeConstant)type;
            ClassComposition clz = (ClassComposition)this.resolveClass(typeProp.getParentType().removeAccess());
            return clz.ensurePropertyComposition(typeProp.getPropertyInfo());
        }
        type = (TypeConstant)this.getConstantPool().register(type);
        return this.getTemplate(type).ensureClass(this, type.normalizeParameters());
    }

    public ClassComposition ensureClassComposition(TypeConstant typeInception, ClassTemplate template) {
        ClassComposition clz = this.f_mapCompositions.get(typeInception);
        if (clz == null) {
            ConstantPool pool = this.getConstantPool();
            assert (typeInception.isShared(pool));
            assert (!typeInception.isAccessSpecified());
            assert (typeInception.normalizeParameters().equals(typeInception));
            typeInception = (TypeConstant)pool.register(typeInception);
            clz = this.f_mapCompositions.computeIfAbsent(typeInception, type -> {
                ClassTemplate templateReal = type.isAnnotated() && type.isIntoVariableType() ? type.getTemplate(this) : template;
                return new ClassComposition(this, templateReal, (TypeConstant)type);
            });
        }
        clz.ensureFieldLayout(this);
        return clz;
    }

    public Container getOriginContainer(SingletonConstant constSingle) {
        IdentityConstant idClz = constSingle.getClassConstant();
        return this.isShared(idClz.getModuleConstant()) ? this.f_parent.getOriginContainer(constSingle) : this;
    }

    public ClassTemplate getTemplate(String sName) {
        return this.getNativeContainer().getTemplate(sName);
    }

    public ClassStructure getClassStructure(String sName) {
        return this.getNativeContainer().getClassStructure(sName);
    }

    public ModuleRepository getModuleRepository() {
        return this.getNativeContainer().getModuleRepository();
    }

    public FileStructure createFileStructure(ModuleStructure moduleApp) {
        return this.getNativeContainer().createFileStructure(moduleApp);
    }

    public boolean isShared(ModuleConstant idModule) {
        return idModule.isEcstasyModule();
    }

    public boolean isParent(Container that) {
        Container parent = that.f_parent;
        return parent != null && (this == parent || this.isParent(parent));
    }

    public long currentTimeMillis() {
        return System.currentTimeMillis() - this.getTimeFrozen();
    }

    public long nanoTime() {
        return System.nanoTime() - this.getTimeFrozen() * 1000000L;
    }

    public boolean freezeTime() {
        if (this.m_ldtFrozen == 0L) {
            this.m_ldtFrozen = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public void unfreezeTime() {
        if (this.m_ldtFrozen != 0L) {
            this.m_cFrozen += Math.max(0L, System.currentTimeMillis() - this.m_ldtFrozen);
            this.m_ldtFrozen = 0L;
        }
    }

    public boolean isTimeFrozen() {
        Container container = this;
        do {
            if (container.m_ldtFrozen == 0L) continue;
            return true;
        } while ((container = container.f_parent) != null);
        return false;
    }

    private long getTimeFrozen() {
        long cFrozen = 0L;
        Container container = this;
        do {
            cFrozen += container.m_cFrozen;
        } while ((container = container.f_parent) != null);
        return cFrozen;
    }

    public boolean isIdle() {
        return this.f_pendingWorkCount.get() == 0L && this.f_callbackCount.get() == 0L && this.m_contextMain.isIdle() && (this.f_parent == null || this.f_parent.isIdle());
    }

    public int ensureTypeSystemHandle(Frame frame, int iReturn) {
        ObjectHandle hTS = this.m_hTypeSystem;
        if (hTS == null) {
            if (frame.f_context.f_container != this) {
                return frame.raiseException("Out of context container");
            }
            ModuleConstant idModule = this.getModule();
            ModuleStructure module = (ModuleStructure)idModule.getComponent();
            Map<ModuleConstant, String> mapModules = module.collectDependencies();
            int cModules = mapModules.size();
            ObjectHandle[] ahModules = new ObjectHandle[cModules];
            ObjectHandle[] ahShared = new xBoolean.BooleanHandle[cModules];
            boolean fDeferred = false;
            int index = 0;
            for (ModuleConstant idDep : mapModules.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList()) {
                ObjectHandle hModule;
                ahModules[index] = hModule = frame.getConstHandle(idDep);
                ahShared[index] = xBoolean.makeHandle(this.isModuleShared(idDep));
                fDeferred |= Op.isDeferred(hModule);
                ++index;
            }
            ClassTemplate templateTS = this.getTemplate("reflect.TypeSystem");
            ClassComposition clzTS = templateTS.getCanonicalClass();
            MethodStructure constructor = templateTS.getStructure().findMethod("construct", 2, new TypeConstant[0]);
            ObjectHandle[] ahArg = new ObjectHandle[constructor.getMaxVars()];
            ahArg[1] = xArray.makeArrayHandle(xArray.getBooleanArrayComposition(), ahShared.length, ahShared, xArray.Mutability.Constant);
            TypeComposition clzArray = xModule.ensureArrayComposition(this);
            if (fDeferred) {
                Frame.Continuation stepNext = frameCaller -> {
                    ahArg[0] = xArray.createImmutableArray(clzArray, ahModules);
                    return this.saveTypeSystemHandle(frameCaller, iReturn, templateTS.construct(frameCaller, constructor, clzTS, null, ahArg, -1));
                };
                return new Utils.GetArguments(ahModules, stepNext).doNext(frame);
            }
            ahArg[0] = xArray.createImmutableArray(clzArray, ahModules);
            return this.saveTypeSystemHandle(frame, iReturn, templateTS.construct(frame, constructor, clzTS, null, ahArg, -1));
        }
        return frame.assignValue(iReturn, hTS);
    }

    private int saveTypeSystemHandle(Frame frame, int iReturn, int iResult) {
        switch (iResult) {
            case -1: {
                this.m_hTypeSystem = frame.popStack();
                return frame.assignValue(iReturn, this.m_hTypeSystem);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    this.m_hTypeSystem = frameCaller.popStack();
                    return frameCaller.assignValue(iReturn, this.m_hTypeSystem);
                });
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    protected boolean isModuleShared(ModuleConstant idModule) {
        return idModule.getName().equals("ecstasy.xtclang.org");
    }

    @Override
    public boolean isSpecified(String sName) {
        return switch (sName) {
            case "debug", "test" -> true;
            default -> false;
        };
    }

    @Override
    public boolean isPresent(IdentityConstant constId) {
        return constId.getModuleConstant().equals(this.getModule());
    }

    @Override
    public boolean isVersionMatch(ModuleConstant constModule, VersionConstant constVer) {
        return true;
    }

    @Override
    public boolean isVersion(VersionConstant constVer) {
        return true;
    }

    public void registerNativeCallback() {
        long c = this.f_callbackCount.getAndIncrement();
        assert (c >= 0L);
    }

    public void unregisterNativeCallback() {
        long c = this.f_callbackCount.getAndDecrement();
        assert (c > 0L);
    }

    public NativeContainer getNativeContainer() {
        Container container = this;
        while (true) {
            if (container instanceof NativeContainer) {
                NativeContainer nativeContainer = (NativeContainer)container;
                return nativeContainer;
            }
            container = container.f_parent;
        }
    }

    public String toString() {
        return "Container: " + this.f_idModule.getName();
    }
}

