/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import org.jline.reader.LineReader;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.op.Nop;
import org.xvm.compiler.EvalCompiler;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Debugger;
import org.xvm.runtime.Fiber;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ProxyComposition;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.io.xTerminalConsole;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;

public final class DebugConsole
implements Debugger {
    private List<String> m_listHistory;
    public static final DebugConsole INSTANCE = new DebugConsole();
    private static LineReader LINE_READER;
    private static Terminal TERMINAL;
    private static BufferedReader READER;
    Preferences prefs = Preferences.userNodeForPackage(DebugConsole.class);
    private ViewMode m_viewMode = ViewMode.Frames;
    private Frame.StackFrame[] m_aFrames;
    private Frame m_frame;
    private ObjectHandle.ExceptionHandle m_hException;
    private int m_cSteps;
    private Frame m_frameFocus;
    private final DebugStash m_debugStash = new DebugStash();
    private VarDisplay[] m_aVars;
    private int m_iPC;
    private int m_cHeight = this.prefs.getInt("screen-height", 30);
    private int m_cWidth = this.prefs.getInt("screen-width", 120);
    private Set<BreakPoint> m_setLineBreaks;
    private Set<BreakPoint> m_setThrowBreaks;
    private boolean m_fBreakOnAllThrows;
    private BreakPoint[] m_aBreaks;
    private StepMode m_stepMode = StepMode.None;

    @Override
    public synchronized int activate(Frame frame, int iPC) {
        if (LINE_READER == null && READER == null) {
            LINE_READER = xTerminalConsole.ensureLineReader(null);
            READER = xTerminalConsole.CONSOLE_IN;
            TERMINAL = xTerminalConsole.TERMINAL;
            this.resizeTerminal();
        }
        frame.f_context.setDebuggerActive(true);
        Op[] aop = frame.f_aOp;
        int c = aop.length;
        for (int i = iPC; i < c; ++i) {
            if (!(aop[i] instanceof Nop)) continue;
            this.m_frame = frame;
            this.m_stepMode = StepMode.StepInto;
            return iPC + 1;
        }
        return this.enterCommand(frame, iPC, true);
    }

    @Override
    public synchronized int checkBreakPoint(Frame frame, int iPC) {
        boolean fDebug = false;
        boolean fRender = true;
        block0 : switch (this.m_stepMode.ordinal()) {
            case 6: {
                if (frame != this.m_frame) break;
                fDebug = true;
                fRender = false;
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 1: {
                if (frame != this.m_frame) break;
                fDebug = this.m_cSteps == 0 || --this.m_cSteps == 0;
                break;
            }
            case 2: {
                fDebug = frame.f_fiber.isAssociated(this.m_frame.f_fiber);
                break;
            }
            case 4: {
                fDebug = frame == this.m_frame && iPC == this.m_iPC;
                break;
            }
            case 0: {
                if (this.m_setLineBreaks == null) break;
                Iterator<BreakPoint> iter = this.m_setLineBreaks.iterator();
                block12: while (iter.hasNext()) {
                    BreakPoint bp = iter.next();
                    switch (bp.matches(frame, iPC)) {
                        case -1: {
                            continue block12;
                        }
                        case -5: {
                            this.m_frame = frame;
                            return -5;
                        }
                    }
                    fDebug = true;
                    if (!bp.oneTime) break block0;
                    iter.remove();
                    break block0;
                }
                break;
            }
        }
        return fDebug ? this.enterCommand(frame, iPC, fRender) : iPC + 1;
    }

    @Override
    public synchronized int checkBreakPoint(Frame frame, ObjectHandle.ExceptionHandle hEx) {
        if (frame.isNative()) {
            return -1;
        }
        if (this.m_stepMode == StepMode.NaturalCall) {
            if (frame.f_framePrev == this.m_frame) {
                return frame.m_continuation.proceed(frame);
            }
            return -1;
        }
        if (hEx == this.m_hException) {
            return -1;
        }
        if (this.m_fBreakOnAllThrows || this.m_setThrowBreaks != null && this.m_setThrowBreaks.stream().anyMatch(bp -> bp.matches(hEx))) {
            boolean fRender;
            boolean bl = fRender = this.m_stepMode != StepMode.NaturalReturn;
            if (this.enterCommand(frame, -3, fRender) == -5) {
                return -5;
            }
            if (this.m_stepMode != StepMode.None) {
                this.m_stepMode = StepMode.StepInto;
                return -1;
            }
            this.m_hException = hEx;
        }
        return -3;
    }

    @Override
    public synchronized void onReturn(Frame frame) {
        if (frame != this.m_frame) {
            switch (this.m_stepMode.ordinal()) {
                case 2: {
                    if (frame.isNative() || frame.f_function.isSynthetic()) {
                        return;
                    }
                    if (!frame.f_fiber.isAssociated(this.m_frame.f_fiber)) break;
                    PrintWriter writer = xTerminalConsole.CONSOLE_OUT;
                    writer.println("*** Warning: 'DS' and 'E' commands are not supported here and may cause an unpredictable behavior");
                    this.enterCommand(frame, frame.m_iPC, true);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        switch (this.m_stepMode.ordinal()) {
            case 1: 
            case 3: {
                Frame frameCaller;
                Fiber fiberCaller;
                if (!frame.f_fiber.isAssociated(this.m_frame.f_fiber)) break;
                this.m_stepMode = StepMode.StepInto;
                Frame framePrev = frame.f_framePrev;
                if (framePrev == null || !framePrev.isNative()) break;
                WeakReference<Fiber> refCaller = framePrev.f_fiber.f_refCaller;
                Fiber fiber = fiberCaller = refCaller == null ? null : (Fiber)refCaller.get();
                if (fiberCaller == null || (frameCaller = fiberCaller.getFrame()) == null) break;
                this.m_frame = frameCaller;
            }
        }
    }

    private DebugConsole() {
        this.loadBreakpoints();
        this.loadHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enterCommand(Frame frame, int iPC, boolean fRender) {
        NativeContainer container = frame.f_context.f_container.getNativeContainer();
        boolean fUnfreeze = container.freezeTime();
        try {
            int n = this.enterCommandInternal(frame, iPC, fRender);
            return n;
        }
        finally {
            if (fUnfreeze) {
                container.unfreezeTime();
            }
        }
    }

    private int enterCommandInternal(Frame frame, int iPC, boolean fRender) {
        this.m_frame = frame;
        this.m_iPC = iPC;
        this.m_stepMode = StepMode.None;
        PrintWriter writer = xTerminalConsole.CONSOLE_OUT;
        if (fRender) {
            writer.println(this.renderDisplay());
        }
        while (true) {
            try {
                int iResult;
                block9: while (true) {
                    String sDedup;
                    String sCommand;
                    if (LINE_READER == null) {
                        writer.print("\nEnter command: ");
                        writer.flush();
                        sCommand = READER.readLine();
                        if (sCommand == null) {
                            writer.println();
                            return iPC >= 0 ? iPC + 1 : iPC;
                        }
                    } else {
                        try {
                            writer.flush();
                            sCommand = LINE_READER.readLine("\nEnter command: ");
                        }
                        catch (UserInterruptException e) {
                            System.exit(1);
                            return iPC >= 0 ? iPC + 1 : iPC;
                        }
                    }
                    if ((sCommand = sCommand.trim()).isEmpty()) {
                        sCommand = "VD";
                    }
                    while (!(sDedup = sCommand.replace("  ", " ")).equals(sCommand)) {
                        sCommand = sDedup;
                    }
                    iResult = this.processCommand(frame, iPC, writer, sCommand);
                    switch (iResult) {
                        case -7: {
                            continue block9;
                        }
                        case -3: {
                            writer.println("Invalid command: " + sCommand);
                            continue block9;
                        }
                    }
                    break;
                }
                iPC = iResult;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        frame.f_context.setDebuggerActive(this.m_setLineBreaks != null || this.m_setThrowBreaks != null || this.m_stepMode != StepMode.None);
        return iPC;
    }

    private int performEval(Frame frame, int iPC, String sEval, PrintWriter writer) {
        EvalCompiler compiler = new EvalCompiler(frame, sEval);
        MethodStructure lambda = compiler.createLambda(frame.poolContext().typeString());
        if (lambda == null) {
            for (ErrorListener.ErrorInfo err : compiler.getErrors()) {
                writer.println(err.getMessageText());
            }
            return -1;
        }
        Frame.Continuation continuation = frameCaller -> {
            ObjectHandle.ExceptionHandle hEx = frameCaller.clearException();
            if (hEx == null) {
                writer.println(((xString.StringHandle)frameCaller.popStack()).getStringValue());
            } else {
                writer.println("\"Eval\" threw an exception " + String.valueOf(hEx));
                writer.println(frameCaller.getStackTrace());
            }
            return iPC;
        };
        ObjectHandle[] ahArgs = this.getArguments(frame, lambda, compiler.getArgs());
        return this.resolveEvalArgs(frame, lambda, ahArgs, continuation);
    }

    private int resolveEvalArgs(Frame frame, MethodStructure lambda, ObjectHandle[] ahArg, Frame.Continuation continuation) {
        if (Op.anyDeferred(ahArg)) {
            Frame.Continuation stepNext = frameCaller -> this.callEval(frameCaller, lambda, ahArg, continuation);
            return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
        }
        return this.callEval(frame, lambda, ahArg, continuation);
    }

    private int callEval(Frame frame, MethodStructure lambda, ObjectHandle[] ahArg, Frame.Continuation continuation) {
        ObjectHandle hThis = frame.f_function.isFunction() ? null : frame.getThis();
        ObjectHandle.ExceptionHandle hExPrev = frame.clearException();
        switch (frame.call1(lambda, hThis, ahArg, -1)) {
            case -5: {
                this.m_stepMode = StepMode.NaturalCall;
                frame.m_frameNext.addContinuation(frameCaller -> {
                    lambda.getParent().removeChild(lambda);
                    this.m_stepMode = StepMode.NaturalReturn;
                    int iResult = continuation.proceed(frameCaller);
                    frameCaller.m_hException = hExPrev;
                    return iResult;
                });
                return -5;
            }
            case -3: {
                this.m_stepMode = StepMode.None;
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    private int callToString(Frame frame, ObjectHandle.ExceptionHandle hExPrev, ObjectHandle hVar, PrintWriter writer) {
        switch (Utils.callToString(frame, hVar)) {
            case -1: {
                this.m_stepMode = StepMode.None;
                writer.println(((xString.StringHandle)frame.popStack()).getStringValue());
                frame.m_hException = hExPrev;
                return -1;
            }
            case -5: {
                this.m_stepMode = StepMode.NaturalCall;
                frame.m_frameNext.addContinuation(frameCaller -> {
                    ObjectHandle.ExceptionHandle hEx = frameCaller.clearException();
                    if (hEx == null) {
                        writer.println(((xString.StringHandle)frameCaller.popStack()).getStringValue());
                    } else {
                        writer.println("Call \"toString()\" threw an exception " + String.valueOf(hEx));
                        writer.println(frameCaller.getStackTrace());
                    }
                    this.m_stepMode = StepMode.NaturalReturn;
                    frameCaller.m_hException = hExPrev;
                    return this.m_iPC;
                });
                return -5;
            }
            case -3: {
                this.m_stepMode = StepMode.None;
                writer.println("Call \"toString()\" threw an exception " + String.valueOf(frame.clearException()));
                frame.m_hException = hExPrev;
                return -1;
            }
        }
        throw new IllegalStateException();
    }

    private DebugStash getFrameStash() {
        return this.m_frameFocus.ensureDebugStash();
    }

    private DebugStash getGlobalStash() {
        return this.m_debugStash;
    }

    private int findParentNode(int iVar) {
        VarDisplay var = this.m_aVars[iVar];
        int indent = var.indent;
        assert (indent > 0);
        do {
            var = this.m_aVars[--iVar];
        } while (var.indent >= indent);
        return iVar;
    }

    private Map<String, Integer> ensureExpandMap(int iVar) {
        VarDisplay var = this.m_aVars[iVar];
        while (var.indent > 0) {
            var = this.m_aVars[--iVar];
        }
        return (var.watch != null && this.getGlobalStash().getWatchList().contains(var.watch) || "this".equals(var.path) ? this.getGlobalStash() : this.getFrameStash()).ensureExpandMap();
    }

    private BreakPoint makeBreakPointPC(Frame frame, int iPC) {
        int nLine = frame.f_function.calculateLineNumber(iPC);
        return nLine > 0 ? this.makeBreakPointLine(frame, nLine, false) : null;
    }

    private BreakPoint makeBreakPointLine(Frame frame, int nLine, boolean fOneTime) {
        String sName = frame.f_function.getContainingClass().getName();
        return new BreakPoint(sName, nLine, fOneTime);
    }

    private void addBP(BreakPoint bp) {
        BreakPoint bpExists;
        Set<BreakPoint> setBP;
        Set<BreakPoint> set = setBP = bp.isException() ? this.m_setThrowBreaks : this.m_setLineBreaks;
        if (setBP == null) {
            setBP = new HashSet<BreakPoint>();
            if (bp.isException()) {
                this.m_setThrowBreaks = setBP;
            } else {
                this.m_setLineBreaks = setBP;
            }
        }
        if ((bpExists = this.findBP(bp)) == null) {
            setBP.add(bp);
        } else {
            bpExists.enable();
            if (bp.condition != null) {
                bpExists.condition = bp.condition;
            }
            bp = bpExists;
        }
        if ("*".equals(bp.className)) {
            assert (bp.isException());
            this.m_fBreakOnAllThrows = true;
        }
        this.saveBreakpoints();
    }

    private void removeBP(BreakPoint bp) {
        Set<BreakPoint> setBP;
        Set<BreakPoint> set = setBP = bp.isException() ? this.m_setThrowBreaks : this.m_setLineBreaks;
        if (setBP != null) {
            setBP.remove(bp);
            if (setBP.isEmpty()) {
                if (bp.isException()) {
                    this.m_setThrowBreaks = null;
                } else {
                    this.m_setLineBreaks = null;
                }
            }
        }
        if ("*".equals(bp.className)) {
            assert (bp.isException());
            this.m_fBreakOnAllThrows = false;
        }
        this.saveBreakpoints();
    }

    private void toggleBP(BreakPoint bp) {
        if ((bp = this.findBP(bp)) != null) {
            if (bp.isEnabled()) {
                bp.disable();
            } else {
                bp.enable();
            }
            if ("*".equals(bp.className)) {
                assert (bp.isException());
                this.m_fBreakOnAllThrows = bp.isEnabled();
            }
        }
        this.saveBreakpoints();
    }

    private BreakPoint findBP(BreakPoint bp) {
        if (bp != null) {
            Optional<BreakPoint> obp;
            Set<BreakPoint> setBP;
            Set<BreakPoint> set = setBP = bp.isException() ? this.m_setThrowBreaks : this.m_setLineBreaks;
            if (setBP != null && (obp = setBP.stream().filter(bpEach -> bpEach.equals(bp)).findFirst()).isPresent()) {
                return obp.get();
            }
        }
        return null;
    }

    private static BreakPoint parseBreakPoint(String sName, String sLine, boolean fOneTime) {
        int nLine = DebugConsole.parseNonNegative(sLine);
        return nLine <= 0 ? null : new BreakPoint(sName, nLine, fOneTime);
    }

    private void loadBreakpoints() {
        this.m_setLineBreaks = this.stringToBreakpoints(this.prefs.get("break-points", ""));
        this.m_setThrowBreaks = this.stringToBreakpoints(this.prefs.get("break-throws", ""));
        this.m_fBreakOnAllThrows = this.m_setThrowBreaks != null && this.m_setThrowBreaks.stream().anyMatch(bp -> bp.isEnabled() && "*".equals(bp.className));
    }

    private void saveBreakpoints() {
        this.prefs.put("break-points", this.breakpointsToString(this.m_setLineBreaks));
        this.prefs.put("break-throws", this.breakpointsToString(this.m_setThrowBreaks));
    }

    private int processCommand(Frame frame, int iPC, PrintWriter writer, String sCommand) {
        String[] asParts = Handy.parseDelimitedString(sCommand, ' ');
        int cArgs = asParts.length - 1;
        if (cArgs < 0) {
            return -3;
        }
        switch (asParts[0].toUpperCase()) {
            case "B": {
                if (cArgs != 0) {
                    return -3;
                }
                writer.println(this.renderBreakpoints());
                return -7;
            }
            case "B+": {
                switch (cArgs) {
                    case 0: {
                        BreakPoint bp;
                        if (iPC < 0 || (bp = this.makeBreakPointPC(frame, iPC)) == null) break;
                        this.addBP(bp);
                        return -7;
                    }
                    case 1: {
                        int nLine = DebugConsole.parseNonNegative(asParts[1]);
                        if (nLine <= 0) break;
                        this.addBP(this.makeBreakPointLine(frame, nLine, false));
                        return -7;
                    }
                    case 2: {
                        BreakPoint bp = DebugConsole.parseBreakPoint(asParts[1], asParts[2], false);
                        if (bp == null) break;
                        this.addBP(bp);
                        return -7;
                    }
                }
                return -3;
            }
            case "B-": {
                switch (cArgs) {
                    case 0: {
                        BreakPoint bp;
                        if (iPC < 0 || (bp = this.makeBreakPointPC(frame, iPC)) == null) break;
                        this.removeBP(bp);
                        return -7;
                    }
                    case 1: {
                        int n;
                        if ("*".equals(asParts[1])) {
                            this.m_fBreakOnAllThrows = false;
                            this.m_setLineBreaks = null;
                            this.m_setThrowBreaks = null;
                            this.saveBreakpoints();
                            return -7;
                        }
                        if (this.m_aBreaks == null || (n = DebugConsole.parseNonNegative(asParts[1])) < 0 || n >= this.m_aBreaks.length) break;
                        this.removeBP(this.m_aBreaks[n]);
                        return -7;
                    }
                    case 2: {
                        BreakPoint bp = DebugConsole.parseBreakPoint(asParts[1], asParts[2], false);
                        if (bp == null) break;
                        this.removeBP(bp);
                        return -7;
                    }
                }
                return -3;
            }
            case "BC": {
                BreakPoint bp = null;
                switch (cArgs) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bp = this.makeBreakPointPC(frame, iPC);
                        bp.condition = asParts[1];
                        break;
                    }
                    case 2: {
                        int nLine = DebugConsole.parseNonNegative(asParts[1]);
                        if (nLine <= 0) break;
                        bp = this.makeBreakPointLine(frame, nLine, false);
                        bp.condition = asParts[2];
                        break;
                    }
                    default: {
                        bp = DebugConsole.parseBreakPoint(asParts[1], asParts[2], false);
                        if (bp == null) break;
                        StringBuilder sb = new StringBuilder();
                        for (int i = 3; i < cArgs + 1; ++i) {
                            sb.append(asParts[i]).append(' ');
                        }
                        bp.condition = sb.toString();
                    }
                }
                if (bp == null) {
                    return -3;
                }
                this.addBP(bp);
                return -7;
            }
            case "BE+": {
                if (cArgs == 1) {
                    this.addBP(new BreakPoint(asParts[1]));
                    return -7;
                }
                return -3;
            }
            case "BE-": {
                if (cArgs == 1) {
                    this.removeBP(new BreakPoint(asParts[1]));
                    return -7;
                }
                return -3;
            }
            case "BT": {
                switch (cArgs) {
                    case 0: {
                        BreakPoint bp;
                        if (iPC < 0 || (bp = this.makeBreakPointPC(frame, iPC)) == null) break;
                        BreakPoint bpExists = this.findBP(bp);
                        if (bpExists == null) {
                            this.addBP(bp);
                        } else {
                            this.toggleBP(bpExists);
                        }
                        return -7;
                    }
                    case 1: {
                        if ("*".equals(asParts[1])) {
                            BreakPoint[] aBP = this.allBreakpoints();
                            Arrays.stream(aBP).forEach(this::toggleBP);
                            this.saveBreakpoints();
                            return -7;
                        }
                        if (this.m_aBreaks != null) {
                            int n = DebugConsole.parseNonNegative(asParts[1]);
                            if (n < 0 || n >= this.m_aBreaks.length) break;
                            this.toggleBP(this.m_aBreaks[n]);
                            return -7;
                        }
                        this.toggleBP(new BreakPoint(asParts[1]));
                        return -7;
                    }
                    case 2: {
                        BreakPoint bp = DebugConsole.parseBreakPoint(asParts[1], asParts[2], false);
                        if (bp == null) break;
                        this.toggleBP(bp);
                        return -7;
                    }
                }
                return -3;
            }
            case "F": {
                int cFrames;
                int iFrame = cArgs == 0 ? 0 : DebugConsole.parseNonNegative(asParts[1]);
                Frame.StackFrame[] aFrames = this.m_aFrames;
                int n = cFrames = aFrames == null ? 0 : aFrames.length;
                if (iFrame >= 0 && iFrame < cFrames) {
                    this.m_frameFocus = aFrames[iFrame].frame;
                }
                writer.println(this.renderDebugger());
                return -7;
            }
            case "?": 
            case "HELP": {
                writer.println(this.renderHelp());
                return -7;
            }
            case "N": 
            case "S": {
                int cSteps;
                this.m_stepMode = StepMode.StepOver;
                int n = cSteps = cArgs == 0 ? 0 : DebugConsole.parseNonNegative(asParts[1]);
                if (cSteps > 0) {
                    this.m_cSteps = cSteps;
                }
                return -1;
            }
            case "I": 
            case "S+": {
                this.m_stepMode = StepMode.StepInto;
                return -1;
            }
            case "O": 
            case "S-": {
                this.m_stepMode = StepMode.StepOut;
                return -1;
            }
            case "SL": {
                switch (cArgs) {
                    case 0: {
                        int nLine;
                        if (iPC < 0 || (nLine = frame.f_function.calculateLineNumber(iPC)) <= 0) break;
                        this.addBP(this.makeBreakPointLine(frame, nLine, true));
                        this.m_stepMode = StepMode.None;
                        this.m_frame = null;
                        return -1;
                    }
                    case 1: {
                        int nLine = DebugConsole.parseNonNegative(asParts[1]);
                        if (nLine <= 0) break;
                        this.addBP(this.makeBreakPointLine(frame, nLine, true));
                        this.m_stepMode = StepMode.None;
                        this.m_frame = null;
                        return -1;
                    }
                    case 2: {
                        BreakPoint bp = DebugConsole.parseBreakPoint(asParts[1], asParts[2], true);
                        if (bp == null) break;
                        this.addBP(bp);
                        this.m_stepMode = StepMode.None;
                        this.m_frame = null;
                        return -1;
                    }
                }
                return -3;
            }
            case "R": {
                this.m_stepMode = StepMode.None;
                this.m_frame = null;
                return -1;
            }
            case "VC": {
                this.m_viewMode = ViewMode.Console;
                writer.println(this.renderConsole());
                return -7;
            }
            case "VD": {
                this.m_viewMode = ViewMode.Frames;
                writer.println(this.renderDebugger());
                return -7;
            }
            case "VF": {
                this.m_viewMode = ViewMode.Services;
                System.gc();
                writer.println(this.renderServices());
                return -7;
            }
            case "VS": {
                switch (cArgs) {
                    case 0: {
                        this.resizeTerminal();
                        writer.println(DebugConsole.hruler(this.m_cWidth));
                        writer.println(DebugConsole.vruler(this.m_cHeight - 2, 3));
                        writer.println("Current debugger text width=" + this.m_cWidth + " characters, height= " + this.m_cHeight + " lines.");
                        return -7;
                    }
                    case 2: {
                        int n = DebugConsole.parseNonNegative(asParts[2]);
                        if (n >= 10 && n <= 120) {
                            writer.println("Altering debugger text height from " + this.m_cHeight + " to " + n + " lines.");
                            this.m_cHeight = n;
                            this.prefs.putInt("screen-height", n);
                        } else {
                            writer.println("Illegal text height: " + asParts[2]);
                            return -7;
                        }
                    }
                    case 1: {
                        int n = DebugConsole.parseNonNegative(asParts[1]);
                        if (n >= 40 && n <= 240) {
                            writer.println("Altering debugger text width from " + this.m_cWidth + " to " + n + " characters.");
                            this.m_cWidth = n;
                            this.prefs.putInt("screen-width", n);
                        } else {
                            writer.println("Illegal text width: " + asParts[1]);
                        }
                        writer.println(DebugConsole.hruler(this.m_cWidth));
                        writer.println(DebugConsole.vruler(this.m_cHeight - 2, cArgs + 3));
                        return -7;
                    }
                }
                return -3;
            }
            case "X": {
                if (cArgs >= 1) {
                    VarDisplay[] aVars = this.m_aVars;
                    boolean fRepaint = false;
                    for (int i = 0; i < cArgs; ++i) {
                        int iVar = DebugConsole.parseNonNegative(asParts[i + 1]);
                        if (iVar >= 0 && iVar < aVars.length) {
                            VarDisplay var = aVars[iVar];
                            if (var.canExpand) {
                                Map<String, Integer> mapExpand = this.ensureExpandMap(iVar);
                                if (var.isArray) {
                                    if ("...".equals(var.name)) {
                                        int arrayLevel = var.indent - 1;
                                        do {
                                            var = aVars[--iVar];
                                        } while (var.indent > arrayLevel);
                                        int cShow = mapExpand.getOrDefault(var.path, 0);
                                        cShow = (cShow + 1) * 10;
                                        mapExpand.put(var.path, cShow);
                                    } else {
                                        mapExpand.put(var.path, var.expanded ? 0 : 10);
                                    }
                                } else {
                                    mapExpand.put(var.path, var.expanded ? 0 : 1);
                                }
                                fRepaint = true;
                            } else {
                                writer.println("Cannot expand or contract \"" + var.name + "\"");
                            }
                        }
                        if (!fRepaint) continue;
                        writer.println(this.renderDebugger());
                    }
                    return -7;
                }
                return -3;
            }
            case "V": {
                writer.println("View format has not been implemented.");
                return -7;
            }
            case "E": 
            case "EVAL": {
                if (cArgs < 1) {
                    return -3;
                }
                if (this.m_frameFocus != frame || frame.isNative()) {
                    writer.println("The \"eval\" command is only supported at the top frame.");
                    return -3;
                }
                StringBuilder sb = new StringBuilder("{\nreturn {Object r__ = {\nreturn");
                for (int i = 1; i < cArgs + 1; ++i) {
                    sb.append(' ').append(asParts[i]);
                }
                sb.append(";\n}; return r__.toString();};\n}");
                if (this.performEval(frame, iPC, sb.toString(), writer) == -5) {
                    this.updateHistory(sCommand);
                    return -5;
                }
                return -7;
            }
            case "EM": 
            case "EVAL_MULTI": {
                if (cArgs < 1) {
                    return -3;
                }
                if (this.m_frameFocus != frame || frame.isNative()) {
                    writer.println("The \"eval\" command is only supported at the top frame.");
                    return -3;
                }
                StringBuilder sb = new StringBuilder("{\nreturn {Tuple r__ = {\nreturn");
                for (int i = 1; i < cArgs + 1; ++i) {
                    sb.append(' ').append(asParts[i]);
                }
                sb.append(";\n}; return r__.size == 1 ? r__[0].toString() : r__.toString();};\n}");
                if (this.performEval(frame, iPC, sb.toString(), writer) == -5) {
                    this.updateHistory(sCommand);
                    return -5;
                }
                return -7;
            }
            case "WE": {
                writer.println("Watch Eval has not been implemented.");
                return -7;
            }
            case "WO": {
                if (cArgs >= 1) {
                    VarDisplay[] aVars = this.m_aVars;
                    boolean fRepaint = false;
                    for (int i = 0; i < cArgs; ++i) {
                        int iVar = DebugConsole.parseNonNegative(asParts[i + 1]);
                        if (iVar >= 0 && iVar < aVars.length) {
                            VarDisplay var = aVars[iVar];
                            if (var.hVar == null) {
                                writer.println("Var #" + iVar + " (\"" + var.name + "\") does not have a referent to Watch");
                                continue;
                            }
                            Watch watch = var.watch;
                            if (watch != null && watch.form == 1) {
                                writer.println("Var #" + iVar + " (\"" + var.name + "\") is already a Watched Object");
                                continue;
                            }
                            String sName = var.path;
                            if (sName.startsWith("watch:")) {
                                sName = sName.substring("watch:".length());
                            }
                            watch = new Watch("watch:" + sName, sName, var.hVar);
                            this.getGlobalStash().ensureWatchList().add(watch);
                            fRepaint = true;
                            continue;
                        }
                        writer.println("Var #" + iVar + " does not exist");
                    }
                    if (fRepaint) {
                        writer.println(this.renderDebugger());
                    }
                    return -7;
                }
                return -3;
            }
            case "WR": {
                if (cArgs >= 1) {
                    VarDisplay[] aVars = this.m_aVars;
                    boolean fRepaint = false;
                    for (int i = 0; i < cArgs; ++i) {
                        int iVar = DebugConsole.parseNonNegative(asParts[i + 1]);
                        if (iVar >= 0 && iVar < aVars.length) {
                            boolean fGlobal;
                            VarDisplay var = aVars[iVar];
                            Watch watch = var.watch;
                            if (watch != null) {
                                writer.println("Var #" + iVar + " (\"" + var.name + "\") is already a Watch");
                                continue;
                            }
                            if (var.indent == 0) {
                                writer.println("Var #" + iVar + " (\"" + var.name + "\") is already displayed in the current frame");
                                continue;
                            }
                            if (var.name.startsWith("[")) {
                                parent = aVars[this.findParentNode(iVar)];
                                int index = Integer.valueOf(var.name.substring(1, var.name.length() - 1));
                                watch = new Watch("watch:" + var.path, var.path, parent.hVar, index);
                                fGlobal = false;
                            } else {
                                if (var.name.startsWith(".")) {
                                    writer.println("Var #" + iVar + " is not Watchable");
                                    continue;
                                }
                                parent = aVars[this.findParentNode(iVar)];
                                watch = new Watch("watch:" + var.path, var.path, parent.hVar, var.name);
                                fGlobal = true;
                            }
                            (fGlobal ? this.getGlobalStash() : this.getFrameStash()).ensureWatchList().add(watch);
                            fRepaint = true;
                            continue;
                        }
                        writer.println("Var #" + iVar + " does not exist");
                    }
                    if (fRepaint) {
                        writer.println(this.renderDebugger());
                    }
                    return -7;
                }
                return -3;
            }
            case "W-": {
                if (cArgs >= 1) {
                    VarDisplay[] aVars = this.m_aVars;
                    boolean fRepaint = false;
                    for (int i = 0; i < cArgs; ++i) {
                        int iVar = DebugConsole.parseNonNegative(asParts[i + 1]);
                        if (iVar >= 0 && iVar < aVars.length) {
                            VarDisplay var = aVars[iVar];
                            Watch watch = var.watch;
                            if (watch == null) {
                                writer.println("Var #" + iVar + " (\"" + var.name + "\") is not a Watch");
                                continue;
                            }
                            this.getFrameStash().ensureWatchList().remove(watch);
                            this.getGlobalStash().ensureWatchList().remove(watch);
                            fRepaint = true;
                            continue;
                        }
                        writer.println("Var #" + iVar + " does not exist");
                    }
                    if (fRepaint) {
                        writer.println(this.renderDebugger());
                    }
                    return -7;
                }
                return -3;
            }
            case "D": {
                if (cArgs >= 1) {
                    VarDisplay[] aVars = this.m_aVars;
                    int iVar = DebugConsole.parseNonNegative(asParts[1]);
                    if (iVar >= 0 && iVar < aVars.length) {
                        ObjectHandle hVar = aVars[iVar].hVar;
                        if (cArgs >= 2) {
                            String sProp = asParts[2];
                            try {
                                hVar = ((ObjectHandle.GenericHandle)hVar).getField(frame, sProp);
                            }
                            catch (Throwable e) {
                                writer.println("Invalid property: " + sProp);
                                return -7;
                            }
                        }
                        StringBuilder sb = new StringBuilder();
                        this.renderVar(hVar, false, sb, "   +");
                        writer.println(sb);
                        return -7;
                    }
                }
                return -3;
            }
            case "DS": {
                if (cArgs >= 1) {
                    VarDisplay[] aVars = this.m_aVars;
                    int iVar = DebugConsole.parseNonNegative(asParts[1]);
                    if (iVar >= 0 && iVar < aVars.length) {
                        ObjectHandle hVar = aVars[iVar].hVar;
                        if (hVar != null && cArgs >= 2) {
                            String sProp = asParts[2];
                            try {
                                hVar = ((ObjectHandle.GenericHandle)hVar).getField(frame, sProp);
                            }
                            catch (Throwable e) {
                                writer.println("Invalid property: " + sProp);
                                return -7;
                            }
                        }
                        if (hVar == null) {
                            writer.println("<unassigned>");
                        } else if (hVar == ObjectHandle.DEFAULT) {
                            writer.println("<default>");
                        } else if (this.callToString(frame, frame.clearException(), hVar, writer) == -5) {
                            return -5;
                        }
                        return -7;
                    }
                }
                return -3;
            }
            case "DI": {
                if (cArgs >= 1) {
                    VarDisplay[] aVars = this.m_aVars;
                    int iVar = DebugConsole.parseNonNegative(asParts[1]);
                    if (iVar >= 0 && iVar < aVars.length) {
                        ObjectHandle hVar = aVars[iVar].hVar;
                        if (hVar == null) {
                            writer.println("<unassigned>");
                        } else if (hVar == ObjectHandle.DEFAULT) {
                            writer.println("<default>");
                        } else {
                            writer.print("#" + System.identityHashCode(hVar));
                        }
                        return -7;
                    }
                }
                return -3;
            }
            case "H": 
            case "HISTORY": {
                int n;
                List<String> listHistory = this.m_listHistory;
                if (cArgs > 0 && (n = DebugConsole.parseNonNegative(asParts[1])) >= 0) {
                    while (listHistory.size() > n) {
                        listHistory.remove(n);
                    }
                }
                int i = 0;
                for (String sCmd : listHistory) {
                    writer.println(i++ + ") " + sCmd);
                }
                return -7;
            }
            case "T": 
            case "RESET": {
                if (frame.f_framePrev.isNativeStack()) {
                    writer.println("Cannot reset an active frame across the service boundaries");
                    return -7;
                }
                this.m_stepMode = StepMode.StepInto;
                return -10;
            }
            case ".": {
                int n;
                int n2 = n = cArgs > 0 ? DebugConsole.parseNonNegative(asParts[1]) : 0;
                if (n < 0 || n > this.m_listHistory.size()) {
                    return -3;
                }
                String sCmd = this.m_listHistory.get(n);
                writer.println(sCmd);
                return this.processCommand(frame, iPC, writer, sCmd);
            }
        }
        writer.println("Unknown command: \"" + sCommand + "\"; enter '?' for help");
        return -7;
    }

    private void loadHistory() {
        ArrayList<String> list = new ArrayList<String>();
        String sHistory = this.prefs.get("history", "");
        if (!sHistory.isEmpty()) {
            byte[] abHistory = Base64.getDecoder().decode(sHistory);
            sHistory = new String(abHistory, StandardCharsets.UTF_8);
            int ofStart = 0;
            int ofEnd = sHistory.indexOf(10);
            while (ofEnd > 0) {
                list.add(sHistory.substring(ofStart, ofEnd));
                ofStart = ofEnd + 1;
                ofEnd = sHistory.indexOf(10, ofStart);
            }
        }
        this.m_listHistory = list;
    }

    private Set<BreakPoint> stringToBreakpoints(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        HashSet<BreakPoint> setBP = new HashSet<BreakPoint>();
        for (String sbp : Handy.parseDelimitedString(s, ',')) {
            try {
                BreakPoint bp;
                String[] settings = Handy.parseDelimitedString(sbp, ':');
                String sName = settings[0];
                int nLine = settings.length >= 2 && !settings[1].isEmpty() ? Integer.parseInt(settings[1]) : -1;
                BreakPoint breakPoint = bp = nLine >= 0 ? new BreakPoint(sName, nLine) : new BreakPoint(sName);
                if (settings.length >= 3) {
                    String sCondB64 = settings[2];
                    if (!sCondB64.isEmpty()) {
                        byte[] abCond = Base64.getDecoder().decode(sCondB64);
                        bp.condition = new String(abCond, StandardCharsets.UTF_8);
                    }
                    if (settings.length >= 4 && "off".equals(settings[3])) {
                        bp.disable();
                    }
                }
                setBP.add(bp);
            }
            catch (Exception e) {
                System.err.println("Exception parsing breakpoint \"" + sbp + "\": " + String.valueOf(e));
            }
        }
        return setBP;
    }

    private String breakpointsToString(Set<BreakPoint> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean fFirst = true;
        for (BreakPoint bp : set) {
            if (bp.oneTime) continue;
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(bp.toPrefString());
        }
        return sb.toString();
    }

    private ObjectHandle[] getArguments(Frame frame, MethodStructure lambda, int[] aiArgs) {
        ObjectHandle[] ahArg = new ObjectHandle[lambda.getMaxVars()];
        int c = aiArgs.length;
        for (int i = 0; i < c; ++i) {
            try {
                ahArg[i] = frame.getArgument(aiArgs[i]);
                continue;
            }
            catch (ObjectHandle.ExceptionHandle.WrapperException e) {
                ahArg[i] = new ObjectHandle.DeferredCallHandle(e.getExceptionHandle());
            }
        }
        return ahArg;
    }

    private String renderDisplay() {
        return switch (this.m_viewMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.renderDebugger();
            case 1 -> this.renderConsole();
            case 2 -> this.renderServices();
        };
    }

    private String renderConsole() {
        return "Console:\n" + xTerminalConsole.CONSOLE_LOG.render(this.m_cWidth, this.m_cHeight - 1);
    }

    private void resizeTerminal() {
        if (TERMINAL != null && TERMINAL.getWidth() > 0) {
            this.m_cWidth = TERMINAL.getWidth();
            this.m_cHeight = TERMINAL.getHeight();
        }
    }

    private String renderDebugger() {
        String sFHeader = "Call stack frames:";
        String[] asFrames = this.renderFrames();
        int cchFrames = Math.min(Math.max(this.longestOf(asFrames), sFHeader.length()), this.m_cWidth / 2);
        String sVHeader = "Variables and watches:";
        String[] asVars = this.renderVars();
        int cchVars = Math.max(this.longestOf(asVars), sVHeader.length());
        int cMax = this.m_cWidth - cchFrames - 2;
        if (cchFrames + cchVars + 3 > this.m_cWidth) {
            int max = this.m_cWidth - 3;
            int half = max / 2;
            if (cchFrames <= half) {
                cchVars = max - cchFrames;
            } else if (cchVars <= half) {
                cchFrames = max - cchVars;
            } else {
                cchFrames = half;
                cchVars = max - cchFrames;
            }
        }
        int cFrames = asFrames.length;
        int cVars = asVars.length;
        int cBot = Math.max(cFrames, cVars) + 5;
        int cTop = Math.max(xTerminalConsole.CONSOLE_LOG.size(), 1) + 2;
        int cMid = this.m_cHeight - cBot - cTop;
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        if (this.m_cHeight > 0 && this.m_frameFocus != null && this.m_frameFocus.f_function != null) {
            MethodStructure method = this.m_frameFocus.f_function;
            boolean fPrinted = false;
            int nLine = method.calculateLineNumber(this.m_frameFocus.m_iPC);
            if (nLine > 0) {
                String[] asLine;
                int iFirst = method.getSourceLineNumber();
                int cLines = method.getSourceLineCount();
                if (cLines > cMid) {
                    int cAvail = this.m_cHeight - cBot;
                    cMid = Math.min(cLines, Math.max(7, Math.max(cAvail - cTop, cAvail / 2)));
                    cTop = cAvail - cMid;
                    int iDesiredFirst = nLine - cMid / 2;
                    if (iDesiredFirst > iFirst) {
                        int iDesiredLast = iDesiredFirst + cMid - 1;
                        int iLast = iFirst + cLines - 1;
                        iFirst = iDesiredLast > iLast ? iLast - cMid + 1 : iDesiredFirst;
                    }
                    cLines = cMid;
                }
                if ((asLine = method.getSourceLines(iFirst, cLines, true)) != null) {
                    cLines = asLine.length;
                    int cchNum = DebugConsole.numlen(iFirst + cLines);
                    int cchLine = this.m_cWidth - cchNum - 2;
                    for (int iLine = 0; iLine < cLines; ++iLine) {
                        int nLineNumber = iFirst + iLine + 1;
                        sb.append(nLineNumber == nLine ? (char)'>' : ' ').append(DebugConsole.rjust(String.valueOf(nLineNumber), cchNum));
                        String sLine = asLine[iLine];
                        if (sLine != null) {
                            if (sLine.length() > cchLine) {
                                sLine = sLine.substring(0, cchLine);
                            }
                            sb.append(' ').append(sLine);
                        }
                        sb.append('\n');
                    }
                    fPrinted = true;
                }
            }
            if (!fPrinted) {
                sb.append("(No source available)");
            }
            sb.append(Handy.dup('-', this.m_cWidth)).append('\n');
        }
        sb.append(DebugConsole.ljust(sFHeader, cchFrames)).append(" | ").append(sVHeader).append('\n').append(Handy.dup('-', cchFrames)).append("-|-").append(Handy.dup('-', cchVars));
        int iFrame = 0;
        Object sFrame = null;
        int iVar = 0;
        Object sVar = null;
        while (true) {
            if (sFrame == null) {
                if (iFrame < cFrames) {
                    sFrame = asFrames[iFrame++];
                }
            } else {
                sFrame = "    " + sFrame;
            }
            if (sVar == null) {
                if (iVar < cVars) {
                    if (((String)(sVar = asVars[iVar++])).length() >= cMax) {
                        sVar = ((String)sVar).substring(0, cMax - 4) + "...";
                    }
                    sVar = ((String)sVar).replace('\n', ' ');
                }
            } else {
                sVar = "    " + sVar;
            }
            if (sFrame == null && sVar == null) {
                return "\u001b[2J\u001b[H" + xTerminalConsole.CONSOLE_LOG.render(this.m_cWidth, cTop) + String.valueOf(sb);
            }
            sb.append('\n');
            if (sFrame == null) {
                sb.append(Handy.dup(' ', cchFrames));
            } else if (((String)sFrame).length() > cchFrames) {
                sb.append((CharSequence)sFrame, 0, cchFrames);
                sFrame = ((String)sFrame).substring(cchFrames);
            } else {
                sb.append(DebugConsole.ljust((String)sFrame, cchFrames));
                sFrame = null;
            }
            sb.append(" | ");
            if (sVar == null) {
                sb.append(Handy.dup(' ', cchVars));
                continue;
            }
            if (((String)sVar).length() > cchVars) {
                sb.append((CharSequence)sVar, 0, cchVars);
                sVar = ((String)sVar).substring(cchVars);
                continue;
            }
            sb.append(DebugConsole.ljust((String)sVar, cchVars));
            sVar = null;
        }
    }

    private String[] renderFrames() {
        Frame frameFocus = this.m_frameFocus == null ? this.m_frame : this.m_frameFocus;
        Frame frameTop = this.m_viewMode == ViewMode.Services ? frameFocus : this.m_frame;
        Frame.StackFrame[] aFrames = frameTop.getStackFrameArray();
        Frame frameNewTop = aFrames == null || aFrames.length < 1 ? null : aFrames[0].frame;
        Frame frameOldTop = this.m_aFrames == null || this.m_aFrames.length < 1 ? null : this.m_aFrames[0].frame;
        this.m_aFrames = aFrames;
        if (this.m_frameFocus == null || frameOldTop != frameNewTop) {
            this.m_frameFocus = frameFocus = frameNewTop;
        }
        int cFrames = aFrames.length;
        int cchFrameNum = DebugConsole.numlen(cFrames - 1);
        String[] asFrames = new String[cFrames];
        for (int i = 0; i < cFrames; ++i) {
            Frame.StackFrame segment = aFrames[i];
            asFrames[i] = (segment.frame == frameFocus ? (char)'>' : ' ') + DebugConsole.rjust(Integer.toString(i), cchFrameNum) + "  " + String.valueOf(segment);
        }
        return asFrames;
    }

    private String[] renderVars() {
        ObjectHandle hThis;
        Map<String, Integer> mapExpand;
        ArrayList<VarDisplay> listVars = new ArrayList<VarDisplay>();
        boolean fAnyVars = false;
        int iPass = 0;
        do {
            DebugStash stash = iPass == 0 ? this.getGlobalStash() : this.getFrameStash();
            mapExpand = stash.getExpandMap();
            for (Watch watch : stash.getWatchList()) {
                ObjectHandle hVar = watch.produceHandle(this.m_frame);
                this.addVar((int)0, (String)watch.path, (String)watch.name, (ObjectHandle)hVar, listVars, mapExpand).watch = watch;
                fAnyVars = true;
            }
        } while (++iPass < 2);
        Frame frame = this.m_frameFocus;
        if (frame.isNative() && !fAnyVars) {
            return Handy.NO_ARGS;
        }
        ObjectHandle.ExceptionHandle hException = frame.m_hException;
        if (hException != null) {
            this.addVar(0, "throw", "exception", hException, listVars, mapExpand);
        }
        if ((hThis = frame.f_hThis) != null) {
            this.addVar(0, "this", "this", hThis, listVars, this.getGlobalStash().getExpandMap());
            ClassComposition.FieldInfo field = hThis.getComposition().getFieldInfo("$outer");
            if (field != null) {
                ObjectHandle hOuter = ((ObjectHandle.GenericHandle)hThis).getField(frame, field);
                this.addVar(0, "outer", "outer", hOuter, listVars, mapExpand);
            }
        }
        int cVars = frame.getCurrentVarCount();
        for (int i = 0; i < cVars; ++i) {
            String sVar;
            Frame.VarInfo info = frame.getVarInfo(i);
            String string = sVar = info == null ? "" : info.getName();
            if (sVar.isEmpty()) continue;
            this.addVar(0, sVar, sVar, frame.f_ahVar[i], listVars, mapExpand);
        }
        cVars = listVars.size();
        this.m_aVars = listVars.toArray(new VarDisplay[0]);
        String[] asVars = new String[cVars];
        int cchVarNum = DebugConsole.numlen(listVars.size());
        for (int i = 0; i < cVars; ++i) {
            asVars[i] = this.m_aVars[i].render(i, cchVarNum);
        }
        return asVars;
    }

    private VarDisplay addVar(int cIndent, String sPath, String sVar, ObjectHandle hVar, ArrayList<VarDisplay> listVars, Map<String, Integer> mapExpand) {
        VarDisplay result;
        block11: {
            ListMap<String, ClassComposition.FieldInfo> mapLayout;
            block12: {
                TypeComposition composition;
                boolean fCanExpand = false;
                boolean fArray = false;
                long cElements = 0L;
                if (hVar instanceof xRef.RefHandle) {
                    xRef.RefHandle hRef = (xRef.RefHandle)hVar;
                    hVar = hRef.getReferent();
                }
                mapLayout = null;
                if (hVar != null && (composition = hVar.getComposition()) != null && !(composition instanceof ProxyComposition)) {
                    mapLayout = this.getFieldLayout(composition);
                    if (!mapLayout.isEmpty()) {
                        fCanExpand = true;
                    }
                    if (hVar instanceof xArray.ArrayHandle) {
                        xArray.ArrayHandle hArray = (xArray.ArrayHandle)hVar;
                        fArray = true;
                        cElements = hArray.m_hDelegate.m_cSize;
                        if (cElements > 0L) {
                            fCanExpand = true;
                        }
                    }
                }
                boolean fExpanded = fCanExpand && !"...".equals(sVar) && mapExpand.getOrDefault(sPath, 0) > 0;
                result = new VarDisplay(cIndent, sPath, sVar, hVar, fCanExpand, fExpanded);
                listVars.add(result);
                if (!fExpanded) break block11;
                if (!fArray) break block12;
                int cMax = mapExpand.getOrDefault(sPath, 10);
                int i = 0;
                while ((long)i < cElements) {
                    if (i >= cMax) {
                        this.addVar(cIndent + 1, sPath + "...", "...", hVar, listVars, mapExpand);
                    } else if (((xArray)hVar.getTemplate()).extractArrayValue(this.m_frame, hVar, i, -1) == -1) {
                        ObjectHandle hElement = this.m_frame.popStack();
                        String sElement = "[" + i + "]";
                        this.addVar(cIndent + 1, sPath + sElement, sElement, hElement, listVars, mapExpand);
                        ++i;
                        continue;
                    }
                    break block11;
                }
                break block11;
            }
            if (!(hVar instanceof ObjectHandle.GenericHandle)) break block11;
            ObjectHandle.GenericHandle hGeneric = (ObjectHandle.GenericHandle)hVar;
            if (mapLayout != null) {
                for (Map.Entry<String, ClassComposition.FieldInfo> entry : mapLayout.entrySet()) {
                    String sName = entry.getKey();
                    ObjectHandle hField = hGeneric.getField(entry.getValue().getIndex());
                    this.addVar(cIndent + 1, sPath + "." + sName, sName, hField, listVars, mapExpand);
                }
            }
        }
        return result;
    }

    private void renderVar(ObjectHandle hVal, boolean fField, StringBuilder sb, String sTab) {
        block8: {
            ListMap<String, ClassComposition.FieldInfo> mapLayout;
            block6: {
                block7: {
                    if (hVal == null) {
                        if (fField) {
                            sb.append('=');
                        }
                        sb.append("<unassigned>");
                        return;
                    }
                    TypeComposition composition = hVal.getComposition();
                    ListMap<String, ClassComposition.FieldInfo> listMap = mapLayout = composition == null ? null : this.getFieldLayout(composition);
                    if (mapLayout == null && !mapLayout.isEmpty()) break block6;
                    if (fField) {
                        sb.append('=');
                    }
                    if (hVal instanceof xArray.ArrayHandle) {
                        // empty if block
                    }
                    sb.append(hVal);
                    if (!hVal.isService()) break block7;
                    sb.append(" [container=").append(hVal.getService().f_context.f_container.getModule().getName()).append(']');
                    break block8;
                }
                if (!(hVal instanceof ObjectHandle.GenericHandle)) break block8;
                ObjectHandle.GenericHandle hGeneric = (ObjectHandle.GenericHandle)hVal;
                if (hGeneric.m_owner == null) break block8;
                sb.append(" [owner=").append(hGeneric.m_owner.getModule().getName()).append(']');
                break block8;
            }
            if (fField) {
                sb.append(": ");
            }
            sb.append(hVal.getType().getValueString());
            for (Map.Entry<String, ClassComposition.FieldInfo> entry : mapLayout.entrySet()) {
                ObjectHandle hField = ((ObjectHandle.GenericHandle)hVal).getField(entry.getValue().getIndex());
                sb.append('\n').append(sTab).append(entry.getKey());
                this.renderVar(hField, true, sb, sTab + "   ");
            }
        }
    }

    private ListMap<String, ClassComposition.FieldInfo> getFieldLayout(TypeComposition clz) {
        HashSet<String> setSimple = new HashSet<String>();
        HashSet<String> setColliding = null;
        for (Object enid : clz.getFieldLayout().keySet()) {
            String sSimple;
            if (enid instanceof IdentityConstant.NestedIdentity) continue;
            if (enid instanceof PropertyConstant) {
                PropertyConstant idProp = (PropertyConstant)enid;
                v0 = idProp.getName();
            } else {
                v0 = sSimple = (String)enid;
            }
            if (setColliding != null && setColliding.contains(sSimple) || setSimple.add(sSimple)) continue;
            setSimple.remove(sSimple);
            if (setColliding == null) {
                setColliding = new HashSet<String>(1);
            }
            setColliding.add(sSimple);
        }
        ListMap<String, ClassComposition.FieldInfo> mapLayout = new ListMap<String, ClassComposition.FieldInfo>();
        for (Map.Entry<Object, ClassComposition.FieldInfo> entry : clz.getFieldLayout().entrySet()) {
            String string;
            Object enid = entry.getKey();
            ClassComposition.FieldInfo field = entry.getValue();
            if (enid instanceof IdentityConstant.NestedIdentity || field.isSynthetic()) continue;
            if (enid instanceof PropertyConstant) {
                PropertyConstant idProp = (PropertyConstant)enid;
                string = setColliding != null && setColliding.contains(idProp.getName()) ? idProp.getPathString() : idProp.getName();
            } else {
                string = (String)enid;
            }
            String sName = string;
            mapLayout.put(sName, field);
        }
        return mapLayout;
    }

    private int longestOf(String[] as) {
        int max = 0;
        for (String a : as) {
            int cch = a.length();
            if (cch <= max) continue;
            max = cch;
        }
        return max;
    }

    private BreakPoint[] allBreakpoints() {
        TreeSet<BreakPoint> setBP = new TreeSet<BreakPoint>();
        if (this.m_setLineBreaks != null) {
            setBP.addAll(this.m_setLineBreaks);
        }
        if (this.m_setThrowBreaks != null) {
            setBP.addAll(this.m_setThrowBreaks);
        }
        return setBP.toArray(new BreakPoint[0]);
    }

    private String renderBreakpoints() {
        BreakPoint[] aBP = this.allBreakpoints();
        this.m_aBreaks = aBP;
        int cBP = aBP.length;
        if (cBP == 0) {
            return "(No breakpoints.)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Breakpoint List:\n").append("-------------------------");
        int cch = DebugConsole.numlen(cBP);
        for (int i = 0; i < cBP; ++i) {
            sb.append('\n').append(DebugConsole.rjust(Integer.toString(i), cch)).append("  ").append(aBP[i]);
        }
        return sb.toString();
    }

    private String renderServices() {
        ArrayList<Frame.StackFrame> listFrames = new ArrayList<Frame.StackFrame>();
        int ixFrame = 0;
        StringBuilder sb = new StringBuilder();
        for (Container container : this.m_frame.f_context.getRuntime().containers()) {
            if (!sb.isEmpty()) {
                sb.append("\n\n");
            }
            sb.append("+container ").append(container.getModule());
            if (container.f_parent != null) {
                sb.append(" parent=").append(container.f_parent.getModule());
            }
            for (ServiceContext ctx : container.getServices()) {
                sb.append("\n    Service \"").append(ctx.f_sName).append("\" (id=").append(ctx.f_lId).append("); status=").append((Object)ctx.getStatus());
                for (Fiber fiber : ctx.getFibers()) {
                    Frame frameBlocker;
                    Fiber fiberCaller;
                    sb.append('\n');
                    Frame frame = fiber.getFrame();
                    if (frame == null && (fiberCaller = fiber.getCaller()) != null) {
                        frame = fiberCaller.getFrame();
                    }
                    if (frame == null) {
                        sb.append(Handy.dup(' ', 8));
                    } else {
                        sb.append(frame == this.m_frame ? (char)'>' : ' ');
                        sb.append(DebugConsole.ljust(String.valueOf(ixFrame++), 7));
                    }
                    sb.append(fiber);
                    if (fiber.getStatus() == Fiber.FiberStatus.Waiting) {
                        assert (frame != null);
                        frame = frame.f_framePrev;
                        sb.append(fiber.reportWaiting());
                    }
                    if (frame != null) {
                        Frame.StackFrame stackFrame = new Frame.StackFrame(frame);
                        listFrames.add(stackFrame);
                        sb.append(" @").append(stackFrame);
                    }
                    if ((frameBlocker = fiber.getBlocker()) == null) continue;
                    sb.append(" blocked by ").append(frameBlocker.f_fiber);
                }
            }
        }
        this.m_aFrames = listFrames.toArray(new Frame.StackFrame[0]);
        return sb.toString();
    }

    private void updateHistory(String sCommand) {
        List<String> list = this.m_listHistory;
        while (list.size() > 42) {
            list.remove(42);
        }
        list.remove(sCommand);
        list.add(0, sCommand);
        StringBuilder sbCommands = new StringBuilder();
        for (String s : list) {
            sbCommands.append('\n').append(s);
        }
        byte[] abHistory = sbCommands.substring(1).getBytes(StandardCharsets.UTF_8);
        this.prefs.put("history", Base64.getEncoder().encodeToString(abHistory));
    }

    private static int numlen(int n) {
        return Integer.toString(n).length();
    }

    private static String ljust(String s, int cch) {
        int cOld = s.length();
        int cSpaces = cch - cOld;
        return cSpaces > 0 ? s + Handy.dup(' ', cSpaces) : s;
    }

    private static String rjust(String s, int cch) {
        int cOld = ((String)s).length();
        int cSpaces = cch - cOld;
        assert (cSpaces >= 0);
        if (cSpaces > 0) {
            s = " ".repeat(cSpaces) + (String)s;
        }
        return s;
    }

    private static String hruler(int c) {
        StringBuilder sb1 = new StringBuilder(c * 2 + 1);
        StringBuilder sb2 = new StringBuilder(c);
        for (int i = 0; i < c; ++i) {
            sb1.append(i % 10 == 0 ? (char)(48 + i / 10 % 10) : (char)' ');
            sb2.append(i % 10);
        }
        return sb1.append('\n').append((CharSequence)sb2).toString();
    }

    private static String vruler(int c, int skip) {
        int digits = c > 100 ? 3 : (c > 10 ? 2 : 1);
        StringBuilder sb = new StringBuilder(c * (digits + 1));
        for (int i = skip; i < c; ++i) {
            sb.append(DebugConsole.rjust(Integer.toString(i % 10 == 0 ? i : i % 10), digits)).append('\n');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static int parseNonNegative(String sNumber) {
        try {
            return Integer.parseInt(sNumber);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String renderHelp() {
        return "\nCommand                  Description\n-------------------      ---------------------------------------------\nF <frame#>               Switch to the specified Frame number\nX <var#>                 Expand (or contract) the specified variable number\nV <var#>                 Toggle the view mode (output format) for the specified variable number\nE <expr>                 Evaluate the specified expression\nEM <expr>                Evaluate the specified expression that produces multiple (or conditional) results\nWE <expr>                Add a \"watch\" for the specified expression\nWO <var#>                Add a watch on the specified referent (the object itself)\nWR <var#>                Add a watch on the specified reference (the property or variable)\nW- <var#>                Remove the specified watch\nD <var#>                 Display the structure view of the specified variable number\nDS <var#>                Display the \"toString()\" value of the specified variable number\nDI <var#>                Display an identity code for the specified variable number\n\nS  (or N)                Step over (\"proceed to next line\")\nS  (or N) <count>        Repeatedly step over (\"proceed to next line\") <count> times\nS+ (or I)                Step in\nS- (or O)                Step out of frame\nSL                       Step (run) to current line\nSL <line>                Step (run) to specified line\nSL <name> <line>         Step (run) to specified line\nR                        Run to next breakpoint\nT                        Reset (return to) a previous stack frame\n\nB+                       Add breakpoint for the current line\nB-                       Remove breakpoint for the current line\nBT                       Toggle breakpoint for the current line\nB+ <line>                Add specified breakpoint\nB+ <name> <line>         Add specified breakpoint\nB- <name> <line>         Remove specified breakpoint\nBC <cond>                Add conditional breakpoint for the current line\nBC <line> <cond>         Add specified conditional breakpoint\nBC <name> <line> <cond>  Add specified conditional breakpoint\nBT <name> <line>         Toggle specified breakpoint\nBE+ <exception>          Break on exception\nBE- <exception>          Remove exception breakpoint\nBE+ *                    Break on all exceptions\nBE- *                    Remove the \"all exception\" breakpoint\nB- *                     Clear all breakpoints\nBT *                     Toggle all breakpoints (enable all iff all enabled; otherwise disable all)\nB                        List current breakpoints\nB- <breakpoint#>         Remove specified breakpoint (from the breakpoint list)\nBT <breakpoint#>         Toggle specified breakpoint (from the breakpoint list)\n\nVC                       View Console\nVD                       View Debugger\nVF                       View Services and Fibers\nVS <width> <height>      Set view width and optional height for debugger and console views\n\nH                        Display command history\nH <count>                Purge command history\n.                        Repeat the last command\n. <number>               Repeat the specified command from the history list\n\n?  (or HELP)             Display this help message\n";
    }

    static enum StepMode {
        None,
        StepOver,
        StepInto,
        StepOut,
        StepLine,
        NaturalCall,
        NaturalReturn;

    }

    static class BreakPoint
    implements Comparable<BreakPoint> {
        public final String className;
        public final int lineNumber;
        public String condition;
        public boolean oneTime;
        private boolean disabled;
        private MethodStructure lambda;
        private int[] lambdaArgs;

        public BreakPoint(String sName, int nLine) {
            this.className = sName;
            this.lineNumber = nLine;
        }

        public BreakPoint(String sName, int nLine, boolean fOneTime) {
            this.className = sName;
            this.lineNumber = nLine;
            this.oneTime = fOneTime;
        }

        public BreakPoint(String sException) {
            this.className = sException;
            this.lineNumber = -1;
        }

        public boolean isEnabled() {
            return !this.disabled;
        }

        public void enable() {
            this.disabled = false;
        }

        public void disable() {
            this.disabled = true;
        }

        public boolean isException() {
            return this.lineNumber < 0;
        }

        public boolean matches(ObjectHandle.ExceptionHandle hE) {
            if (!this.isEnabled()) {
                return false;
            }
            if ("*".equals(this.className)) {
                return true;
            }
            IdentityConstant idException = (IdentityConstant)hE.getType().getDefiningConstant();
            return this.lineNumber == -1 && this.className.equals(idException.getName());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof BreakPoint)) return false;
            BreakPoint that = (BreakPoint)o;
            if (this.lineNumber != that.lineNumber) return false;
            if (!this.className.equals(that.className)) return false;
            return true;
        }

        public int hashCode() {
            return this.className.hashCode() ^ this.lineNumber;
        }

        @Override
        public int compareTo(BreakPoint that) {
            if (that == null) {
                return 1;
            }
            if (this == that || this.equals(that)) {
                return 0;
            }
            if (this.isException() != that.isException()) {
                return this.isException() ? -1 : 1;
            }
            if ("*".equals(this.className)) {
                return -1;
            }
            if ("*".equals(that.className)) {
                return 1;
            }
            if (this.className.equals(that.className)) {
                return this.lineNumber - that.lineNumber;
            }
            return this.className.compareTo(that.className);
        }

        public int matches(Frame frame, int iPC) {
            if (!this.isEnabled() || this.isException()) {
                return -1;
            }
            MethodStructure method = frame.f_function;
            if (this.className.equals(method.getContainingClass().getName()) && this.lineNumber == method.calculateLineNumber(iPC)) {
                if (this.condition != null) {
                    PrintWriter writer = xTerminalConsole.CONSOLE_OUT;
                    if (this.lambda == null) {
                        String sEval = "{return " + this.condition + ";}";
                        EvalCompiler compiler = new EvalCompiler(frame, sEval);
                        this.lambda = compiler.createLambda(frame.poolContext().typeBoolean());
                        if (this.lambda == null) {
                            writer.println("Removing invalid breakpoint condition");
                            for (ErrorListener.ErrorInfo err : compiler.getErrors()) {
                                writer.println(err.getMessageText());
                                this.condition = null;
                            }
                            return iPC;
                        }
                        this.lambdaArgs = compiler.getArgs();
                    }
                    Frame.Continuation continuation = frameCaller -> {
                        ObjectHandle.ExceptionHandle hEx = frameCaller.clearException();
                        if (hEx == null) {
                            if (((xBoolean.BooleanHandle)frameCaller.popStack()).get()) {
                                return INSTANCE.enterCommand(frameCaller, iPC, true);
                            }
                            DebugConsole.INSTANCE.m_stepMode = StepMode.None;
                            return iPC + 1;
                        }
                        writer.println("Breakpoint evaluation threw an exception " + String.valueOf(hEx));
                        writer.println(frameCaller.getStackTrace());
                        return iPC;
                    };
                    ObjectHandle[] ahArgs = INSTANCE.getArguments(frame, this.lambda, this.lambdaArgs);
                    return INSTANCE.resolveEvalArgs(frame, this.lambda, ahArgs, continuation);
                }
                return iPC;
            }
            return -1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((String)(this.lineNumber < 0 ? ("*".equals(this.className) ? "On ALL exceptions" : "On exception: " + this.className) : "At " + this.className + ":" + this.lineNumber));
            if (this.oneTime) {
                sb.append(" (one time)");
            } else if (this.disabled) {
                sb.append(" (disabled)");
            }
            if (this.condition != null) {
                sb.append(" Condition: ").append(this.condition);
            }
            return sb.toString();
        }

        String toPrefString() {
            StringBuilder sb = new StringBuilder(this.className);
            sb.append(':');
            if (this.lineNumber >= 0) {
                sb.append(this.lineNumber);
            }
            sb.append(':');
            if (this.condition != null) {
                byte[] ab = this.condition.getBytes(StandardCharsets.UTF_8);
                sb.append(Base64.getEncoder().encodeToString(ab));
            }
            if (this.disabled) {
                sb.append(":off");
            }
            return sb.toString();
        }
    }

    static enum ViewMode {
        Frames,
        Console,
        Services;

    }

    public static class DebugStash {
        Map<String, Integer> m_mapExpand;
        ArrayList<Watch> m_listWatches;

        Map<String, Integer> getExpandMap() {
            return this.m_mapExpand == null ? Collections.emptyMap() : this.m_mapExpand;
        }

        Map<String, Integer> ensureExpandMap() {
            if (this.m_mapExpand == null) {
                this.m_mapExpand = new HashMap<String, Integer>();
            }
            return this.m_mapExpand;
        }

        List<Watch> getWatchList() {
            return this.m_listWatches == null ? Collections.emptyList() : this.m_listWatches;
        }

        ArrayList<Watch> ensureWatchList() {
            if (this.m_listWatches == null) {
                this.m_listWatches = new ArrayList();
            }
            return this.m_listWatches;
        }
    }

    static class VarDisplay {
        int indent;
        String path;
        String name;
        ObjectHandle hVar;
        boolean isArray;
        long size;
        boolean canExpand;
        boolean expanded;
        Watch watch;

        VarDisplay(int indent, String path, String name, ObjectHandle hVar, boolean canExpand, boolean expanded) {
            this.indent = indent;
            this.path = path;
            this.name = name;
            this.hVar = hVar;
            this.canExpand = canExpand;
            this.expanded = expanded;
            if (hVar instanceof xArray.ArrayHandle) {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hVar;
                this.isArray = true;
                this.size = hArray.m_hDelegate.m_cSize;
            }
        }

        String render(int nIndex, int cchIndex) {
            StringBuilder sb = new StringBuilder();
            sb.append(DebugConsole.rjust(String.valueOf(nIndex), cchIndex)).append(Handy.dup(' ', this.indent * 2 + 1)).append((char)(this.canExpand ? (this.expanded ? 45 : 43) : 32)).append(this.name);
            if (!"...".equals(this.name)) {
                if (this.isArray) {
                    sb.append('[').append(this.size).append(']');
                }
                if (this.canExpand || this.isArray) {
                    sb.append(" : ");
                    sb.append(this.hVar.getType().getValueString());
                } else if (this.hVar == null) {
                    sb.append(" = <unassigned>");
                } else {
                    sb.append(" = ").append(this.hVar);
                }
            }
            return sb.toString();
        }
    }

    static class Watch {
        static final int EVAL = 0;
        static final int OBJ = 1;
        static final int PROP = 2;
        static final int VAR = 3;
        static final int ELEM = 4;
        int form;
        String path;
        String name;
        ObjectHandle hVar;
        String sVar;
        int index;

        Watch(String path, String name, ObjectHandle hRef) {
            this.form = 1;
            this.path = path;
            this.name = name;
            this.hVar = hRef;
        }

        Watch(String path, String name, ObjectHandle hObj, String sProp) {
            this.form = 2;
            this.path = path;
            this.name = name;
            this.hVar = hObj;
            this.sVar = sProp;
        }

        Watch(String path, String name, ObjectHandle hRef, int index) {
            this.form = 4;
            this.path = path;
            this.name = name;
            this.hVar = hRef;
            this.index = index;
        }

        ObjectHandle produceHandle(Frame frame) {
            switch (this.form) {
                case 0: {
                    throw new UnsupportedOperationException();
                }
                case 1: {
                    return this.hVar;
                }
                case 2: {
                    return ((ObjectHandle.GenericHandle)this.hVar).getField(frame, this.sVar);
                }
                case 3: {
                    throw new UnsupportedOperationException();
                }
                case 4: {
                    long cElements = ((xArray.ArrayHandle)this.hVar).m_hDelegate.m_cSize;
                    return cElements > 0L && this.index >= 0 && (long)this.index < cElements && ((xArray)this.hVar.getTemplate()).extractArrayValue(frame, this.hVar, this.index, -1) == -1 ? frame.popStack() : null;
                }
            }
            return null;
        }
    }
}

