/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;

public class Fiber
implements Comparable<Fiber> {
    private final long f_lId;
    final ServiceContext f_context;
    final WeakReference<Fiber> f_refCaller;
    final int f_iCallerId;
    final MethodStructure f_fnCaller;
    final int f_nDepth;
    private volatile FiberStatus m_status;
    private Frame m_frame;
    public volatile boolean m_fResponded;
    private long m_nanoStarted;
    private ObjectHandle m_hTimeout;
    private long m_ldtTimeout;
    private Map<ObjectHandle, ObjectHandle> m_mapTokens;
    private boolean m_fCloneMap;
    private long m_cOps;
    private ObjectHandle m_hAsyncSection = xNullable.NULL;
    private List<ObjectHandle.ExceptionHandle> m_listUnhandledEx;
    private int m_cPending;
    private Object m_oPendingRequests;
    private Map<CompletableFuture, ObjectHandle> m_mapPendingUncaptured;
    private Frame.Continuation m_resume;
    private Frame m_frameBlocker;
    private static final AtomicLong s_counter = new AtomicLong();

    public Fiber(ServiceContext context, ServiceContext.Message msgCall) {
        this.f_lId = s_counter.getAndIncrement();
        this.f_context = context;
        this.f_iCallerId = msgCall.f_iCallerId;
        this.f_fnCaller = msgCall.f_fnCaller;
        this.m_status = FiberStatus.Initial;
        Fiber fiberCaller = msgCall.f_fiberCaller;
        if (fiberCaller == null) {
            this.f_nDepth = 0;
            this.f_refCaller = null;
            this.m_ldtTimeout = 0L;
            this.m_hTimeout = xNullable.NULL;
            this.m_mapTokens = null;
            this.m_fCloneMap = false;
        } else {
            this.f_nDepth = msgCall.getCallDepth() + 1;
            this.f_refCaller = new WeakReference<Fiber>(fiberCaller);
            this.m_ldtTimeout = msgCall.getTimeoutStamp();
            this.m_hTimeout = msgCall.getTimeoutHandle();
            Map<ObjectHandle, ObjectHandle> mapTokens = msgCall.f_mapTokens;
            if (mapTokens != null && msgCall.isAsync()) {
                this.m_mapTokens = new ConcurrentHashMap<ObjectHandle, ObjectHandle>(mapTokens);
                this.m_fCloneMap = false;
            } else {
                this.m_mapTokens = mapTokens;
                this.m_fCloneMap = true;
            }
        }
    }

    protected Fiber getCaller() {
        return this.f_refCaller == null ? null : (Fiber)this.f_refCaller.get();
    }

    public ObjectHandle getTimeoutHandle() {
        return this.m_hTimeout;
    }

    public void setTimeoutHandle(ObjectHandle hTimeout, long ldtTimeout) {
        assert (hTimeout != null);
        this.m_hTimeout = hTimeout;
        this.m_ldtTimeout = ldtTimeout;
    }

    public long getTimeoutStamp() {
        return this.m_ldtTimeout;
    }

    public void clearTimeout() {
        this.m_ldtTimeout = 0L;
        this.m_hTimeout = xNullable.NULL;
    }

    public Map<ObjectHandle, ObjectHandle> getTokens() {
        return this.m_mapTokens;
    }

    public Map<ObjectHandle, ObjectHandle> ensureTokens() {
        Map<ObjectHandle, ObjectHandle> map = this.m_mapTokens;
        if (map == null) {
            this.m_mapTokens = map = new ConcurrentHashMap<ObjectHandle, ObjectHandle>();
            this.m_fCloneMap = false;
        } else if (this.m_fCloneMap) {
            this.m_mapTokens = map = new ConcurrentHashMap<ObjectHandle, ObjectHandle>(map);
            this.m_fCloneMap = false;
        }
        return map;
    }

    public boolean isContinuationOf(Fiber fiberOrig) {
        if (this.f_context == fiberOrig.f_context) {
            return true;
        }
        Fiber fiberCaller = this.getCaller();
        return fiberCaller != null && fiberCaller.isContinuationOf(fiberOrig);
    }

    public boolean isAssociated(Fiber that) {
        if (this.f_context == that.f_context) {
            return this == that;
        }
        Fiber fiberCaller = this.getCaller();
        if (fiberCaller == null) {
            fiberCaller = that.getCaller();
            return fiberCaller != null && this.isAssociated(fiberCaller);
        }
        return that.isAssociated(fiberCaller);
    }

    public long getId() {
        return this.f_lId;
    }

    public FiberStatus getStatus() {
        return this.m_status;
    }

    public ObjectHandle getAsyncSection() {
        return this.m_hAsyncSection;
    }

    public void setStatus(FiberStatus status, long cOps) {
        this.m_status = status;
        switch (this.m_status.ordinal()) {
            default: {
                throw new IllegalArgumentException();
            }
            case 1: {
                this.m_nanoStarted = this.f_context.f_container.nanoTime();
                this.m_frame = null;
                break;
            }
            case 2: 
            case 3: {
                long cNanos = this.f_context.f_container.nanoTime() - this.m_nanoStarted;
                this.m_nanoStarted = 0L;
                this.f_context.m_cRuntimeNanos += cNanos;
                this.m_frame = this.f_context.getCurrentFrame();
                this.m_cOps += cOps;
                break;
            }
            case 4: {
                this.m_frame = null;
            }
        }
    }

    public Frame getFrame() {
        return switch (this.m_status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> null;
            case 1 -> this.f_context.getCurrentFrame();
            case 2, 3, 4 -> this.m_frame;
        };
    }

    public boolean isReady() {
        return this.m_status != FiberStatus.Waiting || this.m_fResponded || this.isTimedOut();
    }

    public boolean isWaiting() {
        return this.m_status == FiberStatus.Waiting;
    }

    public boolean isTimedOut() {
        return this.m_ldtTimeout > 0L && this.f_context.f_container.currentTimeMillis() > this.m_ldtTimeout;
    }

    public Fiber traceCaller() {
        Fiber fiberCaller = this.getCaller();
        if (fiberCaller == null || fiberCaller.f_context.f_container != this.f_context.f_container) {
            // empty if block
        }
        return fiberCaller;
    }

    public Container getCallingContainer() {
        Fiber fiberCaller = this.getCaller();
        return fiberCaller == null ? null : fiberCaller.f_context.f_container;
    }

    public int prepareRun(Frame frame) {
        int iResult;
        if (this.isTimedOut()) {
            iResult = frame.raiseException(xException.timedOut(frame, "The service has timed-out", this.getTimeoutHandle()));
            this.clearTimeout();
        } else {
            iResult = -1;
            switch (this.getStatus().ordinal()) {
                case 3: {
                    assert (frame == this.m_frame);
                    if (this.m_resume != null) {
                        iResult = this.m_resume.proceed(frame);
                        if (iResult == -8) {
                            this.m_fResponded = false;
                            return -8;
                        }
                        this.m_resume = null;
                    }
                    if (frame.m_hException == null) break;
                    iResult = -3;
                    break;
                }
                case 4: {
                    return frame.raiseException(xException.serviceTerminated(frame, this.f_context.f_sName));
                }
            }
        }
        this.setStatus(FiberStatus.Running, 0L);
        this.m_fResponded = false;
        return iResult;
    }

    public void registerRequest(ServiceContext.Message request) {
        this.addDependee(request);
        ++this.m_cPending;
        request.f_future.whenComplete((_void, ex) -> {
            this.removeDependee(request);
            if (--this.m_cPending == 0 && this.m_status == FiberStatus.Terminating) {
                this.f_context.terminateFiber(this, 0L);
            }
        });
    }

    protected void addDependee(ServiceContext.Message request) {
        if (request.m_fiber == this) {
            return;
        }
        Object oPending = this.m_oPendingRequests;
        if (oPending == null) {
            this.m_oPendingRequests = request;
        } else if (oPending instanceof ServiceContext.Message) {
            ServiceContext.Message requestPrev = (ServiceContext.Message)oPending;
            HashMap<CompletableFuture, ServiceContext.Message> mapPending = new HashMap<CompletableFuture, ServiceContext.Message>();
            mapPending.put(requestPrev.f_future, requestPrev);
            mapPending.put(request.f_future, request);
            this.m_oPendingRequests = mapPending;
        } else {
            Map mapPending = (Map)oPending;
            mapPending.put(request.f_future, request);
        }
    }

    protected void removeDependee(ServiceContext.Message request) {
        if (request.m_fiber == this) {
            return;
        }
        Object oPending = this.m_oPendingRequests;
        if (oPending instanceof ServiceContext.Message) {
            this.m_oPendingRequests = null;
        } else {
            ((Map)oPending).remove(request.f_future);
        }
    }

    public void onResponse() {
        this.m_fResponded = true;
    }

    public void registerUncapturedRequest(ServiceContext.Message request) {
        Map<CompletableFuture, ObjectHandle> mapPending = this.m_mapPendingUncaptured;
        if (mapPending == null) {
            this.m_mapPendingUncaptured = mapPending = new HashMap<CompletableFuture, ObjectHandle>();
        }
        ++this.m_cPending;
        CompletableFuture future = request.f_future;
        mapPending.put(future, this.m_hAsyncSection);
        future.whenComplete((_void, ex) -> {
            if (ex != null) {
                this.processUnhandledException(((ObjectHandle.ExceptionHandle.WrapperException)ex).getExceptionHandle());
            }
            this.m_mapPendingUncaptured.remove(future);
            if (--this.m_cPending == 0 && this.getStatus() == FiberStatus.Terminating) {
                this.f_context.terminateFiber(this, 0L);
            }
        });
    }

    protected void processUnhandledException(ObjectHandle.ExceptionHandle hException) {
        ObjectHandle hAsyncSection = this.m_hAsyncSection;
        if (hAsyncSection == xNullable.NULL) {
            this.f_context.callUnhandledExceptionHandler(hException);
        } else {
            List<ObjectHandle.ExceptionHandle> listEx = this.m_listUnhandledEx;
            if (listEx == null) {
                this.m_listUnhandledEx = listEx = new ArrayList<ObjectHandle.ExceptionHandle>();
            }
            listEx.add(hException);
        }
    }

    public int registerAsyncSection(Frame frame, ObjectHandle hSectionNew) {
        ObjectHandle hSectionOld = this.m_hAsyncSection;
        if (hSectionOld != xNullable.NULL && this.isSectionPending(hSectionOld)) {
            this.m_resume = frameCaller -> {
                if (this.isSectionPending(hSectionOld)) {
                    return -8;
                }
                List<ObjectHandle.ExceptionHandle> listEx = this.m_listUnhandledEx;
                if (listEx != null && !listEx.isEmpty()) {
                    ObjectHandle.GenericHandle hAsyncSection = (ObjectHandle.GenericHandle)hSectionOld;
                    xRTFunction.FunctionHandle hNotify = (xRTFunction.FunctionHandle)hAsyncSection.getField(frameCaller, "notify");
                    return new CallNotify(listEx, hNotify).proceed(frameCaller);
                }
                return -1;
            };
            return -8;
        }
        this.m_hAsyncSection = hSectionNew;
        return -1;
    }

    protected boolean hasPendingRequests() {
        return this.m_status == FiberStatus.Waiting || this.m_cPending > 0;
    }

    private boolean isSectionPending(ObjectHandle hSection) {
        return this.m_mapPendingUncaptured != null && this.m_mapPendingUncaptured.containsValue(hSection);
    }

    public Frame getBlocker() {
        return this.m_frameBlocker;
    }

    protected void setBlocker(Frame frameBlocker) {
        this.m_frameBlocker = frameBlocker;
    }

    public String reportWaiting() {
        assert (this.m_status == FiberStatus.Waiting || this.m_status == FiberStatus.Terminating);
        Object oPending = this.m_oPendingRequests;
        if (oPending == null) {
            return " for closure";
        }
        if (oPending instanceof ServiceContext.Message) {
            ServiceContext.Message msg = (ServiceContext.Message)oPending;
            Fiber fiber = msg.m_fiber;
            return " for " + String.valueOf(fiber == null ? "initial" : fiber);
        }
        StringBuilder sb = new StringBuilder(" for [");
        boolean fFirst = true;
        for (ServiceContext.Message request : ((Map)oPending).values()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(", ");
            }
            Fiber fiber = request.m_fiber;
            sb.append(fiber);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int compareTo(Fiber that) {
        return Long.compare(this.f_lId, that.f_lId);
    }

    public int hashCode() {
        return Long.hashCode(this.f_lId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Fiber)) return false;
        Fiber fiber = (Fiber)obj;
        if (this.f_lId != fiber.f_lId) return false;
        return true;
    }

    public String toString() {
        return "Fiber " + this.f_lId + " (" + this.m_status.name() + ")";
    }

    public static enum FiberStatus {
        Initial(3),
        Running(4),
        Paused(2),
        Waiting(1),
        Terminating(0);

        private final int nActivity;

        private FiberStatus(int nActivity) {
            this.nActivity = nActivity;
        }

        FiberStatus moreActive(FiberStatus that) {
            return that == null || this.nActivity >= that.nActivity ? this : that;
        }
    }

    protected static class CallNotify
    implements Frame.Continuation {
        private final List<ObjectHandle.ExceptionHandle> listEx;
        private final xRTFunction.FunctionHandle hNotify;

        public CallNotify(List<ObjectHandle.ExceptionHandle> listEx, xRTFunction.FunctionHandle hNotify) {
            this.listEx = listEx;
            this.hNotify = hNotify;
        }

        @Override
        public int proceed(Frame frameCaller) {
            block5: while (!this.listEx.isEmpty()) {
                switch (this.hNotify.call1(frameCaller, null, new ObjectHandle[]{this.listEx.remove(0)}, -2)) {
                    case -1: {
                        continue block5;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        continue block5;
                    }
                }
                throw new IllegalStateException();
            }
            return -1;
        }
    }
}

