/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import org.xvm.runtime.Fiber;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ServiceContext;

public class FiberQueue {
    private final ServiceContext f_context;
    private Frame[] m_aFrame = new Frame[16];
    private int m_ixHead = -1;
    private int m_ixTail = 0;
    private int m_cSize = 0;

    public FiberQueue(ServiceContext ctx) {
        this.f_context = ctx;
    }

    public void add(Frame frame) {
        int iInsert;
        Frame[] aFrame;
        if ((aFrame = this.ensureCapacity(++this.m_cSize))[iInsert = this.m_ixTail] != null) {
            this.compact();
            iInsert = this.m_ixTail;
        }
        aFrame[iInsert] = frame;
        if (this.m_ixHead < 0) {
            this.m_ixHead = iInsert;
        }
        this.m_ixTail = (iInsert + 1) % aFrame.length;
    }

    public boolean isEmpty() {
        return this.m_cSize == 0;
    }

    public boolean isReady() {
        if (this.m_cSize == 0) {
            return false;
        }
        int cFrames = this.m_aFrame.length;
        int ixHead = this.m_ixHead;
        for (int i = 0; i < cFrames; ++i) {
            int ix = (i + ixHead) % cFrames;
            int iPriority = this.checkPriority(ix);
            if (iPriority < 0) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.m_cSize;
    }

    public Frame getReady() {
        if (this.m_cSize == 0) {
            return null;
        }
        int cFrames = this.m_aFrame.length;
        int ixHead = this.m_ixHead;
        for (int i = 0; i < cFrames; ++i) {
            int ix = (i + ixHead) % cFrames;
            int iPriority = this.checkPriority(ix);
            if (iPriority < 0) continue;
            return this.remove(ix);
        }
        return null;
    }

    public Frame getAny() {
        if (this.m_cSize == 0) {
            return null;
        }
        int cFrames = this.m_aFrame.length;
        int ixHead = this.m_ixHead;
        for (int i = 0; i < cFrames; ++i) {
            int ix = (i + ixHead) % cFrames;
            if (this.m_aFrame[ix] == null) continue;
            return this.remove(ix);
        }
        return null;
    }

    public String reportStatus() {
        if (this.m_cSize == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int cFrames = this.m_aFrame.length;
        int ixHead = this.m_ixHead;
        block4: for (int i = 0; i < cFrames; ++i) {
            int ix = (i + ixHead) % cFrames;
            int iPriority = this.checkPriority(ix);
            if (iPriority != -1) continue;
            Frame frame = this.m_aFrame[ix];
            if (sb.isEmpty()) {
                sb.append(frame.f_context);
            }
            sb.append("\nframe=").append(frame);
            Fiber fiber = frame.f_fiber;
            switch (fiber.getStatus()) {
                case Waiting: {
                    sb.append(" waiting");
                    continue block4;
                }
                case Initial: {
                    sb.append(" new");
                }
            }
        }
        return sb.toString();
    }

    private int checkPriority(int ix) {
        Frame frame = this.m_aFrame[ix];
        if (frame == null) {
            return -3;
        }
        Fiber fiber = frame.f_fiber;
        switch (fiber.getStatus()) {
            case Running: {
                return 2;
            }
            case Waiting: {
                if (!fiber.isReady()) {
                    return -1;
                }
                return frame.isNativeStack() || fiber == this.f_context.getSynchronizationOwner() || this.canResume(fiber) ? 1 : -2;
            }
            case Initial: {
                return this.canResume(fiber) ? 0 : -2;
            }
        }
        throw new IllegalStateException();
    }

    private boolean canResume(Fiber fiber) {
        switch (this.f_context.getSynchronicity()) {
            case Critical: {
                return false;
            }
            case Synchronized: {
                Fiber fiberCaller = fiber.getCaller();
                return fiberCaller != null && fiberCaller.isContinuationOf(this.f_context.getSynchronizationOwner());
            }
            case Concurrent: {
                return !this.isAnyNonConcurrentWaiting(fiber);
            }
        }
        throw new IllegalStateException();
    }

    private boolean isAnyNonConcurrentWaiting(Fiber fiberCandidate) {
        Frame[] aFrame = this.m_aFrame;
        Fiber fiberCaller = fiberCandidate.getCaller();
        for (Frame frame : aFrame) {
            Fiber fiber;
            if (frame == null || (fiber = frame.f_fiber) == fiberCandidate || fiber.getStatus() != Fiber.FiberStatus.Waiting || frame.isSafeStack() || fiberCaller != null && fiberCaller.isContinuationOf(fiber)) continue;
            fiberCandidate.setBlocker(frame);
            return true;
        }
        fiberCandidate.setBlocker(null);
        return false;
    }

    private Frame remove(int ix) {
        Frame frame = this.m_aFrame[ix];
        assert (frame != null);
        this.m_aFrame[ix] = null;
        if (--this.m_cSize > 0) {
            if (ix == this.m_ixHead) {
                int cCapacity = this.m_aFrame.length;
                while (this.m_aFrame[ix = (ix + 1) % cCapacity] == null) {
                }
                this.m_ixHead = ix;
            }
        } else {
            this.m_ixHead = -1;
            this.m_ixTail = 0;
        }
        return frame;
    }

    private Frame[] ensureCapacity(int cCapacity) {
        Frame[] aFrame = this.m_aFrame;
        int cOld = aFrame.length;
        if (cCapacity > cOld) {
            int cNew = Math.max(cCapacity, cOld + (cOld >> 2));
            Frame[] aNew = new Frame[cNew];
            assert (this.m_ixHead == this.m_ixTail);
            if (this.m_ixHead == 0) {
                System.arraycopy(aFrame, 0, aNew, 0, cOld);
            } else {
                int cHead = cOld - this.m_ixHead;
                System.arraycopy(aFrame, this.m_ixHead, aNew, 0, cHead);
                System.arraycopy(aFrame, 0, aNew, cHead, this.m_ixHead);
                this.m_ixHead = 0;
                this.m_ixTail = cOld;
            }
            aFrame = aNew;
            this.m_aFrame = aNew;
        }
        return aFrame;
    }

    private void compact() {
        int iFrom;
        Frame[] aFrame = this.m_aFrame;
        int cFrames = aFrame.length;
        assert (aFrame[this.m_ixHead] != null);
        int iTo = iFrom = (this.m_ixHead + 1) % cFrames;
        for (int i = 1; i < cFrames; ++i) {
            Frame frame = aFrame[iFrom];
            if (frame != null) {
                if (iFrom != iTo) {
                    assert (aFrame[iTo] == null);
                    aFrame[iTo] = frame;
                    aFrame[iFrom] = null;
                }
                iTo = (iTo + 1) % cFrames;
            }
            iFrom = (iFrom + 1) % cFrames;
        }
        assert (aFrame[iTo] == null);
        this.m_ixTail = iTo;
    }

    public String toString() {
        return "size=" + this.m_cSize;
    }
}

