/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.DynamicFormalConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.DebugConsole;
import org.xvm.runtime.Fiber;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.annotations.xFuture;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;

public class Frame
implements GenericTypeResolver {
    public final Fiber f_fiber;
    public final ServiceContext f_context;
    public final MethodStructure f_function;
    protected final Op[] f_aOp;
    protected final ObjectHandle f_hTarget;
    protected final ObjectHandle f_hThis;
    public final ObjectHandle[] f_ahVar;
    public final VarInfo[] f_aInfo;
    protected final int f_iReturn;
    protected final int[] f_aiReturn;
    public final Frame f_framePrev;
    public final int[] f_anNextVar;
    protected final int f_iPCPrev;
    protected final int f_iId;
    protected final int f_nDepth;
    public int m_iPC;
    public int m_iScope;
    private int m_iGuard = -1;
    private Guard[] m_aGuard;
    public ObjectHandle.ExceptionHandle m_hException;
    public DeferredGuardAction m_deferred;
    public xRTFunction.FullyBoundHandle m_hfnFinally;
    public Frame m_frameNext;
    public Continuation m_continuation;
    public CallChain m_chain;
    public int m_nChainDepth;
    private ObjectHandle m_hStackTop;
    private Deque<ObjectHandle> m_stack;
    public DebugConsole.DebugStash m_debug;
    public static final int VAR_MASK = 1;
    public static final int VAR_STANDARD = 0;
    public static final int VAR_DYNAMIC_REF = 1;
    public static final int TYPE_MASK = 2;
    public static final int TYPE_FIXED = 0;
    public static final int TYPE_DYNAMIC = 2;
    public static final int RESOLVED_TYPE = 4;
    public static final int FUTURE_HANDLE = 8;
    protected static final VarTypeResolver ARRAY_ELEMENT_RESOLVER = new VarTypeResolver(){

        @Override
        public TypeConstant resolve(Frame frame, int nTargetReg, int iAuxId) {
            TypeConstant typeArray;
            if (nTargetReg >= 0) {
                VarInfo infoArray = frame.getVarInfo(nTargetReg);
                typeArray = infoArray.getType();
            } else {
                typeArray = frame.getLocalType(nTargetReg, null);
            }
            return typeArray.getParamType(typeArray.isTuple() ? iAuxId : 0);
        }
    };
    protected static final VarTypeResolver PROPERTY_RESOLVER = new VarTypeResolver(){

        @Override
        public TypeConstant resolve(Frame frame, int nTargetReg, int iPropId) {
            ConstantPool pool = frame.poolContext();
            PropertyConstant constProperty = (PropertyConstant)frame.getConstant(iPropId);
            TypeConstant typeTarget = frame.getLocalType(nTargetReg, null);
            return constProperty.isFormalType() ? constProperty.getFormalType().resolveGenerics(pool, typeTarget).getType() : constProperty.getType().resolveGenerics(pool, typeTarget);
        }
    };
    protected static final VarTypeResolver METHOD_RESOLVER = new VarTypeResolver(){

        @Override
        public TypeConstant resolve(Frame frame, int nTargetReg, int iAuxId) {
            ConstantPool pool = frame.poolContext();
            MethodConstant idMethod = (MethodConstant)(nTargetReg < 0 ? frame.getConstant(nTargetReg) : pool.getConstant(nTargetReg));
            return frame.resolveType(iAuxId >= 0 ? idMethod.getRawReturns()[iAuxId] : pool.ensureTupleType(idMethod.getSignature().getRawReturns()));
        }
    };
    protected static final VarTypeResolver REF_RESOLVER = new VarTypeResolver(){

        @Override
        public TypeConstant resolve(Frame frame, int nTargetReg, int iAuxId) {
            TypeConstant typeRef = frame.getVarInfo(nTargetReg).getType();
            return typeRef.resolveGenericType("Referent");
        }
    };
    protected static final Op[] WAIT_FOR_FUTURE = new Op[]{new Op(){

        @Override
        public int process(Frame frame, int iPC) {
            int cValues = frame.f_ahVar.length;
            assert (cValues > 0);
            if (cValues == 1) {
                assert (frame.f_aiReturn == null);
                xFuture.FutureHandle hFuture = (xFuture.FutureHandle)frame.f_ahVar[0];
                return hFuture.isAssigned() ? frame.returnValue(hFuture, true) : -7;
            }
            assert (frame.f_iReturn == -14);
            boolean[] afDynamic = new boolean[cValues];
            for (int i = 0; i < cValues; ++i) {
                ObjectHandle objectHandle = frame.f_ahVar[i];
                if (objectHandle instanceof xFuture.FutureHandle) {
                    xFuture.FutureHandle hFuture = (xFuture.FutureHandle)objectHandle;
                    if (!hFuture.isAssigned()) {
                        return -7;
                    }
                    afDynamic[i] = true;
                    continue;
                }
                afDynamic[i] = false;
            }
            return frame.returnValues(frame.f_ahVar, afDynamic);
        }

        @Override
        public String toString() {
            return "WaitForResult";
        }
    }};
    protected static final Op[] WAIT_FOR_IO = new Op[]{new Op(){

        @Override
        public int process(Frame frame, int iPC) {
            assert (frame.f_ahVar.length == 1 && frame.f_iReturn == -2);
            CompletableFuture cf = ((ObjectHandle.NativeFutureHandle)frame.f_ahVar[0]).f_future;
            return cf.isDone() ? -2 : -7;
        }

        @Override
        public String toString() {
            return "WaitForIO";
        }
    }};
    static final boolean REPORT_WRAPPING = System.getProperties().containsKey("DEBUG");

    protected Frame(Frame framePrev, MethodStructure function, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn, int[] aiReturn) {
        assert (framePrev != null && function != null);
        this.f_context = framePrev.f_context;
        this.f_iId = this.f_context.m_iFrameCounter++;
        this.f_nDepth = framePrev.f_nDepth + 1;
        this.f_fiber = framePrev.f_fiber;
        this.f_framePrev = framePrev;
        this.f_iPCPrev = framePrev.m_iPC;
        this.f_function = function;
        this.f_aOp = function.getOps();
        this.f_hTarget = hTarget;
        this.f_hThis = hTarget == null ? null : (hTarget.isStruct() ? hTarget : hTarget.revealOrigin());
        this.f_ahVar = ahVar;
        this.f_aInfo = new VarInfo[ahVar.length];
        int cScopes = function == null ? 1 : function.getMaxScopes();
        this.f_anNextVar = new int[cScopes];
        this.f_anNextVar[0] = function == null ? 0 : function.getParamCount();
        this.f_iReturn = iReturn;
        this.f_aiReturn = aiReturn;
    }

    protected Frame(Fiber fiber, int iCallerPC, Op[] aopNative, ObjectHandle[] ahVar, int iReturn, int[] aiReturn) {
        this.f_context = fiber.f_context;
        this.f_iId = this.f_context.m_iFrameCounter++;
        this.f_nDepth = fiber.f_nDepth;
        this.f_fiber = fiber;
        this.f_framePrev = null;
        this.f_iPCPrev = iCallerPC;
        this.f_function = null;
        this.f_aOp = aopNative;
        this.f_hThis = null;
        this.f_hTarget = null;
        this.f_ahVar = ahVar;
        this.f_aInfo = new VarInfo[ahVar.length];
        this.f_anNextVar = null;
        this.f_iReturn = iReturn;
        this.f_aiReturn = aiReturn;
    }

    protected Frame(Frame framePrev, Op[] aopNative, ObjectHandle[] ahVar, int iReturn, int[] aiReturn) {
        this.f_context = framePrev.f_context;
        this.f_iId = this.f_context.m_iFrameCounter++;
        this.f_nDepth = framePrev.f_nDepth + 1;
        this.f_fiber = framePrev.f_fiber;
        this.f_framePrev = framePrev;
        this.f_iPCPrev = framePrev.m_iPC;
        this.f_function = null;
        this.f_aOp = aopNative;
        this.f_hTarget = framePrev.f_hTarget;
        this.f_hThis = framePrev.f_hThis;
        this.f_ahVar = ahVar;
        this.f_aInfo = new VarInfo[ahVar.length];
        this.f_anNextVar = null;
        this.f_iReturn = iReturn;
        this.f_aiReturn = aiReturn;
    }

    public Frame createFrame1(MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        return new Frame(this, method, hTarget, ahVar, iReturn, null);
    }

    public Frame createFrameT(MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        return new Frame(this, method, hTarget, ahVar, -15, new int[]{iReturn});
    }

    public Frame createFrameN(MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
        return new Frame(this, method, hTarget, ahVar, -14, aiReturn);
    }

    public Frame createNativeFrame(Op[] aop, ObjectHandle[] ahVar, int iReturn, int[] aiReturn) {
        return new Frame(this, aop, ahVar, iReturn, aiReturn);
    }

    public Frame createWaitFrame(CompletableFuture<ObjectHandle> cfResult, int iReturn) {
        return this.createWaitFrame(xFuture.makeHandle(cfResult), iReturn);
    }

    public Frame createWaitFrame(xFuture.FutureHandle hFuture, int iReturn) {
        ObjectHandle[] ahFuture = new ObjectHandle[]{hFuture};
        Frame frameNext = this.createNativeFrame(WAIT_FOR_FUTURE, ahFuture, iReturn, null);
        frameNext.f_aInfo[0] = new VarInfo(xFuture.TYPE, 1);
        hFuture.getFuture().whenComplete((r, x) -> this.f_fiber.onResponse());
        return frameNext;
    }

    public Frame createWaitFrame(CompletableFuture<ObjectHandle[]> cfResult, int[] aiReturn) {
        int cReturns = aiReturn.length;
        ObjectHandle[] ahFuture = new ObjectHandle[cReturns];
        Frame frameNext = this.createNativeFrame(WAIT_FOR_FUTURE, ahFuture, -14, aiReturn);
        for (int i = 0; i < cReturns; ++i) {
            int iResult = i;
            CompletionStage cfReturn = cfResult.thenApply(ahResult -> ahResult[iResult]);
            ahFuture[i] = xFuture.makeHandle((CompletableFuture<ObjectHandle>)cfReturn);
            frameNext.f_aInfo[i] = new VarInfo(xFuture.TYPE, 1);
        }
        cfResult.whenComplete((r, x) -> this.f_fiber.onResponse());
        return frameNext;
    }

    public Frame createWaitFrame(ObjectHandle[] ahFuture, int[] aiReturn) {
        Frame frameNext = this.createNativeFrame(WAIT_FOR_FUTURE, ahFuture, -14, aiReturn);
        int cReturns = ahFuture.length;
        ArrayList<CompletableFuture<ObjectHandle>> listFutures = new ArrayList<CompletableFuture<ObjectHandle>>(cReturns);
        for (ObjectHandle handle : ahFuture) {
            if (!(handle instanceof xFuture.FutureHandle)) continue;
            xFuture.FutureHandle hFuture = (xFuture.FutureHandle)handle;
            listFutures.add(hFuture.getFuture());
        }
        CompletableFuture<Void> cfResult = CompletableFuture.allOf(listFutures.toArray(new CompletableFuture[0]));
        cfResult.whenComplete((r, x) -> this.f_fiber.onResponse());
        return frameNext;
    }

    public Frame createWaitIOFrame(CompletableFuture<Object> cfResult, Continuation continuation) {
        ObjectHandle[] ahFuture = new ObjectHandle[]{new ObjectHandle.NativeFutureHandle(cfResult)};
        Frame frameNext = this.createNativeFrame(WAIT_FOR_IO, ahFuture, -2, null);
        frameNext.f_aInfo[0] = new VarInfo(this.poolContext().typeObject(), 0);
        cfResult.whenComplete((r, x) -> {
            this.f_fiber.onResponse();
            this.f_context.ensureScheduled(true);
        });
        frameNext.addContinuation(continuation);
        return frameNext;
    }

    protected int ensureInitialized(Frame frameNext) {
        return frameNext.f_nDepth > 128 ? this.raiseException(xException.stackOverflow(this)) : frameNext.f_function.ensureInitialized(this, frameNext);
    }

    public boolean isNative() {
        return this.f_function == null;
    }

    public boolean isNativeStack() {
        Frame frame = this;
        do {
            if (frame.isNative()) continue;
            return false;
        } while ((frame = frame.f_framePrev) != null);
        return true;
    }

    protected Frame findCallerFrame(int id) {
        Frame frame = this;
        do {
            if (frame.f_iId != id) continue;
            return frame;
        } while ((frame = frame.f_framePrev) != null);
        return null;
    }

    public int call(Frame frameNext) {
        assert (frameNext.f_framePrev == this);
        this.m_frameNext = frameNext;
        return -5;
    }

    public int callInitialized(Frame frameNext) {
        return this.ensureInitialized(frameNext);
    }

    public int call1(MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        try {
            return this.ensureInitialized(this.createFrame1(method, hTarget, ahVar, iReturn));
        }
        catch (IllegalStateException e) {
            return this.raiseException(xException.abstractMethod(this, method.getIdentityConstant().getPathString()));
        }
    }

    public int callT(MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        try {
            return this.ensureInitialized(this.createFrameT(method, hTarget, ahVar, iReturn));
        }
        catch (IllegalStateException e) {
            return this.raiseException(xException.abstractMethod(this, method.getIdentityConstant().getPathString()));
        }
    }

    public int callN(MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
        try {
            return this.ensureInitialized(this.createFrameN(method, hTarget, ahVar, aiReturn));
        }
        catch (IllegalStateException e) {
            return this.raiseException(xException.abstractMethod(this, method.getIdentityConstant().getPathString()));
        }
    }

    public int invoke1(CallChain chain, int nDepth, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        Frame frameNext = this.createFrame1(chain.getMethod(nDepth), hTarget, ahVar, iReturn);
        frameNext.m_chain = chain;
        frameNext.m_nChainDepth = nDepth;
        return this.ensureInitialized(frameNext);
    }

    public int invokeT(CallChain chain, int nDepth, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        Frame frameNext = this.createFrameT(chain.getMethod(nDepth), hTarget, ahVar, iReturn);
        frameNext.m_chain = chain;
        frameNext.m_nChainDepth = nDepth;
        return this.ensureInitialized(frameNext);
    }

    public int invokeN(CallChain chain, int nDepth, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
        Frame frameNext = this.createFrameN(chain.getMethod(nDepth), hTarget, ahVar, aiReturn);
        frameNext.m_chain = chain;
        frameNext.m_nChainDepth = nDepth;
        return this.ensureInitialized(frameNext);
    }

    public ObjectHandle popResult(int iResult) {
        return switch (iResult) {
            case -1 -> this.popStack();
            case -5 -> new ObjectHandle.DeferredCallHandle(this.m_frameNext);
            case -3 -> new ObjectHandle.DeferredCallHandle(this.clearException());
            default -> throw new IllegalStateException();
        };
    }

    public ObjectHandle popResultImmutable(int iResult) {
        switch (iResult) {
            case -1: {
                ObjectHandle hResult = this.popStack();
                hResult.makeImmutable();
                return hResult;
            }
            case -5: {
                ObjectHandle.DeferredCallHandle hDeferred = new ObjectHandle.DeferredCallHandle(this.m_frameNext);
                hDeferred.addContinuation(frameCaller -> {
                    frameCaller.peekStack().makeImmutable();
                    return -1;
                });
                return hDeferred;
            }
            case -3: {
                return new ObjectHandle.DeferredCallHandle(this.clearException());
            }
        }
        throw new IllegalStateException();
    }

    public int wait(CompletableFuture<ObjectHandle> cf, int iReturn) {
        return this.call(this.createWaitFrame(cf, iReturn));
    }

    public int wait(CompletableFuture<ObjectHandle> cf, int iReturn, Continuation continuation) {
        assert (continuation != null);
        Frame frameNext = this.createWaitFrame(cf, iReturn);
        frameNext.addContinuation(continuation);
        return this.call(frameNext);
    }

    public int waitForIO(CompletableFuture cf, Continuation continuation) {
        return this.call(this.createWaitIOFrame(cf, continuation));
    }

    public void pushGuard(Guard guard) {
        Guard[] aGuard = this.m_aGuard;
        if (aGuard == null) {
            assert (this.m_iGuard == -1);
            aGuard = this.m_aGuard = new Guard[this.f_anNextVar.length];
        }
        aGuard[++this.m_iGuard] = guard;
    }

    public void popGuard() {
        this.m_aGuard[this.m_iGuard--] = null;
    }

    protected int findGuard(ObjectHandle.ExceptionHandle hException) {
        Guard[] aGuard = this.m_aGuard;
        if (aGuard != null) {
            for (int iGuard = this.m_iGuard; iGuard >= 0; --iGuard) {
                Guard guard = aGuard[iGuard];
                int iPC = guard.handleException(this, hException, iGuard);
                if (iPC < 0) continue;
                return iPC;
            }
        }
        return -3;
    }

    public int processAllGuard(DeferredGuardAction deferredAction) {
        Guard[] aGuard = this.m_aGuard;
        assert (aGuard != null);
        for (int iGuard = deferredAction.getGuardIndex(); iGuard >= 0; --iGuard) {
            Guard guard = aGuard[iGuard];
            if (!(guard instanceof AllGuard)) continue;
            AllGuard allGuard = (AllGuard)guard;
            deferredAction.setGuardIndex(iGuard - 1);
            this.m_deferred = deferredAction;
            return allGuard.handleJump(this, iGuard);
        }
        this.m_deferred = null;
        return deferredAction.complete(this);
    }

    public ObjectHandle getPredefinedArgument(int iArgId) {
        switch (iArgId) {
            case -1: {
                ObjectHandle hValue = this.popStack();
                return hValue == null ? this.makeDeferredException("Run-time error: empty stack") : hValue;
            }
            case -4: {
                return ObjectHandle.DEFAULT;
            }
            case -13: {
                return this.f_hThis == null ? this.makeDeferredException("Run-time error: no target") : xRTFunction.makeHandle(this, this.m_chain, this.m_nChainDepth).bindTarget(this, this.f_hThis);
            }
            case -5: {
                return this.f_hThis == null ? this.makeDeferredException("Run-time error: no target") : this.f_hThis;
            }
            case -6: {
                return this.f_hTarget == null ? this.makeDeferredException("Run-time error: no target") : this.f_hTarget;
            }
            case -7: {
                return this.f_hThis == null ? this.makeDeferredException("Run-time error: no target") : this.f_hThis.ensureAccess(Constants.Access.PUBLIC);
            }
            case -8: {
                return this.f_hThis == null ? this.makeDeferredException("Run-time error: no target") : this.f_hThis.ensureAccess(Constants.Access.PROTECTED);
            }
            case -9: {
                return this.f_hThis == null ? this.makeDeferredException("Run-time error: no target") : this.f_hThis.ensureAccess(Constants.Access.PRIVATE);
            }
            case -10: {
                return this.f_hThis == null ? this.makeDeferredException("Run-time error: no target") : this.f_hThis.ensureAccess(Constants.Access.STRUCT);
            }
            case -11: {
                return this.f_hThis == null ? this.makeDeferredException("Run-time error: no target") : this.getConstHandle(this.poolContext().ensureClassConstant(this.f_hThis.getType()));
            }
            case -12: {
                xService.ServiceHandle hService = this.f_context.getService();
                return hService == null ? this.makeDeferredException("No service") : hService;
            }
        }
        throw new IllegalStateException("Invalid argument " + iArgId);
    }

    private ObjectHandle.DeferredCallHandle makeDeferredException(String sMsg) {
        return new ObjectHandle.DeferredCallHandle(xException.makeHandle(this, sMsg));
    }

    public TypeConstant getPredefinedArgumentType(int iArgId, ObjectHandle hArg) {
        if (iArgId == -1) {
            return hArg == null ? null : hArg.getType();
        }
        return this.getPredefinedArgument(iArgId).getType();
    }

    public int enterScope(int nNextVar) {
        this.f_anNextVar[this.m_iScope] = nNextVar;
        int iScope = ++this.m_iScope;
        this.f_anNextVar[iScope] = nNextVar;
        return iScope;
    }

    public void exitScope() {
        int iScope = this.m_iScope--;
        int[] anNextVar = this.f_anNextVar;
        int iVarFrom = anNextVar[iScope - 1];
        int iVarTo = anNextVar[iScope] - 1;
        for (int i = iVarFrom; i <= iVarTo; ++i) {
            VarInfo info = this.f_aInfo[i];
            if (info == null) continue;
            info.release();
            this.f_aInfo[i] = null;
            this.f_ahVar[i] = null;
        }
    }

    public void clearAllScopes(int iScope) {
        int iVarFrom = this.f_anNextVar[iScope];
        int iVarTo = this.f_ahVar.length - 1;
        for (int i = iVarFrom; i <= iVarTo; ++i) {
            VarInfo info = this.f_aInfo[i];
            if (info == null) continue;
            info.release();
            this.f_aInfo[i] = null;
            this.f_ahVar[i] = null;
        }
    }

    public ObjectHandle getThis() {
        if (this.f_hThis == null) {
            throw new IllegalStateException("Frame has no \"this\": " + String.valueOf(this));
        }
        return this.f_hThis;
    }

    public boolean isMethod() {
        return this.f_hThis != null;
    }

    public int pushStack(ObjectHandle hValue) {
        assert (hValue != null && !(hValue instanceof ObjectHandle.DeferredCallHandle));
        if (this.m_hStackTop != null) {
            Deque<ObjectHandle> stack = this.m_stack;
            if (stack == null) {
                stack = this.m_stack = new ArrayDeque<ObjectHandle>();
            }
            stack.push(this.m_hStackTop);
        }
        this.m_hStackTop = hValue;
        return -1;
    }

    public ObjectHandle popStack() {
        ObjectHandle hValue = this.m_hStackTop;
        assert (hValue != null);
        Deque<ObjectHandle> stack = this.m_stack;
        this.m_hStackTop = stack == null || stack.isEmpty() ? null : stack.pop();
        return hValue;
    }

    public ObjectHandle peekStack() {
        return this.m_hStackTop;
    }

    public int assignValue(int nVar, ObjectHandle hValue) {
        if (hValue == null) {
            if (nVar == -1) {
                this.pushStack(ObjectHandle.DEFAULT);
            }
            return -1;
        }
        assert (!(hValue instanceof ObjectHandle.DeferredCallHandle));
        if (nVar >= 0) {
            VarInfo info = this.getVarInfo(nVar);
            if (info != null) {
                if (info.isDynamicVar()) {
                    xRef.RefHandle hDest = (xRef.RefHandle)this.f_ahVar[nVar];
                    return hDest.getVarSupport().setReferent(this, hDest, hValue);
                }
                if (info.isFixedType()) {
                    this.checkType(hValue, info);
                }
            }
            this.f_ahVar[nVar] = hValue;
            return -1;
        }
        switch (nVar) {
            case -3: 
            case -2: {
                return -1;
            }
            case -1: {
                return this.pushStack(hValue);
            }
        }
        try {
            PropertyConstant idProp = (PropertyConstant)this.getConstant(nVar);
            ObjectHandle hThis = this.getThis();
            return hThis.getTemplate().setPropertyValue(this, hThis, idProp, hValue);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("nVar=" + nVar);
        }
    }

    private void checkType(ObjectHandle hValueFrom, VarInfo infoTo) {
        TypeConstant typeFrom = hValueFrom.getUnsafeType();
        if (typeFrom.getPosition() != infoTo.m_nTypeId) {
            TypeConstant typeTo = infoTo.getType();
            block0 : switch (typeFrom.calculateRelation(typeTo)) {
                case IS_A: {
                    break;
                }
                case IS_A_WEAK: {
                    if (typeTo.isTypeOfType()) break;
                }
                default: {
                    typeFrom = hValueFrom.revealOrigin().getType();
                    switch (typeFrom.calculateRelation(typeTo)) {
                        case IS_A: {
                            break block0;
                        }
                        case IS_A_WEAK: {
                            if (!REPORT_WRAPPING) break block0;
                            System.err.println("WARNING: wrapping required from: " + typeFrom.getValueString() + " to: " + typeTo.getValueString());
                            break block0;
                        }
                        default: {
                            System.err.println("WARNING: suspicious assignment at " + String.valueOf(this) + " from: " + typeFrom.getValueString() + " to: " + typeTo.getValueString());
                        }
                    }
                }
            }
        }
    }

    public int assignValues(int[] anVar, ObjectHandle ... ahValue) {
        int c = Math.min(anVar.length, ahValue.length);
        return this.assignValues(anVar, ahValue, 0, c);
    }

    private int assignValues(int[] anVar, ObjectHandle[] ahValue, int i, int c) {
        block9: while (true) {
            switch (c - i) {
                default: {
                    ObjectHandle hVal = ahValue[i];
                    if (hVal == null) {
                        assert (i == 1 && ahValue[0] == xBoolean.FALSE);
                        return -1;
                    }
                    switch (this.assignValue(anVar[i], hVal)) {
                        case -1: {
                            ++i;
                            continue block9;
                        }
                        case -5: {
                            int iNext = i + 1;
                            this.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValues(anVar, ahValue, iNext, c));
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }
                case 1: {
                    ObjectHandle hVal = ahValue[i];
                    if (hVal == null) {
                        assert (i == 1 && ahValue[0] == xBoolean.FALSE);
                        return -1;
                    }
                    return this.assignValue(anVar[i], hVal);
                }
                case 0: 
            }
            break;
        }
        return -1;
    }

    public int assignTuple(int nVar, ObjectHandle ... ahValue) {
        TypeComposition clazz = this.getVarInfo(nVar).getType().ensureClass(this);
        return this.assignValue(nVar, xTuple.makeHandle(clazz, ahValue));
    }

    public int assignFutureResult(int iReturn, CompletableFuture<ObjectHandle> cfResult) {
        if (cfResult.isDone()) {
            return xFuture.assignCompleted(this, cfResult, iReturn);
        }
        if (this.isFuture(iReturn)) {
            return this.assignValue(iReturn, xFuture.makeHandle(cfResult));
        }
        return this.wait(cfResult, iReturn);
    }

    public int assignDeferredValue(int nVar, ObjectHandle hValue) {
        return hValue instanceof ObjectHandle.DeferredCallHandle ? hValue.proceed(this, frameCaller -> frameCaller.assignValue(nVar, frameCaller.popStack())) : this.assignValue(nVar, hValue);
    }

    public int assignConditionalDeferredValue(int[] anVar, ObjectHandle hValue) {
        return hValue instanceof ObjectHandle.DeferredCallHandle ? hValue.proceed(this, frameCaller -> frameCaller.assignValues(anVar, xBoolean.TRUE, frameCaller.popStack())) : this.assignValues(anVar, xBoolean.TRUE, hValue);
    }

    public int pushDeferredValue(ObjectHandle hValue) {
        return hValue instanceof ObjectHandle.DeferredCallHandle ? hValue.proceed(this, Utils.NEXT) : this.pushStack(hValue);
    }

    public int returnVoid() {
        return switch (this.f_iReturn) {
            case -3, -2 -> -2;
            case -15 -> this.returnValue(this.f_aiReturn[0], xTuple.H_VOID, false);
            default -> this.returnValue(this.f_iReturn, xTuple.H_VOID, false);
        };
    }

    public int returnValue(ObjectHandle hValue, boolean fDynamic) {
        switch (this.f_iReturn) {
            case -14: {
                assert (this.f_function.isConditionalReturn() && hValue.equals(xBoolean.FALSE));
                return this.returnValue(this.f_aiReturn[0], hValue, fDynamic);
            }
            case -15: {
                Frame framePrev = this.f_framePrev;
                int iReturn = this.f_aiReturn[0];
                TypeConstant typeTuple = iReturn < 0 ? this.poolContext().typeTuple0() : (framePrev.isNative() ? this.f_function.getIdentityConstant().getReturnsAsTuple() : framePrev.getRegisterType(iReturn));
                TypeComposition clzTuple = this.f_context.f_container.resolveClass(typeTuple);
                if (fDynamic) {
                    int n;
                    if (framePrev.isDynamicVar(iReturn)) {
                        return this.returnValue(iReturn, hValue, true);
                    }
                    xRef.RefHandle hRef = (xRef.RefHandle)hValue;
                    if (hRef instanceof xFuture.FutureHandle) {
                        xFuture.FutureHandle hFuture = (xFuture.FutureHandle)hRef;
                        n = hFuture.waitAndAssign(framePrev, -1);
                    } else {
                        n = hRef.getVarSupport().getReferent(framePrev, hRef, -1);
                    }
                    int iResult = n;
                    switch (iResult) {
                        case -1: {
                            hValue = framePrev.popStack();
                            break;
                        }
                        case -5: {
                            framePrev.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xTuple.makeImmutableHandle(clzTuple, frameCaller.popStack())));
                            if (this.m_continuation != null) {
                                framePrev.m_frameNext.addContinuation(this.m_continuation);
                            }
                            return -6;
                        }
                        case -3: {
                            return -4;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                return this.returnValue(iReturn, xTuple.makeImmutableHandle(clzTuple, hValue), false);
            }
        }
        return this.returnValue(this.f_iReturn, hValue, fDynamic);
    }

    public int returnValue(int iReturn, ObjectHandle hValue, boolean fDynamic) {
        int iResult;
        Frame framePrev = this.f_framePrev;
        if (fDynamic) {
            if (iReturn == -3) {
                return -2;
            }
            xRef.RefHandle hSrc = (xRef.RefHandle)hValue;
            if (framePrev.isDynamicVar(iReturn)) {
                if (hSrc instanceof xFuture.FutureHandle) {
                    xFuture.FutureHandle hFutureSrc = (xFuture.FutureHandle)hSrc;
                    xRef.RefHandle hDest = (xRef.RefHandle)framePrev.f_ahVar[iReturn];
                    iResult = hDest instanceof xFuture.FutureHandle ? hDest.getVarSupport().setReferent(framePrev, hDest, hSrc) : hFutureSrc.waitAndAssign(framePrev, iReturn);
                } else {
                    iResult = hSrc.getVarSupport().getReferent(framePrev, hSrc, iReturn);
                }
            } else {
                int n;
                if (hSrc instanceof xFuture.FutureHandle) {
                    xFuture.FutureHandle hFutureSrc = (xFuture.FutureHandle)hSrc;
                    n = hFutureSrc.waitAndAssign(framePrev, iReturn);
                } else {
                    n = hSrc.getVarSupport().getReferent(framePrev, hSrc, iReturn);
                }
                iResult = n;
            }
        } else {
            iResult = framePrev.assignValue(iReturn, hValue);
        }
        switch (iResult) {
            case -1: {
                return -2;
            }
            case -5: {
                if (this.m_continuation != null) {
                    framePrev.m_frameNext.addContinuation(this.m_continuation);
                }
                return -6;
            }
            case -3: {
                return -4;
            }
        }
        throw new IllegalArgumentException("iResult=" + iResult);
    }

    public int returnValues(ObjectHandle[] ahValue, boolean[] afDynamic) {
        switch (this.f_iReturn) {
            case -3: 
            case -2: {
                return -2;
            }
            case -14: {
                return new Utils.ReturnValues(this.f_aiReturn, ahValue, afDynamic).proceed(this);
            }
            case -15: {
                TypeConstant typeRet;
                Frame framePrev = this.f_framePrev;
                int iReturn = this.f_aiReturn[0];
                TypeConstant typeConstant = iReturn < 0 ? this.poolContext().typeTuple() : (typeRet = framePrev.isNative() ? this.f_function.getIdentityConstant().getReturnsAsTuple() : framePrev.getRegisterType(iReturn));
                assert (typeRet.isTuple());
                return new Utils.ReturnTuple(iReturn, typeRet, ahValue, afDynamic).proceed(this);
            }
        }
        return this.returnValue(this.f_iReturn, ahValue[0], afDynamic != null && afDynamic[0]);
    }

    public int returnTuple(xTuple.TupleHandle hTuple) {
        return switch (this.f_iReturn) {
            case -14 -> this.returnValues(hTuple.m_ahValue, null);
            case -15 -> this.returnValue(this.f_aiReturn[0], hTuple, false);
            default -> this.returnValue(this.f_iReturn, hTuple, false);
        };
    }

    public int raiseException(ObjectHandle.ExceptionHandle.WrapperException e) {
        return this.raiseException(e.getExceptionHandle());
    }

    public int raiseException(String sMsg) {
        this.m_hException = xException.makeHandle(this, sMsg);
        return -3;
    }

    public int raiseException(ObjectHandle.ExceptionHandle hException) {
        this.m_hException = hException;
        return -3;
    }

    public ObjectHandle.ExceptionHandle clearException() {
        ObjectHandle.ExceptionHandle hException = this.m_hException;
        this.m_hException = null;
        return hException;
    }

    public Constant[] localConstants() {
        assert (this.f_function != null);
        return this.f_function.getLocalConstants();
    }

    public ConstantPool poolContext() {
        return this.f_context.f_pool;
    }

    public ObjectHandle getConstHandle(Constant constant) {
        return this.f_context.f_container.ensureConstHandle(this, constant);
    }

    public ObjectHandle getConstHandle(int iArg) {
        return this.f_context.f_container.ensureConstHandle(this, this.getConstant(iArg));
    }

    public Constant getConstant(int iArg) {
        assert (iArg <= -16);
        return this.localConstants()[-16 - iArg];
    }

    public String getString(int iArg) {
        return ((StringConstant)this.getConstant(iArg)).getValue();
    }

    public ObjectHandle getInjected(String sName, TypeConstant type, ObjectHandle hOpts) {
        SingletonConstant constInjector;
        PackageStructure pkgImport;
        Container container = this.f_context.f_container;
        if (this.f_function != null && !(container instanceof NativeContainer) && (pkgImport = this.f_function.getImportedPackage(container.getModule())) != null && (constInjector = pkgImport.getModuleInjector()) != null) {
            List<Component.Injection> listInject = pkgImport.getModuleInjections();
            boolean fUse = false;
            for (Component.Injection inject : listInject) {
                String sInjectName = inject.getName();
                if ((!inject.getType().isA(type) || !"_".equals(sInjectName)) && !sInjectName.equals(sName)) continue;
                fUse = true;
                break;
            }
            if (fUse) {
                return Utils.callGetResource(this, this.getConstHandle(constInjector), type, sName);
            }
        }
        return container.getInjectable(this, sName, type, hOpts);
    }

    public TypeConstant getLocalType(int iArg, ObjectHandle hArg) {
        return iArg >= 0 ? this.getRegisterType(iArg) : (iArg <= -16 ? this.resolveType(this.getLocalConstantType(iArg)) : this.getPredefinedArgumentType(iArg, hArg));
    }

    private TypeConstant getLocalConstantType(int iArg) {
        Constant constant = this.getConstant(iArg);
        return constant.getFormat() == Constant.Format.Class ? ((ClassConstant)constant).getValueType(this.poolContext(), null) : constant.getType();
    }

    protected TypeConstant getRegisterType(int nRegister) {
        VarInfo info = this.getVarInfo(nRegister);
        if (info.isStandardVar()) {
            return info.getType();
        }
        return info.getType().getParamType(0);
    }

    public TypeComposition resolveClass(int iArg) {
        return this.resolveType(iArg).ensureClass(this);
    }

    public ClassTemplate ensureTemplate(IdentityConstant constClz) {
        return this.f_context.f_container.getTemplate(constClz);
    }

    public TypeConstant resolveType(int iArg) {
        return this.resolveType((TypeConstant)this.getConstant(iArg));
    }

    public TypeConstant resolveType(TypeConstant type) {
        ConstantPool pool = this.poolContext();
        if (type.containsFormalType(true) && (type = type.resolveGenerics(pool, this.getGenericsResolver(type.containsDynamicType()))).containsFormalType(true)) {
            System.err.println("ERROR: Unresolved type " + String.valueOf(type));
        }
        if (this.f_hThis != null && type.containsAutoNarrowing(true)) {
            type = type.resolveAutoNarrowing(pool, false, this.f_hThis.getType(), null);
        }
        return type;
    }

    public ObjectHandle getArgument(int iArg) throws ObjectHandle.ExceptionHandle.WrapperException {
        if (iArg >= 0) {
            ObjectHandle hValue = this.f_ahVar[iArg];
            if (hValue == null) {
                int cDefault = this.f_function.getDefaultParamCount();
                int cAll = this.f_function.getParamCount();
                if (cDefault > 0 && iArg < cAll && iArg >= cAll - cDefault) {
                    return this.replaceDefaultArgument(iArg);
                }
                VarInfo info = this.f_aInfo[iArg];
                String sName = info == null ? "" : info.getName();
                throw xException.unassignedValue(this, sName).getException();
            }
            if (hValue == ObjectHandle.DEFAULT) {
                return this.replaceDefaultArgument(iArg);
            }
            VarInfo info = this.f_aInfo[iArg];
            if (info != null && info.isDynamicVar()) {
                xRef.RefHandle hRef = (xRef.RefHandle)hValue;
                return switch (hRef.getVarSupport().getReferent(this, hRef, -1)) {
                    case -1 -> this.popStack();
                    case -5 -> new ObjectHandle.DeferredCallHandle(this.m_frameNext);
                    case -3 -> throw this.m_hException.getException();
                    default -> throw new IllegalStateException();
                };
            }
            return hValue;
        }
        return iArg <= -16 ? this.getConstHandle(iArg) : this.getPredefinedArgument(iArg);
    }

    private ObjectHandle replaceDefaultArgument(int iArg) throws ObjectHandle.ExceptionHandle.WrapperException {
        ObjectHandle.DeferredCallHandle hDeferred;
        Constant constValue = this.f_function.getParam(iArg).getDefaultValue();
        if (constValue == null) {
            throw xException.illegalState(this, "Unknown default value for argument \"" + this.f_function.getParam(iArg).getName() + "\"").getException();
        }
        ObjectHandle hValue = this.getConstHandle(constValue);
        if (hValue instanceof ObjectHandle.DeferredCallHandle && !((hDeferred = (ObjectHandle.DeferredCallHandle)hValue) instanceof ObjectHandle.DeferredSingletonHandle)) {
            hDeferred.addContinuation(frameCaller -> {
                this.f_ahVar[iArg] = frameCaller.peekStack();
                return -1;
            });
            return hDeferred;
        }
        this.f_ahVar[iArg] = hValue;
        return this.f_ahVar[iArg];
    }

    public ObjectHandle getReturnValue(int iArg) throws ObjectHandle.ExceptionHandle.WrapperException {
        ObjectHandle hValue = iArg >= 0 ? this.f_ahVar[iArg] : (iArg <= -16 ? this.getConstHandle(iArg) : this.getPredefinedArgument(iArg));
        return hValue == ObjectHandle.DEFAULT ? this.replaceDefaultArgument(iArg) : hValue;
    }

    public ObjectHandle[] getArguments(int[] aiArg, int cVars) throws ObjectHandle.ExceptionHandle.WrapperException {
        int cArgs = aiArg.length;
        ObjectHandle[] ahArg = new ObjectHandle[Math.max(cArgs, cVars)];
        for (int i = cArgs - 1; i >= 0; --i) {
            ahArg[i] = this.getArgument(aiArg[i]);
        }
        return ahArg;
    }

    public boolean isNextRegister(int nVar) {
        return nVar >= this.f_anNextVar[this.m_iScope];
    }

    public void introduceResolvedVar(int nVar, TypeConstant type, String sName, int nStyle, ObjectHandle hValue) {
        this.f_anNextVar[this.m_iScope] = Math.max(this.f_anNextVar[this.m_iScope], nVar + 1);
        VarInfo info = new VarInfo(type, nStyle | 4);
        info.setName(sName);
        this.f_aInfo[nVar] = info;
        if (hValue != null) {
            this.f_ahVar[nVar] = hValue;
        }
    }

    public void introduceResolvedVar(int nVar, TypeConstant type) {
        this.introduceResolvedVar(nVar, type, null, 0, null);
    }

    public void introduceVar(int nVar, int nTypeId, int nNameId, int nStyle, ObjectHandle hValue) {
        this.f_anNextVar[this.m_iScope] = Math.max(this.f_anNextVar[this.m_iScope], nVar + 1);
        this.f_aInfo[nVar] = new VarInfo((TypeConstant)this.localConstants()[nTypeId], nNameId, nStyle);
        if (hValue != null) {
            this.f_ahVar[nVar] = hValue;
        }
    }

    public void introduceVarCopy(int nVar, int nVarFrom) {
        this.f_anNextVar[this.m_iScope] = Math.max(this.f_anNextVar[this.m_iScope], nVar + 1);
        TypeConstant type = nVarFrom >= 0 ? this.getVarInfo(nVarFrom).getType() : this.getConstant(nVarFrom).getType();
        this.f_aInfo[nVar] = new VarInfo(type, 4);
    }

    public void introducePropertyVar(int nVar, int nTargetId, int nPropId) {
        this.f_anNextVar[this.m_iScope] = Math.max(this.f_anNextVar[this.m_iScope], nVar + 1);
        this.f_aInfo[nVar] = new VarInfo(nTargetId, nPropId, PROPERTY_RESOLVER);
    }

    public void introduceMethodReturnVar(int nVar, int nMethodId, int index) {
        this.f_anNextVar[this.m_iScope] = Math.max(this.f_anNextVar[this.m_iScope], nVar + 1);
        this.f_aInfo[nVar] = new VarInfo(nMethodId, index, METHOD_RESOLVER);
    }

    public void introduceElementVar(int nArrayReg, int nIndex) {
        int n = this.m_iScope;
        int n2 = this.f_anNextVar[n];
        this.f_anNextVar[n] = n2 + 1;
        int nVar = n2;
        this.f_aInfo[nVar] = new VarInfo(nArrayReg, nIndex, ARRAY_ELEMENT_RESOLVER);
    }

    public void introduceRefTypeVar(int nVarReg) {
        int n = this.m_iScope;
        int n2 = this.f_anNextVar[n];
        this.f_anNextVar[n] = n2 + 1;
        int nVar = n2;
        this.f_aInfo[nVar] = new VarInfo(nVarReg, 0, REF_RESOLVER);
    }

    public boolean isAssigned(int nVar) {
        return this.f_ahVar[nVar] != null;
    }

    public boolean isDynamicVar(int nVar) {
        return nVar >= 0 && this.getVarInfo(nVar).isDynamicVar();
    }

    public xRef.RefHandle getDynamicVar(int nVar) {
        xRef.RefHandle hRef = (xRef.RefHandle)this.f_ahVar[nVar];
        return hRef.isAssigned() ? hRef : null;
    }

    public boolean isFuture(int nVar) {
        return nVar >= 0 && this.getVarInfo(nVar).isFuture();
    }

    public VarInfo getVarInfo(int nVar) {
        VarInfo info = this.f_aInfo[nVar];
        if (info == null) {
            int cArgs = this.f_function.getParamCount();
            if (nVar >= cArgs) {
                return null;
            }
            Parameter param = this.f_function.getParam(nVar);
            TypeConstant type = this.resolveType(param.getType());
            info = this.f_aInfo[nVar] = new VarInfo(type, 0);
            info.setName(param.getName());
        }
        return info;
    }

    public int getCurrentVarCount() {
        return this.f_anNextVar == null ? 0 : this.f_anNextVar[this.m_iScope];
    }

    public void chainFinalizer(xRTFunction.FullyBoundHandle hFinalizer) {
        if (hFinalizer != null) {
            Frame frameTop = this;
            while (frameTop.m_hfnFinally == null) {
                frameTop = frameTop.f_framePrev;
            }
            frameTop.m_hfnFinally = hFinalizer.chain(frameTop.m_hfnFinally);
        }
    }

    public void addContinuation(Continuation continuation) {
        if (this.m_continuation == null) {
            this.m_continuation = continuation;
        } else {
            if (!(this.m_continuation instanceof ContinuationChain)) {
                this.m_continuation = new ContinuationChain(this.m_continuation);
            }
            ((ContinuationChain)this.m_continuation).add(continuation);
        }
    }

    public ServiceContext.Synchronicity getSynchronicity() {
        if (this.isNativeStack()) {
            return ServiceContext.Synchronicity.Concurrent;
        }
        ServiceContext.Synchronicity synchronicity = this.f_context.getSynchronicity();
        return switch (synchronicity) {
            default -> throw new MatchException(null, null);
            case ServiceContext.Synchronicity.Concurrent -> {
                if (this.isSafeStack()) {
                    yield ServiceContext.Synchronicity.Concurrent;
                }
                yield ServiceContext.Synchronicity.Synchronized;
            }
            case ServiceContext.Synchronicity.Synchronized, ServiceContext.Synchronicity.Critical -> synchronicity;
        };
    }

    public boolean isSafeStack() {
        Frame framePrev = this.f_framePrev;
        if (framePrev == null) {
            assert (this.isNative());
            return true;
        }
        return this.isSafeFrame() && framePrev.isSafeStack();
    }

    public boolean isSafeFrame() {
        MethodStructure function = this.f_function;
        if (function != null) {
            switch (function.getConcurrencySafety()) {
                case Unsafe: {
                    return false;
                }
                case Instance: {
                    ObjectHandle hThis = this.f_hThis;
                    if (hThis == null || !hThis.isMutable()) break;
                    return false;
                }
            }
        }
        return true;
    }

    public GenericTypeResolver getGenericsResolver(boolean fDynamic) {
        return fDynamic || this.f_hThis == null || this.f_function.getTypeParamCount() != 0 ? this : this.f_hThis.getType();
    }

    @Override
    public TypeConstant resolveGenericType(String sFormalName) {
        return this.f_hThis == null ? null : this.f_hThis.getType().resolveGenericType(sFormalName);
    }

    @Override
    public TypeConstant resolveFormalType(FormalConstant constFormal) {
        int nRegister;
        Frame frame = this;
        block0 : switch (constFormal.getFormat()) {
            case Property: {
                MethodStructure method = this.f_function;
                String sFormalName = constFormal.getName();
                if (method.isLambda() && method.isStatic()) {
                    int c = method.getTypeParamCount();
                    for (int i = 0; i < c; ++i) {
                        Parameter param = method.getParam(i);
                        if (!sFormalName.equals(param.getName())) continue;
                        nRegister = i;
                        break block0;
                    }
                    return null;
                }
                return this.resolveGenericType(sFormalName);
            }
            case TypeParameter: {
                TypeParameterConstant constParam = (TypeParameterConstant)constFormal;
                MethodConstant idMethod = constParam.getMethod();
                do {
                    if (!idMethod.equals(frame.f_function.getIdentityConstant())) continue;
                    nRegister = constParam.getRegister();
                    break block0;
                } while ((frame = frame.f_framePrev) != null && !frame.isNative());
                return this.poolContext().typeObject();
            }
            case DynamicFormal: {
                DynamicFormalConstant constDynamic = (DynamicFormalConstant)constFormal;
                MethodConstant idMethod = constDynamic.getMethod();
                do {
                    if (!idMethod.equals(frame.f_function.getIdentityConstant())) continue;
                    TypeConstant typeTarget = frame.f_ahVar[constDynamic.getRegisterIndex()].getType();
                    return typeTarget.isShared(frame.poolContext()) ? constDynamic.getFormalConstant().resolve(typeTarget) : this.poolContext().typeObject();
                } while ((frame = frame.f_framePrev) != null && !frame.isNative());
                return this.poolContext().typeObject();
            }
            case FormalTypeChild: {
                return null;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        TypeConstant typeType = frame.f_ahVar[nRegister].getType();
        assert (typeType.isTypeOfType() && typeType.getParamsCount() >= 1);
        return typeType.getParamType(0);
    }

    public DebugConsole.DebugStash ensureDebugStash() {
        if (this.m_debug == null) {
            this.m_debug = new DebugConsole.DebugStash();
        }
        return this.m_debug;
    }

    public String getStackTrace() {
        StringBuilder sb = new StringBuilder();
        for (String sFrame : this.getStackTraceArray()) {
            sb.append("\n\t").append(sFrame);
        }
        sb.append('\n');
        return sb.toString();
    }

    protected StackFrame[] getStackFrameArray() {
        Frame frame = this;
        Fiber fiber = frame.f_fiber;
        int iPC = this.m_iPC;
        if (fiber.getStatus() != Fiber.FiberStatus.Running) {
            --iPC;
        }
        ArrayList<StackFrame> listFrames = new ArrayList<StackFrame>(7);
        while (true) {
            StackFrame stackFrame = new StackFrame(frame, frame.f_function, iPC);
            listFrames.add(stackFrame);
            iPC = frame.f_iPCPrev;
            frame = frame.f_framePrev;
            if (frame != null) continue;
            Fiber fiberCaller = fiber.traceCaller();
            if (fiberCaller == null) break;
            stackFrame.boundary = true;
            frame = fiberCaller.getFrame();
            if (frame != null) {
                if (fiberCaller.isWaiting()) {
                    frame = frame.f_framePrev;
                    iPC = frame.m_iPC;
                } else {
                    frame = frame.findCallerFrame(fiber.f_iCallerId);
                }
            }
            if (frame == null) {
                MethodStructure fnCaller = fiber.f_fnCaller;
                listFrames.add(new StackFrame(null, fnCaller, -1));
                break;
            }
            fiber = fiberCaller;
        }
        return listFrames.toArray(new StackFrame[0]);
    }

    public String[] getStackTraceArray() {
        Frame frame = this;
        Fiber fiber = frame.f_fiber;
        int iPC = this.m_iPC;
        if (this.f_fiber.getStatus() != Fiber.FiberStatus.Running) {
            --iPC;
        }
        ArrayList<String> listFrames = new ArrayList<String>(7);
        while (true) {
            listFrames.add(Frame.formatFrameDetails(frame.f_context, frame.f_function, iPC, frame.f_aOp, frame.f_framePrev));
            iPC = frame.f_iPCPrev;
            frame = frame.f_framePrev;
            if (frame != null) continue;
            Fiber fiberCaller = fiber.traceCaller();
            if (fiberCaller == null) break;
            frame = fiberCaller.getFrame();
            listFrames.add("    =========");
            if (frame != null) {
                if (fiberCaller.isWaiting()) {
                    frame = frame.f_framePrev;
                    iPC = frame.m_iPC;
                } else {
                    frame = frame.findCallerFrame(fiber.f_iCallerId);
                }
            }
            if (frame == null) {
                MethodStructure fnCaller = fiber.f_fnCaller;
                listFrames.add(Frame.formatFrameDetails(fiberCaller.f_context, fnCaller, -1, null, null));
                break;
            }
            fiber = fiberCaller;
        }
        return listFrames.toArray(Utils.NO_NAMES);
    }

    protected static String formatFrameDetails(ServiceContext ctx, MethodStructure function, int iPC, Op[] aOp, Frame framePrev) {
        StringBuilder sb = new StringBuilder("at ");
        if (function == null) {
            if (framePrev == null) {
                sb.append('^').append(ctx.f_sName);
                if (iPC < 0 && aOp != null && aOp.length > 0) {
                    sb.append(' ').append(aOp[0]);
                }
            } else {
                sb.append("synthetic call by ").append(framePrev);
                if (framePrev.m_iPC >= 0) {
                    sb.append(" at [").append(framePrev.m_iPC).append(']');
                }
            }
        } else {
            sb.append(function.getIdentityConstant().getPathString());
        }
        if (iPC >= 0) {
            int nLine = 0;
            if (function != null) {
                nLine = function.calculateLineNumber(iPC);
            }
            sb.append(" (");
            if (nLine > 0) {
                sb.append(function.getContainingClass().getSourceFileName()).append(':').append(nLine);
            } else {
                sb.append(aOp[iPC]);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public String toString() {
        return Frame.formatFrameDetails(this.f_context, this.f_function, this.m_iPC, this.f_aOp, this.f_framePrev);
    }

    public class VarInfo {
        private TypeConstant m_type;
        private int m_nTypeId;
        private int m_nStyle;
        private final int f_nNameId;
        private String m_sVarName;
        private VarTypeResolver m_resolver;
        private int m_nTargetId;
        private xRef.RefHandle m_ref;

        public VarInfo(TypeConstant type, int nStyle) {
            this(type, 0, nStyle);
        }

        public VarInfo(TypeConstant type, int nNameId, int nStyle) {
            this.m_type = type;
            this.m_nTypeId = type.getPosition();
            this.f_nNameId = nNameId;
            this.m_nStyle = nStyle;
        }

        public VarInfo(int nTargetId, int nAuxId, VarTypeResolver resolver) {
            this.m_nTargetId = nTargetId;
            this.m_nTypeId = nAuxId;
            this.f_nNameId = 0;
            this.m_nStyle = 0;
            this.m_resolver = resolver;
        }

        public String getName() {
            String sName = this.m_sVarName;
            if (sName == null) {
                this.m_sVarName = this.f_nNameId < 0 ? Frame.this.getString(this.f_nNameId) : "";
                sName = this.m_sVarName;
            }
            return sName;
        }

        protected void setName(String sName) {
            this.m_sVarName = sName;
        }

        public boolean isFixedType() {
            return (this.m_nStyle & 2) == 0;
        }

        public boolean isDynamicType() {
            return (this.m_nStyle & 2) == 2;
        }

        public TypeConstant getType() {
            TypeConstant type = this.m_type;
            if ((this.m_nStyle & 4) == 0) {
                if (type == null) {
                    assert (this.m_resolver != null);
                    type = this.m_resolver.resolve(Frame.this, this.m_nTargetId, this.m_nTypeId);
                }
                boolean fDynamic = type.containsDynamicType();
                type = type.resolveGenerics(Frame.this.poolContext(), Frame.this.getGenericsResolver(fDynamic));
                if (fDynamic) {
                    this.m_nStyle |= 2;
                } else {
                    this.m_type = type;
                    this.m_nTypeId = type.getPosition();
                    this.m_nStyle |= 4;
                }
            }
            return type;
        }

        public boolean isStandardVar() {
            return (this.m_nStyle & 1) == 0;
        }

        public boolean isDynamicVar() {
            return (this.m_nStyle & 1) == 1;
        }

        public boolean isFuture() {
            return (this.m_nStyle & 8) != 0;
        }

        public xRef.RefHandle getRef() {
            return this.m_ref;
        }

        public void setRef(xRef.RefHandle ref) {
            this.m_ref = ref;
        }

        public void release() {
            if (this.m_ref != null) {
                this.m_ref.dereference();
            }
        }

        public String toString() {
            return (this.isStandardVar() ? "" : "<dynamic> ") + this.getName();
        }
    }

    @FunctionalInterface
    public static interface Continuation {
        public int proceed(Frame var1);
    }

    public static abstract class Guard {
        protected final int f_nStartAddress;
        protected final int f_nScope;

        protected Guard(int nStartAddress, int nScope) {
            this.f_nStartAddress = nStartAddress;
            this.f_nScope = nScope;
        }

        public abstract int handleException(Frame var1, ObjectHandle.ExceptionHandle var2, int var3);

        protected void introduceValue(Frame frame, int iGuard, ObjectHandle hValue, String sVarName) {
            int nScope = this.f_nScope;
            frame.clearAllScopes(nScope - 1);
            frame.m_iScope = nScope;
            frame.m_iGuard = iGuard - 1;
            frame.f_anNextVar[nScope] = frame.f_anNextVar[nScope - 1];
            int n = nScope;
            int n2 = frame.f_anNextVar[n];
            frame.f_anNextVar[n] = n2 + 1;
            int nVar = n2;
            frame.introduceResolvedVar(nVar, hValue.getType(), sVarName, 0, hValue);
            frame.m_hException = null;
        }
    }

    public static abstract class DeferredGuardAction {
        private int m_ixGuard;
        private final int m_ixGuardBase;

        protected DeferredGuardAction(int ixGuard) {
            this(ixGuard, 0);
        }

        protected DeferredGuardAction(int ixGuardStart, int ixGuardBase) {
            assert (ixGuardStart >= ixGuardBase);
            this.m_ixGuard = ixGuardStart;
            this.m_ixGuardBase = ixGuardBase;
        }

        public abstract int complete(Frame var1);

        public int getGuardIndex() {
            return this.m_ixGuard;
        }

        public void setGuardIndex(int iGuard) {
            this.m_ixGuard = iGuard > this.m_ixGuardBase ? iGuard : -1;
        }
    }

    public static class AllGuard
    extends Guard {
        protected final int f_nFinallyStartAddress;

        public AllGuard(int nStartAddress, int nScope, int nFinallyStartOffset) {
            super(nStartAddress, nScope);
            this.f_nFinallyStartAddress = nStartAddress + nFinallyStartOffset;
        }

        @Override
        public int handleException(Frame frame, ObjectHandle.ExceptionHandle hException, int iGuard) {
            this.introduceValue(frame, iGuard, hException, "");
            return this.f_nFinallyStartAddress + 1;
        }

        protected int handleJump(Frame frame, int iGuard) {
            this.introduceValue(frame, iGuard, xNullable.NULL, "");
            return this.f_nFinallyStartAddress + 1;
        }
    }

    @FunctionalInterface
    public static interface VarTypeResolver {
        public TypeConstant resolve(Frame var1, int var2, int var3);
    }

    protected static class ContinuationChain
    implements Continuation {
        private final List<Continuation> f_list = new ArrayList<Continuation>();
        private int index = -1;

        public ContinuationChain(Continuation step0) {
            this.f_list.add(step0);
        }

        public void add(Continuation stepNext) {
            this.f_list.add(stepNext);
        }

        @Override
        public int proceed(Frame frameCaller) {
            block5: while (++this.index < this.f_list.size()) {
                int iResult = this.f_list.get(this.index).proceed(frameCaller);
                switch (iResult) {
                    case -1: {
                        continue block5;
                    }
                    case -5: {
                        Frame frameNext = frameCaller.m_frameNext;
                        Continuation contNext = frameNext.m_continuation;
                        if (contNext != null) {
                            this.f_list.set(this.index--, contNext);
                        }
                        frameNext.m_continuation = this;
                        return -5;
                    }
                    case -3: {
                        assert (frameCaller.m_hException != null);
                        return -3;
                    }
                }
                if (this.index + 1 == this.f_list.size()) {
                    return iResult;
                }
                throw new IllegalStateException();
            }
            return -1;
        }
    }

    public static class StackFrame {
        public Frame frame;
        public boolean boundary;
        public MethodStructure function;
        public int iPC;

        public StackFrame(Frame frame) {
            this(frame, frame.f_function, frame.m_iPC);
        }

        public StackFrame(Frame frame, MethodStructure function, int iPC) {
            this.frame = frame;
            this.function = function;
            this.iPC = iPC;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.boundary) {
                sb.append("^");
            }
            if (this.function == null) {
                ServiceContext ctx = this.frame.f_context;
                sb.append("Service #").append(ctx.f_lId).append(' ').append(ctx.f_sName);
                if (this.frame.f_aOp != null) {
                    sb.append(' ').append(this.frame.f_aOp[0]);
                }
            } else {
                this.buildShortName(this.function.getIdentityConstant(), sb, false);
                sb.append('(');
                sb.append(this.function.getContainingClass().getSourceFileName());
                if (this.iPC >= 0) {
                    int nLine = this.function.calculateLineNumber(this.iPC);
                    if (nLine > 0) {
                        sb.append(':').append(nLine);
                    } else {
                        sb.append(" iPC=").append(this.iPC);
                    }
                }
                sb.append(')');
            }
            return sb.toString();
        }

        private boolean buildShortName(IdentityConstant id, StringBuilder sb, boolean fHasName) {
            switch (id.getFormat()) {
                case Module: {
                    if (!fHasName) {
                        sb.append(((ModuleConstant)id).getUnqualifiedName());
                        return true;
                    }
                    return false;
                }
                case Package: {
                    if (!fHasName) {
                        sb.append(id.getName());
                        return true;
                    }
                    return false;
                }
                case Class: {
                    if (this.buildShortName(id.getParentConstant(), sb, true)) {
                        sb.append('.');
                    }
                    sb.append(id.getName());
                    return true;
                }
                case Property: 
                case Method: {
                    if (this.buildShortName(id.getParentConstant(), sb, false)) {
                        sb.append('.');
                    }
                    sb.append(id.getName());
                    return true;
                }
            }
            return this.buildShortName(id.getParentConstant(), sb, fHasName);
        }
    }

    public static class MultiGuard
    extends Guard {
        protected final int[] f_anClassConstId;
        protected final int[] f_anNameConstId;
        protected final int[] f_anCatchRelAddress;

        public MultiGuard(int nStartAddress, int nScope, int[] anClassConstId, int[] anNameConstId, int[] anCatchAddress) {
            super(nStartAddress, nScope);
            this.f_anClassConstId = anClassConstId;
            this.f_anNameConstId = anNameConstId;
            this.f_anCatchRelAddress = anCatchAddress;
        }

        @Override
        public int handleException(Frame frame, ObjectHandle.ExceptionHandle hException, int iGuard) {
            TypeConstant typeException = hException.getType();
            int c = this.f_anClassConstId.length;
            for (int iCatch = 0; iCatch < c; ++iCatch) {
                TypeConstant typeCatch = frame.resolveType(this.f_anClassConstId[iCatch]);
                if (!typeException.isA(typeCatch)) continue;
                this.introduceValue(frame, iGuard, hException, frame.getString(this.f_anNameConstId[iCatch]));
                return this.f_nStartAddress + this.f_anCatchRelAddress[iCatch];
            }
            return -3;
        }
    }
}

