/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.Map;
import java.util.Set;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Op;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Runtime;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.util.Auto;

public class MainContainer
extends Container {
    private Map<String, String> m_mapInjections;
    private int m_nResult = 1;

    public MainContainer(Runtime runtime, NativeContainer containerNative, ModuleConstant idModule) {
        super(runtime, containerNative, idModule);
    }

    @Override
    public ObjectHandle getInjectable(Frame frame, String sName, TypeConstant type, ObjectHandle hOpts) {
        ObjectHandle hResource;
        String sValue;
        if (this.m_mapInjections != null && (sValue = this.m_mapInjections.get(sName)) != null) {
            if (type.isNullable()) {
                type = type.removeNullable();
            }
            if (type.equals(frame.poolContext().typeString())) {
                return xString.makeHandle(sValue);
            }
        }
        return (hResource = this.f_parent.getInjectable(frame, sName, type, hOpts)) == null ? new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "Invalid resource: " + sName)) : this.maskInjection(frame, hResource, type);
    }

    private ObjectHandle maskInjection(Frame frame, ObjectHandle hResource, TypeConstant typeInject) {
        if (hResource instanceof ObjectHandle.DeferredCallHandle) {
            ObjectHandle.DeferredCallHandle hDeferred = (ObjectHandle.DeferredCallHandle)hResource;
            hDeferred.addContinuation(frameCaller -> {
                ObjectHandle hR = this.completeMasking(frameCaller, frameCaller.popStack(), typeInject);
                return Op.isDeferred(hR) ? -5 : frameCaller.pushStack(hR);
            });
            return hDeferred;
        }
        return this.completeMasking(frame, hResource, typeInject);
    }

    private ObjectHandle completeMasking(Frame frame, ObjectHandle hResource, TypeConstant typeInject) {
        TypeConstant typeResource = hResource.getComposition().getType();
        if (typeResource.isShared(this.getConstantPool())) {
            if (typeInject.isNullable()) {
                if (hResource == xNullable.NULL) {
                    return hResource;
                }
                typeInject = typeInject.removeNullable();
            }
            if (typeInject instanceof UnionTypeConstant) {
                UnionTypeConstant typeUnion = (UnionTypeConstant)typeInject;
                Set<TypeConstant> setMatch = typeUnion.collectExtended(typeResource, null);
                assert (setMatch.size() == 1);
                typeInject = setMatch.iterator().next();
            }
            if (!typeResource.equals(typeInject) && (hResource = hResource.maskAs(this, typeInject)) == null) {
                return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "Invalid resource type: " + typeResource.getValueString()));
            }
            return hResource;
        }
        return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "Injection type is not a shared: \"" + typeResource.getValueString() + "\""));
    }

    public void start(Map<String, String> mapInjections) {
        if (this.m_contextMain != null) {
            throw new IllegalStateException("Already started");
        }
        if (mapInjections != null && !mapInjections.isEmpty()) {
            this.m_mapInjections = mapInjections;
        }
        this.ensureServiceContext();
    }

    public void invoke0(String sMethodName, ObjectHandle ... ahArg) {
        try (Auto ignore = ConstantPool.withPool(this.f_idModule.getConstantPool());){
            MethodConstant idMethod = this.findModuleMethod(sMethodName, ahArg);
            if (idMethod == null) {
                System.err.println("Missing: " + sMethodName + " method for " + this.f_idModule.getValueString());
                return;
            }
            TypeConstant typeModule = this.f_idModule.getType();
            TypeComposition clzModule = this.resolveClass(typeModule);
            SignatureConstant sigMethod = idMethod.getSignature();
            CallChain chain = clzModule.getMethodCallChain(sigMethod);
            boolean fReturn = sigMethod.getReturnCount() > 0;
            xRTFunction.NativeFunctionHandle hInstantiateModuleAndRun = new xRTFunction.NativeFunctionHandle((frame, ah, iRet) -> {
                SingletonConstant idModule = frame.poolContext().ensureSingletonConstConstant(this.f_idModule);
                ObjectHandle hModule = frame.getConstHandle(idModule);
                int iReturn = fReturn ? -1 : -2;
                int iResult = Op.isDeferred(hModule) ? hModule.proceed(frame, frameCaller -> chain.invoke(frameCaller, frameCaller.popStack(), ahArg, iReturn)) : chain.invoke(frame, hModule, ahArg, iReturn);
                switch (iResult) {
                    case -1: {
                        this.setResult(fReturn ? frame.popStack() : null);
                        break;
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> {
                            this.setResult(fReturn ? frameCaller.popStack() : null);
                            return -1;
                        });
                        break;
                    }
                    case -3: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return iResult;
            });
            this.m_contextMain.callLater(hInstantiateModuleAndRun, Utils.OBJECTS_NONE);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to run: " + String.valueOf(this.f_idModule) + ". Cause: " + e.getMessage());
        }
    }

    private void setResult(ObjectHandle hReturn) {
        int n;
        if (hReturn instanceof ObjectHandle.JavaLong) {
            ObjectHandle.JavaLong hLong = (ObjectHandle.JavaLong)hReturn;
            n = (int)hLong.getValue();
        } else {
            n = 0;
        }
        this.m_nResult = n;
    }

    public int getResult() {
        return this.m_nResult;
    }
}

