/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.FileStructure;
import org.xvm.asm.InjectionKey;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.InjectionSupplier;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Runtime;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.crypto.xRTAlgorithms;
import org.xvm.runtime.template._native.crypto.xRTCertificateManager;
import org.xvm.runtime.template._native.crypto.xRTKeyStore;
import org.xvm.runtime.template._native.io.xTerminalConsole;
import org.xvm.runtime.template._native.lang.src.xRTCompiler;
import org.xvm.runtime.template._native.mgmt.xContainerLinker;
import org.xvm.runtime.template._native.mgmt.xCoreRepository;
import org.xvm.runtime.template._native.net.xRTNetwork;
import org.xvm.runtime.template._native.numbers.xRTRandom;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template._native.temporal.xLocalClock;
import org.xvm.runtime.template._native.temporal.xNanosTimer;
import org.xvm.runtime.template._native.web.xRTConnector;
import org.xvm.runtime.template._native.web.xRTServer;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.reflect.xInjector;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xObject;
import org.xvm.runtime.template.xService;
import org.xvm.util.Auto;
import org.xvm.util.Handy;

public class NativeContainer
extends Container {
    private static final String ECSTASY_MODULE = "ecstasy.xtclang.org";
    private static final String TURTLE_MODULE = "mack.xtclang.org";
    private static final String NATIVE_MODULE = "_native.xtclang.org";
    private static final String TURTLE_PREFIX = "mack.";
    private static final int TURTLE_LENGTH = "mack.".length();
    private static final String NATIVE_PREFIX = "_native.";
    private static final int NATIVE_LENGTH = "_native.".length();
    private ObjectHandle m_hOSStorage;
    private ObjectHandle m_hFileStore;
    private ObjectHandle m_hRootDir;
    private ObjectHandle m_hHomeDir;
    private ObjectHandle m_hCurDir;
    private ObjectHandle m_hTmpDir;
    private ObjectHandle m_hProperties;
    private ObjectHandle m_hSecureNetwork;
    private ObjectHandle m_hInsecureNetwork;
    private final ModuleRepository f_repository;
    private ModuleStructure m_moduleSystem;
    private ModuleStructure m_moduleTurtle;
    private ModuleStructure m_moduleNative;
    private final Map<String, IdentityConstant> f_mapIdByName = new ConcurrentHashMap<String, IdentityConstant>();
    private final Map<String, InjectionKey> f_mapResourceNames = new HashMap<String, InjectionKey>();
    private final Map<InjectionKey, InjectionSupplier> f_mapResources = new HashMap<InjectionKey, InjectionSupplier>();

    public NativeContainer(Runtime runtime, ModuleRepository repository) {
        super(runtime, null, null);
        this.f_repository = repository;
        ConstantPool pool = this.loadNativeTemplates();
        try (Auto ignore = ConstantPool.withPool(pool);){
            this.initResources(pool);
        }
    }

    private ConstantPool loadNativeTemplates() {
        ModuleStructure moduleRoot = this.f_repository.loadModule(ECSTASY_MODULE);
        ModuleStructure moduleTurtle = this.f_repository.loadModule(TURTLE_MODULE);
        ModuleStructure moduleNative = this.f_repository.loadModule(NATIVE_MODULE);
        if (moduleRoot == null || moduleTurtle == null || moduleNative == null) {
            throw new IllegalStateException("Native libraries are missing");
        }
        FileStructure fileRoot = new FileStructure(moduleRoot, true);
        fileRoot.merge(moduleTurtle, true, false);
        fileRoot.merge(moduleNative, true, false);
        fileRoot.linkModules(this.f_repository, true);
        this.m_moduleSystem = fileRoot.getChild(ECSTASY_MODULE);
        this.m_moduleTurtle = fileRoot.getChild(TURTLE_MODULE);
        this.m_moduleNative = fileRoot.getChild(NATIVE_MODULE);
        ConstantPool pool = fileRoot.getConstantPool();
        ConstantPool.setCurrentPool(pool);
        if (pool.getNakedRefType() == null) {
            ClassStructure clzNakedRef = (ClassStructure)this.m_moduleTurtle.getChild("NakedRef");
            pool.setNakedRefType(clzNakedRef.getFormalType());
        }
        String sRoot = xObject.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        sRoot = URLDecoder.decode(sRoot, StandardCharsets.UTF_8);
        HashMap<String, Class> mapTemplateClasses = new HashMap<String, Class>();
        if (sRoot.endsWith(".jar")) {
            this.scanNativeJarDirectory(sRoot, "org/xvm/runtime/template", mapTemplateClasses);
        } else {
            File dirTemplates = new File(sRoot, "org/xvm/runtime/template");
            this.scanNativeDirectory(dirTemplates, "", mapTemplateClasses);
        }
        this.storeNativeTemplate(new xObject(this, this.getClassStructure("Object"), true));
        this.storeNativeTemplate(new xEnum(this, this.getClassStructure("Enum"), true));
        this.storeNativeTemplate(new xConst(this, this.getClassStructure("Const"), true));
        this.storeNativeTemplate(new xService(this, this.getClassStructure("Service"), true));
        for (Map.Entry entry : mapTemplateClasses.entrySet()) {
            Class clz;
            ClassStructure structClass = this.getClassStructure((String)entry.getKey());
            if (structClass == null || this.f_mapTemplatesByType.containsKey(structClass.getIdentityConstant().getType()) || Modifier.isAbstract((clz = (Class)entry.getValue()).getModifiers())) continue;
            try {
                this.storeNativeTemplate((ClassTemplate)clz.getConstructor(Container.class, ClassStructure.class, Boolean.TYPE).newInstance(this, structClass, Boolean.TRUE));
            }
            catch (Exception e) {
                throw new RuntimeException("Constructor failed for " + clz.getName(), e);
            }
        }
        this.f_mapTemplatesByType.put(pool.typeFunction(), xRTFunction.INSTANCE);
        this.f_mapTemplatesByType.put(pool.typeType(), xRTType.INSTANCE);
        HashSet setTemplates = new HashSet(this.f_mapTemplatesByType.values());
        for (ClassTemplate template : setTemplates) {
            template.registerNativeTemplates();
        }
        Utils.initNative(this);
        for (ClassTemplate template : this.f_mapTemplatesByType.values()) {
            template.initNative();
        }
        this.ensureServiceContext();
        ConstantPool.setCurrentPool(null);
        return pool;
    }

    private void scanNativeJarDirectory(String sJarFile, String sPackage, Map<String, Class> mapTemplateClasses) {
        try (JarFile jf = new JarFile(sJarFile);){
            jf.stream().filter(entry -> NativeContainer.isNativeClass(sPackage, entry.getName())).forEach(entry -> mapTemplateClasses.put(NativeContainer.componentName(entry.getName()), NativeContainer.classForName(entry.getName())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isNativeClass(String sPackage, String sFile) {
        return sFile.startsWith(sPackage) && sFile.endsWith(".class") && sFile.indexOf(36) < 0 && sFile.charAt(sFile.lastIndexOf(47) + 1) == 'x';
    }

    private static String componentName(String sFile) {
        String[] parts = Handy.parseDelimitedString(sFile, '/');
        StringBuilder sb = new StringBuilder();
        int c = parts.length - 1;
        for (int i = 4; i < c; ++i) {
            sb.append(parts[i]).append('.');
        }
        String sClass = parts[parts.length - 1];
        assert (sClass.charAt(0) == 'x');
        assert (sClass.endsWith(".class"));
        sb.append(sClass, 1, sClass.indexOf(46));
        return sb.toString();
    }

    private static Class classForName(String sFile) {
        assert (sFile.endsWith(".class"));
        String sClz = sFile.substring(0, sFile.length() - ".class".length()).replace('/', '.');
        try {
            return Class.forName(sClz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void scanNativeDirectory(File dirNative, String sPackage, Map<String, Class> mapTemplateClasses) {
        for (String sName : dirNative.list()) {
            if (sName.endsWith(".class")) {
                if (!sName.startsWith("x") || sName.contains("$")) continue;
                String sSimpleName = sName.substring(1, sName.length() - 6);
                String sQualifiedName = sPackage + sSimpleName;
                String sClass = "org.xvm.runtime.template." + sPackage + "x" + sSimpleName;
                try {
                    mapTemplateClasses.put(sQualifiedName, Class.forName(sClass));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot load " + sClass, e);
                }
            }
            File dir = new File(dirNative, sName);
            if (!dir.isDirectory()) continue;
            this.scanNativeDirectory(dir, sPackage.isEmpty() ? sName + "." : sPackage + sName + ".", mapTemplateClasses);
        }
    }

    private void storeNativeTemplate(ClassTemplate template) {
        TypeConstant typeBase = template.getClassConstant().getType();
        this.registerNativeTemplate(typeBase, template);
    }

    private void initResources(ConstantPool pool) {
        xLocalClock templateClock = xLocalClock.INSTANCE;
        TypeConstant typeClock = templateClock.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("clock", typeClock), templateClock::ensureDefaultClock);
        this.addResourceSupplier(new InjectionKey("localClock", typeClock), templateClock::ensureLocalClock);
        this.addResourceSupplier(new InjectionKey("utcClock", typeClock), templateClock::ensureUTCClock);
        xNanosTimer templateTimer = xNanosTimer.INSTANCE;
        TypeConstant typeTimer = templateTimer.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("timer", typeTimer), templateTimer::ensureTimer);
        xTerminalConsole templateConsole = xTerminalConsole.INSTANCE;
        TypeConstant typeConsole = templateConsole.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("console", typeConsole), templateConsole::ensureConsole);
        xRTRandom templateRandom = xRTRandom.INSTANCE;
        TypeConstant typeRandom = templateRandom.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("rnd", typeRandom), templateRandom::ensureDefaultRandom);
        this.addResourceSupplier(new InjectionKey("random", typeRandom), templateRandom::ensureDefaultRandom);
        TypeConstant typeFileStore = pool.ensureEcstasyTypeConstant("fs.FileStore");
        TypeConstant typeDirectory = pool.ensureEcstasyTypeConstant("fs.Directory");
        this.addResourceSupplier(new InjectionKey("storage", typeFileStore), this::ensureFileStore);
        this.addResourceSupplier(new InjectionKey("rootDir", typeDirectory), this::ensureRootDir);
        this.addResourceSupplier(new InjectionKey("homeDir", typeDirectory), this::ensureHomeDir);
        this.addResourceSupplier(new InjectionKey("curDir", typeDirectory), this::ensureCurDir);
        this.addResourceSupplier(new InjectionKey("tmpDir", typeDirectory), this::ensureTmpDir);
        xRTNetwork templateNetwork = xRTNetwork.INSTANCE;
        TypeConstant typeNetwork = templateNetwork.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("network", typeNetwork), this::ensureInsecureNetwork);
        this.addResourceSupplier(new InjectionKey("insecureNetwork", typeNetwork), this::ensureInsecureNetwork);
        this.addResourceSupplier(new InjectionKey("secureNetwork", typeNetwork), this::ensureSecureNetwork);
        xRTKeyStore templateKeyStore = xRTKeyStore.INSTANCE;
        TypeConstant typeKeyStore = templateKeyStore.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("keystore", typeKeyStore), templateKeyStore::ensureKeyStore);
        xRTCertificateManager templateCertManager = xRTCertificateManager.INSTANCE;
        TypeConstant typeCertManager = templateCertManager.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("manager", typeCertManager), templateCertManager::ensureManager);
        xRTAlgorithms templateAlgorithms = xRTAlgorithms.INSTANCE;
        TypeConstant typeAlgorithms = pool.ensureTerminalTypeConstant(pool.ensureClassConstant(pool.ensureModuleConstant("crypto.xtclang.org"), "Algorithms"));
        this.addResourceSupplier(new InjectionKey("algorithms", typeAlgorithms), templateAlgorithms::ensureAlgorithms);
        xRTConnector templateConnector = xRTConnector.INSTANCE;
        TypeConstant typeConnector = templateConnector.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("connector", typeConnector), templateConnector::ensureConnector);
        xRTServer templateServer = xRTServer.INSTANCE;
        TypeConstant typeServer = templateServer.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("server", typeServer), templateServer::ensureServer);
        xContainerLinker templateLinker = xContainerLinker.INSTANCE;
        TypeConstant typeLinker = templateLinker.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("linker", typeLinker), templateLinker::ensureLinker);
        xCoreRepository templateRepo = xCoreRepository.INSTANCE;
        TypeConstant typeRepo = templateRepo.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("repository", typeRepo), templateRepo::ensureModuleRepository);
        xRTCompiler templateCompiler = xRTCompiler.INSTANCE;
        TypeConstant typeCompiler = templateCompiler.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("compiler", typeCompiler), templateCompiler::ensureCompiler);
        xInjector templateInjector = xInjector.INSTANCE;
        TypeConstant typeInjector = templateInjector.getCanonicalType();
        this.addResourceSupplier(new InjectionKey("injector", typeInjector), templateInjector::ensureInjector);
        TypeConstant typeProps = pool.ensureMapType(pool.typeString(), pool.typeString());
        this.addResourceSupplier(new InjectionKey("properties", typeProps), this::ensureProperties);
    }

    private void addResourceSupplier(InjectionKey key, InjectionSupplier supplier) {
        assert (!this.f_mapResources.containsKey(key));
        this.f_mapResources.put(key, supplier);
        this.f_mapResourceNames.put(key.f_sName, key);
    }

    public ObjectHandle ensureOSStorage(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hStorage = this.m_hOSStorage;
        if (hStorage == null) {
            ClassTemplate template = this.getTemplate("_native.fs.OSStorage");
            ClassComposition clzStorage = template.getCanonicalClass();
            MethodStructure constructor = template.getStructure().findConstructor(new TypeConstant[0]);
            ServiceContext contextNew = this.createServiceContext("OSStorage");
            switch (contextNew.sendConstructRequest(frame, clzStorage, constructor, null, Utils.OBJECTS_NONE, -1)) {
                case -1: {
                    hStorage = frame.popStack();
                    break;
                }
                case -3: {
                    break;
                }
                case -5: {
                    Frame frameNext = frame.m_frameNext;
                    frameNext.addContinuation(frameCaller -> {
                        this.m_hOSStorage = frameCaller.peekStack();
                        return -1;
                    });
                    return new ObjectHandle.DeferredCallHandle(frameNext);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.m_hOSStorage = hStorage;
        }
        return hStorage;
    }

    private ObjectHandle ensureFileStore(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hStore = this.m_hFileStore;
        if (hStore == null) {
            ClassTemplate template = this.getTemplate("_native.fs.OSStorage");
            PropertyConstant idProp = template.getCanonicalType().ensureTypeInfo().findProperty("store").getIdentity();
            return this.getProperty(frame, this.ensureOSStorage(frame, hOpts), idProp, h -> {
                this.m_hFileStore = h;
            });
        }
        return hStore;
    }

    private ObjectHandle ensureRootDir(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hDir = this.m_hRootDir;
        if (hDir == null) {
            ClassTemplate template = this.getTemplate("_native.fs.OSStorage");
            PropertyConstant idProp = template.getCanonicalType().ensureTypeInfo().findProperty("rootDir").getIdentity();
            return this.getProperty(frame, this.ensureOSStorage(frame, hOpts), idProp, h -> {
                this.m_hRootDir = h;
            });
        }
        return hDir;
    }

    private ObjectHandle ensureHomeDir(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hDir = this.m_hHomeDir;
        if (hDir == null) {
            ClassTemplate template = this.getTemplate("_native.fs.OSStorage");
            PropertyConstant idProp = template.getCanonicalType().ensureTypeInfo().findProperty("homeDir").getIdentity();
            return this.getProperty(frame, this.ensureOSStorage(frame, hOpts), idProp, h -> {
                this.m_hHomeDir = h;
            });
        }
        return hDir;
    }

    private ObjectHandle ensureCurDir(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hDir = this.m_hCurDir;
        if (hDir == null) {
            ClassTemplate template = this.getTemplate("_native.fs.OSStorage");
            PropertyConstant idProp = template.getCanonicalType().ensureTypeInfo().findProperty("curDir").getIdentity();
            return this.getProperty(frame, this.ensureOSStorage(frame, hOpts), idProp, h -> {
                this.m_hCurDir = h;
            });
        }
        return hDir;
    }

    private ObjectHandle ensureTmpDir(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hDir = this.m_hTmpDir;
        if (hDir == null) {
            ClassTemplate template = this.getTemplate("_native.fs.OSStorage");
            PropertyConstant idProp = template.getCanonicalType().ensureTypeInfo().findProperty("tmpDir").getIdentity();
            return this.getProperty(frame, this.ensureOSStorage(frame, hOpts), idProp, h -> {
                this.m_hTmpDir = h;
            });
        }
        return hDir;
    }

    private ObjectHandle ensureProperties(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hProps = this.m_hProperties;
        if (hProps == null) {
            ArrayList<xString.StringHandle> listKeys = new ArrayList<xString.StringHandle>();
            ArrayList<xString.StringHandle> listVals = new ArrayList<xString.StringHandle>();
            for (String string : System.getProperties().keySet()) {
                String sVal;
                if (!string.startsWith("xvm.") || (sVal = System.getProperty(string)) == null) continue;
                listKeys.add(xString.makeHandle(string.substring(4)));
                listVals.add(xString.makeHandle(sVal));
            }
            xArray.ArrayHandle haKeys = xArray.makeStringArrayHandle(listKeys.toArray(Utils.STRINGS_NONE));
            xArray.ArrayHandle arrayHandle = xArray.makeStringArrayHandle(listVals.toArray(Utils.STRINGS_NONE));
            ConstantPool pool = this.getConstantPool();
            TypeConstant typeReveal = pool.ensureMapType(pool.typeString(), pool.typeString());
            TypeConstant typeActual = pool.ensureParameterizedTypeConstant(pool.ensureEcstasyTypeConstant("maps.ListMap"), pool.typeString(), pool.typeString());
            switch (Utils.constructListMap(frame, this.resolveClass(typeActual), haKeys, arrayHandle, -1)) {
                case -1: {
                    hProps = frame.popStack().maskAs(this, typeReveal);
                    break;
                }
                case -3: {
                    break;
                }
                case -5: {
                    Frame frameNext = frame.m_frameNext;
                    frameNext.addContinuation(frameCaller -> {
                        this.m_hProperties = frameCaller.peekStack().maskAs(this, typeReveal);
                        return frameCaller.pushStack(this.m_hProperties);
                    });
                    return new ObjectHandle.DeferredCallHandle(frameNext);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.m_hProperties = hProps;
        }
        return hProps;
    }

    private ObjectHandle getProperty(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, Consumer<ObjectHandle> consumer) {
        TypeConstant typeRevealed = idProp.getType();
        if (hTarget instanceof ObjectHandle.DeferredCallHandle) {
            ObjectHandle.DeferredCallHandle hDeferred = (ObjectHandle.DeferredCallHandle)hTarget;
            hDeferred.addContinuation(frameCaller -> {
                ObjectHandle hTargetReal = frameCaller.popStack();
                int iResult = hTargetReal.getTemplate().getPropertyValue(frameCaller, hTargetReal, idProp, -1);
                switch (iResult) {
                    case -1: {
                        ObjectHandle h = frameCaller.popStack().maskAs(this, typeRevealed);
                        frameCaller.pushStack(h);
                        consumer.accept(h);
                        break;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(frameCaller1 -> {
                            ObjectHandle h = frameCaller1.popStack().maskAs(this, typeRevealed);
                            consumer.accept(h);
                            return frameCaller1.pushStack(h);
                        });
                    }
                }
                return iResult;
            });
            return hTarget;
        }
        ClassTemplate template = hTarget.getTemplate();
        switch (template.getPropertyValue(frame, hTarget, idProp, -1)) {
            case -1: {
                ObjectHandle h = frame.popStack().maskAs(this, typeRevealed);
                consumer.accept(h);
                return h;
            }
            case -5: {
                Frame frameNext = frame.m_frameNext;
                frameNext.addContinuation(frameCaller -> {
                    ObjectHandle h = frameCaller.popStack().maskAs(this, typeRevealed);
                    consumer.accept(h);
                    return frameCaller.pushStack(h);
                });
                return new ObjectHandle.DeferredCallHandle(frameNext);
            }
            case -3: {
                return new ObjectHandle.DeferredCallHandle(frame.clearException());
            }
        }
        throw new IllegalStateException();
    }

    public ObjectHandle ensureSecureNetwork(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hNetwork = this.m_hSecureNetwork;
        if (hNetwork == null) {
            this.m_hSecureNetwork = hNetwork = this.instantiateNetwork(frame, hOpts, true);
        }
        return hNetwork;
    }

    public ObjectHandle ensureInsecureNetwork(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hNetwork = this.m_hInsecureNetwork;
        if (hNetwork == null) {
            this.m_hInsecureNetwork = hNetwork = this.instantiateNetwork(frame, hOpts, false);
        }
        return hNetwork;
    }

    protected ObjectHandle instantiateNetwork(Frame frame, ObjectHandle hOpts, boolean fSecure) {
        ObjectHandle hNetwork = null;
        ClassTemplate templateNetwork = this.getTemplate(this.getIdentityConstant("_native.net.RTNetwork"));
        ClassComposition clzMask = templateNetwork.getCanonicalClass();
        ConstantPool pool = this.getConstantPool();
        MethodStructure constructor = templateNetwork.getStructure().findConstructor(pool.typeBoolean());
        ObjectHandle[] ahParams = new ObjectHandle[]{xBoolean.makeHandle(fSecure)};
        switch (templateNetwork.construct(frame, constructor, clzMask, null, ahParams, -1)) {
            case -1: {
                hNetwork = frame.popStack();
                break;
            }
            case -3: {
                break;
            }
            case -5: {
                Frame frameNext = frame.m_frameNext;
                frameNext.addContinuation(frameCaller -> {
                    if (fSecure) {
                        this.m_hSecureNetwork = frameCaller.peekStack();
                    } else {
                        this.m_hInsecureNetwork = frameCaller.peekStack();
                    }
                    return -1;
                });
                return new ObjectHandle.DeferredCallHandle(frameNext);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return hNetwork;
    }

    @Override
    public ModuleConstant getModule() {
        return this.m_moduleSystem.getIdentityConstant();
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.m_moduleNative.getConstantPool();
    }

    @Override
    public ObjectHandle getInjectable(Frame frame, String sName, TypeConstant type, ObjectHandle hOpts) {
        InjectionKey key = this.f_mapResourceNames.get(sName);
        if (key == null) {
            return type.isNullable() ? xNullable.NULL : null;
        }
        TypeConstant typeResource = key.f_type;
        return typeResource.equals(type) || typeResource.isA(type) && type.isA(typeResource) ? this.f_mapResources.get(key).supply(frame, hOpts) : null;
    }

    @Override
    public Container getOriginContainer(SingletonConstant constSingle) {
        return this;
    }

    @Override
    public ClassTemplate getTemplate(String sName) {
        return this.getTemplate(this.getIdentityConstant(sName));
    }

    @Override
    public ClassStructure getClassStructure(String sName) {
        Component component;
        Component component2 = sName.startsWith(NATIVE_PREFIX) ? this.m_moduleNative.getChildByPath(sName.substring(NATIVE_LENGTH)) : (component = sName.startsWith(TURTLE_PREFIX) ? this.m_moduleTurtle.getChildByPath(sName.substring(TURTLE_LENGTH)) : this.m_moduleSystem.getChildByPath(sName));
        while (component instanceof TypedefStructure) {
            TypedefStructure typedef = (TypedefStructure)component;
            component = typedef.getType().getSingleUnderlyingClass(true).getComponent();
        }
        return (ClassStructure)component;
    }

    @Override
    public ModuleRepository getModuleRepository() {
        return this.f_repository;
    }

    @Override
    public FileStructure createFileStructure(ModuleStructure moduleApp) {
        FileStructure fileApp = new FileStructure(this.m_moduleSystem, false);
        fileApp.merge(this.m_moduleTurtle, false, false);
        fileApp.merge(this.f_repository.loadModule("crypto.xtclang.org"), true, false);
        fileApp.merge(this.f_repository.loadModule("net.xtclang.org"), true, false);
        fileApp.merge(this.f_repository.loadModule("web.xtclang.org"), true, false);
        fileApp.merge(this.m_moduleNative, false, false);
        fileApp.merge(moduleApp, true, true);
        assert (fileApp.validateConstants());
        return fileApp;
    }

    protected void registerNativeTemplate(TypeConstant type, ClassTemplate template) {
        this.f_mapTemplatesByType.putIfAbsent(type, template);
    }

    protected TypeConstant getConstType(Constant constValue) {
        String sComponent;
        switch (constValue.getFormat()) {
            case Char: 
            case String: 
            case Bit: 
            case Nibble: 
            case IntLiteral: 
            case FPLiteral: 
            case Int8: 
            case UInt8: 
            case Int16: 
            case UInt16: 
            case Int32: 
            case UInt32: 
            case Int64: 
            case UInt64: 
            case Int128: 
            case UInt128: 
            case IntN: 
            case UIntN: 
            case BFloat16: 
            case Float16: 
            case Float32: 
            case Float64: 
            case Float128: 
            case FloatN: 
            case Dec32: 
            case Dec64: 
            case Dec128: 
            case DecN: 
            case Array: 
            case UInt8Array: 
            case Date: 
            case TimeOfDay: 
            case Time: 
            case Duration: 
            case Range: 
            case Path: 
            case Version: 
            case RegEx: 
            case Module: 
            case Package: 
            case Tuple: 
            case SingletonConst: {
                return constValue.getType();
            }
            case FileStore: {
                sComponent = "_native.fs.CPFileStore";
                break;
            }
            case FSDir: {
                sComponent = "_native.fs.CPDirectory";
                break;
            }
            case FSFile: {
                sComponent = "_native.fs.CPFile";
                break;
            }
            case Map: {
                sComponent = "maps.ListMap";
                break;
            }
            case Set: {
                sComponent = "collections.Array";
                break;
            }
            case MapEntry: {
                throw new UnsupportedOperationException("TODO: " + String.valueOf(constValue));
            }
            case Class: 
            case DecoratedClass: 
            case NativeClass: {
                sComponent = "reflect.Class";
                break;
            }
            case PropertyClassType: {
                sComponent = "_native.reflect.RTProperty";
                break;
            }
            case AnnotatedType: 
            case ParameterizedType: 
            case ImmutableType: 
            case AccessType: 
            case TerminalType: 
            case UnionType: 
            case IntersectionType: 
            case DifferenceType: {
                sComponent = "_native.reflect.RTType";
                break;
            }
            case Method: {
                sComponent = ((MethodConstant)constValue).isFunction() ? "_native.reflect.RTFunction" : "_native.reflect.RTMethod";
                break;
            }
            default: {
                throw new IllegalStateException(constValue.toString());
            }
        }
        return this.getClassStructure(sComponent).getIdentityConstant().getType();
    }

    private IdentityConstant getIdentityConstant(String sName) {
        try {
            return this.f_mapIdByName.computeIfAbsent(sName, s -> this.getClassStructure((String)s).getIdentityConstant());
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Missing constant: " + sName);
        }
    }

    @Override
    public String toString() {
        return "Primordial container";
    }
}

