/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.InjectionKey;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.InjectionSupplier;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;

public class NestedContainer
extends Container {
    public final ObjectHandle f_hProvider;
    private final List<ModuleConstant> f_listShared;
    private final Map<InjectionKey, InjectionSupplier> f_mapResources = new HashMap<InjectionKey, InjectionSupplier>();

    public NestedContainer(Container containerParent, ModuleConstant idModule, ObjectHandle hProvider, List<ModuleConstant> listShared) {
        super(containerParent.f_runtime, containerParent, idModule);
        this.f_hProvider = hProvider;
        this.f_listShared = listShared;
    }

    public Set<InjectionKey> collectInjections() {
        ModuleStructure module = (ModuleStructure)this.getModule().getComponent();
        HashSet<InjectionKey> setInjections = new HashSet<InjectionKey>();
        module.getFileStructure().visitChildren(component -> component.collectInjections(setInjections), false, true);
        return setInjections;
    }

    public void addResourceSupplier(InjectionKey key, xService.ServiceHandle hService, ObjectHandle hSupplier) {
        if (hSupplier instanceof xRTFunction.FunctionHandle) {
            xRTFunction.FunctionHandle hFunction = (xRTFunction.FunctionHandle)hSupplier;
            xRTFunction.FunctionHandle hProxy = xRTFunction.makeAsyncDelegatingHandle(hService, hFunction);
            this.f_mapResources.put(key, (frame, hOpts) -> {
                ObjectHandle[] ahArg = new ObjectHandle[hProxy.getParamCount()];
                ahArg[0] = hOpts == ObjectHandle.DEFAULT ? xNullable.NULL : hOpts;
                switch (hProxy.call1(frame, null, ahArg, -1)) {
                    case -1: {
                        return this.validateResource(frame, frame.popStack());
                    }
                    case -5: {
                        ObjectHandle.DeferredCallHandle hDeferred = new ObjectHandle.DeferredCallHandle(frame.m_frameNext);
                        hDeferred.addContinuation(frameCaller -> {
                            ObjectHandle hR = this.validateResource(frameCaller, frameCaller.popStack());
                            return Op.isDeferred(hR) ? hR.proceed(frameCaller, null) : frameCaller.pushStack(hR);
                        });
                        return hDeferred;
                    }
                    case -3: {
                        return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "Invalid resource: " + String.valueOf(key), frame.m_hException));
                    }
                }
                throw new IllegalStateException();
            });
        } else {
            this.f_mapResources.put(key, (frame, hOpts) -> this.validateResource(frame, hSupplier));
        }
    }

    private ObjectHandle validateResource(Frame frame, ObjectHandle hResource) {
        TypeConstant typeResource = hResource.getComposition().getType();
        if (!hResource.isPassThrough(this)) {
            return new ObjectHandle.DeferredCallHandle(xException.mutableObject(frame, typeResource));
        }
        if (!typeResource.isShared(this.getConstantPool())) {
            return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "Injection type is not a shared: \"" + typeResource.getValueString() + "\""));
        }
        return hResource;
    }

    @Override
    public ObjectHandle getInjectable(Frame frame, String sName, TypeConstant type, ObjectHandle hOpts) {
        InjectionSupplier supplier = this.f_mapResources.get(new InjectionKey(sName, type));
        return supplier == null ? null : supplier.supply(frame, hOpts);
    }

    @Override
    public boolean isShared(ModuleConstant idModule) {
        return super.isShared(idModule) || this.f_listShared.contains(idModule);
    }
}

