/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.xvm.asm.Constant;
import org.xvm.asm.Constants;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.OpSupport;
import org.xvm.runtime.ProxyComposition;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.Proxy;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.text.xChar;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xObject;
import org.xvm.runtime.template.xService;
import org.xvm.util.Handy;

public abstract class ObjectHandle
implements Cloneable {
    protected TypeComposition m_clazz;
    protected boolean m_fMutable;
    public static final ObjectHandle DEFAULT = new ObjectHandle(null){

        @Override
        public TypeConstant getType() {
            return null;
        }

        @Override
        public String toString() {
            return "<default>";
        }
    };

    protected ObjectHandle(TypeComposition clazz) {
        this.m_clazz = clazz;
        this.m_fMutable = false;
    }

    public ObjectHandle cloneAs(TypeComposition clazz) {
        try {
            ObjectHandle handle = (ObjectHandle)super.clone();
            handle.m_clazz = clazz;
            return handle;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public ObjectHandle revealOrigin() {
        return this.getComposition().ensureOrigin(this);
    }

    public boolean isMutable() {
        return this.m_fMutable;
    }

    public boolean makeImmutable() {
        this.m_fMutable = false;
        return true;
    }

    public List<String> validateFields() {
        return null;
    }

    public boolean isSelfContained() {
        return false;
    }

    public TypeComposition getComposition() {
        return this.m_clazz;
    }

    public ClassTemplate getTemplate() {
        return this.getComposition().getTemplate();
    }

    public OpSupport getOpSupport() {
        return this.getComposition().getSupport();
    }

    public TypeConstant getType() {
        return this.augmentType(this.getComposition().getType());
    }

    protected TypeConstant augmentType(TypeConstant type) {
        if (!this.isMutable()) {
            type = type.freeze();
        }
        if (this.isService()) {
            type = type.ensureService();
        }
        return type;
    }

    public TypeConstant getUnsafeType() {
        return this.getType();
    }

    public ObjectHandle ensureAccess(Constants.Access access) {
        return this.getComposition().ensureAccess(this, access);
    }

    public boolean isInflated(PropertyConstant idProp) {
        ClassComposition.FieldInfo field = this.getComposition().getFieldInfo(idProp);
        return field != null && field.isInflated();
    }

    public boolean isInjected(PropertyConstant idProp) {
        return this.getComposition().isInjected(idProp);
    }

    public boolean isAtomic(PropertyConstant idProp) {
        return this.getComposition().isAtomic(idProp);
    }

    public boolean isPassThrough() {
        return this.isPassThrough(null);
    }

    public boolean isPassThrough(Container container) {
        if (this.isService()) {
            return true;
        }
        if (this.isMutable()) {
            return false;
        }
        if (container == null) {
            return true;
        }
        return this.isShared(container, null);
    }

    public boolean isShared(Container container, Map<ObjectHandle, Boolean> mapVisited) {
        return true;
    }

    protected static boolean areShared(ObjectHandle[] ahValue, Container container, Map<ObjectHandle, Boolean> mapVisited) {
        for (ObjectHandle field : ahValue) {
            if (field == null || field.isShared(container, mapVisited)) continue;
            return false;
        }
        return true;
    }

    public boolean isService() {
        return false;
    }

    public xService.ServiceHandle getService() {
        return null;
    }

    public boolean isStruct() {
        return this.getComposition().isStruct();
    }

    public boolean isNativeEqual() {
        return true;
    }

    public ObjectHandle maskAs(Container owner, TypeConstant typeAs) {
        return this;
    }

    public ObjectHandle revealAs(Frame frame, TypeConstant typeAs) {
        return this;
    }

    public int proceed(Frame frameCaller, Frame.Continuation continuation) {
        throw new IllegalStateException("Not deferred");
    }

    public int compareTo(ObjectHandle that) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass()) + " cannot compare");
    }

    public int hashCode() {
        if (this.isNativeEqual()) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass()) + " must implement \"hashCode()\"");
        }
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        if (this.isNativeEqual()) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass()) + " must implement \"equals()\"");
        }
        return this == obj;
    }

    public String toString() {
        TypeComposition clz = this.getComposition();
        return "(" + (this.m_fMutable || clz.getType().isImmutable() ? "" : "immutable ") + String.valueOf(clz) + ") ";
    }

    public static class NativeFutureHandle
    extends ObjectHandle {
        public final CompletableFuture f_future;

        protected NativeFutureHandle(CompletableFuture cf) {
            super(null);
            this.f_future = cf;
        }

        @Override
        public String toString() {
            return "Native: " + String.valueOf(this.f_future);
        }
    }

    public static class InitializingHandle
    extends ObjectHandle {
        private final SingletonConstant f_constSingleton;

        public InitializingHandle(SingletonConstant constSingleton) {
            super(null);
            this.f_constSingleton = constSingleton;
        }

        public ObjectHandle getInitialized() {
            ObjectHandle hConst = this.f_constSingleton.getHandle();
            return hConst == this ? null : hConst;
        }

        protected ObjectHandle assertInitialized() {
            ObjectHandle hConst = this.f_constSingleton.getHandle();
            if (hConst instanceof InitializingHandle) {
                throw new IllegalStateException("Circular initialization \"" + this.f_constSingleton.getValue().getValueString() + "\"");
            }
            return hConst;
        }

        @Override
        public ObjectHandle cloneAs(TypeComposition clazz) {
            return this.assertInitialized().cloneAs(clazz);
        }

        @Override
        public ObjectHandle revealOrigin() {
            return this.assertInitialized().revealOrigin();
        }

        @Override
        public List<String> validateFields() {
            return this.assertInitialized().validateFields();
        }

        @Override
        public boolean isSelfContained() {
            return this.assertInitialized().isSelfContained();
        }

        @Override
        public TypeComposition getComposition() {
            return this.assertInitialized().getComposition();
        }

        @Override
        public TypeConstant getType() {
            return this.f_constSingleton.getType();
        }

        @Override
        public boolean isPassThrough(Container container) {
            return this.assertInitialized().isPassThrough(container);
        }

        @Override
        public boolean isService() {
            return this.assertInitialized().isService();
        }

        @Override
        public xService.ServiceHandle getService() {
            return this.assertInitialized().getService();
        }

        @Override
        public boolean isNativeEqual() {
            return this.assertInitialized().isNativeEqual();
        }

        @Override
        public ObjectHandle maskAs(Container owner, TypeConstant typeAs) {
            return this.assertInitialized().maskAs(owner, typeAs);
        }

        @Override
        public ObjectHandle revealAs(Frame frame, TypeConstant typeAs) {
            return this.assertInitialized().revealAs(frame, typeAs);
        }

        @Override
        public boolean isShared(Container container, Map<ObjectHandle, Boolean> mapVisited) {
            return this.assertInitialized().isShared(container, mapVisited);
        }

        @Override
        public int compareTo(ObjectHandle that) {
            return this.assertInitialized().compareTo(that);
        }

        @Override
        public int hashCode() {
            return this.assertInitialized().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.assertInitialized().equals(obj);
        }

        @Override
        public String toString() {
            ObjectHandle hConst = this.getInitialized();
            return hConst == null ? "<initializing>" : hConst.toString();
        }
    }

    public static class TransientId
    extends ObjectHandle {
        private final int f_nHash = s_hashCode.getAndAdd(1640531527);
        private static final AtomicInteger s_hashCode = new AtomicInteger();

        protected TransientId() {
            super(null);
        }

        @Override
        public int hashCode() {
            return this.f_nHash;
        }

        @Override
        public String toString() {
            return "Transient";
        }
    }

    public static class DeferredArrayHandle
    extends DeferredCallHandle {
        private final TypeComposition f_clzArray;
        private final ObjectHandle[] f_ahValue;

        public DeferredArrayHandle(TypeComposition clzArray, ObjectHandle[] ahValue) {
            super((ExceptionHandle)null);
            this.f_clzArray = clzArray;
            this.f_ahValue = ahValue;
        }

        @Override
        public TypeConstant getType() {
            return this.augmentType(this.f_clzArray.getType());
        }

        @Override
        public ObjectHandle revealOrigin() {
            return this;
        }

        @Override
        public void addContinuation(Frame.Continuation continuation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int proceed(Frame frameCaller, Frame.Continuation continuation) {
            Frame.Continuation stepAssign = frame -> frame.pushStack(xArray.createImmutableArray(this.f_clzArray, this.f_ahValue));
            switch (new Utils.GetArguments(this.f_ahValue, stepAssign).doNext(frameCaller)) {
                case -1: {
                    return continuation.proceed(frameCaller);
                }
                case -5: {
                    frameCaller.m_frameNext.addContinuation(continuation);
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public String toString() {
            return "Deferred array initialization: " + String.valueOf(this.getType());
        }
    }

    public static class DeferredSingletonHandle
    extends DeferredCallHandle {
        private final SingletonConstant f_constSingleton;

        public DeferredSingletonHandle(SingletonConstant constSingleton) {
            super((ExceptionHandle)null);
            this.f_constSingleton = constSingleton;
        }

        @Override
        public void addContinuation(Frame.Continuation continuation) {
            throw new UnsupportedOperationException();
        }

        public SingletonConstant getConstant() {
            return this.f_constSingleton;
        }

        @Override
        public int proceed(Frame frameCaller, Frame.Continuation continuation) {
            return Utils.initConstants(frameCaller, Collections.singletonList(this.f_constSingleton), frame -> {
                frame.pushStack(this.f_constSingleton.getHandle());
                return continuation.proceed(frame);
            });
        }

        @Override
        public String toString() {
            return "Deferred initialization for " + String.valueOf(this.f_constSingleton);
        }
    }

    public static class DeferredPropertyHandle
    extends DeferredCallHandle {
        private final PropertyConstant f_idProp;

        public DeferredPropertyHandle(PropertyConstant idProp) {
            super((ExceptionHandle)null);
            this.f_idProp = idProp;
        }

        @Override
        public void addContinuation(Frame.Continuation continuation) {
            throw new UnsupportedOperationException();
        }

        public PropertyConstant getProperty() {
            return this.f_idProp;
        }

        @Override
        public int proceed(Frame frameCaller, Frame.Continuation continuation) {
            ObjectHandle hThis = frameCaller.getThis();
            switch (hThis.getTemplate().getPropertyValue(frameCaller, hThis, this.f_idProp, -1)) {
                case -1: {
                    return continuation.proceed(frameCaller);
                }
                case -5: {
                    frameCaller.m_frameNext.addContinuation(continuation);
                    return -5;
                }
                case -3: {
                    return -3;
                }
                case -7: {
                    return -7;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public String toString() {
            return "Deferred property access: " + this.f_idProp.getName();
        }
    }

    public static class DeferredCallHandle
    extends ObjectHandle {
        protected final Frame f_frameNext;
        protected final ExceptionHandle f_hException;

        public DeferredCallHandle(Frame frameNext) {
            super(null);
            this.f_frameNext = frameNext;
            this.f_hException = frameNext.m_hException;
        }

        public DeferredCallHandle(ExceptionHandle hException) {
            super(null);
            this.f_frameNext = null;
            this.f_hException = hException;
        }

        @Override
        public int proceed(Frame frameCaller, Frame.Continuation continuation) {
            if (this.f_hException == null) {
                Frame frameNext = this.f_frameNext;
                if (continuation != null) {
                    frameNext.addContinuation(continuation);
                }
                return frameCaller.call(frameNext);
            }
            return frameCaller.raiseException(this.f_hException);
        }

        public void addContinuation(Frame.Continuation continuation) {
            if (this.f_hException == null) {
                this.f_frameNext.addContinuation(continuation);
            }
        }

        @Override
        public boolean isPassThrough(Container container) {
            throw new IllegalStateException();
        }

        @Override
        public String toString() {
            return this.f_hException == null ? "Deferred call: " + String.valueOf(this.f_frameNext) : "Deferred exception: " + String.valueOf(this.f_hException);
        }
    }

    public static class ConstantHandle
    extends ObjectHandle {
        private final Constant f_constant;

        public ConstantHandle(Constant constant) {
            super(xObject.CLASS);
            assert (constant != null);
            this.f_constant = constant;
        }

        public Constant getConstant() {
            return this.f_constant;
        }

        @Override
        public String toString() {
            return this.f_constant.toString();
        }
    }

    public static class JavaLong
    extends ObjectHandle {
        protected long m_lValue;

        public JavaLong(TypeComposition clazz, long lValue) {
            super(clazz);
            this.m_lValue = lValue;
        }

        @Override
        public boolean isSelfContained() {
            return true;
        }

        public long getValue() {
            return this.m_lValue;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.m_lValue);
        }

        @Override
        public int compareTo(ObjectHandle that) {
            return Long.compare(this.m_lValue, ((JavaLong)that).m_lValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof JavaLong)) return false;
            JavaLong that = (JavaLong)obj;
            if (this.m_lValue != that.m_lValue) return false;
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + (this.m_clazz.getTemplate() == xChar.INSTANCE ? Handy.quotedChar((char)this.m_lValue) : String.valueOf(this.m_lValue));
        }
    }

    public static class ExceptionHandle
    extends GenericHandle {
        public final String f_sRTError;

        public ExceptionHandle(TypeComposition clazz, String sRTError) {
            super(clazz);
            this.f_sRTError = sRTError;
        }

        public WrapperException getException() {
            return new WrapperException();
        }

        @Override
        public String toString() {
            String string;
            ObjectHandle hText = this.getField(null, "text");
            String string2 = super.toString();
            if (hText instanceof xString.StringHandle) {
                xString.StringHandle hString = (xString.StringHandle)hText;
                string = Handy.quotedString(hString.getStringValue());
            } else {
                string = "";
            }
            return string2 + string;
        }

        public class WrapperException
        extends Exception {
            public WrapperException() {
            }

            public WrapperException(Throwable cause) {
                super(cause);
            }

            public ExceptionHandle getExceptionHandle() {
                return ExceptionHandle.this;
            }

            @Override
            public String toString() {
                return this.getExceptionHandle().toString();
            }
        }
    }

    public static class GenericHandle
    extends ObjectHandle {
        private final ObjectHandle[] m_aFields;
        protected Container m_owner;
        public static final String OUTER = "$outer";

        public GenericHandle(TypeComposition clazz) {
            super(clazz);
            this.m_fMutable = true;
            this.m_aFields = clazz.initializeStructure();
        }

        public ObjectHandle[] getFields() {
            return this.m_aFields;
        }

        public boolean containsField(PropertyConstant idProp) {
            return this.getComposition().getFieldInfo(idProp) != null;
        }

        public ObjectHandle getField(Frame frame, PropertyConstant idProp) {
            ClassComposition.FieldInfo field = this.getComposition().getFieldInfo(idProp);
            return field == null ? this.missingPropertyException(frame, idProp.getName()) : this.getField(frame, field);
        }

        public ObjectHandle getField(Frame frame, String sProp) {
            ClassComposition.FieldInfo field = this.getComposition().getFieldInfo(sProp);
            return field == null ? this.missingPropertyException(frame, sProp) : this.getField(frame, field);
        }

        private ObjectHandle missingPropertyException(Frame frame, String sProp) {
            return new DeferredCallHandle(xException.makeHandle(frame, "Missing property: " + sProp));
        }

        public ObjectHandle getField(Frame frame, ClassComposition.FieldInfo field) {
            return field.isTransient() ? this.getTransientField(frame, field) : this.m_aFields[field.getIndex()];
        }

        public void setField(Frame frame, PropertyConstant idProp, ObjectHandle hValue) {
            ClassComposition.FieldInfo field = this.getComposition().getFieldInfo(idProp);
            if (field.isTransient()) {
                this.setTransientField(frame, field.getIndex(), hValue);
            } else {
                this.m_aFields[field.getIndex()] = hValue;
            }
        }

        public void setField(Frame frame, String sProp, ObjectHandle hValue) {
            ClassComposition.FieldInfo field = this.getComposition().getFieldInfo(sProp);
            if (field.isTransient()) {
                this.setTransientField(frame, field.getIndex(), hValue);
            } else {
                this.m_aFields[field.getIndex()] = hValue;
            }
        }

        public ClassComposition.FieldInfo getFieldInfo(PropertyConstant idProp) {
            return this.getComposition().getFieldInfo(idProp);
        }

        public ObjectHandle getField(int iPos) {
            return this.m_aFields[iPos];
        }

        public void setField(int iPos, ObjectHandle hValue) {
            this.m_aFields[iPos] = hValue;
        }

        public ObjectHandle getTransientField(Frame frame, ClassComposition.FieldInfo field) {
            TransientId hId = (TransientId)this.m_aFields[field.getIndex()];
            ObjectHandle hValue = frame.f_context.getTransientValue(hId);
            if (hValue == null && field.isInflated()) {
                xRef.RefHandle hRef = field.createRefHandle(frame);
                hRef.setField(frame, OUTER, (ObjectHandle)this);
                frame.f_context.setTransientValue(hId, hRef);
                return hRef;
            }
            return hValue;
        }

        public void setTransientField(Frame frame, int iPos, ObjectHandle hValue) {
            frame.f_context.setTransientValue((TransientId)this.m_aFields[iPos], hValue);
        }

        public Container getOwner() {
            return this.m_owner == null ? this.getComposition().getContainer() : this.m_owner;
        }

        public void setOwner(Container owner) {
            this.m_owner = owner;
        }

        public boolean containsMutableFields() {
            for (ObjectHandle hField : this.m_aFields) {
                if (hField == null || !hField.isMutable()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isService() {
            if (this.m_fMutable && this.getComposition().isInstanceChild()) {
                ObjectHandle hParent = this.getField(null, OUTER);
                return hParent != null && hParent.isService();
            }
            return false;
        }

        @Override
        public xService.ServiceHandle getService() {
            ObjectHandle hParent = this.getField(null, OUTER);
            return hParent == null || !hParent.isService() ? null : hParent.getService();
        }

        @Override
        public ObjectHandle cloneAs(TypeComposition clazz) {
            boolean fUpdateOuter = this.isStruct() || clazz.isStruct();
            GenericHandle hClone = (GenericHandle)super.cloneAs(clazz);
            ObjectHandle[] aFields = this.m_aFields;
            if (fUpdateOuter && aFields != null) {
                for (ClassComposition.FieldInfo field : clazz.getFieldLayout().values()) {
                    xRef.RefHandle hValue;
                    ObjectHandle hOuter;
                    if (!field.isInflated() || field.isTransient() || (hOuter = (hValue = (xRef.RefHandle)aFields[field.getIndex()]).getField(null, OUTER)) == null) continue;
                    hValue.setField(null, OUTER, (ObjectHandle)hClone);
                }
            }
            return hClone;
        }

        @Override
        public List<String> validateFields() {
            ArrayList<String> listUnassigned = null;
            ObjectHandle[] aFields = this.m_aFields;
            if (aFields != null) {
                TypeComposition clazz = this.getComposition();
                for (ClassComposition.FieldInfo field : clazz.getFieldLayout().values()) {
                    ObjectHandle hValue = aFields[field.getIndex()];
                    if (hValue != null || field.isAllowedUnassigned()) continue;
                    if (listUnassigned == null) {
                        listUnassigned = new ArrayList<String>();
                    }
                    listUnassigned.add(field.getName());
                }
            }
            return listUnassigned;
        }

        @Override
        public boolean makeImmutable() {
            if (this.m_fMutable) {
                this.m_fMutable = false;
                if (this.getComposition().makeStructureImmutable(this.m_aFields)) {
                    return true;
                }
                this.m_fMutable = true;
                return false;
            }
            return true;
        }

        @Override
        public boolean isNativeEqual() {
            return false;
        }

        @Override
        public GenericHandle maskAs(Container owner, TypeConstant typeAs) {
            TypeComposition clzAs;
            Container ownerOrig;
            if (!this.isService()) {
                TypeConstant type = this.getType();
                assert (type.isSingleUnderlyingClass(true));
                ModuleConstant idModule = type.getSingleUnderlyingClass(true).getModuleConstant();
                if (!idModule.isCoreModule()) {
                    ProxyComposition clzProxy = new ProxyComposition(this.getComposition(), typeAs);
                    return Proxy.makeHandle(clzProxy, owner.getServiceContext(), this, true);
                }
            }
            if (owner == (ownerOrig = this.getOwner()) || typeAs.isShared(ownerOrig.getConstantPool())) {
                clzAs = this.getComposition().maskAs(typeAs);
            } else {
                ClassComposition clz = (ClassComposition)this.getComposition();
                TypeConstant typeInception = clz.getInceptionType().removeAccess();
                assert (typeInception.isShared(owner.getConstantPool()));
                typeInception = (TypeConstant)owner.getConstantPool().register(typeInception);
                clzAs = owner.ensureClassComposition(typeInception, clz.getTemplate()).maskAs(typeAs);
            }
            if (clzAs != null) {
                GenericHandle hClone = (GenericHandle)this.cloneAs(clzAs);
                hClone.setOwner(owner);
                return hClone;
            }
            return null;
        }

        @Override
        public GenericHandle revealAs(Frame frame, TypeConstant typeAs) {
            Container caller;
            Container owner = this.m_owner;
            if (owner != null && (caller = frame.f_context.f_container) != owner && !caller.isParent(owner)) {
                return null;
            }
            TypeComposition clzAs = this.getComposition().revealAs(typeAs);
            return clzAs == null ? null : (GenericHandle)this.cloneAs(clzAs);
        }

        @Override
        public boolean isShared(Container container, Map<ObjectHandle, Boolean> mapVisited) {
            TypeConstant type = this.getType();
            if (!type.isShared(container.getConstantPool())) {
                return false;
            }
            if (this.isService()) {
                return true;
            }
            if (mapVisited == null) {
                mapVisited = new IdentityHashMap<ObjectHandle, Boolean>();
            }
            return mapVisited.put(this, Boolean.TRUE) != null || GenericHandle.areShared(this.m_aFields, container, mapVisited);
        }
    }
}

