/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.OpSupport;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.reflect.xVar;
import org.xvm.runtime.template.text.xString;

public class PropertyComposition
implements TypeComposition {
    private final ClassComposition f_clzParent;
    private final TypeComposition f_clzRef;
    private final PropertyInfo f_infoProp;
    private final Map<Object, CallChain> f_mapMethods;
    private final Map<PropertyConstant, CallChain> f_mapGetters;
    private final Map<PropertyConstant, CallChain> f_mapSetters;
    private PropertyComposition m_clzInception;
    private PropertyComposition m_clzStruct;

    public PropertyComposition(ClassComposition clzParent, PropertyInfo infoProp) {
        assert (!clzParent.isStruct());
        Container container = clzParent.getContainer();
        TypeConstant typeRef = infoProp.getBaseRefType();
        ClassTemplate templateRef = container.getTemplate(typeRef);
        this.f_clzParent = clzParent;
        this.f_infoProp = infoProp;
        this.f_clzRef = templateRef.ensureClass(container, typeRef);
        this.f_mapMethods = new ConcurrentHashMap<Object, CallChain>();
        this.f_mapGetters = new ConcurrentHashMap<PropertyConstant, CallChain>();
        this.f_mapSetters = new ConcurrentHashMap<PropertyConstant, CallChain>();
    }

    private PropertyComposition(PropertyComposition clzInception) {
        this.f_clzParent = clzInception.f_clzParent;
        this.f_infoProp = clzInception.f_infoProp;
        this.f_clzRef = clzInception.f_clzRef;
        this.f_mapMethods = clzInception.f_mapMethods;
        this.f_mapGetters = clzInception.f_mapGetters;
        this.f_mapSetters = clzInception.f_mapSetters;
        this.m_clzInception = clzInception;
        this.m_clzStruct = this;
    }

    @Override
    public Container getContainer() {
        return this.f_clzParent.getContainer();
    }

    @Override
    public OpSupport getSupport() {
        return this.f_clzRef.getSupport();
    }

    @Override
    public ClassTemplate getTemplate() {
        return this.f_clzRef.getTemplate();
    }

    @Override
    public TypeConstant getType() {
        return this.getInceptionType();
    }

    @Override
    public TypeConstant getInceptionType() {
        TypeConstant typeParent = this.f_clzParent.getInceptionType();
        return typeParent.getConstantPool().ensurePropertyClassTypeConstant(typeParent, this.f_infoProp.getIdentity());
    }

    @Override
    public TypeConstant getBaseType() {
        return this.f_infoProp.getBaseRefType();
    }

    @Override
    public TypeComposition maskAs(TypeConstant type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeComposition revealAs(TypeConstant type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectHandle ensureOrigin(ObjectHandle handle) {
        return handle;
    }

    @Override
    public ObjectHandle ensureAccess(ObjectHandle handle, Constants.Access access) {
        assert (handle.getComposition() == this);
        return access == Constants.Access.STRUCT ^ this.isStruct() ? handle.cloneAs(this.ensureAccess(access)) : handle;
    }

    @Override
    public PropertyComposition ensureAccess(Constants.Access access) {
        if (access == Constants.Access.STRUCT) {
            PropertyComposition clzStruct = this.m_clzStruct;
            if (clzStruct == null) {
                this.m_clzStruct = clzStruct = new PropertyComposition(this);
            }
            return clzStruct;
        }
        return this.isStruct() ? this.m_clzInception : this;
    }

    @Override
    public boolean isStruct() {
        return this.m_clzStruct == this;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isInstanceChild() {
        return false;
    }

    @Override
    public MethodStructure ensureAutoInitializer() {
        return this.f_clzRef.ensureAutoInitializer();
    }

    @Override
    public ObjectHandle[] initializeStructure() {
        return this.f_clzRef.initializeStructure();
    }

    @Override
    public ClassComposition.FieldInfo getFieldInfo(Object id) {
        return this.f_clzRef.getFieldInfo(id);
    }

    @Override
    public boolean makeStructureImmutable(ObjectHandle[] ahField) {
        return this.f_clzRef.makeStructureImmutable(ahField);
    }

    @Override
    public boolean hasOuter() {
        return this.f_clzRef.hasOuter();
    }

    @Override
    public boolean isInjected(PropertyConstant idProp) {
        return false;
    }

    @Override
    public boolean isAtomic(PropertyConstant idProp) {
        return false;
    }

    @Override
    public CallChain getMethodCallChain(Object nidMethod) {
        ConstantPool pool = this.getConstantPool();
        if (nidMethod instanceof SignatureConstant) {
            SignatureConstant sig = (SignatureConstant)nidMethod;
            if (sig.getConstantPool() != pool) {
                nidMethod = pool.register(sig);
            }
        } else {
            IdentityConstant.NestedIdentity idNested = (IdentityConstant.NestedIdentity)nidMethod;
            IdentityConstant idParent = idNested.getIdentityConstant();
            if (idParent.getConstantPool() != pool) {
                idParent = (IdentityConstant)pool.register(idParent);
                nidMethod = idParent.appendNestedIdentity(pool, idNested);
            }
        }
        return this.f_mapMethods.computeIfAbsent(nidMethod, nid -> {
            IdentityConstant.NestedIdentity nested;
            PropertyConstant idBase = this.f_infoProp.getIdentity();
            MethodConstant idNested = (MethodConstant)(nid instanceof IdentityConstant.NestedIdentity && (nested = (IdentityConstant.NestedIdentity)nid).getIdentityConstant().getNestedDepth() > idBase.getNestedDepth() ? nested.getIdentityConstant() : idBase.appendNestedIdentity(idBase.getConstantPool(), nid));
            TypeInfo infoParent = this.getParentInfo();
            MethodInfo info = infoParent.getMethodByNestedId(idNested.getNestedIdentity(), true);
            return info == null ? this.f_clzRef.getMethodCallChain(nid) : new CallChain(info.ensureOptimizedMethodChain(infoParent));
        });
    }

    @Override
    public CallChain getPropertyGetterChain(PropertyConstant idProp) {
        ConstantPool pool = this.getConstantPool();
        if (idProp.getConstantPool() != pool) {
            idProp = (PropertyConstant)pool.register(idProp);
        }
        return this.f_mapGetters.computeIfAbsent(idProp, id -> {
            PropertyConstant idBase = this.f_infoProp.getIdentity();
            PropertyConstant idNested = id.getNestedDepth() > idBase.getNestedDepth() ? id : (PropertyConstant)idBase.appendNestedIdentity(idBase.getConstantPool(), id.getNestedIdentity());
            MethodBody[] chain = this.getParentInfo().getOptimizedGetChain(idNested);
            return chain == null ? this.f_clzRef.getPropertyGetterChain((PropertyConstant)id) : CallChain.createPropertyCallChain(chain);
        });
    }

    @Override
    public CallChain getPropertySetterChain(PropertyConstant idProp) {
        ConstantPool pool = this.getConstantPool();
        if (idProp.getConstantPool() != pool) {
            idProp = (PropertyConstant)pool.register(idProp);
        }
        return this.f_mapSetters.computeIfAbsent(idProp, id -> {
            PropertyConstant idBase = this.f_infoProp.getIdentity();
            PropertyConstant idNested = id.getNestedDepth() > idBase.getNestedDepth() ? id : (PropertyConstant)idBase.appendNestedIdentity(idBase.getConstantPool(), id.getNestedIdentity());
            MethodBody[] chain = this.getParentInfo().getOptimizedSetChain(idNested);
            return chain == null ? this.f_clzRef.getPropertySetterChain((PropertyConstant)id) : new CallChain(chain);
        });
    }

    @Override
    public int getFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        xRef.RefHandle hRef = (xRef.RefHandle)hTarget;
        if (idProp.isTopLevel()) {
            xRef template = (xRef)this.getTemplate();
            return this.f_infoProp.containsBody(idProp) ? template.getNativeReferent(frame, hRef, iReturn) : template.getFieldValue(frame, hRef, idProp, iReturn);
        }
        return this.f_clzRef.getTemplate().getFieldValue(frame, hRef.getReferentHolder(), idProp, iReturn);
    }

    @Override
    public int setFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        xRef.RefHandle hRef = (xRef.RefHandle)hTarget;
        if (idProp.isTopLevel()) {
            xVar template = (xVar)this.getTemplate();
            return this.f_infoProp.containsBody(idProp) ? template.setNativeReferent(frame, hRef, hValue) : template.setFieldValue(frame, hRef, idProp, hValue);
        }
        return this.f_clzRef.getTemplate().setFieldValue(frame, hRef.getReferentHolder(), idProp, hValue);
    }

    @Override
    public Map<Object, ClassComposition.FieldInfo> getFieldLayout() {
        return this.f_clzRef.getFieldLayout();
    }

    @Override
    public xString.StringHandle[] getFieldNameArray() {
        return Utils.STRINGS_NONE;
    }

    @Override
    public ObjectHandle[] getFieldValueArray(Frame frame, ObjectHandle.GenericHandle hValue) {
        return Utils.OBJECTS_NONE;
    }

    public String toString() {
        return String.valueOf(this.f_clzParent) + "." + this.f_infoProp.getName() + (this.isStruct() ? ":struct" : "");
    }

    public boolean isLazy() {
        return this.f_infoProp.isLazy();
    }

    public PropertyInfo getPropertyInfo() {
        return this.f_infoProp;
    }

    public TypeComposition getPropertyClass() {
        return this.f_clzRef;
    }

    public ClassComposition getParentComposition() {
        return this.f_clzParent;
    }

    private TypeInfo getParentInfo() {
        return this.f_clzParent.getInceptionType().ensureTypeInfo();
    }
}

