/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.xvm.asm.ConstantPool;
import org.xvm.runtime.Container;
import org.xvm.util.concurrent.ConcurrentLinkedBlockingQueue;

public class Runtime {
    public final ThreadPoolExecutor f_executorXVM;
    public final ThreadPoolExecutor f_executorIO;
    private final Map<Container, Object> f_containers = new WeakHashMap<Container, Object>();
    protected final AtomicLong f_idProducer = new AtomicLong();
    private volatile long m_lastXvmSubmitNanos;
    private boolean m_fDebugger;

    public Runtime() {
        int parallelism = Integer.parseInt(System.getProperty("xvm.parallelism", "0"));
        if (parallelism <= 0) {
            parallelism = java.lang.Runtime.getRuntime().availableProcessors();
        }
        ThreadGroup groupXVM = new ThreadGroup("XVM");
        ThreadFactory factoryXVM = r -> {
            Thread thread = new Thread(groupXVM, r);
            thread.setDaemon(true);
            thread.setName("XvmWorker@" + thread.hashCode());
            return thread;
        };
        this.f_executorXVM = new ThreadPoolExecutor(parallelism, parallelism, 0L, TimeUnit.SECONDS, new ConcurrentLinkedBlockingQueue<Runnable>(), factoryXVM);
        ThreadGroup groupIO = new ThreadGroup("IO");
        ThreadFactory factoryIO = r -> {
            Thread thread = new Thread(groupIO, r);
            thread.setDaemon(true);
            thread.setName("IOWorker@" + thread.hashCode());
            return thread;
        };
        this.f_executorIO = new ThreadPoolExecutor(parallelism, 1024, 0L, TimeUnit.SECONDS, new ConcurrentLinkedBlockingQueue<Runnable>(), factoryIO);
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContainer(Container container) {
        Map<Container, Object> map = this.f_containers;
        synchronized (map) {
            this.f_containers.putIfAbsent(container, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Container> containers() {
        Map<Container, Object> map = this.f_containers;
        synchronized (map) {
            return new HashSet<Container>(this.f_containers.keySet());
        }
    }

    public Container findContainer(ConstantPool pool) {
        for (Container container : this.f_containers.keySet()) {
            if (container.getConstantPool() != pool) continue;
            return container;
        }
        return null;
    }

    protected void submitService(Runnable task) {
        this.f_executorXVM.submit(task);
        this.m_lastXvmSubmitNanos = System.nanoTime();
    }

    protected void submitIO(Runnable task) {
        this.f_executorIO.submit(task);
    }

    public long makeUniqueId() {
        return this.f_idProducer.getAndIncrement();
    }

    public void shutdownXVM() {
        this.f_executorIO.shutdown();
        this.f_executorXVM.shutdown();
    }

    public boolean isIdle() {
        return this.m_lastXvmSubmitNanos < System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(10L) && this.f_executorXVM.getActiveCount() == 0;
    }

    public boolean isDebuggerActive() {
        return this.m_fDebugger;
    }

    public void setDebuggerActive(boolean fActive) {
        this.m_fDebugger = fActive;
    }
}

