/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.op.Return_0;
import org.xvm.runtime.Container;
import org.xvm.runtime.DebugConsole;
import org.xvm.runtime.Debugger;
import org.xvm.runtime.Fiber;
import org.xvm.runtime.FiberQueue;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Runtime;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.WeakCallback;
import org.xvm.runtime.template.Proxy;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template._native.temporal.xLocalClock;
import org.xvm.runtime.template.annotations.xFuture;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;
import org.xvm.util.concurrent.VarHandles;

public class ServiceContext {
    public final Container f_container;
    public static final int QUEUE_THRESHOLD = 128;
    public static final int MAX_OPS_PER_RUN = 1000000;
    public final ConstantPool f_pool;
    public final long f_lId;
    public final String f_sName;
    private xService.ServiceHandle m_hService;
    public xRTFunction.FunctionHandle m_hExceptionHandler;
    protected int m_iFrameCounter;
    private ObjectHandle m_hSynchronizedSection = xNullable.NULL;
    protected long m_cRuntimeNanos;
    private Frame m_frameCurrent;
    private final Queue<Message> f_queueMsg = new ConcurrentLinkedQueue<Message>();
    private final Queue<Response> f_queueResponse = new ConcurrentLinkedQueue<Response>();
    private final Set<Fiber> f_setFibers = new ConcurrentSkipListSet<Fiber>();
    private final FiberQueue f_queueSuspended = new FiberQueue(this);
    private Synchronicity m_synchronicity = Synchronicity.Concurrent;
    private Fiber m_fiberSyncOwner;
    volatile long m_lLockScheduling;
    static final ThreadLocal<ServiceContext[]> s_tloContext = ThreadLocal.withInitial(() -> new ServiceContext[1]);
    static final VarHandle SCHEDULING_LOCK_HANDLE = VarHandles.of(ServiceContext.class, "m_lLockScheduling");
    private final Map<Op, EnumMap> f_mapOpInfo = new WeakHashMap<Op, EnumMap>();
    private Map<ObjectHandle.TransientId, ObjectHandle> m_mapTransient;
    private Map<Long, WeakCallback.Callback> m_mapCallbacks;
    private final WakeUpScheduler f_wakeUpScheduler = new WakeUpScheduler();

    ServiceContext(Container container, String sName, long lId) {
        this.f_container = container;
        this.f_pool = container.getConstantPool();
        this.f_sName = sName;
        this.f_lId = lId;
    }

    public Runtime getRuntime() {
        return this.f_container.f_runtime;
    }

    public LinkerContext getLinkerContext() {
        return this.f_container;
    }

    public ServiceContext getMainContext() {
        return this.f_container.getServiceContext();
    }

    public xService.ServiceHandle getService() {
        return this.m_hService;
    }

    public void setService(xService.ServiceHandle hService) {
        assert (this.m_hService == null || this.m_hService.isStruct() && !hService.isStruct());
        this.m_hService = hService;
    }

    public ObjectHandle getSynchronizedSection() {
        return this.m_hSynchronizedSection;
    }

    public int setSynchronizedSection(Frame frame, ObjectHandle hSection) {
        assert (hSection != null);
        if (this.m_hSynchronizedSection != xNullable.NULL && this.m_fiberSyncOwner != frame.f_fiber) {
            return frame.raiseException("Attempt to reset unowned SynchronizedSection");
        }
        this.m_hSynchronizedSection = hSection;
        if (hSection == xNullable.NULL) {
            this.setSynchronicity(null, Synchronicity.Concurrent);
        } else {
            ObjectHandle hCritical = ((ObjectHandle.GenericHandle)hSection).getField(frame, "critical");
            this.setSynchronicity(frame.f_fiber, ((xBoolean.BooleanHandle)hCritical).get() ? Synchronicity.Critical : Synchronicity.Synchronized);
        }
        return -1;
    }

    public void setSynchronicity(Fiber fiber, Synchronicity synchronicity) {
        this.m_fiberSyncOwner = fiber;
        this.m_synchronicity = synchronicity;
    }

    public Frame getCurrentFrame() {
        return this.m_frameCurrent;
    }

    public Set<Fiber> getFibers() {
        return this.f_setFibers;
    }

    public static ServiceContext getCurrentContext() {
        return s_tloContext.get()[0];
    }

    public Synchronicity getSynchronicity() {
        return this.m_synchronicity;
    }

    public Fiber getSynchronizationOwner() {
        return this.m_fiberSyncOwner;
    }

    public boolean isDebuggerActive() {
        return this.f_container.f_runtime.isDebuggerActive();
    }

    public void setDebuggerActive(boolean fActive) {
        this.f_container.f_runtime.setDebuggerActive(fActive);
    }

    public Debugger getDebugger() {
        return DebugConsole.INSTANCE;
    }

    public Object getOpInfo(Op op, Enum category) {
        EnumMap mapByCategory = this.f_mapOpInfo.get(op);
        if (mapByCategory == null) {
            return null;
        }
        WeakReference ref = (WeakReference)mapByCategory.get(category);
        return ref == null ? null : ref.get();
    }

    public void setOpInfo(Op op, Enum category, Object info) {
        this.f_mapOpInfo.computeIfAbsent(op, op_ -> new EnumMap(category.getClass())).put(category, new WeakReference<Object>(info));
    }

    public ObjectHandle getTransientValue(ObjectHandle.TransientId ref) {
        return this.ensureTransientMap().get(ref);
    }

    public void setTransientValue(ObjectHandle.TransientId ref, ObjectHandle value) {
        this.ensureTransientMap().put(ref, value);
    }

    private Map<ObjectHandle.TransientId, ObjectHandle> ensureTransientMap() {
        Map<ObjectHandle.TransientId, ObjectHandle> map = this.m_mapTransient;
        if (map == null) {
            map = this.m_mapTransient = new WeakHashMap<ObjectHandle.TransientId, ObjectHandle>();
        }
        return map;
    }

    protected Map<Long, WeakCallback.Callback> ensureCallbackMap() {
        Map<Long, WeakCallback.Callback> map = this.m_mapCallbacks;
        if (map == null) {
            map = this.m_mapCallbacks = new HashMap<Long, WeakCallback.Callback>();
        }
        return map;
    }

    protected Map<Long, WeakCallback.Callback> getCallbackMap() {
        return this.m_mapCallbacks;
    }

    /*
     * Exception decompiling
     */
    protected boolean drainWork() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void ensureScheduled(boolean fAsync) {
        if (this.tryAcquireSchedulingLock()) {
            this.execute(!fAsync);
        }
    }

    public void execute(boolean fAllowInlineExecution) {
        if (fAllowInlineExecution && this.drainWork()) {
            if (this.isTerminated()) {
                this.f_container.terminate(this);
            } else {
                this.releaseSchedulingLock();
            }
        } else {
            this.f_container.schedule(this);
        }
    }

    protected boolean tryAcquireSchedulingLock() {
        return SCHEDULING_LOCK_HANDLE.getAndAdd(this, 1L) == 0L;
    }

    protected void releaseSchedulingLock() {
        long lLockPreState = this.m_lLockScheduling;
        if (this.isContended() || !SCHEDULING_LOCK_HANDLE.compareAndSet(this, lLockPreState, 0L)) {
            this.f_container.schedule(this);
        } else if (!this.f_setFibers.isEmpty()) {
            long ldtTimeout = Long.MAX_VALUE;
            for (Fiber fiber : this.f_setFibers) {
                long ldtTimeoutFiber = fiber.getTimeoutStamp();
                if (ldtTimeoutFiber <= 0L) continue;
                ldtTimeout = Math.min(ldtTimeout, ldtTimeoutFiber);
            }
            if (ldtTimeout != Long.MAX_VALUE) {
                this.f_wakeUpScheduler.schedule(ldtTimeout);
            }
        }
    }

    public boolean addRequest(Message msg) {
        this.f_queueMsg.add(msg);
        this.ensureScheduled(msg.isAsync());
        return this.isOverwhelmed();
    }

    public boolean isOverwhelmed() {
        return this.f_queueSuspended.size() > 128;
    }

    private void respond(Response response) {
        this.f_queueResponse.add(response);
        this.ensureScheduled(true);
    }

    private void processResponses() {
        Response response;
        while ((response = this.f_queueResponse.poll()) != null) {
            response.run();
        }
    }

    private Frame nextFiber() {
        Message message;
        this.processResponses();
        FiberQueue qFiber = this.f_queueSuspended;
        while ((message = this.f_queueMsg.poll()) != null) {
            qFiber.add(message.createFrame(this));
        }
        return this.m_frameCurrent == null ? qFiber.getReady() : this.m_frameCurrent;
    }

    public void suspendFiber(Frame frame) {
        switch (frame.f_fiber.getStatus()) {
            case Running: {
                throw new IllegalStateException();
            }
            case Initial: {
                this.f_queueSuspended.add(frame);
                break;
            }
            case Waiting: {
                this.m_frameCurrent = null;
                this.f_queueSuspended.add(frame);
                break;
            }
            case Paused: {
                this.m_frameCurrent = frame;
            }
        }
    }

    public Frame execute(Frame frame) {
        int iPC;
        Fiber fiber = frame.f_fiber;
        int iPCLast = iPC = frame.m_iPC;
        this.m_frameCurrent = frame;
        switch (fiber.prepareRun(frame)) {
            case -1: {
                break;
            }
            case -5: {
                frame = this.m_frameCurrent = frame.m_frameNext;
                iPC = 0;
                break;
            }
            case -3: {
                iPC = -3;
                break;
            }
            case -8: {
                return frame;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Op[] aOp = frame.f_aOp;
        int cOps = 0;
        block30: while (true) {
            if (iPC >= 0) {
                frame.m_iPC = iPC;
                if (++cOps > 1000000 && !this.isDebuggerActive()) {
                    fiber.setStatus(Fiber.FiberStatus.Paused, cOps);
                    return frame;
                }
                try {
                    iPCLast = iPC;
                    if ((iPC = aOp[iPC].process(frame, iPCLast)) != -1) continue;
                    iPC = iPCLast + 1;
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                    System.err.println(frame.getStackTrace());
                    iPC = frame.raiseException("Run-time error: " + String.valueOf(e));
                }
                continue;
            }
            switch (iPC) {
                case -6: {
                    frame = frame.f_framePrev;
                }
                case -5: {
                    this.m_frameCurrent = frame.m_frameNext;
                    frame.m_frameNext = null;
                    frame = this.m_frameCurrent;
                    aOp = frame.f_aOp;
                    iPC = frame.m_hException == null ? 0 : -3;
                    continue block30;
                }
                case -2: {
                    if (this.isDebuggerActive()) {
                        this.getDebugger().onReturn(frame);
                    }
                    Frame.Continuation continuation = frame.m_continuation;
                    this.m_frameCurrent = frame.f_framePrev;
                    frame = this.m_frameCurrent;
                    if (frame != null) {
                        iPC = frame.m_iPC + 1;
                    }
                    if (continuation != null) {
                        int iResult = continuation.proceed(frame);
                        switch (iResult) {
                            case -1: {
                                break;
                            }
                            case -3: {
                                assert (frame.m_hException != null);
                                iPC = -3;
                                continue block30;
                            }
                            case -5: {
                                assert (frame.m_frameNext != null);
                                this.m_frameCurrent = frame.m_frameNext;
                                frame.m_frameNext = null;
                                frame = this.m_frameCurrent;
                                aOp = frame.f_aOp;
                                iPC = 0;
                                continue block30;
                            }
                            case -2: {
                                iPC = -2;
                                continue block30;
                            }
                            default: {
                                if (iResult < 0) {
                                    throw new IllegalStateException();
                                }
                                iPC = iResult;
                            }
                        }
                    }
                    if (frame == null) {
                        this.terminateFiber(fiber, cOps);
                        this.m_frameCurrent = null;
                        return null;
                    }
                    aOp = frame.f_aOp;
                    continue block30;
                }
                case -4: {
                    frame = frame.f_framePrev;
                }
                case -3: {
                    ObjectHandle.ExceptionHandle hException = frame.m_hException;
                    assert (hException != null);
                    boolean fDebugger = this.isDebuggerActive();
                    while (true) {
                        if (fDebugger) {
                            iPC = this.getDebugger().checkBreakPoint(frame, hException);
                            switch (iPC) {
                                case -1: {
                                    break;
                                }
                                case -5: {
                                    this.m_frameCurrent = frame.m_frameNext;
                                    frame.m_frameNext = null;
                                    frame = this.m_frameCurrent;
                                    aOp = frame.f_aOp;
                                    iPC = 0;
                                    continue block30;
                                }
                                case -3: {
                                    fDebugger = false;
                                    break;
                                }
                                default: {
                                    assert (iPC >= 0 && frame.m_hException == null);
                                    frame = this.m_frameCurrent = frame.f_framePrev;
                                    aOp = frame.f_aOp;
                                    continue block30;
                                }
                            }
                        }
                        if ((iPC = frame.findGuard(hException)) >= 0) {
                            this.m_frameCurrent = frame;
                            aOp = frame.f_aOp;
                            continue block30;
                        }
                        Frame frameCaller = frame.f_framePrev;
                        if (frameCaller == null) break;
                        frame = frameCaller;
                        frame.raiseException(hException);
                    }
                    frame.raiseException(hException);
                    this.m_frameCurrent = frame;
                    aOp = frame.f_aOp;
                    iPC = frame.m_iPC + 1;
                    continue block30;
                }
                case -7: {
                    fiber.setStatus(Fiber.FiberStatus.Waiting, cOps);
                    return frame;
                }
                case -8: {
                    frame.m_iPC = iPCLast + 1;
                    fiber.setStatus(Fiber.FiberStatus.Waiting, cOps);
                    return frame;
                }
                case -9: {
                    fiber.setStatus(Fiber.FiberStatus.Paused, cOps);
                    return frame;
                }
                case -10: {
                    frame = frame.f_framePrev;
                    assert (frame != null && !frame.isNativeStack());
                    aOp = frame.f_aOp;
                    iPC = frame.m_iPC;
                    this.insertBreakPointOp(aOp, iPC);
                    continue block30;
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid code: " + iPC);
    }

    private void insertBreakPointOp(final Op[] aOp, int iPC) {
        final Op opReset = aOp[iPC];
        aOp[iPC] = new Op(this){
            final /* synthetic */ ServiceContext this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int process(Frame frame, int iPC) {
                int nResult = this.this$0.getDebugger().checkBreakPoint(frame, iPC);
                switch (nResult) {
                    default: {
                        System.err.println("Not supported result: " + nResult);
                    }
                    case -1: {
                        aOp[iPC] = opReset;
                        return iPC;
                    }
                    case -10: {
                        aOp[iPC] = opReset;
                        return -10;
                    }
                    case -5: 
                }
                return -5;
            }

            @Override
            public String toString() {
                return "Debug";
            }
        };
    }

    protected Frame createServiceEntryFrame(Message msg, int cReturns, Op[] aopNative) {
        TypeConstant typeReturn;
        switch (cReturns) {
            case -1: {
                typeReturn = this.f_pool.typeTuple0();
                cReturns = 1;
                break;
            }
            case 0: {
                typeReturn = null;
                break;
            }
            default: {
                typeReturn = this.f_pool.typeObject();
            }
        }
        ObjectHandle[] ahVar = new ObjectHandle[cReturns];
        Fiber fiber = this.createFiber(msg);
        Frame frame = new Frame(fiber, msg.f_iCallerPC, aopNative, ahVar, -2, null);
        for (int nVar = 0; nVar < cReturns; ++nVar) {
            Frame.VarInfo[] varInfoArray = frame.f_aInfo;
            Frame frame2 = frame;
            Objects.requireNonNull(frame2);
            varInfoArray[nVar] = frame2.new Frame.VarInfo(typeReturn, 0);
        }
        return frame;
    }

    protected Fiber createFiber(Message msg) {
        Fiber fiber = new Fiber(this, msg);
        this.f_setFibers.add(fiber);
        return fiber;
    }

    protected void terminateFiber(Fiber fiber, long cOps) {
        if (fiber == this.m_fiberSyncOwner) {
            this.m_fiberSyncOwner = null;
            this.m_synchronicity = Synchronicity.Concurrent;
        }
        fiber.setStatus(Fiber.FiberStatus.Terminating, cOps);
        if (!fiber.hasPendingRequests()) {
            this.f_setFibers.remove(fiber);
        }
    }

    public int shutdown(Frame frame) {
        if (this.m_hService != null) {
            Fiber fiberThis;
            Message message;
            this.m_hService = null;
            FiberQueue qFiber = this.f_queueSuspended;
            while ((message = this.f_queueMsg.poll()) != null) {
                qFiber.add(message.createFrame(this));
            }
            Set<Fiber> setFibers = this.f_setFibers;
            Fiber fiber = fiberThis = frame == null ? null : frame.f_fiber;
            while (!qFiber.isEmpty()) {
                Frame frameNext = qFiber.getAny();
                Fiber fiber2 = frameNext.f_fiber;
                if (fiber2 == fiberThis) continue;
                fiber2.setStatus(Fiber.FiberStatus.Terminating, 0L);
                this.execute(frameNext);
                setFibers.remove(fiber2);
            }
            assert (setFibers.isEmpty() || setFibers.size() == 1 && setFibers.contains(fiberThis));
            this.f_container.terminate(this);
        }
        return -1;
    }

    public ServiceStatus getStatus() {
        if (this.isTerminated()) {
            return ServiceStatus.Terminated;
        }
        Enum statusActive = null;
        for (Fiber fiber : this.f_setFibers) {
            Fiber.FiberStatus status = fiber.getStatus();
            switch (status) {
                case Running: 
                case Initial: 
                case Paused: {
                    return ServiceStatus.Busy;
                }
            }
            statusActive = status.moreActive((Fiber.FiberStatus)statusActive);
        }
        if (statusActive == null) {
            return ServiceStatus.Idle;
        }
        return switch (10.$SwitchMap$org$xvm$runtime$Fiber$FiberStatus[statusActive.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1, 2, 4 -> ServiceStatus.Busy;
            case 3 -> ServiceStatus.BusyWaiting;
            case 5 -> ServiceStatus.IdleWaiting;
        };
    }

    public boolean isContended() {
        return this.m_frameCurrent != null || !this.f_queueResponse.isEmpty() || !this.f_queueMsg.isEmpty() || this.f_queueSuspended.isReady();
    }

    public boolean isIdle() {
        return this.f_setFibers.isEmpty();
    }

    public boolean isTerminated() {
        return this.m_hService == null && this.m_iFrameCounter > 0;
    }

    public int validatePassThrough(Frame frame, ServiceContext ctxDst, TypeSupplier typeSupplier, ObjectHandle[] ahArg) {
        Container container = ctxDst.f_container == this.f_container ? null : ctxDst.f_container;
        return this.validatePassThroughArgs(frame, container, typeSupplier, ahArg, ahArg.length, 0);
    }

    public int validatePassThrough(Frame frame, ServiceContext ctxDst, TypeSupplier typeSupplier, ObjectHandle[] ahArg, int cArgs) {
        Container container = ctxDst.f_container == this.f_container ? null : ctxDst.f_container;
        return this.validatePassThroughArgs(frame, container, typeSupplier, ahArg, cArgs, 0);
    }

    private int validatePassThroughArgs(Frame frame, Container container, TypeSupplier typeSupplier, ObjectHandle[] ahArg, int cArgs, int ixStart) {
        ObjectHandle hArg;
        block5: for (int i = ixStart; i < cArgs && (hArg = ahArg[i]) != null; ++i) {
            if (hArg.isPassThrough(container)) {
                if (!(hArg instanceof xRTFunction.FunctionHandle)) continue;
                xRTFunction.FunctionHandle hFn = (xRTFunction.FunctionHandle)hArg;
                if (container == null) continue;
                ahArg[i] = xRTFunction.makeAsyncDelegatingHandle(this.getService(), hFn);
                continue;
            }
            if (hArg instanceof Proxy.ProxyHandle) {
                Proxy.ProxyHandle hProxy = (Proxy.ProxyHandle)hArg;
                ahArg[i] = hProxy.getTarget();
                continue;
            }
            int ix = i;
            if (hArg.getType().isA(this.f_pool.typeAutoFreezable())) {
                return Utils.callFreeze(frame, hArg, null, frameCaller -> {
                    ahArg[ix] = frameCaller.popStack();
                    return this.validatePassThroughArgs(frameCaller, container, typeSupplier, ahArg, cArgs, ix + 1);
                });
            }
            switch (hArg.getTemplate().createProxyHandle(frame, this, hArg, typeSupplier == null ? null : typeSupplier.get(i))) {
                case -1: {
                    ahArg[i] = frame.popStack();
                    continue block5;
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> {
                        ahArg[ix] = frameCaller.popStack();
                        return this.validatePassThroughArgs(frameCaller, container, typeSupplier, ahArg, cArgs, ix + 1);
                    });
                    return -5;
                }
                case -3: {
                    return -3;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return -1;
    }

    public CompletableFuture<ObjectHandle> callLater(xRTFunction.FunctionHandle hFunction, ObjectHandle[] ahArg) {
        CompletableFuture<ObjectHandle> future = this.postRequest(null, hFunction, ahArg, 0);
        if (future != null) {
            future.whenComplete((r, x) -> {
                if (x != null) {
                    this.callUnhandledExceptionHandler(((ObjectHandle.ExceptionHandle.WrapperException)x).getExceptionHandle());
                }
            });
        }
        return future;
    }

    public CompletableFuture<ObjectHandle> callLater(Frame frame, xRTFunction.FunctionHandle hFunction, ObjectHandle[] ahArg) {
        CompletableFuture<ObjectHandle> future = this.postRequest(frame, hFunction, ahArg, 0);
        if (future != null) {
            future.whenComplete((r, x) -> {
                if (x != null) {
                    this.callUnhandledExceptionHandler(((ObjectHandle.ExceptionHandle.WrapperException)x).getExceptionHandle());
                }
            });
        }
        return future;
    }

    public CompletableFuture<ObjectHandle> postRequest(Frame frame, xRTFunction.FunctionHandle hFunction, ObjectHandle[] ahArg, int cReturns) {
        if (this.isTerminated()) {
            return null;
        }
        CallLaterRequest request = new CallLaterRequest(frame, hFunction, ahArg, cReturns);
        this.addRequest(request);
        return request.f_future;
    }

    public int sendOp1Request(Frame frame, Op op, int iReturn, TypeConstant ... typeRet) {
        assert (iReturn != -3);
        OpRequest request = new OpRequest(frame, op, iReturn == -2 ? 0 : 1, frame.isDynamicVar(iReturn), typeRet.length == 0 ? null : i -> typeRet[i]);
        this.addRequest(request);
        frame.f_fiber.registerRequest(request);
        return frame.assignFutureResult(iReturn, request.f_future);
    }

    public int sendOpNRequest(Frame frame, Op op, int[] aiReturn, TypeConstant ... typeRet) {
        int cRets;
        OpRequest request = new OpRequest(frame, op, cRets, false, (cRets = aiReturn.length) == 0 ? null : i -> typeRet[i]);
        this.addRequest(request);
        frame.f_fiber.registerRequest(request);
        return frame.call(frame.createWaitFrame(request.f_future, aiReturn));
    }

    public int sendConstructRequest(Frame frame, final TypeComposition clazz, final MethodStructure constructor, final ObjectHandle hParent, final ObjectHandle[] ahArg, final int iReturn) {
        Op opConstruct = new Op(this){

            @Override
            public int process(Frame frame, int iPC) {
                xService service = (xService)clazz.getTemplate();
                return service.constructSync(frame, constructor, clazz, hParent, ahArg, iReturn == -2 ? -2 : 0);
            }

            @Override
            public String toString() {
                return "Construct: " + constructor.getContainingClass().getName();
            }
        };
        return this.sendOp1Request(frame, opConstruct, iReturn, new TypeConstant[0]);
    }

    public int sendAllocateRequest(Frame frame, final TypeComposition clazz, final ObjectHandle hParent, int iReturn) {
        assert (iReturn != -2);
        Op opAllocate = new Op(this){
            final /* synthetic */ ServiceContext this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int process(Frame frame, int iPC) {
                xService service = (xService)(hParent != null && hParent.isService() ? hParent.getService().getTemplate() : clazz.getTemplate());
                return service.allocateSync(frame, clazz, hParent, 0);
            }

            @Override
            public String toString() {
                return "Allocate: " + this.this$0.f_sName;
            }
        };
        return this.sendOp1Request(frame, opAllocate, iReturn, new TypeConstant[0]);
    }

    public int sendInvoke1Request(Frame frame, final xRTFunction.FunctionHandle hFunction, final ObjectHandle hTarget, final ObjectHandle[] ahArg, boolean fTuple, int iReturn) {
        boolean fAsync;
        boolean fHandleExceptions;
        if (this.isTerminated()) {
            return frame.raiseException(xException.serviceTerminated(frame, this.f_sName));
        }
        final int cReturns = switch (iReturn) {
            case -3 -> {
                if (!$assertionsDisabled && fTuple) {
                    throw new AssertionError();
                }
                fHandleExceptions = true;
                fAsync = true;
                yield 0;
            }
            case -2 -> {
                if (!$assertionsDisabled && fTuple) {
                    throw new AssertionError();
                }
                fHandleExceptions = false;
                fAsync = false;
                yield 0;
            }
            default -> {
                fAsync = frame.isDynamicVar(iReturn);
                fHandleExceptions = false;
                yield fTuple ? -1 : 1;
            }
        };
        Op opCall = new Op(this){

            @Override
            public int process(Frame frame, int iPC) {
                return switch (cReturns) {
                    case -1 -> hFunction.callT(frame, hTarget, ahArg, 0);
                    case 0 -> hFunction.call1(frame, hTarget, ahArg, -2);
                    case 1 -> hFunction.call1(frame, hTarget, ahArg, 0);
                    default -> throw new IllegalStateException();
                };
            }

            @Override
            public String toString() {
                return hFunction.toString();
            }
        };
        TypeSupplier supplier = this.resolveFormalReturnTypes(hFunction, ahArg);
        OpRequest request = new OpRequest(frame, opCall, cReturns, fAsync, supplier);
        boolean fOverwhelmed = this.addRequest(request);
        Fiber fiber = frame.f_fiber;
        CompletableFuture future = request.f_future;
        if (fHandleExceptions && !fOverwhelmed) {
            if (future.isDone()) {
                return frame.assignFutureResult(iReturn, future);
            }
            fiber.registerUncapturedRequest(request);
            return -1;
        }
        fiber.registerRequest(request);
        return frame.assignFutureResult(iReturn, future);
    }

    public int sendInvokeNRequest(Frame frame, final xRTFunction.FunctionHandle hFunction, final ObjectHandle hTarget, final ObjectHandle[] ahArg, int[] aiReturn) {
        if (this.isTerminated()) {
            return frame.raiseException(xException.serviceTerminated(frame, this.f_sName));
        }
        final int cReturns = aiReturn.length;
        Op opCall = new Op(this){

            @Override
            public int process(Frame frame, int iPC) {
                int[] aiReturn = new int[cReturns];
                for (int i = 0; i < cReturns; ++i) {
                    aiReturn[i] = i;
                }
                return hFunction.callN(frame, hTarget, ahArg, aiReturn);
            }

            @Override
            public String toString() {
                return hFunction.toString();
            }
        };
        boolean fAsync = true;
        for (int iReturn : aiReturn) {
            if (frame.isFuture(iReturn)) continue;
            fAsync = false;
            break;
        }
        TypeSupplier supplier = this.resolveFormalReturnTypes(hFunction, ahArg);
        OpRequest request = new OpRequest(frame, opCall, cReturns, fAsync, supplier);
        CompletableFuture future = request.f_future;
        boolean fOverwhelmed = this.addRequest(request);
        if (cReturns == 0) {
            frame.f_fiber.registerUncapturedRequest(request);
            return fOverwhelmed || future.isDone() ? frame.assignFutureResult(-2, future) : -1;
        }
        frame.f_fiber.registerRequest(request);
        if (cReturns == 1) {
            CompletionStage cfReturn = future.thenApply(ahResult -> ahResult[0]);
            return frame.assignFutureResult(aiReturn[0], (CompletableFuture<ObjectHandle>)cfReturn);
        }
        if (fAsync) {
            for (int i = 0; i < cReturns; ++i) {
                int iReturn = i;
                int iResult = frame.assignFutureResult(aiReturn[i], (CompletableFuture<ObjectHandle>)future.thenApply(ah -> ah[iReturn]));
                assert (iResult == -1);
            }
            return -1;
        }
        return frame.call(frame.createWaitFrame(future, aiReturn));
    }

    private TypeSupplier resolveFormalReturnTypes(final xRTFunction.FunctionHandle hFunction, final ObjectHandle[] ahArg) {
        TypeConstant[] atype = hFunction.getReturnTypes();
        if (atype.length == 0) {
            return null;
        }
        boolean fFormal = false;
        for (TypeConstant type : atype) {
            if (!type.containsTypeParameter(true)) continue;
            fFormal = true;
            break;
        }
        if (!fFormal) {
            return i -> atype[i];
        }
        GenericTypeResolver resolver = new GenericTypeResolver(){

            @Override
            public TypeConstant resolveGenericType(String sFormalName) {
                return null;
            }

            @Override
            public TypeConstant resolveFormalType(FormalConstant constFormal) {
                if (constFormal instanceof TypeParameterConstant) {
                    MethodStructure method;
                    TypeParameterConstant constTypeParam = (TypeParameterConstant)constFormal;
                    int nRegister = constTypeParam.getRegister();
                    MethodConstant idMethod = hFunction.getMethodId();
                    MethodStructure methodStructure = method = idMethod == null ? null : (MethodStructure)idMethod.getComponent();
                    if (method != null && nRegister < method.getTypeParamCount() && method.getParam(nRegister).getName().equals(constTypeParam.getName())) {
                        return ahArg[nRegister].getType().getParamType(0);
                    }
                }
                return null;
            }
        };
        return i -> {
            TypeConstant type = atype[i];
            return type.containsTypeParameter(true) ? type.resolveGenerics(this.f_pool, resolver) : type;
        };
    }

    public int sendProperty01Request(Frame frame, final ObjectHandle hTarget, final PropertyConstant idProp, final int iReturn, final xService.PropertyOperation01 op) {
        if (this.isTerminated()) {
            return frame.raiseException(xException.serviceTerminated(frame, this.f_sName));
        }
        Op opGet = new Op(this){

            @Override
            public int process(Frame frame, int iPC) {
                int iResult = op.invoke(frame, hTarget, idProp, iReturn == -2 ? -2 : 0);
                return idProp.isFuture() && iResult == -1 ? ((xFuture.FutureHandle)frame.f_ahVar[0]).waitAndAssign(frame, 0) : iResult;
            }

            @Override
            public String toString() {
                return idProp.getPathString();
            }
        };
        return this.sendOp1Request(frame, opGet, iReturn, idProp.getType().resolveGenerics(this.f_pool, hTarget.getType()));
    }

    public int sendProperty10Request(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue, xService.PropertyOperation10 op) {
        Container containerDst;
        if (this.isTerminated()) {
            return frame.raiseException(xException.serviceTerminated(frame, this.f_sName));
        }
        Container container = containerDst = frame.f_context.f_container == this.f_container ? null : this.f_container;
        if (hValue.isPassThrough(containerDst)) {
            return this.completeSendProperty10(frame, hTarget, idProp, hValue, op);
        }
        if (idProp == null) {
            return frame.raiseException(xException.mutableObject(frame, hValue.getType()));
        }
        TypeConstant typeProp = idProp.getType().resolveGenerics(this.f_pool, hTarget.getType());
        ObjectHandle[] ahValue = new ObjectHandle[]{hValue};
        switch (frame.f_context.validatePassThrough(frame, this, i -> typeProp, ahValue, 1)) {
            case -1: {
                return this.completeSendProperty10(frame, hTarget, idProp, ahValue[0], op);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> this.completeSendProperty10(frameCaller, hTarget, idProp, ahValue[0], op));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    private int completeSendProperty10(Frame frame, final ObjectHandle hTarget, final PropertyConstant idProp, final ObjectHandle hPassValue, final xService.PropertyOperation10 op) {
        Op opSet = new Op(this){

            @Override
            public int process(Frame frame, int iPC) {
                return op.invoke(frame, hTarget, idProp, hPassValue);
            }

            @Override
            public String toString() {
                return idProp == null ? "<Referent>" : idProp.getPathString();
            }
        };
        return this.sendOp1Request(frame, opSet, -2, new TypeConstant[0]);
    }

    public CompletableFuture<ObjectHandle> sendConstantRequest(Frame frame, final List<SingletonConstant> listConstants) {
        Op opInit = new Op(this){

            @Override
            public int process(Frame frame, int iPC) {
                return Utils.initConstants(frame, listConstants, frameCaller -> frameCaller.assignValue(0, xNullable.NULL));
            }

            @Override
            public String toString() {
                return "StaticInitializationRequest";
            }
        };
        OpRequest request = new OpRequest(frame, opInit, 1, false, null);
        this.addRequest(request);
        return request.f_future;
    }

    protected void callUnhandledExceptionHandler(ObjectHandle.ExceptionHandle hException) {
        xRTFunction.FunctionHandle hFunction = this.m_hExceptionHandler;
        if (hFunction == null) {
            hFunction = new xRTFunction.NativeFunctionHandle((frame, ahArg, iReturn) -> {
                switch (Utils.callToString(frame, ahArg[0])) {
                    case -1: {
                        Utils.log(frame, "\nUnhandled exception: " + ((xString.StringHandle)frame.popStack()).getStringValue());
                        return -1;
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> {
                            Utils.log(frameCaller, "\nUnhandled exception: " + ((xString.StringHandle)frameCaller.popStack()).getStringValue());
                            return -1;
                        });
                        return -5;
                    }
                }
                throw new IllegalStateException();
            });
        }
        this.postRequest(null, hFunction, new ObjectHandle[]{hException}, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Service \"").append(this.f_sName).append("\" (id=").append(this.f_lId).append(')');
        if (this.m_synchronicity != null && this.m_synchronicity != Synchronicity.Concurrent) {
            sb.append(" ").append(this.m_synchronicity.name());
        }
        if (this.m_frameCurrent != null) {
            sb.append(" ").append(this.m_frameCurrent);
        }
        return sb.toString();
    }

    public static enum Synchronicity {
        Concurrent,
        Synchronized,
        Critical;

    }

    protected class WakeUpScheduler {
        private long f_ldtScheduled;
        private TimerTask m_taskCurrent;

        protected WakeUpScheduler() {
        }

        protected void schedule(long ldtWakeUp) {
            long ldtNow = ServiceContext.this.f_container.currentTimeMillis();
            if (this.f_ldtScheduled > 0L) {
                if (ldtNow <= this.f_ldtScheduled && this.f_ldtScheduled <= ldtWakeUp) {
                    return;
                }
                if (ldtNow < this.f_ldtScheduled) {
                    this.m_taskCurrent.cancel();
                }
            }
            this.f_ldtScheduled = ldtWakeUp;
            this.m_taskCurrent = new TimerTask(){

                @Override
                public void run() {
                    ServiceContext.this.ensureScheduled(true);
                }
            };
            xLocalClock.TIMER.schedule(this.m_taskCurrent, Math.max(1L, ldtWakeUp - ldtNow));
        }
    }

    public static abstract class Message {
        public final CompletableFuture f_future;
        public Fiber m_fiber;
        public final Fiber f_fiberCaller;
        public final MethodStructure f_fnCaller;
        public final int f_iCallerId;
        public final int f_iCallerPC;
        public final Map<ObjectHandle, ObjectHandle> f_mapTokens;

        protected Message(Frame frameCaller) {
            if (frameCaller == null) {
                this.f_fiberCaller = null;
                this.f_fnCaller = null;
                this.f_iCallerId = 0;
                this.f_iCallerPC = -1;
                this.f_mapTokens = null;
            } else {
                this.f_fiberCaller = frameCaller.f_fiber;
                this.f_fnCaller = frameCaller.f_function;
                this.f_iCallerId = frameCaller.f_iId;
                this.f_iCallerPC = frameCaller.m_iPC;
                this.f_mapTokens = frameCaller.f_fiber.getTokens();
            }
            this.f_future = new CompletableFuture();
        }

        public abstract boolean isAsync();

        public abstract int getCallDepth();

        public abstract ObjectHandle getTimeoutHandle();

        public abstract long getTimeoutStamp();

        abstract Frame createFrame(ServiceContext var1);

        protected void sendResponse(Fiber fiberCaller, Frame frame, CompletableFuture future, int cReturns) {
            ServiceContext ctxDst = fiberCaller.f_context;
            switch (cReturns) {
                case 0: {
                    ctxDst.respond(new Response<xTuple.TupleHandle>(fiberCaller, xTuple.H_VOID, frame.m_hException, future));
                    break;
                }
                case 1: {
                    ObjectHandle hReturn = frame.f_ahVar[0];
                    ObjectHandle.ExceptionHandle hException = frame.m_hException;
                    ctxDst.respond(new Response<ObjectHandle>(fiberCaller, hReturn, hException, future));
                    break;
                }
                case -1: {
                    ObjectHandle[] ahReturn = frame.f_ahVar;
                    ObjectHandle.ExceptionHandle hException = frame.m_hException;
                    xTuple.TupleHandle hTuple = hException == null ? (xTuple.TupleHandle)ahReturn[0] : null;
                    ctxDst.respond(new Response<xTuple.TupleHandle>(fiberCaller, hTuple, hException, future));
                    break;
                }
                default: {
                    assert (cReturns > 1);
                    ObjectHandle[] ahReturn = frame.f_ahVar;
                    ObjectHandle.ExceptionHandle hException = frame.m_hException;
                    if (hException == null) {
                        int c = ahReturn.length;
                        for (int i = 0; i < c; ++i) {
                            ObjectHandle hReturn = ahReturn[i];
                            if (hReturn != null) continue;
                            assert (i > 0 && ahReturn[0].equals(xBoolean.FALSE));
                            ahReturn[i] = ObjectHandle.DEFAULT;
                        }
                    }
                    ctxDst.respond(new Response<ObjectHandle[]>(fiberCaller, ahReturn, hException, future));
                    break;
                }
            }
        }
    }

    public static class Response<T>
    implements Runnable {
        private final Fiber f_fiberCaller;
        private final T f_return;
        private final ObjectHandle.ExceptionHandle f_hException;
        private final CompletableFuture<T> f_future;

        public Response(Fiber fiberCaller, T returnValue, ObjectHandle.ExceptionHandle hException, CompletableFuture<T> future) {
            assert (returnValue != null || hException != null);
            this.f_fiberCaller = fiberCaller;
            this.f_hException = hException;
            this.f_return = returnValue;
            this.f_future = future;
        }

        @Override
        public void run() {
            this.f_fiberCaller.onResponse();
            if (this.f_hException == null) {
                this.f_future.complete(this.f_return);
            } else {
                this.f_future.completeExceptionally(this.f_hException.getException());
                if (xException.isTimedOut(this.f_hException)) {
                    this.f_fiberCaller.clearTimeout();
                }
            }
        }
    }

    public static enum ServiceStatus {
        Idle,
        IdleWaiting,
        Busy,
        BusyWaiting,
        ShuttingDown,
        Terminated;

    }

    public static interface TypeSupplier {
        public TypeConstant get(int var1);
    }

    public static class CallLaterRequest
    extends Message {
        private final xRTFunction.FunctionHandle f_hFunction;
        private final ObjectHandle[] f_ahArg;
        private final int f_cReturns;

        public CallLaterRequest(Frame frameCaller, xRTFunction.FunctionHandle hFunction, ObjectHandle[] ahArg, int cReturns) {
            super(frameCaller);
            assert (cReturns <= 1);
            this.f_hFunction = hFunction;
            this.f_ahArg = ahArg;
            this.f_cReturns = cReturns;
        }

        @Override
        public boolean isAsync() {
            return true;
        }

        @Override
        public int getCallDepth() {
            return 0;
        }

        @Override
        public ObjectHandle getTimeoutHandle() {
            return xNullable.NULL;
        }

        @Override
        public long getTimeoutStamp() {
            return 0L;
        }

        @Override
        public Frame createFrame(ServiceContext context) {
            Op opCall = new Op(){

                @Override
                public int process(Frame frame, int iPC) {
                    return f_hFunction.call1(frame, null, f_ahArg, f_cReturns == 0 ? -2 : 0);
                }

                @Override
                public String toString() {
                    return "CallLaterRequest: " + f_hFunction.getName();
                }
            };
            Frame frame0 = context.createServiceEntryFrame(this, this.f_cReturns, new Op[]{opCall, Return_0.INSTANCE});
            this.m_fiber = frame0.f_fiber;
            if (this.f_fiberCaller == null) {
                frame0.f_fiber.registerRequest(this);
                frame0.addContinuation(_null -> {
                    ObjectHandle.ExceptionHandle hException = frame0.m_hException;
                    if (hException == null) {
                        this.f_future.complete(this.f_cReturns == 0 ? xTuple.H_VOID : frame0.f_ahVar[0]);
                    } else {
                        this.f_future.completeExceptionally(hException.getException());
                    }
                    return -1;
                });
            } else {
                frame0.addContinuation(_null -> {
                    this.sendResponse(this.f_fiberCaller, frame0, this.f_future, this.f_cReturns);
                    return -1;
                });
            }
            return frame0;
        }
    }

    public static class OpRequest
    extends Message {
        private final Op f_op;
        private final int f_cReturns;
        private final boolean f_fAsync;
        private final TypeSupplier f_typeSupplier;
        private final int f_nDepth;
        private final ObjectHandle f_hTimeout;
        private final long f_ldtTimeout;

        protected OpRequest(Frame frameCaller, Op op, int cReturns, boolean fAsync, TypeSupplier typeSupplier) {
            super(frameCaller);
            this.f_op = op;
            this.f_cReturns = cReturns;
            this.f_fAsync = fAsync;
            this.f_typeSupplier = typeSupplier;
            this.f_nDepth = frameCaller.f_nDepth;
            this.f_hTimeout = frameCaller.f_fiber.getTimeoutHandle();
            this.f_ldtTimeout = frameCaller.f_fiber.getTimeoutStamp();
        }

        @Override
        public boolean isAsync() {
            return this.f_fAsync;
        }

        @Override
        public int getCallDepth() {
            return this.f_nDepth;
        }

        @Override
        public ObjectHandle getTimeoutHandle() {
            return this.f_hTimeout;
        }

        @Override
        public long getTimeoutStamp() {
            return this.f_ldtTimeout;
        }

        @Override
        public Frame createFrame(ServiceContext context) {
            Op opCheck = new Op(){

                @Override
                public int process(Frame frame, int iPC) {
                    return this.checkResponse(f_fiberCaller, frame, f_cReturns, 0);
                }

                @Override
                public String toString() {
                    return "Check";
                }
            };
            Op opRespond = new Op(){

                @Override
                public int process(Frame frame, int iPC) {
                    this.sendResponse(f_fiberCaller, frame, f_future, f_cReturns);
                    return iPC + 1;
                }

                @Override
                public String toString() {
                    return "Respond";
                }
            };
            Frame frame0 = context.createServiceEntryFrame(this, this.f_cReturns, new Op[]{this.f_op, opCheck, opRespond, Return_0.INSTANCE});
            this.m_fiber = frame0.f_fiber;
            return frame0;
        }

        protected int checkResponse(Fiber fiberCaller, Frame frame, int cReturns, int index) {
            ServiceContext ctxSrc = frame.f_context;
            ServiceContext ctxDst = fiberCaller.f_context;
            block0 : switch (cReturns) {
                case 0: {
                    break;
                }
                case 1: {
                    if (frame.m_hException != null) break;
                    int iResult = ctxSrc.validatePassThrough(frame, ctxDst, this.f_typeSupplier, frame.f_ahVar, 1);
                    if (iResult == -3) {
                        Arrays.fill(frame.f_ahVar, null);
                    }
                    return iResult;
                }
                case -1: {
                    xTuple.TupleHandle hTuple;
                    ObjectHandle[] ahReturn = frame.f_ahVar;
                    ObjectHandle.ExceptionHandle hException = frame.m_hException;
                    if (hException != null || (hTuple = (xTuple.TupleHandle)ahReturn[0]) == null) break;
                    Object[] ahValue = hTuple.m_ahValue;
                    switch (ctxSrc.validatePassThrough(frame, ctxDst, null, (ObjectHandle[])ahValue)) {
                        case -1: {
                            hTuple.makeImmutable();
                            break block0;
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> {
                                hTuple.makeImmutable();
                                return -1;
                            });
                            return -5;
                        }
                        case -3: {
                            Arrays.fill(ahValue, null);
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }
                default: {
                    assert (cReturns > 1);
                    Object[] ahReturn = frame.f_ahVar;
                    ObjectHandle.ExceptionHandle hException = frame.m_hException;
                    if (hException != null) break;
                    for (int i = index; i < cReturns; ++i) {
                        ObjectHandle hReturn = ahReturn[i];
                        if (hReturn != null) continue;
                        assert (i > 0 && ahReturn[0].equals(xBoolean.FALSE));
                        ahReturn[i] = ObjectHandle.DEFAULT;
                    }
                    int iResult = ctxSrc.validatePassThrough(frame, ctxDst, this.f_typeSupplier, (ObjectHandle[])ahReturn, cReturns);
                    if (iResult == -3) {
                        Arrays.fill(ahReturn, null);
                    }
                    return iResult;
                }
            }
            return -1;
        }

        public String toString() {
            return this.f_op.toString();
        }
    }
}

