/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.VarSupport;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.annotations.xFuture;
import org.xvm.runtime.template.annotations.xInject;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.maps.xListMap;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.reflect.xClass;
import org.xvm.runtime.template.reflect.xModule;
import org.xvm.runtime.template.reflect.xPackage;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xOrdered;

public abstract class Utils {
    public static final ObjectHandle[] OBJECTS_NONE = new ObjectHandle[0];
    public static final xString.StringHandle[] STRINGS_NONE = new xString.StringHandle[0];
    public static final String[] NO_NAMES = new String[0];
    public static final Frame.Continuation NEXT = frame -> -1;
    public static final Predicate ANY = t -> true;
    public static ClassStructure CONST_HELPER;
    private static ClassTemplate ANNOTATION_TEMPLATE;
    private static ClassTemplate ANNOTATION_TEMPLATE_TEMPLATE;
    private static ClassTemplate ARGUMENT_TEMPLATE;
    private static ClassTemplate RT_PARAMETER_TEMPLATE;
    private static MethodStructure ANNOTATION_CONSTRUCT;
    private static MethodStructure ANNOTATION_TEMPLATE_CONSTRUCT;
    private static MethodStructure ARGUMENT_CONSTRUCT;
    private static MethodStructure RT_PARAMETER_CONSTRUCT;
    private static MethodStructure LIST_MAP_CONSTRUCT;
    private static MethodStructure STRING_VALUE_OF;
    private static TypeConstant ANNOTATION_ARRAY_TYPE;
    private static TypeConstant ARGUMENT_ARRAY_TYPE;
    private static SignatureConstant SIG_FREEZE;
    private static SignatureConstant SIG_GET_RESOURCE;
    protected static final Op[] WAIT_FOR_RELIEF;

    public static void initNative(NativeContainer container) {
        ConstantPool pool = container.getConstantPool();
        ANNOTATION_TEMPLATE = container.getTemplate("reflect.Annotation");
        ANNOTATION_TEMPLATE_TEMPLATE = container.getTemplate("reflect.AnnotationTemplate");
        ARGUMENT_TEMPLATE = container.getTemplate("reflect.Argument");
        RT_PARAMETER_TEMPLATE = container.getTemplate("_native.reflect.RTParameter");
        ANNOTATION_CONSTRUCT = ANNOTATION_TEMPLATE.getStructure().findMethod("construct", 2, new TypeConstant[0]);
        ANNOTATION_TEMPLATE_CONSTRUCT = ANNOTATION_TEMPLATE_TEMPLATE.getStructure().findMethod("construct", 2, new TypeConstant[0]);
        ARGUMENT_CONSTRUCT = ARGUMENT_TEMPLATE.getStructure().findMethod("construct", 2, new TypeConstant[0]);
        RT_PARAMETER_CONSTRUCT = RT_PARAMETER_TEMPLATE.getStructure().findMethod("construct", 5, new TypeConstant[0]);
        LIST_MAP_CONSTRUCT = xListMap.INSTANCE.ensureConstructor();
        ANNOTATION_ARRAY_TYPE = pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.Annotation"));
        ARGUMENT_ARRAY_TYPE = pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.Argument"));
        CONST_HELPER = container.getClassStructure("_native.ConstHelper");
        STRING_VALUE_OF = CONST_HELPER.findMethod("valueOf", 1, new TypeConstant[0]);
        SIG_FREEZE = container.getClassStructure("Freezable").findMethod("freeze", 1, new TypeConstant[0]).getIdentityConstant().getSignature();
        SIG_GET_RESOURCE = container.getClassStructure("mgmt.ResourceProvider").findMethod("getResource", 2, new TypeConstant[0]).getIdentityConstant().getSignature();
    }

    public static ObjectHandle[] ensureSize(ObjectHandle[] ahArg, int cVars) {
        int cArgs = ahArg.length;
        if (cArgs < cVars) {
            ObjectHandle[] ahVar = new ObjectHandle[cVars];
            System.arraycopy(ahArg, 0, ahVar, 0, cArgs);
            return ahVar;
        }
        return ahArg;
    }

    public static xRTFunction.FullyBoundHandle makeFinalizer(Frame frame, MethodStructure constructor, ObjectHandle[] ahArg) {
        MethodStructure methodFinally = constructor.getConstructFinally();
        return methodFinally == null ? null : xRTFunction.makeInternalHandle(frame, methodFinally).bindArguments(ahArg);
    }

    public static int callToString(Frame frame, ObjectHandle hValue) {
        TypeComposition clz = hValue.getComposition();
        CallChain chain = clz.getMethodCallChain(clz.getConstantPool().sigToString());
        return chain.isNative() ? hValue.getTemplate().buildStringValue(frame, hValue, -1) : chain.invoke(frame, hValue, OBJECTS_NONE, -1);
    }

    public static int callValueOf(Frame frame, ObjectHandle hValue) {
        ObjectHandle[] ahVar = new ObjectHandle[STRING_VALUE_OF.getMaxVars()];
        ahVar[0] = hValue;
        return frame.call1(STRING_VALUE_OF, null, ahVar, -1);
    }

    public static int callFreeze(Frame frame, ObjectHandle hValue, Boolean FInPlace, Frame.Continuation continuation) {
        CallChain chain = hValue.getComposition().getMethodCallChain(SIG_FREEZE);
        if (chain.isEmpty()) {
            return frame.raiseException("Missing method \"freeze()\" on " + hValue.getType().getValueString());
        }
        int iResult = FInPlace == null ? chain.invoke(frame, hValue, -1) : chain.invoke(frame, hValue, (ObjectHandle)xBoolean.makeHandle(FInPlace), -1);
        switch (iResult) {
            case -1: {
                return continuation.proceed(frame);
            }
            case -5: {
                frame.m_frameNext.addContinuation(continuation);
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    public static int assignConditionalResult(Frame frame, int iResult, int[] aiReturn) {
        switch (iResult) {
            case -1: {
                return frame.assignValues(aiReturn, xBoolean.TRUE, frame.popStack());
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValues(aiReturn, xBoolean.TRUE, frameCaller.popStack()));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    public static ObjectHandle ensureInitializedEnum(Frame frame, xEnum.EnumHandle hEnum) {
        if (hEnum.isStruct()) {
            IdentityConstant idValue = (IdentityConstant)hEnum.getType().getDefiningConstant();
            return frame.getConstHandle(frame.poolContext().ensureSingletonConstConstant(idValue));
        }
        return hEnum;
    }

    public static ObjectHandle callGetResource(Frame frame, ObjectHandle hInjector, TypeConstant type, String sName) {
        int iResult;
        if (Op.isDeferred(hInjector)) {
            iResult = hInjector.proceed(frame, frameCaller -> {
                int n;
                ObjectHandle hResource = Utils.callGetResource(frameCaller, frameCaller.popStack(), type, sName);
                if (hResource instanceof ObjectHandle.DeferredCallHandle) {
                    ObjectHandle.DeferredCallHandle hDeferred = (ObjectHandle.DeferredCallHandle)hResource;
                    n = hDeferred.proceed(frameCaller, null);
                } else {
                    n = frameCaller.pushStack(hResource);
                }
                return n;
            });
        } else {
            TypeComposition clazz = hInjector.getComposition();
            CallChain chain = clazz.getMethodCallChain(SIG_GET_RESOURCE);
            if (chain.isEmpty()) {
                return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "Missing method \"" + SIG_GET_RESOURCE.getValueString() + "\" on " + hInjector.getType().getValueString()));
            }
            ObjectHandle[] ahArg = new ObjectHandle[chain.getMaxVars()];
            ahArg[0] = type.ensureTypeHandle(frame.f_context.f_container);
            ahArg[1] = xString.makeHandle(sName);
            iResult = chain.invoke(frame, hInjector, ahArg, -1);
        }
        return frame.popResult(iResult);
    }

    public static int assignInitializedEnum(Frame frame, xEnum.EnumHandle hEnum, int iReturn) {
        return frame.assignDeferredValue(iReturn, Utils.ensureInitializedEnum(frame, hEnum));
    }

    public static void log(Frame frame, String sMsg) {
        long lFiberId;
        ServiceContext context;
        if (sMsg.charAt(0) == '\n') {
            System.out.println();
            sMsg = sMsg.substring(1);
        }
        if (frame == null) {
            context = ServiceContext.getCurrentContext();
            lFiberId = -1L;
        } else {
            context = frame.f_context;
            lFiberId = frame.f_fiber.getId();
        }
        System.out.println(String.valueOf(new Timestamp(context.f_container.currentTimeMillis())) + " " + String.valueOf(context) + ", fiber " + lFiberId + ": " + sMsg);
    }

    public static int callEqualsSequence(Frame frame, TypeConstant type1, TypeConstant type2, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        if (hValue1 == hValue2) {
            return frame.assignValue(iReturn, xBoolean.TRUE);
        }
        switch (type1.callEquals(frame, hValue1, hValue2, -1)) {
            case -1: {
                return Utils.completeEquals(frame, type2, hValue1, hValue2, iReturn);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> Utils.completeEquals(frameCaller, type2, hValue1, hValue2, iReturn));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    protected static int completeEquals(Frame frame, TypeConstant type2, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        ObjectHandle hResult = frame.popStack();
        return hResult == xBoolean.FALSE ? frame.assignValue(iReturn, hResult) : type2.callEquals(frame, hValue1, hValue2, iReturn);
    }

    public static int callCompareSequence(Frame frame, TypeConstant type1, TypeConstant type2, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        if (hValue1 == hValue2) {
            return frame.assignValue(iReturn, xOrdered.EQUAL);
        }
        switch (type1.callCompare(frame, hValue1, hValue2, -1)) {
            case -1: {
                return Utils.completeCompare(frame, type2, hValue1, hValue2, iReturn);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> Utils.completeCompare(frameCaller, type2, hValue1, hValue2, iReturn));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    protected static int completeCompare(Frame frame, TypeConstant type2, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        ObjectHandle hResult = frame.popStack();
        return hResult != xOrdered.EQUAL ? frame.assignValue(iReturn, hResult) : type2.callCompare(frame, hValue1, hValue2, iReturn);
    }

    public static ObjectHandle.ExceptionHandle translate(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof ObjectHandle.ExceptionHandle.WrapperException) {
            ObjectHandle.ExceptionHandle.WrapperException we = (ObjectHandle.ExceptionHandle.WrapperException)e;
            return we.getExceptionHandle();
        }
        if (e instanceof ExecutionException || e instanceof CompletionException) {
            return Utils.translate(e.getCause());
        }
        if (e instanceof CancellationException) {
            return xException.makeHandle(null, "cancelled");
        }
        if (e instanceof InterruptedException) {
            return xException.makeHandle(null, "interrupted");
        }
        return xException.makeHandle(null, "Unexpected native exception: " + e.getMessage());
    }

    public static int initConstants(Frame frame, List<SingletonConstant> listSingletons, Frame.Continuation continuation) {
        boolean fMainContext = false;
        block5: for (final SingletonConstant constSingleton : listSingletons) {
            int iResult;
            ObjectHandle hValue = constSingleton.getHandle();
            if (hValue != null) continue;
            ServiceContext ctxCurr = frame.f_context;
            if (!fMainContext) {
                ServiceContext ctxMain = ctxCurr.getMainContext();
                if (ctxCurr == ctxMain) {
                    fMainContext = true;
                } else {
                    if (ctxMain.isOverwhelmed()) {
                        Frame frameNext = frame.createNativeFrame(WAIT_FOR_RELIEF, OBJECTS_NONE, -2, null);
                        frameNext.addContinuation(frameCaller -> Utils.initConstants(frameCaller, listSingletons, continuation));
                        return frame.call(frameNext);
                    }
                    assert (continuation != null);
                    CompletableFuture<ObjectHandle> cfResult = ctxMain.sendConstantRequest(frame, listSingletons);
                    if (ctxCurr.getSynchronicity() == ServiceContext.Synchronicity.Concurrent) {
                        ctxCurr.setSynchronicity(frame.f_fiber, ServiceContext.Synchronicity.Critical);
                        cfResult.whenComplete((r, e) -> ctxCurr.setSynchronicity(null, ServiceContext.Synchronicity.Concurrent));
                    }
                    return frame.wait(cfResult, -2, continuation);
                }
            }
            if (!constSingleton.markInitializing()) {
                return continuation.proceed(frame);
            }
            Container containerThis = ctxCurr.f_container;
            Container containerOrig = containerThis.getOriginContainer(constSingleton);
            if (containerOrig == containerThis) {
                iResult = Utils.constructSingletonHandle(frame, constSingleton);
            } else {
                Op opConstruct = new Op(){

                    @Override
                    public int process(Frame frame, int iPC) {
                        switch (Utils.constructSingletonHandle(frame, constSingleton)) {
                            case -1: {
                                return frame.assignValue(0, frame.popStack());
                            }
                            case -5: {
                                Frame.Continuation stepNext = frameCaller -> frameCaller.assignValue(0, frameCaller.popStack());
                                frame.m_frameNext.addContinuation(stepNext);
                                return -5;
                            }
                            case -3: {
                                return -3;
                            }
                        }
                        throw new IllegalStateException();
                    }

                    @Override
                    public String toString() {
                        return "ConstructSingleton: " + String.valueOf(constSingleton.getClassConstant());
                    }
                };
                iResult = containerOrig.getServiceContext().sendOp1Request(frame, opConstruct, -1, new TypeConstant[0]);
            }
            switch (iResult) {
                case -1: {
                    constSingleton.setHandle(frame.popStack());
                    continue block5;
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> {
                        constSingleton.setHandle(frameCaller.popStack());
                        return Utils.initConstants(frameCaller, listSingletons, continuation);
                    });
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        return continuation.proceed(frame);
    }

    private static int constructSingletonHandle(Frame frame, SingletonConstant constSingleton) {
        IdentityConstant constValue = constSingleton.getClassConstant();
        switch (constValue.getFormat()) {
            case Module: {
                return xModule.INSTANCE.createConstHandle(frame, constValue);
            }
            case Package: {
                return xPackage.INSTANCE.createConstHandle(frame, constValue);
            }
            case Property: {
                return Utils.callPropertyInitializer(frame, (PropertyConstant)constValue);
            }
            case Class: {
                ClassConstant idClz = (ClassConstant)constValue;
                ClassStructure clz = (ClassStructure)idClz.getComponent();
                assert (clz.isSingleton());
                Container container = frame.f_context.f_container;
                ClassTemplate template = container.getTemplate(idClz);
                if (template.getStructure().getFormat() == Component.Format.ENUMVALUE) {
                    return template.createConstHandle(frame, constSingleton);
                }
                MethodStructure constructor = clz.findConstructor(TypeConstant.NO_TYPES);
                return template.construct(frame, constructor, template.getCanonicalClass(container), null, OBJECTS_NONE, -1);
            }
        }
        throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constValue));
    }

    private static int callPropertyInitializer(Frame frame, PropertyConstant idProp) {
        PropertyStructure prop = (PropertyStructure)idProp.getComponent();
        if (prop.isInjected()) {
            AnnotatedTypeConstant typeRef = frame.poolContext().ensureAnnotatedTypeConstant(idProp.getRefType(null), prop.getRefAnnotations());
            TypeComposition clzRef = typeRef.ensureClass(frame);
            VarSupport support = (VarSupport)clzRef.getSupport();
            switch (support.introduceRef(frame, clzRef, idProp.getName(), -1)) {
                case -1: {
                    return support.getReferent(frame, (xRef.RefHandle)frame.popStack(), -1);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> support.getReferent(frameCaller, (xRef.RefHandle)frameCaller.popStack(), -1));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        Constant constVal = prop.getInitialValue();
        if (constVal == null) {
            MethodStructure methodInit = prop.getInitializer();
            if (methodInit == null) {
                return frame.raiseException("Initializer is missing for " + prop.getIdentityConstant().getPathString());
            }
            ObjectHandle[] ahVar = Utils.ensureSize(OBJECTS_NONE, methodInit.getMaxVars());
            return frame.call1(methodInit, null, ahVar, -1);
        }
        return frame.pushDeferredValue(frame.getConstHandle(constVal));
    }

    public static xArray.ArrayHandle makeAnnoArrayHandle(Container container, ObjectHandle[] ahAnno) {
        return xArray.makeArrayHandle(container.ensureClassComposition(ANNOTATION_ARRAY_TYPE, xArray.INSTANCE), ahAnno.length, ahAnno, xArray.Mutability.Constant);
    }

    public static xArray.ArrayHandle makeArgumentArrayHandle(Container container, ObjectHandle[] ahArg) {
        return xArray.makeArrayHandle(container.ensureClassComposition(ARGUMENT_ARRAY_TYPE, xArray.INSTANCE), ahArg.length, ahArg, xArray.Mutability.Constant);
    }

    public static int constructListMap(Frame frame, TypeComposition clzMap, ObjectHandle haKeys, ObjectHandle haValues, int iReturn) {
        MethodStructure constructor = LIST_MAP_CONSTRUCT;
        ObjectHandle[] ahArg = new ObjectHandle[constructor.getMaxVars()];
        ahArg[0] = haKeys;
        ahArg[1] = haValues;
        return clzMap.getTemplate().construct(frame, constructor, clzMap, null, ahArg, iReturn);
    }

    public static int constructArgument(Frame frame, TypeConstant typeReferent, ObjectHandle hValue, String sName) {
        MethodStructure constructor = ARGUMENT_CONSTRUCT;
        ObjectHandle[] ahArg = new ObjectHandle[constructor.getMaxVars()];
        ahArg[0] = hValue;
        ahArg[1] = sName == null ? xNullable.NULL : xString.makeHandle(sName);
        TypeComposition clzArg = ARGUMENT_TEMPLATE.ensureParameterizedClass(frame.f_context.f_container, typeReferent);
        return ARGUMENT_TEMPLATE.construct(frame, constructor, clzArg, null, ahArg, -1);
    }

    public static int constructAnnotation(Frame frame, xClass.ClassHandle hAnno, ObjectHandle[] ahAnnoArg, int iReturn) {
        MethodStructure constructor = ANNOTATION_CONSTRUCT;
        ObjectHandle[] ahArg = new ObjectHandle[constructor.getMaxVars()];
        ahArg[0] = hAnno;
        ahArg[1] = Utils.makeArgumentArrayHandle(frame.f_context.f_container, ahAnnoArg);
        ClassTemplate template = ANNOTATION_TEMPLATE;
        return template.construct(frame, constructor, template.getCanonicalClass(), null, ahArg, iReturn);
    }

    public static int constructAnnotationTemplate(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hClass, ObjectHandle[] ahAnnoArg, int iReturn) {
        MethodStructure constructor = ANNOTATION_TEMPLATE_CONSTRUCT;
        ObjectHandle[] ahArg = new ObjectHandle[constructor.getMaxVars()];
        ahArg[0] = hClass;
        ahArg[1] = Utils.makeArgumentArrayHandle(frame.f_context.f_container, ahAnnoArg);
        ClassTemplate template = ANNOTATION_TEMPLATE_TEMPLATE;
        return template.construct(frame, constructor, template.getCanonicalClass(), null, ahArg, iReturn);
    }

    static {
        WAIT_FOR_RELIEF = new Op[]{new Op(){

            @Override
            public int process(Frame frame, int iPC) {
                ServiceContext ctxCurr = frame.f_context;
                ServiceContext ctxMain = ctxCurr.getMainContext();
                assert (ctxMain != ctxCurr);
                return ctxMain.isOverwhelmed() ? -9 : -2;
            }

            @Override
            public String toString() {
                return "WaitForRelief";
            }
        }};
    }

    public static class FillArray
    implements Frame.Continuation {
        private final ObjectHandle hArray;
        private final xArray template;
        private final long cSize;
        private final ValueSupplier supplier;
        private final int iReturn;
        private int index = -1;

        public FillArray(xArray.ArrayHandle hArray, int cSize, ValueSupplier supplier, int iReturn) {
            this.hArray = hArray;
            this.template = hArray.getTemplate();
            this.cSize = cSize;
            this.supplier = supplier;
            this.iReturn = iReturn;
        }

        @Override
        public int proceed(Frame frameCaller) {
            return this.template.assignArrayValue(frameCaller, this.hArray, this.index, frameCaller.popStack()) == -3 ? -3 : this.doNext(frameCaller);
        }

        public int doNext(Frame frameCaller) {
            block5: while ((long)(++this.index) < this.cSize) {
                switch (this.supplier.get(frameCaller, this.index)) {
                    case -1: {
                        continue block5;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            return frameCaller.assignValue(this.iReturn, this.hArray);
        }
    }

    @FunctionalInterface
    public static interface ValueSupplier {
        public int get(Frame var1, int var2);
    }

    public static class CreateParameters
    implements Frame.Continuation {
        private final Parameter[] aParam;
        private final ObjectHandle[] ahParam;
        private final Frame.Continuation continuation;
        private final TypeConstant typeRTParameter;
        private int index = -1;

        public CreateParameters(Parameter[] aParam, ObjectHandle[] ahParam, Frame.Continuation continuation) {
            this.aParam = aParam;
            this.ahParam = ahParam;
            this.continuation = continuation;
            this.typeRTParameter = RT_PARAMETER_TEMPLATE.getClassConstant().getType();
        }

        @Override
        public int proceed(Frame frameCaller) {
            this.updateResult(frameCaller);
            return this.doNext(frameCaller);
        }

        protected void updateResult(Frame frameCaller) {
            this.ahParam[this.index] = frameCaller.popStack();
        }

        public int doNext(Frame frameCaller) {
            while (++this.index < this.aParam.length) {
                int iResult;
                Parameter param = this.aParam[this.index];
                TypeConstant type = param.getType();
                String sName = param.getName();
                boolean fFormal = param.isTypeParameter();
                Constant constDefault = param.getDefaultValue();
                ConstantPool pool = frameCaller.poolContext();
                ClassTemplate template = RT_PARAMETER_TEMPLATE;
                TypeConstant typeParam = pool.ensureParameterizedTypeConstant(this.typeRTParameter, type);
                ClassComposition clzParam = frameCaller.f_context.f_container.ensureClassComposition(typeParam, template);
                MethodStructure construct = RT_PARAMETER_CONSTRUCT;
                ObjectHandle[] ahArg = new ObjectHandle[construct.getMaxVars()];
                ahArg[0] = xInt64.makeHandle(this.index);
                ahArg[1] = sName == null ? xNullable.NULL : xString.makeHandle(sName);
                ahArg[2] = xBoolean.makeHandle(fFormal);
                if (constDefault == null) {
                    ahArg[3] = xBoolean.FALSE;
                    ahArg[4] = xNullable.NULL;
                } else {
                    ahArg[3] = xBoolean.TRUE;
                    ahArg[4] = frameCaller.getConstHandle(constDefault);
                }
                if ((iResult = template.construct(frameCaller, construct, clzParam, null, ahArg, -1)) == -3) continue;
                assert (iResult == -5);
                frameCaller.m_frameNext.addContinuation(this);
                return iResult;
            }
            return this.continuation.proceed(frameCaller);
        }
    }

    public static class CreateAnnos
    implements Frame.Continuation {
        private Stage stageNext;
        private final Annotation[] aAnno;
        private final int iReturn;
        private final ObjectHandle[] ahAnno;
        private int iAnno = -1;
        private ObjectHandle hAnnoClz;
        private MethodStructure constructAnno;
        private ObjectHandle[] ahAnnoArg;
        private ObjectHandle hValue;
        private int iArg = -1;

        public CreateAnnos(Annotation[] aAnno, int iReturn) {
            this.aAnno = aAnno;
            this.ahAnno = new ObjectHandle[aAnno.length];
            this.iReturn = iReturn;
            this.stageNext = Stage.Class;
        }

        @Override
        public int proceed(Frame frameCaller) {
            switch (this.stageNext.ordinal()) {
                case 0: {
                    assert (this.iAnno >= 0);
                    this.ahAnno[this.iAnno] = frameCaller.popStack();
                    break;
                }
                case 1: {
                    this.hAnnoClz = frameCaller.popStack();
                    break;
                }
                case 2: {
                    assert (this.iArg >= 0);
                    this.ahAnnoArg[this.iArg] = frameCaller.popStack();
                    break;
                }
                case 3: {
                    this.hValue = frameCaller.popStack();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return this.doNext(frameCaller);
        }

        /*
         * Enabled aggressive block sorting
         */
        public int doNext(Frame frameCaller) {
            block7: while (true) {
                switch (this.stageNext.ordinal()) {
                    case 0: {
                        assert (this.hAnnoClz == null);
                        assert (this.ahAnnoArg == null);
                        if (++this.iAnno == this.aAnno.length) {
                            return frameCaller.assignValue(this.iReturn, Utils.makeAnnoArrayHandle(frameCaller.f_context.f_container, this.ahAnno));
                        }
                        Annotation anno = this.aAnno[this.iAnno];
                        ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
                        this.hAnnoClz = frameCaller.getConstHandle(idAnno);
                        this.stageNext = Stage.ArgumentArray;
                        if (Op.isDeferred(this.hAnnoClz)) {
                            return this.hAnnoClz.proceed(frameCaller, this);
                        }
                    }
                    case 1: {
                        assert (this.hAnnoClz != null);
                        assert (this.ahAnnoArg == null);
                        Annotation anno = this.aAnno[this.iAnno];
                        int cArgs = anno.getParams().length;
                        ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
                        ClassStructure structAnno = (ClassStructure)idAnno.getComponent();
                        this.constructAnno = structAnno.findMethod("construct", m -> true);
                        if (this.constructAnno == null) return frameCaller.raiseException("Unknown annotation: " + String.valueOf(idAnno) + " with " + cArgs + " parameters");
                        if (cArgs > this.constructAnno.getParamCount()) {
                            return frameCaller.raiseException("Unknown annotation: " + String.valueOf(idAnno) + " with " + cArgs + " parameters");
                        }
                        int cParamsAll = this.constructAnno.getParamCount();
                        int cParamsRequired = this.constructAnno.getRequiredParamCount();
                        if (cParamsRequired > cArgs) {
                            return frameCaller.raiseException("Missing arguments for: " + String.valueOf(idAnno) + "; required=" + cParamsRequired + "; actual=" + cArgs);
                        }
                        if (cArgs > cParamsAll) {
                            return frameCaller.raiseException("Unknown arguments for: " + String.valueOf(idAnno) + "; required=" + cParamsAll + "; actual=" + cArgs);
                        }
                        if (cParamsAll == 0) {
                            this.ahAnnoArg = OBJECTS_NONE;
                            this.stageNext = Stage.Annotation;
                            break;
                        }
                        this.ahAnnoArg = new ObjectHandle[cParamsAll];
                        this.iArg = -1;
                        this.stageNext = Stage.ArgumentValue;
                    }
                    case 2: {
                        RegisterConstant constReg;
                        Constant constArg;
                        assert (this.ahAnnoArg != null);
                        if (++this.iArg == this.constructAnno.getParamCount()) {
                            this.stageNext = Stage.Annotation;
                            continue block7;
                        }
                        Constant[] aconstArg = this.aAnno[this.iAnno].getParams();
                        Constant constant = constArg = this.iArg < aconstArg.length ? aconstArg[this.iArg] : null;
                        if (constArg == null || constArg instanceof RegisterConstant && (constReg = (RegisterConstant)constArg).getRegisterIndex() == -4) {
                            constArg = this.constructAnno.getParam(this.iArg).getDefaultValue();
                        }
                        this.hValue = frameCaller.getConstHandle(constArg);
                        this.stageNext = Stage.Argument;
                        if (Op.isDeferred(this.hValue)) {
                            return this.hValue.proceed(frameCaller, this);
                        }
                    }
                    case 3: {
                        assert (this.ahAnnoArg != null);
                        assert (this.constructAnno != null);
                        assert (this.hValue != null);
                        Parameter param = this.constructAnno.getParam(this.iArg);
                        TypeConstant type = param.getType().resolveGenerics(frameCaller.poolContext(), frameCaller.getGenericsResolver(false));
                        int iResult = Utils.constructArgument(frameCaller, type, this.hValue, param.getName());
                        if (iResult == -5) {
                            frameCaller.m_frameNext.addContinuation(this);
                            this.stageNext = Stage.ArgumentValue;
                            return iResult;
                        }
                        if ($assertionsDisabled) return iResult;
                        if (iResult == -3) return iResult;
                        throw new AssertionError();
                    }
                    case 4: {
                        assert (this.hAnnoClz != null);
                        assert (this.ahAnnoArg != null);
                        int iResult = Utils.constructAnnotation(frameCaller, (xClass.ClassHandle)this.hAnnoClz, this.ahAnnoArg, -1);
                        if (iResult == -5) {
                            frameCaller.m_frameNext.addContinuation(this);
                            this.hAnnoClz = null;
                            this.ahAnnoArg = null;
                            this.constructAnno = null;
                            this.stageNext = Stage.Class;
                            return iResult;
                        }
                        if ($assertionsDisabled) return iResult;
                        if (iResult == -3) return iResult;
                        throw new AssertionError();
                    }
                }
            }
        }

        static enum Stage {
            Class,
            ArgumentArray,
            ArgumentValue,
            Argument,
            Annotation;

        }
    }

    @FunctionalInterface
    public static interface BinaryAction {
        public static final BinaryAction ADD = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeAdd(frameCaller, hValue, hArg, -1);
        public static final BinaryAction SUB = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeSub(frameCaller, hValue, hArg, -1);
        public static final BinaryAction MUL = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeMul(frameCaller, hValue, hArg, -1);
        public static final BinaryAction DIV = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeDiv(frameCaller, hValue, hArg, -1);
        public static final BinaryAction MOD = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeMod(frameCaller, hValue, hArg, -1);
        public static final BinaryAction SHL = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeShl(frameCaller, hValue, hArg, -1);
        public static final BinaryAction SHR = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeShr(frameCaller, hValue, hArg, -1);
        public static final BinaryAction USHR = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeShrAll(frameCaller, hValue, hArg, -1);
        public static final BinaryAction AND = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeAnd(frameCaller, hValue, hArg, -1);
        public static final BinaryAction OR = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeOr(frameCaller, hValue, hArg, -1);
        public static final BinaryAction XOR = (frameCaller, hValue, hArg) -> hValue.getOpSupport().invokeXor(frameCaller, hValue, hArg, -1);

        public int invoke(Frame var1, ObjectHandle var2, ObjectHandle var3);
    }

    @FunctionalInterface
    public static interface UnaryAction {
        public static final UnaryAction INC = (frameCaller, hValue) -> hValue.getOpSupport().invokeNext(frameCaller, hValue, -1);
        public static final UnaryAction DEC = (frameCaller, hValue) -> hValue.getOpSupport().invokePrev(frameCaller, hValue, -1);

        public int invoke(Frame var1, ObjectHandle var2);
    }

    public static class InPlaceVarBinary
    extends AbstractInPlace {
        private final BinaryAction action;
        private final xRef.RefHandle hTarget;
        private final ObjectHandle hArg;

        public InPlaceVarBinary(BinaryAction action, xRef.RefHandle hTarget, ObjectHandle hArg) {
            this.action = action;
            this.hTarget = hTarget;
            this.hArg = hArg;
        }

        @Override
        public int doNext(Frame frameCaller) {
            block10: while (true) {
                int iResult;
                switch (++this.ixStep) {
                    case 0: {
                        iResult = this.hTarget.getVarSupport().getReferent(frameCaller, this.hTarget, -1);
                        break;
                    }
                    case 1: {
                        iResult = this.action.invoke(frameCaller, this.hValueOld, this.hArg);
                        break;
                    }
                    case 2: {
                        return this.hTarget.getVarSupport().setReferent(frameCaller, this.hTarget, this.hValueNew);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                switch (iResult) {
                    case -1: {
                        this.updateResult(frameCaller);
                        continue block10;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }
    }

    public static class InPlaceVarUnary
    extends AbstractInPlace {
        private final UnaryAction action;
        private final xRef.RefHandle hTarget;
        private final boolean fPost;
        private final int iReturn;

        public InPlaceVarUnary(UnaryAction action, xRef.RefHandle hTarget, boolean fPost, int iReturn) {
            this.action = action;
            this.hTarget = hTarget;
            this.fPost = fPost;
            this.iReturn = iReturn;
        }

        @Override
        public int doNext(Frame frameCaller) {
            block11: while (true) {
                int iResult;
                int nStep = ++this.ixStep;
                switch (nStep) {
                    case 0: {
                        iResult = this.hTarget.getVarSupport().getReferent(frameCaller, this.hTarget, -1);
                        break;
                    }
                    case 1: {
                        iResult = this.action.invoke(frameCaller, this.hValueOld);
                        break;
                    }
                    case 2: {
                        iResult = this.hTarget.getVarSupport().setReferent(frameCaller, this.hTarget, this.hValueNew);
                        break;
                    }
                    case 3: {
                        return frameCaller.assignValue(this.iReturn, this.fPost ? this.hValueOld : this.hValueNew);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                switch (iResult) {
                    case -1: {
                        this.updateResult(frameCaller);
                        continue block11;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }
    }

    public static class InPlacePropertyBinary
    extends AbstractInPlace {
        private final BinaryAction action;
        private final ClassTemplate template;
        private final ObjectHandle hTarget;
        private final PropertyConstant idProp;
        private final ObjectHandle hArg;

        protected InPlacePropertyBinary(BinaryAction action, ClassTemplate template, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
            this.action = action;
            this.template = template;
            this.hTarget = hTarget;
            this.idProp = idProp;
            this.hArg = hArg;
        }

        @Override
        public int doNext(Frame frameCaller) {
            block10: while (true) {
                int iResult;
                switch (++this.ixStep) {
                    case 0: {
                        iResult = this.template.getPropertyValue(frameCaller, this.hTarget, this.idProp, -1);
                        break;
                    }
                    case 1: {
                        iResult = this.action.invoke(frameCaller, this.hValueOld, this.hArg);
                        break;
                    }
                    case 2: {
                        return this.template.setPropertyValue(frameCaller, this.hTarget, this.idProp, this.hValueNew);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                switch (iResult) {
                    case -1: {
                        this.updateResult(frameCaller);
                        continue block10;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }
    }

    public static class InPlacePropertyUnary
    extends AbstractInPlace {
        private final UnaryAction action;
        private final ClassTemplate template;
        private final ObjectHandle hTarget;
        private final PropertyConstant idProp;
        private final boolean fPost;
        private final int iReturn;

        protected InPlacePropertyUnary(UnaryAction action, ClassTemplate template, ObjectHandle hTarget, PropertyConstant idProp, boolean fPost, int iReturn) {
            this.action = action;
            this.template = template;
            this.hTarget = hTarget;
            this.idProp = idProp;
            this.fPost = fPost;
            this.iReturn = iReturn;
        }

        @Override
        public int doNext(Frame frameCaller) {
            block11: while (true) {
                int iResult;
                switch (++this.ixStep) {
                    case 0: {
                        iResult = this.template.getPropertyValue(frameCaller, this.hTarget, this.idProp, -1);
                        break;
                    }
                    case 1: {
                        iResult = this.action.invoke(frameCaller, this.hValueOld);
                        break;
                    }
                    case 2: {
                        iResult = this.template.setPropertyValue(frameCaller, this.hTarget, this.idProp, this.hValueNew);
                        break;
                    }
                    case 3: {
                        return frameCaller.assignValue(this.iReturn, this.fPost ? this.hValueOld : this.hValueNew);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                switch (iResult) {
                    case -1: {
                        this.updateResult(frameCaller);
                        continue block11;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }
    }

    public static abstract class AbstractInPlace
    implements Frame.Continuation {
        protected ObjectHandle hValueOld;
        protected ObjectHandle hValueNew;
        protected int ixStep = -1;

        @Override
        public int proceed(Frame frameCaller) {
            this.updateResult(frameCaller);
            return this.doNext(frameCaller);
        }

        protected void updateResult(Frame frameCaller) {
            switch (this.ixStep) {
                case 0: {
                    this.hValueOld = frameCaller.popStack();
                    break;
                }
                case 1: {
                    this.hValueNew = frameCaller.popStack();
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public abstract int doNext(Frame var1);
    }

    public static class ReturnTuple
    implements Frame.Continuation {
        private final int iReturn;
        private final TypeConstant typeTuple;
        private final ObjectHandle[] ahValue;
        private final boolean[] afDynamic;
        private int index = -1;
        private boolean fAllAssigned = true;

        public ReturnTuple(int iReturn, TypeConstant typeTuple, ObjectHandle[] ahValue, boolean[] afDynamic) {
            this.iReturn = iReturn;
            this.typeTuple = typeTuple;
            this.ahValue = ahValue;
            this.afDynamic = afDynamic;
        }

        @Override
        public int proceed(Frame frameCaller) {
            block5: while (++this.index < this.ahValue.length) {
                Frame framePrev;
                ObjectHandle hValue = this.ahValue[this.index];
                if (hValue == null) {
                    assert (this.index == 1 && this.ahValue[0] == xBoolean.FALSE);
                    return -2;
                }
                if (hValue instanceof ObjectHandle.DeferredCallHandle) {
                    ObjectHandle.DeferredCallHandle hDeferred = (ObjectHandle.DeferredCallHandle)hValue;
                    hDeferred.addContinuation(this::updateDeferredValue);
                    return hDeferred.proceed(frameCaller, this);
                }
                boolean fDynamic = this.afDynamic != null && this.afDynamic[this.index];
                if (!fDynamic || ((xRef.RefHandle)hValue).isAssigned()) continue;
                if (hValue instanceof xInject.InjectedHandle) {
                    xInject.InjectedHandle hRef = (xInject.InjectedHandle)hValue;
                    int iResult = ((xInject)hRef.getTemplate()).getReferent(frameCaller, hRef, -1);
                    switch (iResult) {
                        case -1: {
                            this.afDynamic[this.index] = false;
                            this.ahValue[this.index--] = frameCaller.popStack();
                            continue block5;
                        }
                        case -5: {
                            frameCaller.m_frameNext.addContinuation(frame -> {
                                this.afDynamic[this.index] = false;
                                this.ahValue[this.index--] = frame.popStack();
                                return this.proceed(frame);
                            });
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                }
                if ((framePrev = frameCaller.f_framePrev).isDynamicVar(this.iReturn)) continue;
                this.fAllAssigned = false;
            }
            if (this.fAllAssigned) {
                return frameCaller.returnValue(this.iReturn, xTuple.makeHandle(this.typeTuple.ensureClass(frameCaller), this.ahValue), false);
            }
            TypeConstant typeFuture = frameCaller.poolContext().ensureFuture(this.typeTuple);
            xFuture.FutureTupleHandle hFuture = new xFuture.FutureTupleHandle(typeFuture.ensureClass(frameCaller), this.ahValue);
            return frameCaller.returnValue(this.iReturn, hFuture, true);
        }

        protected int updateDeferredValue(Frame frameCaller) {
            this.ahValue[this.index--] = frameCaller.popStack();
            return -1;
        }
    }

    public static class ReturnValues
    implements Frame.Continuation {
        private final int[] aiReturn;
        private final ObjectHandle[] ahValue;
        private final boolean[] afDynamic;
        private int index = -1;
        private boolean fAllAssigned = true;

        public ReturnValues(int[] aiReturn, ObjectHandle[] ahValue, boolean[] afDynamic) {
            this.aiReturn = aiReturn;
            this.ahValue = ahValue;
            this.afDynamic = afDynamic;
        }

        @Override
        public int proceed(Frame frameCaller) {
            block9: while (++this.index < this.aiReturn.length) {
                ObjectHandle hValue = this.ahValue[this.index];
                if (hValue == null) {
                    assert (this.index == 1 && this.ahValue[0] == xBoolean.FALSE);
                    return -2;
                }
                if (hValue instanceof ObjectHandle.DeferredCallHandle) {
                    ObjectHandle.DeferredCallHandle hDeferred = (ObjectHandle.DeferredCallHandle)hValue;
                    hDeferred.addContinuation(this::updateDeferredValue);
                    return hDeferred.proceed(frameCaller, this);
                }
                boolean fDynamic = this.afDynamic != null && this.afDynamic[this.index];
                int iReturn = this.aiReturn[this.index];
                if (fDynamic && !((xRef.RefHandle)hValue).isAssigned() && iReturn != -3) {
                    Frame framePrev;
                    if (hValue instanceof xInject.InjectedHandle) {
                        xInject.InjectedHandle hRef = (xInject.InjectedHandle)hValue;
                        int iResult = ((xInject)hRef.getTemplate()).getReferent(frameCaller, hRef, -1);
                        switch (iResult) {
                            case -1: {
                                this.afDynamic[this.index] = false;
                                this.ahValue[this.index--] = frameCaller.popStack();
                                continue block9;
                            }
                            case -5: {
                                frameCaller.m_frameNext.addContinuation(frame -> {
                                    this.afDynamic[this.index] = false;
                                    this.ahValue[this.index--] = frame.popStack();
                                    return this.proceed(frame);
                                });
                                return -5;
                            }
                            case -3: {
                                return -3;
                            }
                        }
                    }
                    if (!(framePrev = frameCaller.f_framePrev).isDynamicVar(iReturn)) {
                        this.fAllAssigned = false;
                        continue;
                    }
                }
                switch (frameCaller.returnValue(iReturn, hValue, fDynamic)) {
                    case -2: {
                        continue block9;
                    }
                    case -4: {
                        return -4;
                    }
                }
                throw new IllegalStateException();
            }
            if (this.fAllAssigned) {
                return -2;
            }
            Frame framePrev = frameCaller.f_framePrev;
            framePrev.call(framePrev.createWaitFrame(this.ahValue, this.aiReturn));
            return -6;
        }

        protected int updateDeferredValue(Frame frameCaller) {
            this.ahValue[this.index--] = frameCaller.popStack();
            return -1;
        }
    }

    public static class AssignValues
    implements Frame.Continuation {
        private final int[] aiReturn;
        private final ObjectHandle[] ahValue;
        private int index = -1;

        public AssignValues(int[] aiReturn, ObjectHandle[] ahValue) {
            this.aiReturn = aiReturn;
            this.ahValue = ahValue;
        }

        @Override
        public int proceed(Frame frameCaller) {
            block5: while (++this.index < this.aiReturn.length) {
                ObjectHandle hValue = this.ahValue[this.index];
                if (hValue instanceof ObjectHandle.DeferredCallHandle) {
                    ObjectHandle.DeferredCallHandle hDeferred = (ObjectHandle.DeferredCallHandle)hValue;
                    hDeferred.addContinuation(this::updateDeferredValue);
                    return hDeferred.proceed(frameCaller, this);
                }
                switch (frameCaller.assignValue(this.aiReturn[this.index], this.ahValue[this.index])) {
                    case -1: {
                        continue block5;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            return -1;
        }

        protected int updateDeferredValue(Frame frameCaller) {
            this.ahValue[this.index--] = frameCaller.popStack();
            return -1;
        }
    }

    public static class GetArguments
    implements Frame.Continuation {
        private final ObjectHandle[] ahArg;
        private final Frame.Continuation continuation;
        private int index = -1;

        public GetArguments(ObjectHandle[] ahArg, Frame.Continuation continuation) {
            this.ahArg = ahArg;
            this.continuation = continuation;
        }

        @Override
        public int proceed(Frame frameCaller) {
            this.updateResult(frameCaller);
            return this.doNext(frameCaller);
        }

        protected void updateResult(Frame frameCaller) {
            this.ahArg[this.index] = frameCaller.popStack();
        }

        public int doNext(Frame frameCaller) {
            ObjectHandle hArg;
            while (++this.index < this.ahArg.length && (hArg = this.ahArg[this.index]) != null) {
                if (!(hArg instanceof ObjectHandle.DeferredCallHandle)) continue;
                return hArg.proceed(frameCaller, this);
            }
            return this.continuation.proceed(frameCaller);
        }
    }
}

