/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime;

import java.lang.ref.WeakReference;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.template._native.reflect.xRTFunction;

public class WeakCallback
extends WeakReference<ServiceContext> {
    private final long f_lCallbackId;

    public WeakCallback(Frame frame, xRTFunction.FunctionHandle hFunction) {
        super(frame.f_context);
        this.f_lCallbackId = frame.f_context.f_container.f_runtime.makeUniqueId();
        frame.f_context.ensureCallbackMap().put(this.f_lCallbackId, new Callback(frame, hFunction));
    }

    public Callback extractCallback() {
        Callback callback;
        ServiceContext context = (ServiceContext)this.get();
        if (context != null && (callback = context.getCallbackMap().remove(this.f_lCallbackId)) != null) {
            return callback;
        }
        throw new IllegalStateException();
    }

    public String toString() {
        Callback callback;
        ServiceContext context = (ServiceContext)this.get();
        if (context != null && (callback = context.getCallbackMap().get(this.f_lCallbackId)) != null) {
            return callback.functionHandle().toString();
        }
        return "Empty";
    }

    public record Callback(Frame frame, xRTFunction.FunctionHandle functionHandle) {
    }
}

