/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.gc;

import org.xvm.runtime.gc.ObjectManager;
import org.xvm.runtime.gc.SegFault;
import org.xvm.util.ShallowSizeOf;

public class LongArrayObjectManager
implements ObjectManager<long[]> {
    public static final LongArrayObjectManager INSTANCE = new LongArrayObjectManager();
    private static final long INVALIDATION_MASK = Long.MIN_VALUE;

    @Override
    public long[] allocate(int cFields) {
        return new long[cFields + 1];
    }

    @Override
    public void free(long[] o) {
        o[0] = Long.MIN_VALUE;
    }

    @Override
    public long getByteSize(long[] o) {
        return ShallowSizeOf.arrayOf(Long.TYPE, this.validate(o).length);
    }

    @Override
    public long getHeader(long[] o) {
        return this.validate(o)[0];
    }

    @Override
    public void setHeader(long[] o, long header) {
        this.validate((long[])o)[0] = header;
    }

    @Override
    public long getField(long[] o, int index) {
        return this.validate(o)[index + 1];
    }

    @Override
    public void setField(long[] o, int index, long address) {
        this.validate((long[])o)[index + 1] = address;
    }

    protected long[] validate(long[] o) {
        if ((o[0] & Long.MIN_VALUE) != 0L) {
            throw new SegFault();
        }
        return o;
    }
}

