/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.gc;

import java.util.HashSet;
import java.util.Set;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.xvm.runtime.gc.GcSpace;
import org.xvm.runtime.gc.ObjectManager;
import org.xvm.runtime.gc.SegFault;
import org.xvm.util.LongMuterator;

public class MarkAndSweepGcSpace<V>
implements GcSpace {
    static final long MARKER_MASK = 1L;
    static final long WEAK_MASK = 2L;
    static final long FIELD_COUNT_MASK = 4092L;
    static final int FIELD_COUNT_SHIFT = 2;
    final ObjectManager<V> f_accessor;
    final LongConsumer f_clearedListener;
    final long f_cbLimitSoft;
    final long f_cbLimitHard;
    long m_cBytes;
    int m_nTopFree;
    int[] m_anFreeSlots = new int[1024];
    V[] m_aObjects = new Object[this.m_anFreeSlots.length];
    final Set<Supplier<? extends LongMuterator>> f_setRoots = new HashSet<Supplier<? extends LongMuterator>>();
    boolean m_fAllocationMarker;

    public MarkAndSweepGcSpace(ObjectManager<V> accessor, LongConsumer clearedListener) {
        this(accessor, clearedListener, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public MarkAndSweepGcSpace(ObjectManager<V> accessor, LongConsumer clearedListener, long cbLimitSoft, long cbLimitHard) {
        this.f_accessor = accessor;
        this.f_clearedListener = clearedListener;
        this.f_cbLimitSoft = cbLimitSoft;
        this.f_cbLimitHard = cbLimitHard;
        for (int i = 0; i < this.m_anFreeSlots.length; ++i) {
            this.m_anFreeSlots[i] = i;
        }
        this.m_nTopFree = this.m_anFreeSlots.length - 1;
    }

    @Override
    public long allocate(int cFields) throws OutOfMemoryError {
        if (this.m_nTopFree < 0 || this.m_cBytes > this.f_cbLimitSoft) {
            this.gc();
            if (this.m_cBytes > this.f_cbLimitHard) {
                throw new OutOfMemoryError("hard limit exceeded");
            }
            if (this.m_nTopFree < 0) {
                this.grow();
            }
        }
        V resource = this.f_accessor.allocate(cFields);
        this.getAndSetHeaderBit(resource, 1L, this.m_fAllocationMarker);
        this.setFieldCount(resource, cFields);
        this.m_cBytes += this.f_accessor.getByteSize(resource);
        int slot = this.m_anFreeSlots[this.m_nTopFree--];
        this.m_aObjects[slot] = resource;
        return this.address(slot);
    }

    @Override
    public long allocateWeak(int cFields) throws OutOfMemoryError {
        if (cFields == 0) {
            throw new IllegalArgumentException("weak-refs must have at least one field");
        }
        long address = this.allocate(cFields);
        this.getAndSetHeaderBit(this.ensure(address), 2L, true);
        return address;
    }

    @Override
    public boolean isValid(long address) {
        if (!this.isLocal(address)) {
            return false;
        }
        int slot = this.slot(address);
        return slot < this.m_aObjects.length && this.m_aObjects[slot] != null;
    }

    private V ensure(long address) throws SegFault {
        if (address == 0L) {
            throw new NullPointerException();
        }
        if (!this.isLocal(address)) {
            throw new SegFault();
        }
        int slot = this.slot(address);
        if (slot > this.m_aObjects.length) {
            throw new SegFault();
        }
        V o = this.m_aObjects[slot];
        if (o == null) {
            throw new SegFault();
        }
        return o;
    }

    @Override
    public long getField(long address, int index) throws SegFault {
        return this.f_accessor.getField(this.ensure(address), index);
    }

    @Override
    public void setField(long address, int index, long handle) throws SegFault {
        this.f_accessor.setField(this.ensure(address), index, handle);
    }

    @Override
    public void addRoot(Supplier<? extends LongMuterator> root) {
        this.f_setRoots.add(root);
    }

    @Override
    public void removeRoot(Supplier<? extends LongMuterator> root) {
        this.f_setRoots.remove(root);
    }

    @Override
    public long getByteCount() {
        return this.m_cBytes;
    }

    @Override
    public void gc() {
        int i;
        boolean fReachableMarker;
        this.m_fAllocationMarker = fReachableMarker = !this.m_fAllocationMarker;
        int[] state = null;
        for (Supplier<? extends LongMuterator> root : this.f_setRoots) {
            LongMuterator liter = root.get();
            while (liter.hasNext()) {
                state = this.walkAndMark(state, liter.next(), fReachableMarker, 0);
            }
        }
        V[] aObjects = this.m_aObjects;
        int[] anFreeSlots = this.m_anFreeSlots;
        int[] anNotify = null;
        int nNotifyTop = 0;
        for (i = 0; i < aObjects.length; ++i) {
            int[] anNotifyNew;
            V o = aObjects[i];
            if (o == null) continue;
            long header = this.f_accessor.getHeader(o);
            if ((header & 1L) == 1L != fReachableMarker) {
                aObjects[i] = null;
                anFreeSlots[++this.m_nTopFree] = i;
                this.m_cBytes -= this.f_accessor.getByteSize(o);
                this.f_accessor.free(o);
                continue;
            }
            if ((header & 2L) != 2L || (anNotifyNew = this.handleWeakSweep(o, i, anNotify, nNotifyTop, fReachableMarker)) == null || nNotifyTop >= anNotifyNew.length || anNotifyNew[nNotifyTop] == 0) continue;
            anNotify = anNotifyNew;
            ++nNotifyTop;
        }
        if (anNotify != null) {
            for (i = 0; i < nNotifyTop; ++i) {
                this.f_clearedListener.accept(this.address((int)anNotify[i]));
            }
        }
    }

    private int[] walkAndMark(int[] state, long address, boolean fReachableMarker, int depth) {
        V o;
        if (this.isLocal(address) && this.getAndSetHeaderBit(o = this.ensure(address), 1L, fReachableMarker) != fReachableMarker) {
            int cFields = this.getFieldCount(o);
            if (depth == 1024) {
                state = this.walkAndMarkIterative(state, address, cFields, fReachableMarker);
            } else {
                int i;
                boolean fWeak = this.getHeaderBit(o, 2L);
                int n = i = fWeak ? 1 : 0;
                while (i < cFields) {
                    state = this.walkAndMark(state, this.f_accessor.getField(o, i), fReachableMarker, depth + 1);
                    ++i;
                }
            }
        }
        return state;
    }

    private int[] walkAndMarkIterative(int[] state, long address, int cFields, boolean fReachableMarker) {
        if (state == null) {
            state = new int[128];
        }
        int iTop = -1;
        state[++iTop] = this.slot(address);
        state[++iTop] = cFields;
        while (true) {
            if (state[iTop] > 0) {
                V o = this.ensure(this.address(state[iTop - 1]));
                int n = iTop;
                state[n] = state[n] - 1;
                int iField = state[n];
                if (iField == 0 && this.getHeaderBit(o, 2L) || !this.isLocal(address = this.f_accessor.getField(o, iField)) || this.getAndSetHeaderBit(o = this.ensure(address), 1L, fReachableMarker) == fReachableMarker || (cFields = this.getFieldCount(o)) <= 0) continue;
                if (iTop + 1 == state.length) {
                    int[] newState = new int[state.length * 2];
                    System.arraycopy(state, 0, newState, 0, state.length);
                    state = newState;
                }
                state[++iTop] = this.slot(address);
                state[++iTop] = cFields;
                continue;
            }
            if ((iTop -= 2) <= 0) break;
        }
        return state;
    }

    private int[] handleWeakSweep(V weak, int nWeak, int[] anNotify, int nNotifyTop, boolean fReachableMarker) {
        V referent;
        long pReferent = this.f_accessor.getField(weak, 0);
        if (this.isLocal(pReferent) && ((referent = this.m_aObjects[this.slot(pReferent)]) == null || this.getHeaderBit(referent, 1L) != fReachableMarker)) {
            this.f_accessor.setField(weak, 0, 0L);
            if (this.getFieldCount(weak) > 1 && this.f_accessor.getField(weak, 1) != 0L) {
                if (anNotify == null) {
                    anNotify = new int[8];
                } else if (nNotifyTop > anNotify.length) {
                    int[] anWeaksNew = new int[anNotify.length * 2];
                    System.arraycopy(anWeaksNew, 0, anWeaksNew, 0, anNotify.length);
                    anNotify = anWeaksNew;
                }
                anNotify[nNotifyTop] = nWeak;
            }
        }
        return anNotify;
    }

    private void grow() throws OutOfMemoryError {
        int[] anFreeSlots = this.m_anFreeSlots;
        V[] aObjects = this.m_aObjects;
        int capOld = anFreeSlots.length;
        int capNew = capOld * 2;
        if (capNew == 0) {
            capNew = Integer.MAX_VALUE;
        }
        int[] anFreeSlotsNew = new int[capNew];
        Object[] aObjectsNew = new Object[capNew];
        System.arraycopy(aObjects, 0, aObjectsNew, 0, aObjects.length);
        int c = capNew - capOld;
        for (int i = 0; i < c; ++i) {
            anFreeSlotsNew[i] = capOld + i;
        }
        this.m_nTopFree = capNew - capOld;
        this.m_anFreeSlots = anFreeSlotsNew;
        this.m_aObjects = aObjectsNew;
    }

    private long address(int slot) {
        return (long)slot << 32 | 1L;
    }

    private int slot(long address) {
        return (int)(address >>> 32);
    }

    private boolean isLocal(long address) {
        return (address & 1L) == 1L;
    }

    private boolean getHeaderBit(V o, long mask) {
        return (this.f_accessor.getHeader(o) & mask) != 0L;
    }

    private boolean getAndSetHeaderBit(V o, long mask, boolean value) {
        long header = this.f_accessor.getHeader(o);
        if (value) {
            this.f_accessor.setHeader(o, header | mask);
        } else {
            this.f_accessor.setHeader(o, header & (mask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return (header & mask) != 0L;
    }

    private int getFieldCount(V o) {
        return (int)((this.f_accessor.getHeader(o) & 0xFFCL) >>> 2);
    }

    private void setFieldCount(V o, int cFields) {
        if (cFields < 0 || (long)cFields > 1023L) {
            throw new IllegalArgumentException();
        }
        this.f_accessor.setHeader(o, this.f_accessor.getHeader(o) & 0xFFFFFFFFFFFFF003L | (long)cFields << 2);
    }
}

