/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.xBoolean;

public class Identity
extends ClassTemplate {
    public static Identity INSTANCE;
    public static ClassConstant INCEPTION_CLASS;

    public Identity(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
            INCEPTION_CLASS = new NativeRebaseConstant((ClassConstant)structure.getIdentityConstant());
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("equals", null, BOOLEAN);
        this.markNativeMethod("hashCode", null, INT);
        this.invalidateTypeInfo();
    }

    @Override
    protected ClassConstant getInceptionClassConstant() {
        return INCEPTION_CLASS;
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "equals": {
                IdentityHandle hId1 = (IdentityHandle)ahArg[1];
                IdentityHandle hId2 = (IdentityHandle)ahArg[2];
                return frame.assignValue(iReturn, xBoolean.makeHandle(hId1.m_hValue == hId2.m_hValue));
            }
            case "hashCode": {
                IdentityHandle hId = (IdentityHandle)ahArg[1];
                return frame.assignValue(iReturn, xInt64.makeHandle(hId.hashCode()));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        IdentityHandle hId1 = (IdentityHandle)hValue1;
        IdentityHandle hId2 = (IdentityHandle)hValue2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(hId1.m_hValue == hId2.m_hValue));
    }

    public static IdentityHandle ensureIdentity(ObjectHandle h) {
        return new IdentityHandle(INSTANCE.getCanonicalClass(), h);
    }

    public static class IdentityHandle
    extends ObjectHandle {
        private final ObjectHandle m_hValue;

        protected IdentityHandle(ClassComposition clzIdentity, ObjectHandle hValue) {
            super(clzIdentity);
            this.m_hValue = hValue;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.m_hValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof IdentityHandle)) return false;
            IdentityHandle that = (IdentityHandle)obj;
            if (this.m_hValue != that.m_hValue) return false;
            return true;
        }
    }
}

