/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template;

import java.util.function.Consumer;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.reflect.xVar;

public interface IndexSupport {
    public int extractArrayValue(Frame var1, ObjectHandle var2, long var3, int var5);

    public int assignArrayValue(Frame var1, ObjectHandle var2, long var3, ObjectHandle var5);

    public TypeConstant getElementType(Frame var1, ObjectHandle var2, long var3) throws ObjectHandle.ExceptionHandle.WrapperException;

    public long size(ObjectHandle var1);

    default public int makeRef(Frame frame, ObjectHandle hTarget, long lIndex, boolean fReadOnly, int iReturn) {
        try {
            TypeConstant typeEl = this.getElementType(frame, hTarget, lIndex);
            TypeComposition clzRef = fReadOnly ? xRef.INSTANCE.ensureParameterizedClass(frame.f_context.f_container, typeEl) : xVar.INSTANCE.ensureParameterizedClass(frame.f_context.f_container, typeEl);
            xRef.IndexedRefHandle hRef = new xRef.IndexedRefHandle(clzRef, hTarget, lIndex);
            return frame.assignValue(iReturn, hRef);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    default public int invokePreInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ObjectHandle hValue;
        switch (this.extractArrayValue(frame, hTarget, lIndex, -1)) {
            case -1: {
                hValue = frame.popStack();
                break;
            }
            case -3: {
                return -3;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (hValue.getOpSupport().invokeNext(frame, hValue, -1)) {
            case -1: {
                ObjectHandle hValueNew = frame.popStack();
                return this.assignArrayValue(frame, hTarget, lIndex, hValueNew) == -3 ? -3 : frame.assignValue(iReturn, hValueNew);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    ObjectHandle hValueNew = frameCaller.popStack();
                    return this.assignArrayValue(frameCaller, hTarget, lIndex, hValueNew) == -3 ? -3 : frameCaller.assignValue(iReturn, hValueNew);
                });
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    default public int invokePostInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ObjectHandle hValue;
        switch (this.extractArrayValue(frame, hTarget, lIndex, -1)) {
            case -1: {
                hValue = frame.popStack();
                break;
            }
            case -3: {
                return -3;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (hValue.getOpSupport().invokeNext(frame, hValue, -1)) {
            case -1: {
                return this.assignArrayValue(frame, hTarget, lIndex, frame.popStack()) == -3 ? -3 : frame.assignValue(iReturn, hValue);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> this.assignArrayValue(frameCaller, hTarget, lIndex, frameCaller.popStack()) == -3 ? -3 : frameCaller.assignValue(iReturn, hValue));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    default public int invokePreDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ObjectHandle hValue;
        switch (this.extractArrayValue(frame, hTarget, lIndex, -1)) {
            case -1: {
                hValue = frame.popStack();
                break;
            }
            case -3: {
                return -3;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (hValue.getOpSupport().invokePrev(frame, hValue, -1)) {
            case -1: {
                ObjectHandle hValueNew = frame.popStack();
                return this.assignArrayValue(frame, hTarget, lIndex, hValueNew) == -3 ? -3 : frame.assignValue(iReturn, hValueNew);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    ObjectHandle hValueNew = frameCaller.popStack();
                    return this.assignArrayValue(frameCaller, hTarget, lIndex, hValueNew) == -3 ? -3 : frameCaller.assignValue(iReturn, hValueNew);
                });
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    default public int invokePostDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ObjectHandle hValue;
        switch (this.extractArrayValue(frame, hTarget, lIndex, -1)) {
            case -1: {
                hValue = frame.popStack();
                break;
            }
            case -3: {
                return -3;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (hValue.getOpSupport().invokePrev(frame, hValue, -1)) {
            case -1: {
                return this.assignArrayValue(frame, hTarget, lIndex, frame.popStack()) == -3 ? -3 : frame.assignValue(iReturn, hValue);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> this.assignArrayValue(frameCaller, hTarget, lIndex, frame.popStack()) == -3 ? -3 : frameCaller.assignValue(iReturn, hValue));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    default public ObjectHandle[] toArray(Frame frame, ObjectHandle hTarget) throws ObjectHandle.ExceptionHandle.WrapperException {
        int cValues = (int)this.size(hTarget);
        ObjectHandle[] ahValue = new ObjectHandle[cValues];
        block4: for (int i = 0; i < cValues; ++i) {
            switch (this.extractArrayValue(frame, hTarget, i, -1)) {
                case -1: {
                    ahValue[i] = frame.popStack();
                    continue block4;
                }
                case -3: {
                    throw frame.m_hException.getException();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return ahValue;
    }

    default public void forEach(Frame frame, ObjectHandle hTarget, Consumer<ObjectHandle> consumer) throws ObjectHandle.ExceptionHandle.WrapperException {
        int cValues = (int)this.size(hTarget);
        block4: for (int i = 0; i < cValues; ++i) {
            switch (this.extractArrayValue(frame, hTarget, i, -1)) {
                case -1: {
                    consumer.accept(frame.popStack());
                    continue block4;
                }
                case -3: {
                    throw frame.m_hException.getException();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

