/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template;

import java.util.Arrays;
import java.util.Map;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ProxyComposition;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xObject;
import org.xvm.runtime.template.xService;

public class Proxy
extends xService {
    public static Proxy INSTANCE;

    public Proxy(Container container) {
        super(container, xObject.INSTANCE.getStructure(), false);
        INSTANCE = this;
    }

    @Override
    public void initNative() {
    }

    @Override
    public ClassComposition ensureClass(Container container, TypeConstant typeActual) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahArg, int iReturn) {
        throw new IllegalStateException();
    }

    @Override
    public ObjectHandle createStruct(Frame frame, TypeComposition clazz) {
        throw new IllegalStateException();
    }

    @Override
    public int createProxyHandle(Frame frame, ServiceContext ctxTarget, ObjectHandle hTarget, TypeConstant typeProxy) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        if (ctxTarget != hProxy.f_context) {
            return frame.raiseException("Out of context \"" + hProxy.f_context.f_sName + "\" service");
        }
        if (hProxy.getType().equals(typeProxy)) {
            return frame.assignValue(-1, hProxy);
        }
        ProxyComposition clzProxy = new ProxyComposition(hProxy.getComposition().getOrigin(), typeProxy);
        return frame.assignValue(-1, Proxy.makeHandle(clzProxy, ctxTarget, hProxy.getTarget(), hProxy.f_fStrict));
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        return frame.f_context == hProxy.f_context ? hTarget.getTemplate().invokeNative1(frame, method, hTarget, hArg, iReturn) : this.makeAsyncNativeHandle(hTarget, method).call1(frame, hProxy, new ObjectHandle[]{hArg}, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        return frame.f_context == hProxy.f_context ? hTarget.getTemplate().invokeNativeN(frame, method, hTarget, ahArg, iReturn) : this.makeAsyncNativeHandle(hTarget, method).call1(frame, hProxy, ahArg, iReturn);
    }

    @Override
    public int invoke1(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        return frame.f_context == hProxy.f_context ? hTarget.getTemplate().invoke1(frame, chain, hTarget, ahVar, iReturn) : this.makeAsyncHandle(hProxy, chain).call1(frame, hProxy, ahVar, iReturn);
    }

    @Override
    public int invokeT(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        return frame.f_context == hProxy.f_context ? hTarget.getTemplate().invokeT(frame, chain, hTarget, ahVar, iReturn) : this.makeAsyncHandle(hProxy, chain).callT(frame, hProxy, ahVar, iReturn);
    }

    @Override
    public int invokeN(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        return frame.f_context == hProxy.f_context ? hTarget.getTemplate().invokeN(frame, chain, hTarget, ahVar, aiReturn) : this.makeAsyncHandle(hProxy, chain).callN(frame, hProxy, ahVar, aiReturn);
    }

    @Override
    public int getPropertyValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        ClassTemplate template = hTarget.getTemplate();
        return frame.f_context == hProxy.f_context ? template.getPropertyValue(frame, hTarget, idProp, iReturn) : hProxy.f_context.sendProperty01Request(frame, hTarget, idProp, iReturn, template::getPropertyValue);
    }

    @Override
    public int getFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        if (frame.f_context == hProxy.f_context) {
            return hTarget.getTemplate().getFieldValue(frame, hTarget, idProp, iReturn);
        }
        throw new IllegalStateException("Invalid context");
    }

    @Override
    public int setPropertyValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        ClassTemplate template = hTarget.getTemplate();
        return frame.f_context == hProxy.f_context ? template.setPropertyValue(frame, hTarget, idProp, hValue) : hProxy.f_context.sendProperty10Request(frame, hTarget, idProp, hValue, template::setPropertyValue);
    }

    @Override
    public int setFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        if (frame.f_context == hProxy.f_context) {
            return hTarget.getTemplate().setFieldValue(frame, hTarget, idProp, hValue);
        }
        throw new IllegalStateException("Invalid context");
    }

    @Override
    public int createPropertyRef(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, boolean fRO, int iReturn) {
        ProxyHandle hProxy = (ProxyHandle)hTarget;
        hTarget = hProxy.f_hTarget;
        if (frame.f_context == hProxy.f_context) {
            return hTarget.getTemplate().createPropertyRef(frame, hTarget, idProp, fRO, iReturn);
        }
        throw new IllegalStateException("Invalid context");
    }

    public static ProxyHandle makeHandle(ProxyComposition clzProxy, ServiceContext ctx, ObjectHandle hTarget, Boolean fStrict) {
        return new ProxyHandle(clzProxy, ctx, hTarget, fStrict);
    }

    private xRTFunction.FunctionHandle makeAsyncNativeHandle(final ObjectHandle hTarget, MethodStructure method) {
        return new xRTFunction.AsyncHandle(this, Proxy.INSTANCE.f_container, method){

            @Override
            protected ObjectHandle getContextTarget(Frame frame, ObjectHandle hService) {
                return hTarget;
            }
        };
    }

    private xRTFunction.FunctionHandle makeAsyncHandle(final ProxyHandle hProxy, CallChain chain) {
        final ObjectHandle hTarget = hProxy.f_hTarget;
        return new xRTFunction.AsyncHandle(this, hTarget.getComposition().getContainer(), chain){

            @Override
            protected ObjectHandle getContextTarget(Frame frame, ObjectHandle hService) {
                return hTarget;
            }

            @Override
            protected int call1Impl(Frame frame, ObjectHandle hTarget2, ObjectHandle[] ahVar, int iReturn) {
                assert (hTarget2.isService());
                if (frame.f_context == hTarget2.getService().f_context) {
                    switch (super.call1Impl(frame, hTarget2, ahVar, -1)) {
                        case -1: {
                            return this.convertResult(frame, hProxy, iReturn);
                        }
                        case -5: {
                            Frame.Continuation stepNext = frameCaller -> this.convertResult(frameCaller, hProxy, iReturn);
                            frame.m_frameNext.addContinuation(stepNext);
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }
                return super.call1Impl(frame, hTarget2, ahVar, iReturn);
            }

            @Override
            protected int callTImpl(Frame frame, ObjectHandle hTarget2, ObjectHandle[] ahVar, int iReturn) {
                assert (hTarget2.isService());
                if (frame.f_context == hTarget2.getService().f_context) {
                    switch (super.callTImpl(frame, hTarget2, ahVar, -1)) {
                        case -1: {
                            return this.convertTupleResult(frame, hProxy, iReturn);
                        }
                        case -5: {
                            Frame.Continuation stepNext = frameCaller -> this.convertTupleResult(frameCaller, hProxy, iReturn);
                            frame.m_frameNext.addContinuation(stepNext);
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }
                return super.callTImpl(frame, hTarget2, ahVar, iReturn);
            }

            @Override
            protected int callNImpl(Frame frame, ObjectHandle hTarget2, ObjectHandle[] ahVar, int[] aiReturn) {
                assert (hTarget2.isService());
                if (frame.f_context == hTarget2.getService().f_context) {
                    int[] aiStack = new int[aiReturn.length];
                    Arrays.fill(aiStack, -1);
                    switch (super.callNImpl(frame, hTarget2, ahVar, aiStack)) {
                        case -1: {
                            return this.convertResults(frame, this.getMethod(), hProxy, aiReturn);
                        }
                        case -5: {
                            Frame.Continuation stepNext = frameCaller -> this.convertResults(frameCaller, this.getMethod(), hProxy, aiReturn);
                            frame.m_frameNext.addContinuation(stepNext);
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }
                return super.callNImpl(frame, hTarget2, ahVar, aiReturn);
            }

            private int convertResult(Frame frame, ProxyHandle hProxy2, int iReturn) {
                return frame.assignValue(iReturn, this.convertValue(hProxy2, frame.popStack()));
            }

            private int convertTupleResult(Frame frame, ProxyHandle hProxy2, int iReturn) {
                ObjectHandle[] ahValueOld;
                xTuple.TupleHandle hTuple = (xTuple.TupleHandle)frame.popStack();
                ObjectHandle[] ahValueNew = ahValueOld = hTuple.m_ahValue;
                int c = ahValueOld.length;
                for (int i = 0; i < c; ++i) {
                    ObjectHandle hValueOld = ahValueOld[i];
                    ObjectHandle hValueNew = this.convertValue(hProxy2, hValueOld);
                    if (hValueNew == hValueOld) continue;
                    if (ahValueNew == ahValueOld) {
                        ahValueNew = (ObjectHandle[])ahValueOld.clone();
                    }
                    ahValueNew[i] = hValueNew;
                }
                if (ahValueNew != ahValueOld) {
                    hTuple = xTuple.makeHandle(hTuple.getComposition(), ahValueNew);
                }
                return frame.assignValue(iReturn, hTuple);
            }

            private int convertResults(Frame frame, MethodStructure method, ProxyHandle hProxy2, int[] aiReturn) {
                int cReturns = aiReturn.length;
                ObjectHandle[] ahReturn = new ObjectHandle[cReturns];
                for (int i = cReturns - 1; i >= 0; --i) {
                    ObjectHandle hReturn = frame.popStack();
                    if (hReturn == xBoolean.FALSE && i == cReturns - 1 && method.isConditionalReturn()) {
                        return frame.assignValue(aiReturn[0], hReturn);
                    }
                    ahReturn[i] = this.convertValue(hProxy2, hReturn);
                }
                return frame.assignValues(aiReturn, ahReturn);
            }

            private ObjectHandle convertValue(ProxyHandle hProxy2, ObjectHandle hResult) {
                ObjectHandle hTarget2 = hProxy2.f_hTarget;
                if (hResult == hTarget2) {
                    hResult = hProxy2;
                }
                return hResult;
            }
        };
    }

    public static class ProxyHandle
    extends xService.ServiceHandle {
        protected final ObjectHandle f_hTarget;
        protected final boolean f_fStrict;

        protected ProxyHandle(ProxyComposition clazz, ServiceContext context, ObjectHandle hTarget, boolean fStrict) {
            super(clazz, context);
            this.f_hTarget = hTarget;
            this.f_fStrict = fStrict;
        }

        public ObjectHandle getTarget() {
            return this.f_hTarget;
        }

        @Override
        public ProxyComposition getComposition() {
            return (ProxyComposition)super.getComposition();
        }

        @Override
        public TypeConstant getUnsafeType() {
            return this.f_fStrict ? super.getUnsafeType() : this.f_hTarget.getUnsafeType();
        }

        @Override
        public ObjectHandle cloneAs(TypeComposition clazz) {
            return this.f_hTarget.cloneAs(clazz);
        }

        @Override
        public boolean isPassThrough(Container container) {
            return container == null || container != this.getOwner();
        }

        @Override
        public boolean isShared(Container container, Map<ObjectHandle, Boolean> mapVisited) {
            return true;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProxyHandle)) return false;
            ProxyHandle that = (ProxyHandle)obj;
            if (this.f_hTarget != that.f_hTarget) return false;
            return true;
        }

        @Override
        public String toString() {
            return "Proxy: " + this.f_hTarget.toString() + (String)(this.f_fStrict ? " as " + this.getType().getValueString() : "");
        }
    }
}

