/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import java.util.Arrays;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.BitView;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;

public abstract class BitBasedDelegate
extends ByteBasedDelegate
implements BitView {
    protected BitBasedDelegate(Container container, ClassStructure structure) {
        super(container, structure, (byte)0, (byte)1);
    }

    @Override
    public xRTDelegate.DelegateHandle createDelegate(Container container, TypeConstant typeElement, int cSize, ObjectHandle[] ahContent, xArray.Mutability mutability) {
        byte[] ab = new byte[BitBasedDelegate.storage(cSize)];
        int c = ahContent.length;
        for (int i = 0; i < c; ++i) {
            if (!this.isSet(ahContent[i])) continue;
            int n = BitBasedDelegate.index(i);
            ab[n] = (byte)(ab[n] | BitBasedDelegate.bitMask(i));
        }
        return new BitArrayHandle(this.getCanonicalClass(), ab, cSize, mutability);
    }

    @Override
    public int invokePreInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        if (BitBasedDelegate.getBit(hDelegate.m_abValue, lIndex)) {
            return this.overflow(frame);
        }
        BitBasedDelegate.setBit(hDelegate.m_abValue, lIndex, true);
        return frame.assignValue(iReturn, this.makeBitHandle(true));
    }

    @Override
    public int invokePreDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        if (!BitBasedDelegate.getBit(hDelegate.m_abValue, lIndex)) {
            return this.overflow(frame);
        }
        BitBasedDelegate.setBit(hDelegate.m_abValue, lIndex, false);
        return frame.assignValue(iReturn, this.makeBitHandle(false));
    }

    @Override
    public int invokePostInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        if (BitBasedDelegate.getBit(hDelegate.m_abValue, lIndex)) {
            return this.overflow(frame);
        }
        BitBasedDelegate.setBit(hDelegate.m_abValue, lIndex, true);
        return frame.assignValue(iReturn, this.makeBitHandle(false));
    }

    @Override
    public int invokePostDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        if (!BitBasedDelegate.getBit(hDelegate.m_abValue, lIndex)) {
            return this.overflow(frame);
        }
        BitBasedDelegate.setBit(hDelegate.m_abValue, lIndex, false);
        return frame.assignValue(iReturn, this.makeBitHandle(true));
    }

    @Override
    public xRTDelegate.DelegateHandle fill(xRTDelegate.DelegateHandle hTarget, int cSize, ObjectHandle hValue) {
        assert (cSize > 0);
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        byte[] ab = hDelegate.m_abValue;
        if (this.isSet(hValue)) {
            int ix = BitBasedDelegate.index(cSize - 1);
            if (ix > 0) {
                Arrays.fill(ab, 0, ix - 1, (byte)1);
            }
            ab[ix] = BitBasedDelegate.tailMask(cSize - 1);
            if (ix + 1 < ab.length) {
                Arrays.fill(ab, ix + 1, ab.length - 1, (byte)0);
            }
        } else {
            Arrays.fill(ab, 0, ab.length - 1, (byte)0);
        }
        hDelegate.m_cSize = cSize;
        return hDelegate;
    }

    @Override
    public int getPropertyCapacity(Frame frame, ObjectHandle hTarget, int iReturn) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle((long)hDelegate.m_abValue.length << 3));
    }

    @Override
    public int setPropertyCapacity(Frame frame, ObjectHandle hTarget, long nCapacity) {
        return super.setPropertyCapacity(frame, hTarget, BitBasedDelegate.storage(nCapacity));
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        byte[] abBits = this.getBits(hDelegate, ofStart, cSize, fReverse);
        return new BitArrayHandle(hDelegate.getComposition(), abBits, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        return frame.assignValue(iReturn, this.makeBitHandle(BitBasedDelegate.getBit(hDelegate.m_abValue, lIndex)));
    }

    @Override
    protected int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (lIndex >= cSize) {
            if (BitBasedDelegate.index(lIndex) >= abValue.length) {
                abValue = hDelegate.m_abValue = BitBasedDelegate.grow(abValue, BitBasedDelegate.storage(lIndex + 1L));
            }
            hDelegate.m_cSize = lIndex + 1L;
        }
        BitBasedDelegate.setBit(abValue, (int)lIndex, this.isSet(hValue));
        return -1;
    }

    @Override
    protected void insertElementImpl(xRTDelegate.DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (BitBasedDelegate.storage(cSize + 1L) > abValue.length) {
            abValue = hDelegate.m_abValue = BitBasedDelegate.grow(hDelegate.m_abValue, BitBasedDelegate.storage(cSize) + 1);
        }
        ++hDelegate.m_cSize;
        if (lIndex < cSize) {
            for (long i = lIndex + 1L; i < cSize; ++i) {
                BitBasedDelegate.setBit(abValue, i, BitBasedDelegate.getBit(abValue, i - 1L));
            }
        }
        BitBasedDelegate.setBit(abValue, lIndex, this.isSet(hElement));
    }

    @Override
    protected void deleteElementImpl(xRTDelegate.DelegateHandle hTarget, long lIndex) {
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (lIndex < cSize - 1L) {
            for (long i = lIndex + 1L; i < cSize; ++i) {
                BitBasedDelegate.setBit(abValue, i - 1L, BitBasedDelegate.getBit(abValue, i));
            }
        }
        BitBasedDelegate.setBit(abValue, --hDelegate.m_cSize, false);
    }

    @Override
    protected void deleteRangeImpl(xRTDelegate.DelegateHandle hTarget, long lIndex, long cDelete) {
        long i;
        BitArrayHandle hDelegate = (BitArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (lIndex < cSize - cDelete) {
            for (i = lIndex + cDelete; i < cSize; ++i) {
                BitBasedDelegate.setBit(abValue, i - cDelete, BitBasedDelegate.getBit(abValue, i));
            }
        }
        for (i = cSize - cDelete; i < cSize; ++i) {
            BitBasedDelegate.setBit(abValue, i, false);
        }
        hDelegate.m_cSize -= cDelete;
    }

    @Override
    public byte[] getBits(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBits, boolean fReverse) {
        BitArrayHandle hBits = (BitArrayHandle)hDelegate;
        byte[] ab = hBits.m_abValue;
        if (hBits.getMutability() == xArray.Mutability.Constant && ofStart == 0L && cBits == (long)ab.length << 3 && !fReverse) {
            return ab;
        }
        byte[] abBits = BitBasedDelegate.extractBits(ab, ofStart, cBits);
        return fReverse ? BitBasedDelegate.reverseBits(abBits, cBits) : abBits;
    }

    @Override
    public boolean extractBit(xRTDelegate.DelegateHandle hDelegate, long of) {
        BitArrayHandle hBits = (BitArrayHandle)hDelegate;
        return BitBasedDelegate.getBit(hBits.m_abValue, (int)of);
    }

    @Override
    public void assignBit(xRTDelegate.DelegateHandle hDelegate, long of, boolean fBit) {
        BitArrayHandle hBits = (BitArrayHandle)hDelegate;
        BitBasedDelegate.setBit(hBits.m_abValue, (int)of, fBit);
    }

    public static byte[] reverseBits(byte[] abBits, long cBits) {
        byte[] abValueR = new byte[abBits.length];
        int i = 0;
        while ((long)i < cBits) {
            if (BitBasedDelegate.getBit(abBits, i)) {
                BitBasedDelegate.setBit(abValueR, cBits - 1L - (long)i, true);
            }
            ++i;
        }
        return abValueR;
    }

    public static int storage(long cBits) {
        return (int)((cBits - 1L) / 8L + 1L);
    }

    public static boolean getBit(byte[] abValue, long iIndex) {
        return (abValue[BitBasedDelegate.index(iIndex)] & BitBasedDelegate.bitMask(iIndex)) != 0;
    }

    public static void setBit(byte[] abValue, long iIndex, boolean fSet) {
        if (fSet) {
            int n = BitBasedDelegate.index(iIndex);
            abValue[n] = (byte)(abValue[n] | BitBasedDelegate.bitMask(iIndex));
        } else {
            int n = BitBasedDelegate.index(iIndex);
            abValue[n] = (byte)(abValue[n] & (byte)(~BitBasedDelegate.bitMask(iIndex)));
        }
    }

    protected static byte[] extractBits(byte[] abSrc, long ofStart, long cBits) {
        byte[] abDst;
        int cBytes = BitBasedDelegate.storage(cBits);
        if (ofStart == 0L) {
            abDst = Arrays.copyOfRange(abSrc, 0, cBytes);
        } else {
            abDst = new byte[cBytes];
            int i = 0;
            while ((long)i < cBits) {
                if (BitBasedDelegate.getBit(abSrc, i + (int)ofStart)) {
                    BitBasedDelegate.setBit(abDst, i, true);
                }
                ++i;
            }
        }
        return abDst;
    }

    private static int index(long iBit) {
        return (int)(iBit / 8L);
    }

    private static byte bitMask(long iBit) {
        return (byte)(128 >>> (int)(iBit & 7L));
    }

    public static byte tailMask(long iBit) {
        return (byte)(128 >> (int)(iBit & 7L));
    }

    @Override
    protected ObjectHandle makeElementHandle(long lValue) {
        throw new IllegalStateException();
    }

    protected abstract boolean isSet(ObjectHandle var1);

    protected abstract ObjectHandle makeBitHandle(boolean var1);

    public static class BitArrayHandle
    extends ByteBasedDelegate.ByteArrayHandle {
        public BitArrayHandle(TypeComposition clazz, byte[] abValue, long cSize, xArray.Mutability mutability) {
            super(clazz, abValue, cSize, mutability);
        }

        @Override
        public long getBitCount() {
            return this.m_cSize;
        }

        @Override
        protected void purgeUnusedSpace() {
            byte[] ab = this.m_abValue;
            int c = BitBasedDelegate.storage(this.m_cSize);
            if (ab.length != c) {
                byte[] abNew = new byte[c];
                System.arraycopy(ab, 0, abNew, 0, c);
                this.m_abValue = abNew;
            }
        }

        @Override
        public int compareTo(ObjectHandle that) {
            byte[] abThis = this.m_abValue;
            long cThis = this.m_cSize;
            byte[] abThat = ((BitArrayHandle)that).m_abValue;
            long cThat = ((BitArrayHandle)that).m_cSize;
            if (cThis != cThat) {
                return (int)(cThis - cThat);
            }
            int c = BitBasedDelegate.storage(cThis);
            for (int i = 0; i < c; ++i) {
                int iDiff = abThis[i] - abThat[i];
                if (iDiff == 0) continue;
                return iDiff < 0 ? -1 : 1;
            }
            return 0;
        }
    }
}

