/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import org.xvm.asm.ClassStructure;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.BitBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.BitView;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTBitDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTSlicingDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTView;
import org.xvm.runtime.template._native.collections.arrays.xRTViewToBit;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xBit;

public abstract class ByteBasedBitView
extends xRTViewToBit
implements BitView {
    public ByteBasedBitView(Container container, ClassStructure structure) {
        super(container, structure, false);
    }

    @Override
    public xRTDelegate.DelegateHandle createBitViewDelegate(xRTDelegate.DelegateHandle hSource, xArray.Mutability mutability) {
        xRTDelegate.DelegateHandle delegateHandle;
        ClassComposition clzView = this.getCanonicalClass();
        if (hSource instanceof xRTSlicingDelegate.SliceHandle) {
            xRTDelegate.DelegateHandle delegateHandle2;
            xRTDelegate.DelegateHandle hView;
            xRTSlicingDelegate.SliceHandle hSlice = (xRTSlicingDelegate.SliceHandle)hSource;
            hSource = hSlice.f_hSource;
            if (hSource instanceof xRTView.ViewHandle) {
                hView = (xRTView.ViewHandle)hSource;
                hSource = hView.unwrapSource();
            }
            if (hSource instanceof ByteBasedDelegate.ByteArrayHandle) {
                ByteBasedDelegate.ByteArrayHandle hBytes = (ByteBasedDelegate.ByteArrayHandle)hSource;
                delegateHandle2 = new ViewHandle(clzView, hBytes, hBytes.getBitCount(), mutability);
            } else {
                delegateHandle2 = xRTViewToBit.INSTANCE.createBitViewDelegate(hSource, mutability);
            }
            hView = delegateHandle2;
            return this.slice(hView, hSlice.f_ofStart * 8L, hSlice.m_cSize * 8L, false);
        }
        if (hSource instanceof xRTView.ViewHandle) {
            xRTView.ViewHandle hView = (xRTView.ViewHandle)hSource;
            hSource = hView.unwrapSource();
        }
        if (hSource instanceof ByteBasedDelegate.ByteArrayHandle) {
            ByteBasedDelegate.ByteArrayHandle hBytes = (ByteBasedDelegate.ByteArrayHandle)hSource;
            delegateHandle = new ViewHandle(clzView, hBytes, hBytes.getBitCount(), mutability);
        } else {
            delegateHandle = xRTViewToBit.INSTANCE.createBitViewDelegate(hSource, mutability);
        }
        return delegateHandle;
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        ViewHandle hView = (ViewHandle)hTarget;
        byte[] abBits = this.getBits(hView, ofStart, cSize, fReverse);
        return xRTBitDelegate.INSTANCE.makeHandle(abBits, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        ViewHandle hView = (ViewHandle)hTarget;
        return frame.assignValue(iReturn, xBit.makeHandle(BitBasedDelegate.getBit(hView.f_hSource.m_abValue, lIndex)));
    }

    @Override
    public int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        ViewHandle hView = (ViewHandle)hTarget;
        BitBasedDelegate.setBit(hView.f_hSource.m_abValue, lIndex, ((ObjectHandle.JavaLong)hValue).getValue() != 0L);
        return -1;
    }

    @Override
    public byte[] getBits(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBits, boolean fReverse) {
        ViewHandle hView = (ViewHandle)hDelegate;
        byte[] abBits = BitBasedDelegate.extractBits(hView.f_hSource.m_abValue, ofStart, cBits);
        if (fReverse) {
            abBits = BitBasedDelegate.reverseBits(abBits, cBits);
        }
        return abBits;
    }

    @Override
    public boolean extractBit(xRTDelegate.DelegateHandle hDelegate, long of) {
        ViewHandle hView = (ViewHandle)hDelegate;
        return BitBasedDelegate.getBit(hView.f_hSource.m_abValue, of);
    }

    @Override
    public void assignBit(xRTDelegate.DelegateHandle hDelegate, long of, boolean fBit) {
        ViewHandle hView = (ViewHandle)hDelegate;
        BitBasedDelegate.setBit(hView.f_hSource.m_abValue, of, fBit);
    }

    @Override
    public byte[] getBytes(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBytes, boolean fReverse) {
        return this.getBits(hDelegate, ofStart * 8L, cBytes * 8L, fReverse);
    }

    @Override
    public byte extractByte(xRTDelegate.DelegateHandle hDelegate, long of) {
        ViewHandle hView = (ViewHandle)hDelegate;
        return hView.f_hSource.m_abValue[(int)of];
    }

    @Override
    public void assignByte(xRTDelegate.DelegateHandle hDelegate, long of, byte bValue) {
        ViewHandle hView = (ViewHandle)hDelegate;
        hView.f_hSource.m_abValue[(int)of] = bValue;
    }

    protected static class ViewHandle
    extends xRTView.ViewHandle {
        protected final ByteBasedDelegate.ByteArrayHandle f_hSource;

        protected ViewHandle(TypeComposition clazz, ByteBasedDelegate.ByteArrayHandle hSource, long cSize, xArray.Mutability mutability) {
            super(clazz, mutability);
            this.f_hSource = hSource;
            this.m_cSize = cSize;
        }

        @Override
        public xRTDelegate.DelegateHandle getSource() {
            return this.f_hSource;
        }
    }
}

