/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.ByteView;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public abstract class ByteBasedDelegate
extends xRTDelegate
implements ByteView {
    private final byte f_bMinValue;
    private final byte f_bMaxValue;

    public ByteBasedDelegate(Container container, ClassStructure structure, byte bMinValue, byte bMaxValue) {
        super(container, structure, false);
        this.f_bMinValue = bMinValue;
        this.f_bMaxValue = bMaxValue;
    }

    @Override
    public xRTDelegate.DelegateHandle createDelegate(Container container, TypeConstant typeElement, int cSize, ObjectHandle[] ahContent, xArray.Mutability mutability) {
        byte[] ab = new byte[cSize];
        int c = ahContent.length;
        for (int i = 0; i < c; ++i) {
            ab[i] = (byte)((ObjectHandle.JavaLong)ahContent[i]).getValue();
        }
        return this.makeHandle(ab, cSize, mutability);
    }

    @Override
    public xRTDelegate.DelegateHandle fill(xRTDelegate.DelegateHandle hTarget, int cSize, ObjectHandle hValue) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        Arrays.fill(hDelegate.m_abValue, 0, cSize, (byte)((ObjectHandle.JavaLong)hValue).getValue());
        hDelegate.m_cSize = cSize;
        return hDelegate;
    }

    @Override
    public int getPropertyCapacity(Frame frame, ObjectHandle hTarget, int iReturn) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle(hDelegate.m_abValue.length));
    }

    @Override
    public int setPropertyCapacity(Frame frame, ObjectHandle hTarget, long nCapacity) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        byte[] abOld = hDelegate.m_abValue;
        int nSize = (int)hDelegate.m_cSize;
        if (nCapacity < (long)nSize) {
            return frame.raiseException(xException.illegalArgument(frame, "Capacity cannot be less then size"));
        }
        int nCapacityOld = abOld.length;
        if (nCapacity > (long)nCapacityOld) {
            byte[] abNew = new byte[(int)nCapacity];
            System.arraycopy(abOld, 0, abNew, 0, abOld.length);
            hDelegate.m_abValue = abNew;
        }
        return -1;
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        byte[] abValue = Arrays.copyOfRange(hDelegate.m_abValue, (int)ofStart, (int)(ofStart + cSize));
        if (fReverse) {
            abValue = ByteBasedDelegate.reverseBytes(abValue, (int)cSize);
        }
        return new ByteArrayHandle(hDelegate.getComposition(), abValue, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        byte b = hDelegate.m_abValue[(int)lIndex];
        return frame.assignValue(iReturn, this.makeElementHandle(b));
    }

    @Override
    protected int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        int nIndex = (int)lIndex;
        if (nIndex >= cSize) {
            if (nIndex >= abValue.length) {
                abValue = hDelegate.m_abValue = ByteBasedDelegate.grow(abValue, nIndex + 1);
            }
            hDelegate.m_cSize = nIndex + 1;
        }
        abValue[nIndex] = (byte)((ObjectHandle.JavaLong)hValue).getValue();
        return -1;
    }

    @Override
    protected void insertElementImpl(xRTDelegate.DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        byte bValue = (byte)((ObjectHandle.JavaLong)hElement).getValue();
        if (cSize == abValue.length) {
            abValue = hDelegate.m_abValue = ByteBasedDelegate.grow(hDelegate.m_abValue, cSize + 1);
        }
        ++hDelegate.m_cSize;
        int nIndex = (int)lIndex;
        if (nIndex < cSize) {
            System.arraycopy(abValue, nIndex, abValue, nIndex + 1, cSize - nIndex);
        }
        abValue[nIndex] = bValue;
    }

    @Override
    protected void deleteElementImpl(xRTDelegate.DelegateHandle hTarget, long lIndex) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (lIndex < (long)(cSize - 1)) {
            int nIndex = (int)lIndex;
            System.arraycopy(abValue, nIndex + 1, abValue, nIndex, cSize - nIndex - 1);
        }
        abValue[(int)(--hDelegate.m_cSize)] = 0;
    }

    @Override
    protected void deleteRangeImpl(xRTDelegate.DelegateHandle hTarget, long lIndex, long cDelete) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        int nIndex = (int)lIndex;
        int nDelete = (int)cDelete;
        if (nIndex < cSize - nDelete) {
            System.arraycopy(abValue, nIndex + 1, abValue, nIndex, cSize - nIndex - nDelete);
        }
        Arrays.fill(abValue, cSize - nDelete, cSize, (byte)0);
        hDelegate.m_cSize -= cDelete;
    }

    @Override
    public int invokeIndexOf(Frame frame, xRTDelegate.DelegateHandle hTarget, xRTDelegate.DelegateHandle hThat, int ofStart, int[] aiReturn) {
        byte[] abThis = ((ByteArrayHandle)hTarget).m_abValue;
        byte[] abThat = ((ByteArrayHandle)hThat).m_abValue;
        int cbThis = abThis.length;
        int cbThat = abThat.length;
        ofStart = Math.max(ofStart, 0);
        if (cbThat == 0) {
            return ofStart > cbThis ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, xInt64.makeHandle(ofStart));
        }
        if (ofStart > cbThis - cbThat) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        byte bFirstMatch = abThat[0];
        int stopAt = cbThis - cbThat;
        block0: for (int of = ofStart; of <= stopAt; ++of) {
            if (abThis[of] != bFirstMatch) continue;
            for (int i = 1; i < cbThat; ++i) {
                if (abThis[of + i] != abThat[i]) continue block0;
            }
            return frame.assignValues(aiReturn, xBoolean.TRUE, xInt64.makeHandle(of));
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    @Override
    public byte[] getBytes(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBytes, boolean fReverse) {
        ByteArrayHandle hBytes = (ByteArrayHandle)hDelegate;
        byte[] ab = hBytes.m_abValue;
        if (hBytes.getMutability() == xArray.Mutability.Constant && ofStart == 0L && cBytes == (long)ab.length && !fReverse) {
            return ab;
        }
        ab = Arrays.copyOfRange(ab, (int)ofStart, (int)(ofStart + cBytes));
        return fReverse ? ByteBasedDelegate.reverseBytes(ab, (int)cBytes) : ab;
    }

    @Override
    public byte extractByte(xRTDelegate.DelegateHandle hDelegate, long of) {
        ByteArrayHandle hBytes = (ByteArrayHandle)hDelegate;
        return hBytes.m_abValue[(int)of];
    }

    @Override
    public void assignByte(xRTDelegate.DelegateHandle hDelegate, long of, byte bValue) {
        ByteArrayHandle hBytes = (ByteArrayHandle)hDelegate;
        hBytes.m_abValue[(int)of] = bValue;
    }

    @Override
    public int invokePreInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        byte by = hDelegate.m_abValue[n];
        hDelegate.m_abValue[n] = (byte)(by + 1);
        byte bValue = by;
        if (bValue == this.f_bMaxValue) {
            int n2 = (int)lIndex;
            hDelegate.m_abValue[n2] = (byte)(hDelegate.m_abValue[n2] - 1);
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeElementHandle(bValue + 1));
    }

    @Override
    public int invokePreDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        byte by = hDelegate.m_abValue[n];
        hDelegate.m_abValue[n] = (byte)(by - 1);
        byte bValue = by;
        if (bValue == this.f_bMinValue) {
            int n2 = (int)lIndex;
            hDelegate.m_abValue[n2] = (byte)(hDelegate.m_abValue[n2] + 1);
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeElementHandle(bValue - 1));
    }

    @Override
    public int invokePostInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        byte by = hDelegate.m_abValue[n];
        hDelegate.m_abValue[n] = (byte)(by + 1);
        byte bValue = by;
        if (bValue == this.f_bMaxValue) {
            int n2 = (int)lIndex;
            hDelegate.m_abValue[n2] = (byte)(hDelegate.m_abValue[n2] - 1);
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeElementHandle(bValue));
    }

    @Override
    public int invokePostDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ByteArrayHandle hDelegate = (ByteArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        byte by = hDelegate.m_abValue[n];
        hDelegate.m_abValue[n] = (byte)(by - 1);
        byte bValue = by;
        if (bValue == this.f_bMinValue) {
            int n2 = (int)lIndex;
            hDelegate.m_abValue[n2] = (byte)(hDelegate.m_abValue[n2] + 1);
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeElementHandle(bValue));
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        ByteArrayHandle h1 = (ByteArrayHandle)hValue1;
        ByteArrayHandle h2 = (ByteArrayHandle)hValue2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(Arrays.equals(h1.m_abValue, h2.m_abValue)));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        ByteArrayHandle h1 = (ByteArrayHandle)hValue1;
        ByteArrayHandle h2 = (ByteArrayHandle)hValue2;
        if (h1 == h2) {
            return true;
        }
        return h1.getMutability() == h2.getMutability() && h1.m_cSize == h2.m_cSize && Arrays.equals(h1.m_abValue, h2.m_abValue);
    }

    public ByteBuffer wrap(ByteArrayHandle hTarget, int ofStart, int ofEnd) {
        return ByteBuffer.wrap(hTarget.m_abValue, ofStart, ofEnd);
    }

    public static byte[] reverseBytes(byte[] abValue, int cSize) {
        byte[] abValueR = new byte[cSize];
        for (int i = 0; i < cSize; ++i) {
            abValueR[i] = abValue[cSize - 1 - i];
        }
        return abValueR;
    }

    protected static byte[] grow(byte[] abValue, int cSize) {
        int cCapacity = ByteBasedDelegate.calculateCapacity(abValue.length, cSize);
        byte[] abNew = new byte[cCapacity];
        System.arraycopy(abValue, 0, abNew, 0, abValue.length);
        return abNew;
    }

    protected abstract ObjectHandle makeElementHandle(long var1);

    public ByteArrayHandle makeHandle(byte[] ab, long cSize, xArray.Mutability mutability) {
        return new ByteArrayHandle(this.getCanonicalClass(), ab, cSize, mutability);
    }

    public static class ByteArrayHandle
    extends xRTDelegate.DelegateHandle {
        protected byte[] m_abValue;

        protected ByteArrayHandle(TypeComposition clazz, byte[] abValue, long cSize, xArray.Mutability mutability) {
            super(clazz, mutability);
            this.m_abValue = abValue;
            this.m_cSize = cSize;
        }

        @Override
        public boolean makeImmutable() {
            if (this.isMutable()) {
                this.purgeUnusedSpace();
            }
            return super.makeImmutable();
        }

        public long getBitCount() {
            return this.m_cSize * 8L;
        }

        protected void purgeUnusedSpace() {
            byte[] ab = this.m_abValue;
            int c = (int)this.m_cSize;
            if (ab.length != c) {
                byte[] abNew = new byte[c];
                System.arraycopy(ab, 0, abNew, 0, c);
                this.m_abValue = abNew;
            }
        }

        @Override
        public int compareTo(ObjectHandle that) {
            byte[] abThis = this.m_abValue;
            int cThis = (int)this.m_cSize;
            byte[] abThat = ((ByteArrayHandle)that).m_abValue;
            int cThat = (int)((ByteArrayHandle)that).m_cSize;
            if (cThis != cThat) {
                return cThis - cThat;
            }
            for (int i = 0; i < cThis; ++i) {
                int iDiff = abThis[i] - abThat[i];
                if (iDiff == 0) continue;
                return iDiff;
            }
            return 0;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.m_abValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ByteArrayHandle)) return false;
            ByteArrayHandle that = (ByteArrayHandle)obj;
            if (!Arrays.equals(this.m_abValue, that.m_abValue)) return false;
            return true;
        }
    }
}

