/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import org.xvm.asm.ClassStructure;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.BitBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.BitView;
import org.xvm.runtime.template._native.collections.arrays.LongBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTBitDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTSlicingDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTView;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromBit;
import org.xvm.runtime.template._native.collections.arrays.xRTViewToBit;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xBit;

public abstract class LongBasedBitView
extends xRTViewToBit
implements BitView {
    public static LongBasedBitView INSTANCE;
    protected final int f_nBitsPerValue;

    public LongBasedBitView(Container container, ClassStructure structure, int nBitsPerValue) {
        super(container, structure, false);
        this.f_nBitsPerValue = nBitsPerValue;
    }

    @Override
    public xRTDelegate.DelegateHandle createBitViewDelegate(xRTDelegate.DelegateHandle hSource, xArray.Mutability mutability) {
        ClassComposition clzView = this.getCanonicalClass();
        if (hSource instanceof xRTSlicingDelegate.SliceHandle) {
            xRTSlicingDelegate.SliceHandle hSlice = (xRTSlicingDelegate.SliceHandle)hSource;
            LongBasedDelegate.LongArrayHandle hLong = (LongBasedDelegate.LongArrayHandle)hSlice.f_hSource;
            int cBits = this.getBitsPerValue(hLong);
            ViewHandle hView = new ViewHandle(clzView, hLong, hLong.m_cSize * (long)cBits, mutability);
            return this.slice(hView, hSlice.f_ofStart * (long)cBits, hSlice.m_cSize * (long)cBits, false);
        }
        if (hSource instanceof xRTViewFromBit.ViewHandle) {
            xRTViewFromBit.ViewHandle hView = (xRTViewFromBit.ViewHandle)hSource;
            return new ViewHandle(clzView, (LongBasedDelegate.LongArrayHandle)hView.f_hSource, hSource.m_cSize, mutability);
        }
        LongBasedDelegate.LongArrayHandle hLong = (LongBasedDelegate.LongArrayHandle)hSource;
        int cBits = this.getBitsPerValue(hLong);
        return new ViewHandle(clzView, hLong, hSource.m_cSize * (long)cBits, mutability);
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        ViewHandle hView = (ViewHandle)hTarget;
        byte[] abBits = this.getBits(hView, ofStart, cSize, fReverse);
        return xRTBitDelegate.INSTANCE.makeHandle(abBits, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        ViewHandle hView = (ViewHandle)hTarget;
        return frame.assignValue(iReturn, xBit.makeHandle(LongBasedDelegate.getBit(hView.f_hSource.m_alValue, lIndex)));
    }

    @Override
    public int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        ViewHandle hView = (ViewHandle)hTarget;
        LongBasedDelegate.setBit(hView.f_hSource.m_alValue, lIndex, ((ObjectHandle.JavaLong)hValue).getValue() != 0L);
        return -1;
    }

    @Override
    public byte[] getBits(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBits, boolean fReverse) {
        ViewHandle hView = (ViewHandle)hDelegate;
        byte[] abBits = LongBasedDelegate.extractBits(hView.f_hSource.m_alValue, ofStart, cBits);
        if (fReverse) {
            abBits = BitBasedDelegate.reverseBits(abBits, cBits);
        }
        return abBits;
    }

    @Override
    public boolean extractBit(xRTDelegate.DelegateHandle hDelegate, long of) {
        ViewHandle hView = (ViewHandle)hDelegate;
        return LongBasedDelegate.getBit(hView.f_hSource.m_alValue, of);
    }

    @Override
    public void assignBit(xRTDelegate.DelegateHandle hDelegate, long of, boolean fBit) {
        ViewHandle hView = (ViewHandle)hDelegate;
        LongBasedDelegate.setBit(hView.f_hSource.m_alValue, of, fBit);
    }

    @Override
    public byte[] getBytes(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBytes, boolean fReverse) {
        return this.getBits(hDelegate, ofStart * 8L, cBytes * 8L, fReverse);
    }

    @Override
    public byte extractByte(xRTDelegate.DelegateHandle hDelegate, long of) {
        ViewHandle hView = (ViewHandle)hDelegate;
        return LongBasedDelegate.getByte(hView.f_hSource.m_alValue, of);
    }

    @Override
    public void assignByte(xRTDelegate.DelegateHandle hDelegate, long of, byte bValue) {
        ViewHandle hView = (ViewHandle)hDelegate;
        LongBasedDelegate.setByte(hView.f_hSource.m_alValue, of, bValue);
    }

    protected int getBitsPerValue(LongBasedDelegate.LongArrayHandle hArray) {
        return this.f_nBitsPerValue;
    }

    protected static class ViewHandle
    extends xRTView.ViewHandle {
        protected final LongBasedDelegate.LongArrayHandle f_hSource;

        protected ViewHandle(TypeComposition clazz, LongBasedDelegate.LongArrayHandle hSource, long cSize, xArray.Mutability mutability) {
            super(clazz, mutability);
            this.f_hSource = hSource;
            this.m_cSize = cSize;
        }

        @Override
        public xRTDelegate.DelegateHandle getSource() {
            return this.f_hSource;
        }
    }
}

