/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import java.util.Arrays;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.BitBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.BitView;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.util.Handy;

public abstract class LongBasedDelegate
extends xRTDelegate
implements BitView {
    protected final int f_nBitsPerValue;
    protected final int f_nValuesPerLong;
    protected final int f_nIndexShift;
    protected final int f_nIndexMask;
    protected final long f_lValueMask;
    protected final long f_lSignBit;
    protected final boolean f_fSigned;

    protected LongBasedDelegate(Container container, ClassStructure structure, int nBitsPerValue, boolean fSigned) {
        super(container, structure, false);
        this.f_nBitsPerValue = nBitsPerValue;
        this.f_nValuesPerLong = 64 / nBitsPerValue;
        this.f_nIndexShift = this.f_nValuesPerLong >> 1;
        this.f_nIndexMask = (1 << this.f_nIndexShift) - 1;
        this.f_lValueMask = -1L >>> 64 - this.f_nBitsPerValue;
        this.f_lSignBit = 1L << this.f_nBitsPerValue - 1;
        this.f_fSigned = fSigned;
    }

    @Override
    public xRTDelegate.DelegateHandle createDelegate(Container container, TypeConstant typeElement, int cSize, ObjectHandle[] ahContent, xArray.Mutability mutability) {
        long[] alValue = new long[this.storage(cSize)];
        int c = ahContent.length;
        for (int i = 0; i < c; ++i) {
            this.setValue(alValue, i, ((ObjectHandle.JavaLong)ahContent[i]).getValue());
        }
        return this.makeHandle(alValue, cSize, mutability);
    }

    @Override
    public xRTDelegate.DelegateHandle fill(xRTDelegate.DelegateHandle hTarget, int cSize, ObjectHandle hValue) {
        assert (cSize > 0);
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        long[] al = hDelegate.m_alValue;
        long lValue = ((ObjectHandle.JavaLong)hValue).getValue();
        for (int i = 0; i < cSize; ++i) {
            this.setValue(al, i, lValue);
        }
        hDelegate.m_cSize = cSize;
        return hDelegate;
    }

    @Override
    public int getPropertyCapacity(Frame frame, ObjectHandle hTarget, int iReturn) {
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle((long)hDelegate.m_alValue.length * (long)this.f_nValuesPerLong));
    }

    @Override
    public int setPropertyCapacity(Frame frame, ObjectHandle hTarget, long nCapacity) {
        int nOld;
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        long[] alOld = hDelegate.m_alValue;
        long cSize = hDelegate.m_cSize;
        if (nCapacity < cSize) {
            return frame.raiseException(xException.illegalArgument(frame, "Capacity cannot be less then size"));
        }
        int nNew = this.storage((int)nCapacity);
        if (nNew > (nOld = this.storage(alOld.length))) {
            long[] alNew = new long[nNew];
            System.arraycopy(alOld, 0, alNew, 0, alOld.length);
            hDelegate.m_alValue = alNew;
        }
        return -1;
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        int nStart = this.valueIndex(ofStart);
        if (nStart != 0) {
            throw new UnsupportedOperationException("TODO");
        }
        long[] alValue = Arrays.copyOfRange(hDelegate.m_alValue, nStart, nStart + this.storage(cSize));
        if (fReverse) {
            alValue = this.reverse(alValue, (int)cSize);
        }
        return new LongArrayHandle(hDelegate.getComposition(), alValue, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        return frame.assignValue(iReturn, this.makeElementHandle(this.getValue(hDelegate.m_alValue, lIndex)));
    }

    @Override
    protected int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        if (lIndex >= cSize) {
            if (this.valueIndex(lIndex) >= alValue.length) {
                alValue = hDelegate.m_alValue = LongBasedDelegate.grow(alValue, this.storage(lIndex + 1L));
            }
            hDelegate.m_cSize = lIndex + 1L;
        }
        this.setValue(alValue, lIndex, ((ObjectHandle.JavaLong)hValue).getValue());
        return -1;
    }

    @Override
    protected void insertElementImpl(xRTDelegate.DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        if (cSize == (long)alValue.length) {
            alValue = hDelegate.m_alValue = LongBasedDelegate.grow(hDelegate.m_alValue, this.storage(cSize) + 1);
        }
        ++hDelegate.m_cSize;
        if (lIndex != cSize) {
            throw new UnsupportedOperationException("TODO GG");
        }
        this.setValue(alValue, cSize, ((ObjectHandle.JavaLong)hElement).getValue());
    }

    @Override
    protected void deleteElementImpl(xRTDelegate.DelegateHandle hTarget, long lIndex) {
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        if (lIndex < cSize - 1L) {
            for (long i = lIndex + 1L; i < cSize; ++i) {
                this.setValue(alValue, i - 1L, this.getValue(alValue, i));
            }
        }
        alValue[(int)(--hDelegate.m_cSize)] = 0L;
    }

    @Override
    protected void deleteRangeImpl(xRTDelegate.DelegateHandle hTarget, long lIndex, long cDelete) {
        long i;
        LongArrayHandle hDelegate = (LongArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        if (lIndex < cSize - cDelete) {
            for (i = lIndex + cDelete; i < cSize; ++i) {
                this.setValue(alValue, i - cDelete, this.getValue(alValue, i));
            }
        }
        for (i = cSize - cDelete; i < cSize; ++i) {
            this.setValue(alValue, i, 0L);
        }
        hDelegate.m_cSize -= cDelete;
    }

    protected abstract ObjectHandle makeElementHandle(long var1);

    @Override
    public byte[] getBits(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBits, boolean fReverse) {
        LongArrayHandle hLongs = (LongArrayHandle)hDelegate;
        byte[] abBits = LongBasedDelegate.extractBits(hLongs.m_alValue, ofStart, cBits);
        if (fReverse) {
            abBits = BitBasedDelegate.reverseBits(abBits, cBits);
        }
        return abBits;
    }

    @Override
    public boolean extractBit(xRTDelegate.DelegateHandle hDelegate, long of) {
        LongArrayHandle hLongs = (LongArrayHandle)hDelegate;
        return LongBasedDelegate.getBit(hLongs.m_alValue, of);
    }

    @Override
    public void assignBit(xRTDelegate.DelegateHandle hDelegate, long of, boolean fBit) {
        LongArrayHandle hLongs = (LongArrayHandle)hDelegate;
        LongBasedDelegate.setBit(hLongs.m_alValue, of, fBit);
    }

    @Override
    public byte[] getBytes(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBytes, boolean fReverse) {
        return this.getBits(hDelegate, ofStart * 8L, cBytes * 8L, fReverse);
    }

    @Override
    public byte extractByte(xRTDelegate.DelegateHandle hDelegate, long of) {
        LongArrayHandle hLongs = (LongArrayHandle)hDelegate;
        return LongBasedDelegate.getByte(hLongs.m_alValue, of);
    }

    @Override
    public void assignByte(xRTDelegate.DelegateHandle hDelegate, long of, byte bValue) {
        LongArrayHandle hLongs = (LongArrayHandle)hDelegate;
        LongBasedDelegate.setByte(hLongs.m_alValue, of, bValue);
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        LongArrayHandle h1 = (LongArrayHandle)hValue1;
        LongArrayHandle h2 = (LongArrayHandle)hValue2;
        if (h1 == h2) {
            return frame.assignValue(iReturn, xBoolean.TRUE);
        }
        if (h1.m_cSize != h2.m_cSize) {
            return frame.assignValue(iReturn, xBoolean.FALSE);
        }
        int cStore = this.storage(h1.m_cSize);
        return frame.assignValue(iReturn, xBoolean.makeHandle(Arrays.equals(h1.m_alValue, 0, cStore, h2.m_alValue, 0, cStore)));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        LongArrayHandle h1 = (LongArrayHandle)hValue1;
        LongArrayHandle h2 = (LongArrayHandle)hValue2;
        if (h1 == h2) {
            return true;
        }
        return h1.getMutability() == h2.getMutability() && h1.m_cSize == h2.m_cSize && Arrays.equals(h1.m_alValue, h2.m_alValue);
    }

    public long[] reverse(long[] alValue, int cSize) {
        long[] alValueR = new long[cSize];
        for (int i = 0; i < cSize; ++i) {
            this.setValue(alValueR, cSize - 1 - i, this.getValue(alValue, i));
        }
        return alValueR;
    }

    public static long[] grow(long[] alValue, int cNew) {
        int cCapacity = LongBasedDelegate.calculateCapacity(alValue.length, cNew);
        long[] alNew = new long[cCapacity];
        System.arraycopy(alValue, 0, alNew, 0, alValue.length);
        return alNew;
    }

    protected int storage(long cValues) {
        return (int)((cValues - 1L) / (long)this.f_nValuesPerLong + 1L);
    }

    protected long getValue(long[] alValue, long lIndex) {
        long l = alValue[this.valueIndex(lIndex)] >>> this.shiftCount(lIndex) & this.f_lValueMask;
        if (this.f_fSigned && (l & this.f_lSignBit) != 0L) {
            l |= this.f_lValueMask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    protected void setValue(long[] alValue, long lIndex, long lValue) {
        int nIndex = this.valueIndex(lIndex);
        int cShift = this.shiftCount(lIndex);
        long lMask = this.f_lValueMask << cShift;
        alValue[nIndex] = alValue[nIndex] & (lMask ^ 0xFFFFFFFFFFFFFFFFL) | (lValue & this.f_lValueMask) << cShift;
    }

    private int valueIndex(long lIndex) {
        return (int)(lIndex >>> this.f_nIndexShift);
    }

    private int shiftCount(long lIndex) {
        return 64 - this.f_nBitsPerValue * (((int)lIndex & this.f_nIndexMask) + 1);
    }

    protected static byte getByte(long[] alValue, long of) {
        int ixVal = (int)(of / 8L);
        int ofByte = 7 - (int)(of & 7L);
        return (byte)(alValue[ixVal] >>> ofByte * 8 & 0xFFL);
    }

    protected static void setByte(long[] alValue, long of, byte bValue) {
        int ixVal = (int)(of / 8L);
        int ofByte = 7 - (int)(of & 7L);
        long lMask = 255L << ofByte * 8;
        alValue[ixVal] = alValue[ixVal] & (lMask ^ 0xFFFFFFFFFFFFFFFFL) | ((long)bValue & 0xFFL) << ofByte * 8;
    }

    protected static byte[] extractBits(long[] alValue, long ofStart, long cBits) {
        int cBytes = BitBasedDelegate.storage(cBits);
        byte[] abBits = new byte[cBytes];
        int ofDest = 0;
        if (ofStart % 64L == 0L) {
            int ixSource = (int)(ofStart / 64L);
            int cVals = (int)(cBits / 64L);
            int i = 0;
            while (i < cVals) {
                Handy.toByteArray(alValue[ixSource + i], abBits, ofDest);
                ++i;
                ofDest += 8;
            }
            if (cBits % 64L == 0L) {
                return abBits;
            }
            ofStart += (long)cVals * 64L;
            cBits %= 64L;
        }
        for (long i = 0L; i < cBits; ++i) {
            BitBasedDelegate.setBit(abBits, (long)ofDest + i, LongBasedDelegate.getBit(alValue, ofStart + i));
        }
        return abBits;
    }

    protected static boolean getBit(long[] alValue, long lIndex) {
        return (alValue[LongBasedDelegate.bitIndex(lIndex)] & LongBasedDelegate.bitMask(lIndex)) != 0L;
    }

    protected static void setBit(long[] alValue, long lIndex, boolean fSet) {
        if (fSet) {
            int n = LongBasedDelegate.bitIndex(lIndex);
            alValue[n] = alValue[n] | LongBasedDelegate.bitMask(lIndex);
        } else {
            int n = LongBasedDelegate.bitIndex(lIndex);
            alValue[n] = alValue[n] & (LongBasedDelegate.bitMask(lIndex) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    protected static int bitIndex(long lBit) {
        return (int)(lBit / 64L);
    }

    protected static long bitMask(long lBit) {
        return Long.MIN_VALUE >>> (int)(lBit & 0x3FL);
    }

    public LongArrayHandle makeHandle(long[] alValue, long cSize, xArray.Mutability mutability) {
        return new LongArrayHandle(this.getCanonicalClass(), alValue, cSize, mutability);
    }

    public static class LongArrayHandle
    extends xRTDelegate.DelegateHandle {
        protected long[] m_alValue;

        protected LongArrayHandle(TypeComposition clazz, long[] alValue, long cValues, xArray.Mutability mutability) {
            super(clazz, mutability);
            this.m_alValue = alValue;
            this.m_cSize = cValues;
        }

        @Override
        public boolean makeImmutable() {
            if (this.isMutable()) {
                this.purgeUnusedSpace();
            }
            return super.makeImmutable();
        }

        protected void purgeUnusedSpace() {
            long[] al = this.m_alValue;
            int c = ((LongBasedDelegate)this.getTemplate()).storage(this.m_cSize);
            if (al.length != c) {
                long[] alNew = new long[c];
                System.arraycopy(al, 0, alNew, 0, c);
                this.m_alValue = alNew;
            }
        }

        @Override
        public int compareTo(ObjectHandle that) {
            long[] alThis = this.m_alValue;
            long cThis = this.m_cSize;
            long[] alThat = ((LongArrayHandle)that).m_alValue;
            long cThat = ((LongArrayHandle)that).m_cSize;
            if (cThis != cThat) {
                return (int)(cThis - cThat);
            }
            int c = ((LongBasedDelegate)this.getTemplate()).storage(cThis);
            for (int i = 0; i < c; ++i) {
                long iDiff = alThis[i] - alThat[i];
                if (iDiff == 0L) continue;
                return iDiff < 0L ? -1 : 1;
            }
            return 0;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.m_alValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof LongArrayHandle)) return false;
            LongArrayHandle that = (LongArrayHandle)obj;
            if (!Arrays.equals(this.m_alValue, that.m_alValue)) return false;
            return true;
        }
    }
}

