/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import java.util.Arrays;
import org.xvm.asm.ClassStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.collections.arrays.LongBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;

public abstract class LongDelegate
extends LongBasedDelegate {
    public static LongDelegate INSTANCE;
    protected final boolean f_fSigned;

    public LongDelegate(Container container, ClassStructure structure, boolean fSigned) {
        super(container, structure, 64, fSigned);
        this.f_fSigned = fSigned;
    }

    @Override
    public int invokePreInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        long l = hDelegate.m_alValue[n] + 1L;
        hDelegate.m_alValue[n] = l;
        return frame.assignValue(iReturn, this.makeElementHandle(l));
    }

    @Override
    public int invokePostInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        long l = hDelegate.m_alValue[n];
        hDelegate.m_alValue[n] = l + 1L;
        return frame.assignValue(iReturn, this.makeElementHandle(l));
    }

    @Override
    public int invokePreDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        long l = hDelegate.m_alValue[n] - 1L;
        hDelegate.m_alValue[n] = l;
        return frame.assignValue(iReturn, this.makeElementHandle(l));
    }

    @Override
    public int invokePostDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        long l = hDelegate.m_alValue[n];
        hDelegate.m_alValue[n] = l - 1L;
        return frame.assignValue(iReturn, this.makeElementHandle(l));
    }

    @Override
    public xRTDelegate.DelegateHandle fill(xRTDelegate.DelegateHandle hTarget, int cSize, ObjectHandle hValue) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        Arrays.fill(hDelegate.m_alValue, 0, cSize, ((ObjectHandle.JavaLong)hValue).getValue());
        hDelegate.m_cSize = cSize;
        return hDelegate;
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        return frame.assignValue(iReturn, this.makeElementHandle(hDelegate.m_alValue[(int)lIndex]));
    }

    @Override
    protected int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        int nIndex = (int)lIndex;
        if (nIndex >= cSize) {
            if (nIndex >= alValue.length) {
                alValue = hDelegate.m_alValue = LongDelegate.grow(alValue, nIndex + 1);
            }
            hDelegate.m_cSize = nIndex + 1;
        }
        alValue[nIndex] = ((ObjectHandle.JavaLong)hValue).getValue();
        return -1;
    }

    @Override
    protected void insertElementImpl(xRTDelegate.DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        if (cSize == alValue.length) {
            alValue = hDelegate.m_alValue = LongDelegate.grow(hDelegate.m_alValue, cSize + 1);
        }
        ++hDelegate.m_cSize;
        if (lIndex == (long)cSize) {
            alValue[cSize] = ((ObjectHandle.JavaLong)hElement).getValue();
        } else {
            int nIndex = (int)lIndex;
            System.arraycopy(alValue, nIndex, alValue, nIndex + 1, cSize - nIndex);
            alValue[nIndex] = ((ObjectHandle.JavaLong)hElement).getValue();
        }
    }

    @Override
    protected void deleteElementImpl(xRTDelegate.DelegateHandle hTarget, long lIndex) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        if (lIndex < (long)(cSize - 1)) {
            int nIndex = (int)lIndex;
            System.arraycopy(alValue, nIndex + 1, alValue, nIndex, cSize - nIndex - 1);
        }
        alValue[(int)(--hDelegate.m_cSize)] = 0L;
    }

    @Override
    protected void deleteRangeImpl(xRTDelegate.DelegateHandle hTarget, long lIndex, long cDelete) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        int nIndex = (int)lIndex;
        int nDelete = (int)cDelete;
        if (nIndex < cSize - nDelete) {
            System.arraycopy(alValue, nIndex + nDelete, alValue, nIndex, cSize - nIndex - nDelete);
        }
        hDelegate.m_cSize -= cDelete;
    }

    @Override
    public long[] reverse(long[] alValue, int cSize) {
        return LongDelegate.reverseLongs(alValue, cSize);
    }

    public static long[] reverseLongs(long[] alValue, int cSize) {
        long[] alValueR = new long[cSize];
        for (int i = 0; i < cSize; ++i) {
            alValueR[i] = alValue[cSize - 1 - i];
        }
        return alValueR;
    }
}

