/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import java.util.Arrays;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.LongBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.BaseInt128;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public abstract class LongLongDelegate
extends xRTDelegate {
    public static LongLongDelegate INSTANCE;
    protected final boolean f_fSigned;

    public LongLongDelegate(Container container, ClassStructure structure, boolean fSigned) {
        super(container, structure, false);
        this.f_fSigned = fSigned;
    }

    @Override
    public xRTDelegate.DelegateHandle createDelegate(Container container, TypeConstant typeElement, int cSize, ObjectHandle[] ahContent, xArray.Mutability mutability) {
        long[] alValue = new long[2 * cSize];
        int iDst = 0;
        int c = ahContent.length;
        for (int iSrc = 0; iSrc < c; ++iSrc) {
            LongLong ll = ((BaseInt128.LongLongHandle)ahContent[iSrc]).getValue();
            alValue[iDst++] = ll.getHighValue();
            alValue[iDst++] = ll.getLowValue();
        }
        return new LongBasedDelegate.LongArrayHandle(this.getCanonicalClass(), alValue, cSize, mutability);
    }

    @Override
    public xRTDelegate.DelegateHandle fill(xRTDelegate.DelegateHandle hTarget, int cSize, ObjectHandle hValue) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        long[] alValue = hDelegate.m_alValue;
        LongLong ll = ((BaseInt128.LongLongHandle)hValue).getValue();
        long lH = ll.getHighValue();
        long lL = ll.getLowValue();
        int iDst = 0;
        for (int iSrc = 0; iSrc < cSize; ++iSrc) {
            alValue[iDst++] = lH;
            alValue[iDst++] = lL;
        }
        hDelegate.m_cSize = cSize;
        return hDelegate;
    }

    @Override
    public int getPropertyCapacity(Frame frame, ObjectHandle hTarget, int iReturn) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle((long)hDelegate.m_alValue.length / 2L));
    }

    @Override
    public int setPropertyCapacity(Frame frame, ObjectHandle hTarget, long nCapacity) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        long[] abOld = hDelegate.m_alValue;
        long cSize = hDelegate.m_cSize;
        if (nCapacity < cSize) {
            return frame.raiseException(xException.illegalArgument(frame, "Capacity cannot be less then size"));
        }
        int nNew = (int)nCapacity * 2;
        int nOld = abOld.length;
        if (nNew > nOld) {
            long[] abNew = new long[nNew];
            System.arraycopy(abOld, 0, abNew, 0, abOld.length);
            hDelegate.m_alValue = abNew;
        }
        return -1;
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        long[] alValue = Arrays.copyOfRange(hDelegate.m_alValue, (int)ofStart * 2, (int)(ofStart * 2L + cSize * 2L));
        if (fReverse) {
            alValue = LongLongDelegate.reverseLong2(alValue, (int)cSize);
        }
        return new LongBasedDelegate.LongArrayHandle(hDelegate.getComposition(), alValue, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        long[] alValue = hDelegate.m_alValue;
        int nIndex = (int)lIndex * 2;
        return frame.assignValue(iReturn, this.makeElementHandle(new LongLong(alValue[nIndex + 1], alValue[nIndex])));
    }

    @Override
    protected int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        int nIndex = (int)lIndex * 2;
        if (lIndex >= (long)cSize) {
            if (nIndex >= alValue.length) {
                alValue = hDelegate.m_alValue = LongBasedDelegate.grow(alValue, nIndex + 2);
            }
            hDelegate.m_cSize = lIndex + 1L;
        }
        LongLong ll = ((BaseInt128.LongLongHandle)hValue).getValue();
        alValue[nIndex] = ll.getHighValue();
        alValue[nIndex + 1] = ll.getLowValue();
        return -1;
    }

    @Override
    protected void insertElementImpl(xRTDelegate.DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        int nIndex = (int)lIndex * 2;
        if (2 * cSize == alValue.length) {
            alValue = hDelegate.m_alValue = LongBasedDelegate.grow(hDelegate.m_alValue, 2 * cSize + 2);
        }
        ++hDelegate.m_cSize;
        LongLong ll = ((BaseInt128.LongLongHandle)hElement).getValue();
        if (lIndex < (long)cSize) {
            System.arraycopy(alValue, nIndex, alValue, nIndex + 2, 2 * cSize - nIndex);
        }
        alValue[nIndex] = ll.getHighValue();
        alValue[nIndex + 1] = ll.getLowValue();
    }

    @Override
    protected void deleteElementImpl(xRTDelegate.DelegateHandle hTarget, long lIndex) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        int nIndex = (int)lIndex * 2;
        if (lIndex < (long)(cSize - 1)) {
            System.arraycopy(alValue, nIndex + 2, alValue, nIndex, 2 * cSize - nIndex - 2);
        }
        alValue[nIndex] = 0L;
        alValue[nIndex + 1] = 0L;
        --hDelegate.m_cSize;
    }

    @Override
    protected void deleteRangeImpl(xRTDelegate.DelegateHandle hTarget, long lIndex, long cDelete) {
        LongBasedDelegate.LongArrayHandle hDelegate = (LongBasedDelegate.LongArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        long[] alValue = hDelegate.m_alValue;
        if (lIndex < (long)cSize - cDelete) {
            int nIndex = (int)lIndex * 2;
            int nDelete = (int)cDelete * 2;
            System.arraycopy(alValue, nIndex + nDelete, alValue, nIndex, 2 * cSize - nIndex - nDelete);
        }
        hDelegate.m_cSize -= cDelete;
    }

    protected abstract ObjectHandle makeElementHandle(LongLong var1);

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        LongBasedDelegate.LongArrayHandle h1 = (LongBasedDelegate.LongArrayHandle)hValue1;
        LongBasedDelegate.LongArrayHandle h2 = (LongBasedDelegate.LongArrayHandle)hValue2;
        if (h1 == h2) {
            return frame.assignValue(iReturn, xBoolean.TRUE);
        }
        if (h1.m_cSize != h2.m_cSize) {
            return frame.assignValue(iReturn, xBoolean.FALSE);
        }
        int cStore = (int)h1.m_cSize * 2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(Arrays.equals(h1.m_alValue, 0, cStore, h2.m_alValue, 0, cStore)));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        LongBasedDelegate.LongArrayHandle h1 = (LongBasedDelegate.LongArrayHandle)hValue1;
        LongBasedDelegate.LongArrayHandle h2 = (LongBasedDelegate.LongArrayHandle)hValue2;
        if (h1 == h2) {
            return true;
        }
        return h1.getMutability() == h2.getMutability() && h1.m_cSize == h2.m_cSize && Arrays.equals(h1.m_alValue, h2.m_alValue);
    }

    public static long[] reverseLong2(long[] alValue, int cSize) {
        long[] alValueR = new long[2 * cSize];
        for (int i = 0; i < cSize; ++i) {
            alValueR[i] = alValue[2 * cSize - 2 - i];
            alValueR[i + 1] = alValue[2 * cSize - 1 - i];
        }
        return alValueR;
    }
}

