/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import java.util.Arrays;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xChar;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public class xRTCharDelegate
extends xRTDelegate {
    public static xRTCharDelegate INSTANCE;

    public xRTCharDelegate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
    }

    @Override
    public TypeConstant getCanonicalType() {
        ConstantPool pool = this.pool();
        return pool.ensureParameterizedTypeConstant(this.getInceptionClassConstant().getType(), pool.typeChar());
    }

    @Override
    public xRTDelegate.DelegateHandle createDelegate(Container container, TypeConstant typeElement, int cSize, ObjectHandle[] ahContent, xArray.Mutability mutability) {
        char[] ach = new char[cSize];
        int c = ahContent.length;
        for (int i = 0; i < c; ++i) {
            ach[i] = (char)((ObjectHandle.JavaLong)ahContent[i]).getValue();
        }
        return new CharArrayHandle(this.getCanonicalClass(), ach, cSize, mutability);
    }

    @Override
    public int invokePreInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        char c = hDelegate.m_achValue[n];
        hDelegate.m_achValue[n] = (char)(c + '\u0001');
        char chValue = c;
        if (chValue == '\uffff') {
            int n2 = (int)lIndex;
            hDelegate.m_achValue[n2] = (char)(hDelegate.m_achValue[n2] - '\u0001');
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, xChar.makeHandle(chValue + '\u0001'));
    }

    @Override
    public int invokePreDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        char c = hDelegate.m_achValue[n];
        hDelegate.m_achValue[n] = (char)(c - '\u0001');
        char chValue = c;
        if (chValue == '\u0000') {
            int n2 = (int)lIndex;
            hDelegate.m_achValue[n2] = (char)(hDelegate.m_achValue[n2] + '\u0001');
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, xChar.makeHandle(chValue - '\u0001'));
    }

    @Override
    public int invokePostInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        char c = hDelegate.m_achValue[n];
        hDelegate.m_achValue[n] = (char)(c + '\u0001');
        char chValue = c;
        if (chValue == '\uffff') {
            int n2 = (int)lIndex;
            hDelegate.m_achValue[n2] = (char)(hDelegate.m_achValue[n2] - '\u0001');
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, xChar.makeHandle(chValue));
    }

    @Override
    public int invokePostDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        if (this.checkWriteInPlace(frame, hDelegate, lIndex, hDelegate.m_cSize) == -3) {
            return -3;
        }
        int n = (int)lIndex;
        char c = hDelegate.m_achValue[n];
        hDelegate.m_achValue[n] = (char)(c - '\u0001');
        char chValue = c;
        if (chValue == '\u0000') {
            int n2 = (int)lIndex;
            hDelegate.m_achValue[n2] = (char)(hDelegate.m_achValue[n2] + '\u0001');
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, xChar.makeHandle(chValue));
    }

    @Override
    public xRTDelegate.DelegateHandle fill(xRTDelegate.DelegateHandle hTarget, int cSize, ObjectHandle hValue) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        Arrays.fill(hDelegate.m_achValue, 0, cSize, (char)((ObjectHandle.JavaLong)hValue).getValue());
        hDelegate.m_cSize = cSize;
        return hDelegate;
    }

    @Override
    public int getPropertyCapacity(Frame frame, ObjectHandle hTarget, int iReturn) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle(hDelegate.m_achValue.length));
    }

    @Override
    public int setPropertyCapacity(Frame frame, ObjectHandle hTarget, long nCapacity) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        char[] achOld = hDelegate.m_achValue;
        int nSize = (int)hDelegate.m_cSize;
        if (nCapacity < (long)nSize) {
            return frame.raiseException(xException.illegalArgument(frame, "Capacity cannot be less then size"));
        }
        int nCapacityOld = achOld.length;
        if (nCapacity > (long)nCapacityOld) {
            char[] achNew = new char[(int)nCapacity];
            System.arraycopy(achOld, 0, achNew, 0, achOld.length);
            hDelegate.m_achValue = achNew;
        }
        return -1;
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        CharArrayHandle h1 = (CharArrayHandle)hValue1;
        CharArrayHandle h2 = (CharArrayHandle)hValue2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(Arrays.equals(h1.m_achValue, h2.m_achValue)));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        CharArrayHandle h1 = (CharArrayHandle)hValue1;
        CharArrayHandle h2 = (CharArrayHandle)hValue2;
        if (h1 == h2) {
            return true;
        }
        return h1.getMutability() == h2.getMutability() && h1.m_cSize == h2.m_cSize && Arrays.equals(h1.m_achValue, h2.m_achValue);
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        char[] achValue = Arrays.copyOfRange(hDelegate.m_achValue, (int)ofStart, (int)(ofStart + cSize));
        if (fReverse) {
            achValue = xRTCharDelegate.reverse(achValue, (int)cSize);
        }
        return new CharArrayHandle(hDelegate.getComposition(), achValue, (int)cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        return frame.assignValue(iReturn, xChar.makeHandle(hDelegate.m_achValue[(int)lIndex]));
    }

    @Override
    protected int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        char[] achValue = hDelegate.m_achValue;
        int nIndex = (int)lIndex;
        if (nIndex >= cSize) {
            if (nIndex >= achValue.length) {
                achValue = hDelegate.m_achValue = this.grow(achValue, nIndex + 1);
            }
            hDelegate.m_cSize = nIndex + 1;
        }
        achValue[nIndex] = (char)((ObjectHandle.JavaLong)hValue).getValue();
        return -1;
    }

    @Override
    protected void insertElementImpl(xRTDelegate.DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        char[] achValue = hDelegate.m_achValue;
        if (cSize == achValue.length) {
            achValue = hDelegate.m_achValue = this.grow(hDelegate.m_achValue, cSize + 1);
        }
        ++hDelegate.m_cSize;
        if (lIndex == (long)cSize) {
            achValue[cSize] = (char)((ObjectHandle.JavaLong)hElement).getValue();
        } else {
            int nIndex = (int)lIndex;
            System.arraycopy(achValue, nIndex, achValue, nIndex + 1, cSize - nIndex);
            achValue[nIndex] = (char)((ObjectHandle.JavaLong)hElement).getValue();
        }
    }

    @Override
    protected void deleteElementImpl(xRTDelegate.DelegateHandle hTarget, long lIndex) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        char[] achValue = hDelegate.m_achValue;
        int nIndex = (int)lIndex;
        if (nIndex < cSize - 1) {
            System.arraycopy(achValue, nIndex + 1, achValue, nIndex, cSize - nIndex - 1);
        }
        achValue[(int)(--hDelegate.m_cSize)] = '\u0000';
    }

    @Override
    protected void deleteRangeImpl(xRTDelegate.DelegateHandle hTarget, long lIndex, long cDelete) {
        CharArrayHandle hDelegate = (CharArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        char[] achValue = hDelegate.m_achValue;
        int nIndex = (int)lIndex;
        int nDelete = (int)cDelete;
        if (nIndex < cSize - nDelete) {
            System.arraycopy(achValue, nIndex + nDelete, achValue, nIndex, cSize - nIndex - nDelete);
        }
        hDelegate.m_cSize -= cDelete;
    }

    @Override
    public int invokeIndexOf(Frame frame, xRTDelegate.DelegateHandle hTarget, xRTDelegate.DelegateHandle hThat, int ofStart, int[] aiReturn) {
        char[] achThis = ((CharArrayHandle)hTarget).m_achValue;
        char[] achThat = ((CharArrayHandle)hThat).m_achValue;
        int cchThis = achThis.length;
        int cchThat = achThat.length;
        ofStart = Math.max(ofStart, 0);
        if (cchThat == 0) {
            return ofStart > cchThis ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, xInt64.makeHandle(ofStart));
        }
        if (ofStart > cchThis - cchThat) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        char chFirstMatch = achThat[0];
        int stopAt = cchThis - cchThat;
        block0: for (int of = ofStart; of <= stopAt; ++of) {
            if (achThis[of] != chFirstMatch) continue;
            for (int i = 1; i < cchThat; ++i) {
                if (achThis[of + i] != achThat[i]) continue block0;
            }
            return frame.assignValues(aiReturn, xBoolean.TRUE, xInt64.makeHandle(of));
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public static char[] getChars(CharArrayHandle hChars, int ofStart, int cChars, boolean fReverse) {
        char[] ach = hChars.m_achValue;
        if (hChars.getMutability() == xArray.Mutability.Constant && ofStart == 0 && cChars == ach.length && !fReverse) {
            return ach;
        }
        ach = Arrays.copyOfRange(ach, ofStart, ofStart + cChars);
        return fReverse ? xRTCharDelegate.reverse(ach, cChars) : ach;
    }

    private static char[] reverse(char[] achValue, int cSize) {
        char[] achValueR = new char[cSize];
        for (int i = 0; i < cSize; ++i) {
            achValueR[i] = achValue[cSize - 1 - i];
        }
        return achValueR;
    }

    private char[] grow(char[] achValue, int cSize) {
        int cCapacity = xRTCharDelegate.calculateCapacity(achValue.length, cSize);
        char[] achNew = new char[cCapacity];
        System.arraycopy(achValue, 0, achNew, 0, achValue.length);
        return achNew;
    }

    public CharArrayHandle makeHandle(char[] ach, xArray.Mutability mutability) {
        return new CharArrayHandle(this.getCanonicalClass(), ach, ach.length, mutability);
    }

    public static class CharArrayHandle
    extends xRTDelegate.DelegateHandle {
        protected char[] m_achValue;

        protected CharArrayHandle(TypeComposition clazz, char[] achValue, int cSize, xArray.Mutability mutability) {
            super(clazz, mutability);
            this.m_achValue = achValue;
            this.m_cSize = cSize;
        }

        @Override
        public boolean makeImmutable() {
            if (this.isMutable()) {
                this.purgeUnusedSpace();
            }
            return super.makeImmutable();
        }

        protected void purgeUnusedSpace() {
            char[] ach = this.m_achValue;
            int c = (int)this.m_cSize;
            if (ach.length != c) {
                char[] achNew = new char[c];
                System.arraycopy(ach, 0, achNew, 0, c);
                this.m_achValue = achNew;
            }
        }

        @Override
        public int compareTo(ObjectHandle that) {
            char[] achThis = this.m_achValue;
            int cThis = (int)this.m_cSize;
            char[] achThat = ((CharArrayHandle)that).m_achValue;
            int cThat = (int)((CharArrayHandle)that).m_cSize;
            if (cThis != cThat) {
                return cThis - cThat;
            }
            for (int i = 0; i < cThis; ++i) {
                int iDiff = achThis[i] - achThat[i];
                if (iDiff == 0) continue;
                return iDiff;
            }
            return 0;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.m_achValue);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof CharArrayHandle && Arrays.equals(this.m_achValue, ((CharArrayHandle)obj).m_achValue);
        }

        @Override
        public String toString() {
            return String.copyValueOf(this.m_achValue, 0, (int)this.m_cSize);
        }
    }
}

