/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.IndexSupport;
import org.xvm.runtime.template._native.collections.arrays.xRTBitDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTBooleanDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTCharDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTFloat64Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTInt128Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTInt16Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTInt32Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTInt64Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTInt8Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTNibbleDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTSlicingDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTStringDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt128Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt16Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt32Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt64Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt8Delegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;

public class xRTDelegate
extends ClassTemplate
implements IndexSupport {
    public static xRTDelegate INSTANCE;
    protected static final String[] ELEMENT_TYPE;
    private static Map<TypeConstant, xRTDelegate> DELEGATES;

    public xRTDelegate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void registerNativeTemplates() {
        if (this == INSTANCE) {
            this.registerNativeTemplate(new xRTNibbleDelegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTBooleanDelegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTBitDelegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTCharDelegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTInt8Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTInt16Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTInt32Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTInt64Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTInt128Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTUInt8Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTUInt16Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTUInt32Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTUInt64Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTUInt128Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTFloat64Delegate(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xRTStringDelegate(this.f_container, this.f_struct, true));
        }
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            ConstantPool pool = this.pool();
            HashMap<TypeConstant, xRTDelegate> mapDelegates = new HashMap<TypeConstant, xRTDelegate>();
            mapDelegates.put(pool.typeNibble(), xRTNibbleDelegate.INSTANCE);
            mapDelegates.put(pool.typeBoolean(), xRTBooleanDelegate.INSTANCE);
            mapDelegates.put(pool.typeBit(), xRTBitDelegate.INSTANCE);
            mapDelegates.put(pool.typeChar(), xRTCharDelegate.INSTANCE);
            mapDelegates.put(pool.typeInt8(), xRTInt8Delegate.INSTANCE);
            mapDelegates.put(pool.typeInt16(), xRTInt16Delegate.INSTANCE);
            mapDelegates.put(pool.typeInt32(), xRTInt32Delegate.INSTANCE);
            mapDelegates.put(pool.typeInt64(), xRTInt64Delegate.INSTANCE);
            mapDelegates.put(pool.typeInt128(), xRTInt128Delegate.INSTANCE);
            mapDelegates.put(pool.typeUInt8(), xRTUInt8Delegate.INSTANCE);
            mapDelegates.put(pool.typeUInt16(), xRTUInt16Delegate.INSTANCE);
            mapDelegates.put(pool.typeUInt32(), xRTUInt32Delegate.INSTANCE);
            mapDelegates.put(pool.typeUInt64(), xRTUInt64Delegate.INSTANCE);
            mapDelegates.put(pool.typeUInt128(), xRTUInt128Delegate.INSTANCE);
            mapDelegates.put(pool.typeFloat64(), xRTFloat64Delegate.INSTANCE);
            mapDelegates.put(pool.typeString(), xRTStringDelegate.INSTANCE);
            DELEGATES = mapDelegates;
            this.markNativeProperty("capacity");
            this.markNativeProperty("mutability");
            this.markNativeProperty("size");
            this.markNativeMethod("getElement", INT, ELEMENT_TYPE);
            this.markNativeMethod("setElement", new String[]{"numbers.Int64", "Element"}, VOID);
            this.markNativeMethod("elementAt", INT, new String[]{"reflect.Var<Element>"});
            this.markNativeMethod("insert", null, THIS);
            this.markNativeMethod("delete", INT, THIS);
            this.markNativeMethod("reify", null, null);
            this.invalidateTypeInfo();
        }
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public TypeComposition ensureParameterizedClass(Container container, TypeConstant ... atypeParams) {
        assert (atypeParams.length == 1);
        xRTDelegate template = DELEGATES.get(atypeParams[0]);
        return template == null ? super.ensureParameterizedClass(container, atypeParams) : template.getCanonicalClass();
    }

    @Override
    public ClassTemplate getTemplate(TypeConstant type) {
        return xRTDelegate.getArrayTemplate(type.getParamType(0));
    }

    public DelegateHandle createDelegate(Container container, TypeConstant typeElement, int cSize, ObjectHandle[] ahContent, xArray.Mutability mutability) {
        ObjectHandle[] ahValue;
        TypeComposition clzDelegate = this.ensureParameterizedClass(container, typeElement);
        int cContent = ahContent.length;
        if (cSize > cContent) {
            ahValue = new ObjectHandle[cSize];
            if (cContent > 0) {
                System.arraycopy(ahContent, 0, ahValue, 0, cContent);
            }
        } else {
            ahValue = mutability == xArray.Mutability.Constant ? ahContent : (ObjectHandle[])ahContent.clone();
        }
        return new GenericArrayDelegate(clzDelegate, ahValue, cSize, mutability);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        DelegateHandle hDelegate = (DelegateHandle)hTarget;
        switch (sPropName) {
            case "capacity": {
                return this.getPropertyCapacity(frame, hTarget, iReturn);
            }
            case "mutability": {
                return Utils.assignInitializedEnum(frame, xArray.MUTABILITY.getEnumByOrdinal(hDelegate.getMutability().ordinal()), iReturn);
            }
            case "size": {
                return this.getPropertySize(frame, hTarget, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeSet(Frame frame, ObjectHandle hTarget, String sPropName, ObjectHandle hValue) {
        DelegateHandle hDelegate = (DelegateHandle)hTarget;
        switch (sPropName) {
            case "capacity": {
                return this.setPropertyCapacity(frame, hTarget, ((ObjectHandle.JavaLong)hValue).getValue());
            }
            case "mutability": {
                xArray.Mutability mutability = xArray.Mutability.values()[((xEnum.EnumHandle)hValue).getOrdinal()];
                if (mutability.compareTo(hDelegate.getMutability()) > 0) {
                    return frame.raiseException(xException.illegalState(frame, hDelegate.getMutability().toString()));
                }
                hDelegate.setMutability(mutability);
                return -1;
            }
        }
        return super.invokeNativeSet(frame, hTarget, sPropName, hValue);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "delete": {
                return this.invokeDeleteElement(frame, hTarget, hArg, iReturn);
            }
            case "elementAt": {
                return this.makeRef(frame, hTarget, ((ObjectHandle.JavaLong)hArg).getValue(), false, iReturn);
            }
            case "getElement": {
                return this.extractArrayValue(frame, hTarget, ((ObjectHandle.JavaLong)hArg).getValue(), iReturn);
            }
            case "reify": {
                DelegateHandle hDelegate = (DelegateHandle)hTarget;
                xArray.Mutability mutability = hArg == ObjectHandle.DEFAULT || hArg == xNullable.NULL ? hDelegate.getMutability() : xArray.Mutability.values()[((xEnum.EnumHandle)hArg).getOrdinal()];
                return frame.assignValue(iReturn, this.createCopy(hDelegate, mutability));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "insert": {
                return this.invokeInsertElement(frame, hTarget, (ObjectHandle.JavaLong)ahArg[0], ahArg[1], iReturn);
            }
            case "setElement": {
                return this.assignArrayValue(frame, hTarget, ((ObjectHandle.JavaLong)ahArg[0]).getValue(), ahArg[1]);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        GenericArrayDelegate h1 = (GenericArrayDelegate)hValue1;
        GenericArrayDelegate h2 = (GenericArrayDelegate)hValue2;
        ObjectHandle[] ah1 = h1.m_ahValue;
        int cElements = ah1.length;
        ObjectHandle[] ah2 = h2.m_ahValue;
        if (cElements != ah2.length) {
            return frame.assignValue(iReturn, xBoolean.FALSE);
        }
        TypeConstant typeEl = clazz.getType().getParamType(0);
        int[] holder = new int[]{0};
        return new Equals(ah1, ah2, typeEl, cElements, holder, iReturn).doNext(frame);
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        GenericArrayDelegate h1 = (GenericArrayDelegate)hValue1;
        GenericArrayDelegate h2 = (GenericArrayDelegate)hValue2;
        if (h1 == h2) {
            return true;
        }
        if (h1.getMutability() != h2.getMutability() || h1.m_cSize != h2.m_cSize) {
            return false;
        }
        ObjectHandle[] ah1 = h1.m_ahValue;
        ObjectHandle[] ah2 = h2.m_ahValue;
        if (ah1 == ah2) {
            return true;
        }
        int c = (int)h1.m_cSize;
        for (int i = 0; i < c; ++i) {
            ObjectHandle hV1 = ah1[i];
            ObjectHandle hV2 = ah2[i];
            ClassTemplate template = hV1.getTemplate();
            if (template == hV2.getTemplate() && template.compareIdentity(hV1, hV2)) continue;
            return false;
        }
        return true;
    }

    protected int getPropertyCapacity(Frame frame, ObjectHandle hTarget, int iReturn) {
        GenericArrayDelegate hDelegate = (GenericArrayDelegate)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle(hDelegate.m_ahValue.length));
    }

    protected int setPropertyCapacity(Frame frame, ObjectHandle hTarget, long nCapacity) {
        GenericArrayDelegate hDelegate = (GenericArrayDelegate)hTarget;
        ObjectHandle[] ahOld = hDelegate.m_ahValue;
        int nSize = (int)hDelegate.m_cSize;
        if (nCapacity < (long)nSize) {
            return frame.raiseException(xException.illegalArgument(frame, "Capacity cannot be less then size"));
        }
        int nCapacityOld = ahOld.length;
        if (nCapacity > (long)nCapacityOld) {
            ObjectHandle[] ahNew = new ObjectHandle[(int)nCapacity];
            System.arraycopy(ahOld, 0, ahNew, 0, ahOld.length);
            hDelegate.m_ahValue = ahNew;
        }
        return -1;
    }

    protected int getPropertySize(Frame frame, ObjectHandle hTarget, int iReturn) {
        DelegateHandle hDelegate = (DelegateHandle)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle(hDelegate.m_cSize));
    }

    protected int invokeInsertElement(Frame frame, ObjectHandle hTarget, ObjectHandle.JavaLong hIndex, ObjectHandle hValue, int iReturn) {
        DelegateHandle hDelegate = (DelegateHandle)hTarget;
        xArray.Mutability mutability = null;
        switch (hDelegate.getMutability()) {
            case Fixed: {
                return frame.raiseException(xException.sizeLimited(frame, "Fixed size array"));
            }
            case Constant: 
            case Persistent: {
                mutability = hDelegate.getMutability();
                hDelegate = this.createCopy(hDelegate, xArray.Mutability.Mutable);
            }
        }
        this.insertElementImpl(hDelegate, hValue, (int)hIndex.getValue());
        if (mutability != null) {
            hDelegate.setMutability(mutability);
        }
        return frame.assignValue(iReturn, hDelegate);
    }

    protected int invokeDeleteElement(Frame frame, ObjectHandle hTarget, ObjectHandle hValue, int iReturn) {
        DelegateHandle hDelegate = (DelegateHandle)hTarget;
        long lIndex = ((ObjectHandle.JavaLong)hValue).getValue();
        if (lIndex < 0L || lIndex >= hDelegate.m_cSize) {
            return frame.raiseException(xException.outOfBounds(frame, lIndex, hDelegate.m_cSize));
        }
        xArray.Mutability mutability = null;
        switch (hDelegate.getMutability()) {
            case Fixed: {
                return frame.raiseException(xException.sizeLimited(frame, "Fixed size array"));
            }
            case Constant: 
            case Persistent: {
                mutability = hDelegate.getMutability();
                hDelegate = this.createCopy(hDelegate, xArray.Mutability.Mutable);
            }
        }
        this.deleteElementImpl(hDelegate, lIndex);
        if (mutability != null) {
            hDelegate.setMutability(mutability);
        }
        return frame.assignValue(iReturn, hDelegate);
    }

    public int invokeIndexOf(Frame frame, DelegateHandle hTarget, DelegateHandle hThat, int ofStart, int[] aiReturn) {
        return 0;
    }

    public DelegateHandle slice(DelegateHandle hTarget, long ofStart, long cSize, boolean fReverse) {
        return ofStart == 0L && cSize == hTarget.m_cSize && !fReverse ? hTarget : xRTSlicingDelegate.INSTANCE.makeHandle(hTarget, ofStart, cSize, fReverse);
    }

    public DelegateHandle fill(DelegateHandle hTarget, int cSize, ObjectHandle hValue) {
        GenericArrayDelegate hDelegate = (GenericArrayDelegate)hTarget;
        Arrays.fill(hDelegate.m_ahValue, 0, cSize, hValue);
        hDelegate.m_cSize = cSize;
        return hDelegate;
    }

    public DelegateHandle deleteRange(DelegateHandle hTarget, long ofStart, long cSize) {
        DelegateHandle hDelegate = hTarget;
        xArray.Mutability mutability = hTarget.getMutability();
        switch (mutability) {
            case Fixed: {
                throw new IllegalStateException();
            }
            case Constant: 
            case Persistent: {
                hDelegate = this.createCopy(hTarget, xArray.Mutability.Mutable);
            }
        }
        if (cSize == 1L) {
            this.deleteElementImpl(hDelegate, ofStart);
        } else {
            this.deleteRangeImpl(hDelegate, ofStart, cSize);
        }
        if (hDelegate != hTarget) {
            hDelegate.setMutability(mutability);
        }
        return hDelegate;
    }

    protected DelegateHandle createCopy(DelegateHandle hTarget, xArray.Mutability mutability) {
        return this.createCopyImpl(hTarget, mutability, 0L, hTarget.m_cSize, false);
    }

    @Override
    public int extractArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        DelegateHandle hDelegate = (DelegateHandle)hTarget;
        return lIndex < 0L || lIndex >= hDelegate.m_cSize ? frame.raiseException(xException.outOfBounds(frame, lIndex, hDelegate.m_cSize)) : this.extractArrayValueImpl(frame, hDelegate, lIndex, iReturn);
    }

    @Override
    public int assignArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, ObjectHandle hValue) {
        DelegateHandle hDelegate = (DelegateHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        if (this.checkWrite(frame, hDelegate, lIndex, cSize) == -3) {
            return -3;
        }
        if (lIndex < 0L) {
            return frame.raiseException(xException.outOfBounds(frame, lIndex, cSize));
        }
        if (lIndex > cSize && hTarget.getType().getParamType(0).getDefaultValue() == null) {
            return frame.raiseException(xException.unsupported(frame, "No default value"));
        }
        return this.assignArrayValueImpl(frame, hDelegate, lIndex, hValue);
    }

    @Override
    public TypeConstant getElementType(Frame frame, ObjectHandle hTarget, long lIndex) {
        return hTarget.getType().getParamType(0);
    }

    @Override
    public long size(ObjectHandle hTarget) {
        return ((DelegateHandle)hTarget).m_cSize;
    }

    protected int checkWrite(Frame frame, DelegateHandle hDelegate, long lIndex, long cSize) {
        switch (hDelegate.getMutability()) {
            case Fixed: {
                if (lIndex < cSize) break;
            }
            case Constant: {
                return frame.raiseException(xException.readOnly(frame, hDelegate.getMutability()));
            }
        }
        return -1;
    }

    protected int checkWriteInPlace(Frame frame, DelegateHandle hDelegate, long lIndex, long cSize) {
        if (this.checkWrite(frame, hDelegate, lIndex, cSize) == -3) {
            return -3;
        }
        if (lIndex < 0L || lIndex >= cSize) {
            return frame.raiseException(xException.outOfBounds(frame, lIndex, cSize));
        }
        return -1;
    }

    protected DelegateHandle createCopyImpl(DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        GenericArrayDelegate hDelegate = (GenericArrayDelegate)hTarget;
        if (ofStart == 0L && cSize == hDelegate.m_cSize && cSize == (long)hDelegate.m_ahValue.length && mutability == hDelegate.getMutability() && mutability == xArray.Mutability.Constant && !fReverse) {
            return hDelegate;
        }
        ObjectHandle[] ahValue = Arrays.copyOfRange(hDelegate.m_ahValue, (int)ofStart, (int)(ofStart + cSize));
        if (fReverse) {
            ahValue = xRTDelegate.reverse(ahValue, (int)cSize);
        }
        return new GenericArrayDelegate(hDelegate.getComposition(), ahValue, mutability);
    }

    protected int extractArrayValueImpl(Frame frame, DelegateHandle hTarget, long lIndex, int iReturn) {
        return frame.assignValue(iReturn, ((GenericArrayDelegate)hTarget).m_ahValue[(int)lIndex]);
    }

    protected int assignArrayValueImpl(Frame frame, DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        GenericArrayDelegate hDelegate = (GenericArrayDelegate)hTarget;
        Object[] ahValue = hDelegate.m_ahValue;
        int nIndex = (int)lIndex;
        int cSize = (int)hDelegate.m_cSize;
        if (nIndex == cSize) {
            if (cSize == ahValue.length) {
                hDelegate.m_ahValue = xRTDelegate.grow((ObjectHandle[])ahValue, cSize + 1);
                ahValue = hDelegate.m_ahValue;
            }
            ++hDelegate.m_cSize;
        } else if (nIndex > cSize) {
            TypeConstant typeElement = hTarget.getType().getParamType(0);
            Constant constDefault = typeElement.getDefaultValue();
            if (constDefault == null) {
                return frame.raiseException(xException.unsupported(frame, "No default value for " + typeElement.getValueString()));
            }
            if (nIndex >= ahValue.length) {
                ahValue = xRTDelegate.grow((ObjectHandle[])ahValue, nIndex + 1);
                hDelegate.m_ahValue = ahValue;
            }
            hDelegate.m_cSize = nIndex + 1;
            ObjectHandle hDefault = frame.getConstHandle(constDefault);
            if (Op.isDeferred(hDefault)) {
                Object[] ahVal = ahValue;
                return hDefault.proceed(frame, arg_0 -> xRTDelegate.lambda$assignArrayValueImpl$0((ObjectHandle[])ahVal, cSize, nIndex, hValue, arg_0));
            }
            Arrays.fill(ahValue, cSize, nIndex, hDefault);
        }
        ahValue[nIndex] = hValue;
        return -1;
    }

    protected void insertElementImpl(DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        GenericArrayDelegate hDelegate = (GenericArrayDelegate)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        ObjectHandle[] ahValue = hDelegate.m_ahValue;
        int nIndex = (int)lIndex;
        if (cSize == ahValue.length) {
            hDelegate.m_ahValue = xRTDelegate.grow(ahValue, cSize + 1);
            ahValue = hDelegate.m_ahValue;
        }
        ++hDelegate.m_cSize;
        if (lIndex == (long)cSize) {
            ahValue[cSize] = hElement;
        } else {
            System.arraycopy(ahValue, nIndex, ahValue, nIndex + 1, cSize - nIndex);
            ahValue[nIndex] = hElement;
        }
    }

    protected void deleteElementImpl(DelegateHandle hTarget, long lIndex) {
        GenericArrayDelegate hDelegate = (GenericArrayDelegate)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        ObjectHandle[] ahValue = hDelegate.m_ahValue;
        int nIndex = (int)lIndex;
        if (nIndex < cSize - 1) {
            System.arraycopy(ahValue, nIndex + 1, ahValue, nIndex, cSize - nIndex - 1);
        }
        ahValue[(int)(--hDelegate.m_cSize)] = null;
    }

    protected void deleteRangeImpl(DelegateHandle hTarget, long lIndex, long cDelete) {
        GenericArrayDelegate hDelegate = (GenericArrayDelegate)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        Object[] ahValue = hDelegate.m_ahValue;
        int nIndex = (int)lIndex;
        int nDelete = (int)cDelete;
        if (nIndex < cSize - nDelete) {
            System.arraycopy(ahValue, nIndex + nDelete, ahValue, nIndex, cSize - nIndex - nDelete);
        }
        Arrays.fill(ahValue, cSize - nDelete, cSize, null);
        hDelegate.m_cSize -= cDelete;
    }

    public static xRTDelegate getArrayTemplate(TypeConstant typeParam) {
        xRTDelegate template = DELEGATES.get(typeParam);
        return template == null ? INSTANCE : template;
    }

    private static ObjectHandle[] reverse(ObjectHandle[] ahValue, int cSize) {
        ObjectHandle[] ahValueR = new ObjectHandle[cSize];
        for (int i = 0; i < cSize; ++i) {
            ahValueR[i] = ahValue[cSize - 1 - i];
        }
        return ahValueR;
    }

    private static ObjectHandle[] grow(ObjectHandle[] ahValue, int cSize) {
        int cCapacity = xRTDelegate.calculateCapacity(ahValue.length, cSize);
        ObjectHandle[] ahNew = new ObjectHandle[cCapacity];
        System.arraycopy(ahValue, 0, ahNew, 0, ahValue.length);
        return ahNew;
    }

    protected static int calculateCapacity(int cOld, int cDesired) {
        assert (cDesired > cOld);
        return cDesired + Math.max(cDesired >> 2, 16);
    }

    private static /* synthetic */ int lambda$assignArrayValueImpl$0(ObjectHandle[] ahVal, int cSize, int nIndex, ObjectHandle hValue, Frame frameCaller) {
        Arrays.fill(ahVal, cSize, nIndex, frameCaller.popStack());
        ahVal[nIndex] = hValue;
        return -1;
    }

    static {
        ELEMENT_TYPE = new String[]{"Element"};
    }

    public static class GenericArrayDelegate
    extends DelegateHandle {
        protected ObjectHandle[] m_ahValue;

        protected GenericArrayDelegate(TypeComposition clazz, ObjectHandle[] ahValue, xArray.Mutability mutability) {
            this(clazz, ahValue, ahValue.length, mutability);
        }

        protected GenericArrayDelegate(TypeComposition clzArray, ObjectHandle[] ahValue, int cSize, xArray.Mutability mutability) {
            super(clzArray, mutability);
            this.m_ahValue = ahValue;
            this.m_cSize = cSize;
        }

        public ObjectHandle get(long nIndex) {
            return this.m_ahValue[(int)nIndex];
        }

        public Stream<ObjectHandle> stream() {
            return Arrays.stream(this.m_ahValue);
        }

        @Override
        public boolean isShared(Container container, Map<ObjectHandle, Boolean> mapVisited) {
            if (mapVisited == null) {
                mapVisited = new IdentityHashMap<ObjectHandle, Boolean>();
            }
            return mapVisited.put(this, Boolean.TRUE) != null || GenericArrayDelegate.areShared(this.m_ahValue, container, mapVisited);
        }

        @Override
        public boolean makeImmutable() {
            ObjectHandle[] ahValue = this.m_ahValue;
            int c = (int)this.m_cSize;
            for (int i = 0; i < c; ++i) {
                ObjectHandle hValue = ahValue[i];
                if (hValue.isService() || hValue.makeImmutable()) continue;
                return false;
            }
            return super.makeImmutable();
        }

        @Override
        public boolean isNativeEqual() {
            return false;
        }
    }

    public static abstract class DelegateHandle
    extends ObjectHandle {
        public long m_cSize;
        private xArray.Mutability m_mutability;

        protected DelegateHandle(TypeComposition clazz, xArray.Mutability mutability) {
            super(clazz);
            this.m_fMutable = mutability != xArray.Mutability.Constant;
            this.m_mutability = mutability;
        }

        public xArray.Mutability getMutability() {
            return this.m_mutability;
        }

        public void setMutability(xArray.Mutability mutability) {
            assert (mutability.compareTo(this.m_mutability) <= 0);
            this.m_mutability = mutability;
        }

        @Override
        public boolean makeImmutable() {
            this.setMutability(xArray.Mutability.Constant);
            return super.makeImmutable();
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ", size=" + this.m_cSize;
        }
    }

    protected static class Equals
    implements Frame.Continuation {
        private final ObjectHandle[] ah1;
        private final ObjectHandle[] ah2;
        private final TypeConstant typeEl;
        private final int cElements;
        private final int[] holder;
        private final int iReturn;

        public Equals(ObjectHandle[] ah1, ObjectHandle[] ah2, TypeConstant typeEl, int cElements, int[] holder, int iReturn) {
            this.ah1 = ah1;
            this.ah2 = ah2;
            this.typeEl = typeEl;
            this.cElements = cElements;
            this.holder = holder;
            this.iReturn = iReturn;
        }

        @Override
        public int proceed(Frame frameCaller) {
            ObjectHandle hResult = frameCaller.popStack();
            if (hResult == xBoolean.FALSE) {
                return frameCaller.assignValue(this.iReturn, hResult);
            }
            return this.doNext(frameCaller);
        }

        public int doNext(Frame frameCaller) {
            block6: {
                block5: while (true) {
                    int iEl;
                    this.holder[0] = this.holder[0] + 1;
                    if (iEl >= this.cElements) break block6;
                    switch (this.typeEl.callEquals(frameCaller, this.ah1[iEl], this.ah2[iEl], -1)) {
                        case -1: {
                            ObjectHandle hResult;
                            if ((hResult = frameCaller.popStack()) != xBoolean.FALSE) continue block5;
                            return frameCaller.assignValue(this.iReturn, hResult);
                        }
                        case -5: {
                            frameCaller.m_frameNext.addContinuation(this);
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    break;
                }
                throw new IllegalStateException();
            }
            return frameCaller.assignValue(this.iReturn, xBoolean.TRUE);
        }
    }
}

