/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.BitBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.ByteView;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;

public class xRTNibbleDelegate
extends ByteBasedDelegate
implements ByteView {
    public static xRTNibbleDelegate INSTANCE;
    private static MethodStructure FN_OF_INT;
    private static PropertyConstant PROP_BITS;
    private static final ObjectHandle[] NIBBLES;

    public xRTNibbleDelegate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, (byte)0, (byte)15);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.pool();
        ClassStructure structNibble = (ClassStructure)pool.typeNibble().getSingleUnderlyingClass(false).getComponent();
        FN_OF_INT = structNibble.findMethod("of", 1, pool.typeInt64());
        PROP_BITS = (PropertyConstant)structNibble.getChild("bits").getIdentityConstant();
    }

    @Override
    public TypeConstant getCanonicalType() {
        ConstantPool pool = this.pool();
        return pool.ensureParameterizedTypeConstant(this.getInceptionClassConstant().getType(), pool.typeNibble());
    }

    @Override
    public xRTDelegate.DelegateHandle createDelegate(Container container, TypeConstant typeElement, int cSize, ObjectHandle[] ahContent, xArray.Mutability mutability) {
        byte[] ab = new byte[xRTNibbleDelegate.storage(cSize)];
        int c = ahContent.length;
        for (int i = 0; i < c; ++i) {
            int nNibble = xRTNibbleDelegate.getValue((ObjectHandle.GenericHandle)ahContent[i]);
            if (NIBBLES[nNibble] == null) {
                xRTNibbleDelegate.NIBBLES[nNibble] = ahContent[i];
            }
            xRTNibbleDelegate.setNibble(ab, i, nNibble);
        }
        return new NibbleArrayHandle(this.getCanonicalClass(), ab, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        NibbleArrayHandle hDelegate = (NibbleArrayHandle)hTarget;
        int nNibble = xRTNibbleDelegate.getNibble(hDelegate.m_abValue, lIndex);
        return xRTNibbleDelegate.assignNibble(frame, nNibble, iReturn);
    }

    @Override
    protected int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        NibbleArrayHandle hDelegate = (NibbleArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (lIndex >= cSize) {
            if (xRTNibbleDelegate.index(lIndex) >= abValue.length) {
                abValue = hDelegate.m_abValue = xRTNibbleDelegate.grow(abValue, xRTNibbleDelegate.storage(lIndex + 1L));
            }
            hDelegate.m_cSize = lIndex + 1L;
        }
        xRTNibbleDelegate.setNibble(abValue, (int)lIndex, xRTNibbleDelegate.getValue((ObjectHandle.GenericHandle)hValue));
        return -1;
    }

    @Override
    protected void insertElementImpl(xRTDelegate.DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        NibbleArrayHandle hDelegate = (NibbleArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (xRTNibbleDelegate.storage(cSize + 1L) > abValue.length) {
            abValue = hDelegate.m_abValue = xRTNibbleDelegate.grow(hDelegate.m_abValue, xRTNibbleDelegate.storage(cSize) + 1);
        }
        ++hDelegate.m_cSize;
        if (lIndex < cSize) {
            for (long i = lIndex + 1L; i < cSize; ++i) {
                xRTNibbleDelegate.setNibble(abValue, i, xRTNibbleDelegate.getNibble(abValue, i - 1L));
            }
        }
        xRTNibbleDelegate.setNibble(abValue, lIndex, xRTNibbleDelegate.getValue((ObjectHandle.GenericHandle)hElement));
    }

    @Override
    protected void deleteElementImpl(xRTDelegate.DelegateHandle hTarget, long lIndex) {
        NibbleArrayHandle hDelegate = (NibbleArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (lIndex < cSize - 1L) {
            for (long i = lIndex + 1L; i < cSize; ++i) {
                xRTNibbleDelegate.setNibble(abValue, i - 1L, xRTNibbleDelegate.getNibble(abValue, i));
            }
        }
        xRTNibbleDelegate.setNibble(abValue, --hDelegate.m_cSize, 0);
    }

    @Override
    protected void deleteRangeImpl(xRTDelegate.DelegateHandle hTarget, long lIndex, long cDelete) {
        long i;
        NibbleArrayHandle hDelegate = (NibbleArrayHandle)hTarget;
        long cSize = hDelegate.m_cSize;
        byte[] abValue = hDelegate.m_abValue;
        if (lIndex < cSize - cDelete) {
            for (i = lIndex + cDelete; i < cSize; ++i) {
                xRTNibbleDelegate.setNibble(abValue, i - cDelete, xRTNibbleDelegate.getNibble(abValue, i));
            }
        }
        for (i = cSize - cDelete; i < cSize; ++i) {
            xRTNibbleDelegate.setNibble(abValue, i, 0);
        }
        hDelegate.m_cSize -= cDelete;
    }

    @Override
    protected ObjectHandle makeElementHandle(long lValue) {
        throw new IllegalStateException();
    }

    public static int assignNibble(Frame frame, int nNibble, int iReturn) {
        ObjectHandle hNibble = NIBBLES[nNibble];
        if (hNibble == null) {
            ObjectHandle[] ahArg = new ObjectHandle[FN_OF_INT.getMaxVars()];
            ahArg[0] = xInt64.makeHandle(nNibble);
            switch (frame.call1(FN_OF_INT, null, ahArg, -1)) {
                case -5: {
                    Frame.Continuation stepNext = frameCaller -> {
                        ObjectHandle h;
                        xRTNibbleDelegate.NIBBLES[nNibble] = h = frameCaller.popStack();
                        return frameCaller.assignValue(iReturn, h);
                    };
                    frame.m_frameNext.addContinuation(stepNext);
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        return frame.assignValue(iReturn, hNibble);
    }

    public static int getValue(ObjectHandle.GenericHandle hNibble) {
        xArray.ArrayHandle haBits = (xArray.ArrayHandle)hNibble.getField(null, PROP_BITS);
        BitBasedDelegate.BitArrayHandle hDelegate = (BitBasedDelegate.BitArrayHandle)haBits.m_hDelegate;
        return (hDelegate.m_abValue[0] & 0xF0) >>> 4;
    }

    private static int storage(long cNibbles) {
        return (int)((cNibbles - 1L) / 2L + 1L);
    }

    private static int index(long iNibble) {
        return (int)(iNibble / 2L);
    }

    public static int getNibble(byte[] abValue, long iIndex) {
        return (byte)(abValue[xRTNibbleDelegate.index(iIndex)] >>> (int)(4L * (1L - iIndex % 2L))) & 0xF;
    }

    public static void setNibble(byte[] abValue, long iIndex, int bNibble) {
        int ix = xRTNibbleDelegate.index(iIndex);
        abValue[ix] = iIndex % 2L == 0L ? (byte)(abValue[ix] & 0xF | (byte)(bNibble << 4)) : (byte)(abValue[ix] & 0xF0 | (byte)(bNibble &= 0xF));
    }

    @Override
    public NibbleArrayHandle makeHandle(byte[] abValue, long cNibbles, xArray.Mutability mutability) {
        return new NibbleArrayHandle(this.getCanonicalClass(), abValue, cNibbles, mutability);
    }

    static {
        NIBBLES = new ObjectHandle[16];
    }

    public static class NibbleArrayHandle
    extends ByteBasedDelegate.ByteArrayHandle {
        public NibbleArrayHandle(TypeComposition clazz, byte[] abValue, long cSize, xArray.Mutability mutability) {
            super(clazz, abValue, cSize, mutability);
        }

        @Override
        public long getBitCount() {
            return this.m_cSize * 4L;
        }

        @Override
        protected void purgeUnusedSpace() {
            byte[] ab = this.m_abValue;
            int c = xRTNibbleDelegate.storage(this.m_cSize);
            if (ab.length != c) {
                byte[] abNew = new byte[c];
                System.arraycopy(ab, 0, abNew, 0, c);
                this.m_abValue = abNew;
            }
        }

        @Override
        public int compareTo(ObjectHandle that) {
            byte[] abThis = this.m_abValue;
            long cThis = this.m_cSize;
            byte[] abThat = ((NibbleArrayHandle)that).m_abValue;
            long cThat = ((NibbleArrayHandle)that).m_cSize;
            if (cThis != cThat) {
                return (int)(cThis - cThat);
            }
            int c = xRTNibbleDelegate.storage(cThis);
            for (int i = 0; i < c; ++i) {
                int iDiff = abThis[i] - abThat[i];
                if (iDiff == 0) continue;
                return iDiff < 0 ? -1 : 1;
            }
            return 0;
        }
    }
}

