/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import java.util.Arrays;
import java.util.stream.Stream;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public class xRTStringDelegate
extends xRTDelegate {
    public static xRTStringDelegate INSTANCE;

    public xRTStringDelegate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
    }

    @Override
    public TypeConstant getCanonicalType() {
        ConstantPool pool = this.pool();
        return pool.ensureParameterizedTypeConstant(this.getInceptionClassConstant().getType(), pool.typeString());
    }

    @Override
    public xRTDelegate.DelegateHandle createDelegate(Container container, TypeConstant typeElement, int cSize, ObjectHandle[] ahContent, xArray.Mutability mutability) {
        String[] as = new String[cSize];
        int c = ahContent.length;
        for (int i = 0; i < c; ++i) {
            as[i] = ((xString.StringHandle)ahContent[i]).getStringValue();
        }
        return this.makeHandle(as, cSize, mutability);
    }

    @Override
    public xRTDelegate.DelegateHandle fill(xRTDelegate.DelegateHandle hTarget, int cSize, ObjectHandle hValue) {
        StringArrayHandle hDelegate = (StringArrayHandle)hTarget;
        Arrays.fill(hDelegate.m_asValue, 0, cSize, ((xString.StringHandle)hValue).getStringValue());
        hDelegate.m_cSize = cSize;
        return hDelegate;
    }

    @Override
    public int getPropertyCapacity(Frame frame, ObjectHandle hTarget, int iReturn) {
        StringArrayHandle hDelegate = (StringArrayHandle)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle(hDelegate.m_asValue.length));
    }

    @Override
    public int setPropertyCapacity(Frame frame, ObjectHandle hTarget, long nCapacity) {
        StringArrayHandle hDelegate = (StringArrayHandle)hTarget;
        String[] asOld = hDelegate.m_asValue;
        int nSize = (int)hDelegate.m_cSize;
        if (nCapacity < (long)nSize) {
            return frame.raiseException(xException.illegalArgument(frame, "Capacity cannot be less then size"));
        }
        int nCapacityOld = asOld.length;
        if (nCapacity > (long)nCapacityOld) {
            String[] abNew = new String[(int)nCapacity];
            System.arraycopy(asOld, 0, abNew, 0, asOld.length);
            hDelegate.m_asValue = abNew;
        }
        return -1;
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        StringArrayHandle hDelegate = (StringArrayHandle)hTarget;
        String[] abValue = Arrays.copyOfRange(hDelegate.m_asValue, (int)ofStart, (int)(ofStart + cSize));
        if (fReverse) {
            abValue = xRTStringDelegate.reverseBytes(abValue, (int)cSize);
        }
        return new StringArrayHandle(hDelegate.getComposition(), abValue, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        StringArrayHandle hDelegate = (StringArrayHandle)hTarget;
        String s = hDelegate.m_asValue[(int)lIndex];
        return frame.assignValue(iReturn, xString.makeHandle(s));
    }

    @Override
    protected int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        StringArrayHandle hDelegate = (StringArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        String[] abValue = hDelegate.m_asValue;
        if (lIndex == (long)cSize) {
            if (cSize == abValue.length) {
                hDelegate.m_asValue = xRTStringDelegate.grow(abValue, cSize + 1);
                abValue = hDelegate.m_asValue;
            }
            ++hDelegate.m_cSize;
        }
        abValue[(int)lIndex] = ((xString.StringHandle)hValue).getStringValue();
        return -1;
    }

    @Override
    protected void insertElementImpl(xRTDelegate.DelegateHandle hTarget, ObjectHandle hElement, long lIndex) {
        StringArrayHandle hDelegate = (StringArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        String[] asValue = hDelegate.m_asValue;
        String bValue = ((xString.StringHandle)hElement).getStringValue();
        if (cSize == asValue.length) {
            asValue = hDelegate.m_asValue = xRTStringDelegate.grow(hDelegate.m_asValue, cSize + 1);
        }
        ++hDelegate.m_cSize;
        int nIndex = (int)lIndex;
        if (nIndex < cSize) {
            System.arraycopy(asValue, nIndex, asValue, nIndex + 1, cSize - nIndex);
        }
        asValue[nIndex] = bValue;
    }

    @Override
    protected void deleteElementImpl(xRTDelegate.DelegateHandle hTarget, long lIndex) {
        StringArrayHandle hDelegate = (StringArrayHandle)hTarget;
        int cSize = (int)hDelegate.m_cSize;
        String[] asValue = hDelegate.m_asValue;
        if (lIndex < (long)(cSize - 1)) {
            int nIndex = (int)lIndex;
            System.arraycopy(asValue, nIndex + 1, asValue, nIndex, cSize - nIndex - 1);
        }
        asValue[(int)(--hDelegate.m_cSize)] = null;
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        StringArrayHandle h1 = (StringArrayHandle)hValue1;
        StringArrayHandle h2 = (StringArrayHandle)hValue2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(Arrays.equals(h1.m_asValue, h2.m_asValue)));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        StringArrayHandle h1 = (StringArrayHandle)hValue1;
        StringArrayHandle h2 = (StringArrayHandle)hValue2;
        if (h1 == h2) {
            return true;
        }
        return h1.getMutability() == h2.getMutability() && h1.m_cSize == h2.m_cSize && Arrays.equals(h1.m_asValue, h2.m_asValue);
    }

    public static String[] reverseBytes(String[] abValue, int cSize) {
        String[] abValueR = new String[cSize];
        for (int i = 0; i < cSize; ++i) {
            abValueR[i] = abValue[cSize - 1 - i];
        }
        return abValueR;
    }

    protected static String[] grow(String[] abValue, int cSize) {
        int cCapacity = xRTStringDelegate.calculateCapacity(abValue.length, cSize);
        String[] abNew = new String[cCapacity];
        System.arraycopy(abValue, 0, abNew, 0, abValue.length);
        return abNew;
    }

    public StringArrayHandle makeHandle(String[] as, long cSize, xArray.Mutability mutability) {
        return new StringArrayHandle(this.getCanonicalClass(), as, cSize, mutability);
    }

    public static class StringArrayHandle
    extends xRTDelegate.DelegateHandle {
        protected String[] m_asValue;

        protected StringArrayHandle(TypeComposition clazz, String[] asValue, long cSize, xArray.Mutability mutability) {
            super(clazz, mutability);
            this.m_asValue = asValue;
            this.m_cSize = cSize;
        }

        public String get(long nIndex) {
            if (nIndex < 0L || nIndex >= this.m_cSize) {
                throw new ArrayIndexOutOfBoundsException((int)nIndex);
            }
            return this.m_asValue[(int)nIndex];
        }

        public Stream<String> stream() {
            return Arrays.stream(this.m_asValue, 0, (int)this.m_cSize);
        }

        @Override
        public boolean makeImmutable() {
            if (this.isMutable()) {
                String[] as = this.m_asValue;
                int c = (int)this.m_cSize;
                if (as.length != c) {
                    String[] asNew = new String[c];
                    System.arraycopy(as, 0, asNew, 0, c);
                    this.m_asValue = asNew;
                }
                return super.makeImmutable();
            }
            return true;
        }

        @Override
        public boolean isNativeEqual() {
            return true;
        }

        @Override
        public int compareTo(ObjectHandle that) {
            String[] asThis = this.m_asValue;
            int cThis = (int)this.m_cSize;
            String[] asThat = ((StringArrayHandle)that).m_asValue;
            int cThat = (int)((StringArrayHandle)that).m_cSize;
            if (cThis != cThat) {
                return cThis - cThat;
            }
            for (int i = 0; i < cThis; ++i) {
                int iDiff = asThis[i].compareTo(asThat[i]);
                if (iDiff == 0) continue;
                return iDiff;
            }
            return 0;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.m_asValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof StringArrayHandle)) return false;
            StringArrayHandle that = (StringArrayHandle)obj;
            if (!Arrays.equals(this.m_asValue, that.m_asValue)) return false;
            return true;
        }
    }
}

