/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.collections.arrays.ByteView;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTFloat64Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromByte;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.BaseBinaryFP;
import org.xvm.runtime.template.numbers.xFloat64;
import org.xvm.util.Handy;

public class xRTViewFromByteToFloat64
extends xRTViewFromByte {
    public static xRTViewFromByteToFloat64 INSTANCE;

    public xRTViewFromByteToFloat64(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public TypeConstant getCanonicalType() {
        ConstantPool pool = this.pool();
        return pool.ensureParameterizedTypeConstant(this.getInceptionClassConstant().getType(), pool.typeFloat64());
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        xRTViewFromByte.ViewHandle hView = (xRTViewFromByte.ViewHandle)hTarget;
        xRTDelegate.DelegateHandle hSource = hView.f_hSource;
        ClassTemplate tSource = hSource.getTemplate();
        if (tSource instanceof ByteView) {
            ByteView tView = (ByteView)((Object)tSource);
            double[] adValue = new double[(int)cSize];
            int i = 0;
            while ((long)i < cSize) {
                byte[] ab = tView.getBytes(hSource, ofStart + (long)i * 8L, 8L, fReverse);
                adValue[i] = Double.longBitsToDouble(Handy.byteArrayToLong(ab, 0));
                ++i;
            }
            return xRTFloat64Delegate.INSTANCE.makeHandle(adValue, adValue.length, mutability);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        xRTViewFromByte.ViewHandle hView = (xRTViewFromByte.ViewHandle)hTarget;
        xRTDelegate.DelegateHandle hSource = hView.f_hSource;
        ClassTemplate tSource = hSource.getTemplate();
        if (tSource instanceof ByteView) {
            ByteView tView = (ByteView)((Object)tSource);
            byte[] ab = tView.getBytes(hSource, lIndex * 8L, 8L, false);
            double d = Double.longBitsToDouble(Handy.byteArrayToLong(ab, 0));
            return frame.assignValue(iReturn, xFloat64.INSTANCE.makeHandle(d));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        xRTViewFromByte.ViewHandle hView = (xRTViewFromByte.ViewHandle)hTarget;
        xRTDelegate.DelegateHandle hSource = hView.f_hSource;
        ClassTemplate tSource = hSource.getTemplate();
        if (tSource instanceof ByteView) {
            ByteView tView = (ByteView)((Object)tSource);
            long lValue = Double.doubleToRawLongBits(((BaseBinaryFP.FloatHandle)hValue).getValue());
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 56 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 48 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 40 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 32 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 24 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 16 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 8 & 0xFFL));
            tView.assignByte(hSource, lIndex * 8L, (byte)(lValue & 0xFFL));
            return -1;
        }
        throw new UnsupportedOperationException();
    }
}

