/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.collections.arrays.ByteView;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTInt64Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromByte;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.util.Handy;

public class xRTViewFromByteToInt64
extends xRTViewFromByte {
    public static xRTViewFromByteToInt64 INSTANCE;

    public xRTViewFromByteToInt64(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public TypeConstant getCanonicalType() {
        ConstantPool pool = this.pool();
        return pool.ensureParameterizedTypeConstant(this.getInceptionClassConstant().getType(), pool.typeInt64());
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        xRTViewFromByte.ViewHandle hView = (xRTViewFromByte.ViewHandle)hTarget;
        xRTDelegate.DelegateHandle hSource = hView.f_hSource;
        ClassTemplate tSource = hSource.getTemplate();
        if (tSource instanceof ByteView) {
            ByteView tView = (ByteView)((Object)tSource);
            long[] alValue = new long[(int)cSize];
            int i = 0;
            while ((long)i < cSize) {
                byte[] ab = tView.getBytes(hSource, ofStart + (long)i * 8L, 8L, fReverse);
                alValue[i] = Handy.byteArrayToLong(ab, 0);
                ++i;
            }
            return xRTInt64Delegate.INSTANCE.makeHandle(alValue, alValue.length, mutability);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        xRTViewFromByte.ViewHandle hView = (xRTViewFromByte.ViewHandle)hTarget;
        xRTDelegate.DelegateHandle hSource = hView.f_hSource;
        ClassTemplate tSource = hSource.getTemplate();
        if (tSource instanceof ByteView) {
            ByteView tView = (ByteView)((Object)tSource);
            byte[] ab = tView.getBytes(hSource, lIndex * 8L, 8L, false);
            long l = Handy.byteArrayToLong(ab, 0);
            return frame.assignValue(iReturn, xInt64.makeHandle(l));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        xRTViewFromByte.ViewHandle hView = (xRTViewFromByte.ViewHandle)hTarget;
        xRTDelegate.DelegateHandle hSource = hView.f_hSource;
        ClassTemplate tSource = hSource.getTemplate();
        if (tSource instanceof ByteView) {
            ByteView tView = (ByteView)((Object)tSource);
            long lValue = ((ObjectHandle.JavaLong)hValue).getValue();
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 56 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 48 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 40 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 32 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 24 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 16 & 0xFFL));
            tView.assignByte(hSource, lIndex++ * 8L, (byte)(lValue >>> 8 & 0xFFL));
            tView.assignByte(hSource, lIndex * 8L, (byte)(lValue & 0xFFL));
            return -1;
        }
        throw new UnsupportedOperationException();
    }
}

