/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.collections.arrays;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.BitBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.BitView;
import org.xvm.runtime.template._native.collections.arrays.LongBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTBitDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTFloat64Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTSlicingDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTView;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromBit;
import org.xvm.runtime.template._native.collections.arrays.xRTViewToBit;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xBit;
import org.xvm.util.Handy;

public class xRTViewToBitFromFloat64
extends xRTViewToBit
implements BitView {
    public static xRTViewToBitFromFloat64 INSTANCE;

    public xRTViewToBitFromFloat64(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public TypeConstant getCanonicalType() {
        ConstantPool pool = this.pool();
        return pool.ensureParameterizedTypeConstant(this.getInceptionClassConstant().getType(), pool.typeFloat64());
    }

    @Override
    public xRTDelegate.DelegateHandle createBitViewDelegate(xRTDelegate.DelegateHandle hSource, xArray.Mutability mutability) {
        ClassComposition clzView = this.getCanonicalClass();
        if (hSource instanceof xRTSlicingDelegate.SliceHandle) {
            xRTSlicingDelegate.SliceHandle hSlice = (xRTSlicingDelegate.SliceHandle)hSource;
            xRTFloat64Delegate.DoubleArrayHandle hLong = (xRTFloat64Delegate.DoubleArrayHandle)hSlice.f_hSource;
            ViewHandle hView = new ViewHandle(clzView, hLong, hLong.m_cSize * 64L, mutability);
            return this.slice(hView, hSlice.f_ofStart * 64L, hSlice.m_cSize * 64L, false);
        }
        if (hSource instanceof xRTViewFromBit.ViewHandle) {
            xRTViewFromBit.ViewHandle hView = (xRTViewFromBit.ViewHandle)hSource;
            return new ViewHandle(clzView, (xRTFloat64Delegate.DoubleArrayHandle)hView.f_hSource, hSource.m_cSize, mutability);
        }
        xRTFloat64Delegate.DoubleArrayHandle hLong = (xRTFloat64Delegate.DoubleArrayHandle)hSource;
        return new ViewHandle(clzView, hLong, hSource.m_cSize * 64L, mutability);
    }

    @Override
    protected xRTDelegate.DelegateHandle createCopyImpl(xRTDelegate.DelegateHandle hTarget, xArray.Mutability mutability, long ofStart, long cSize, boolean fReverse) {
        ViewHandle hView = (ViewHandle)hTarget;
        byte[] abBits = this.getBits(hView, ofStart, cSize, fReverse);
        return xRTBitDelegate.INSTANCE.makeHandle(abBits, cSize, mutability);
    }

    @Override
    protected int extractArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, int iReturn) {
        ViewHandle hView = (ViewHandle)hTarget;
        return frame.assignValue(iReturn, xBit.makeHandle(xRTViewToBitFromFloat64.getBit(hView.f_hSource.m_adValue, lIndex)));
    }

    @Override
    public int assignArrayValueImpl(Frame frame, xRTDelegate.DelegateHandle hTarget, long lIndex, ObjectHandle hValue) {
        ViewHandle hView = (ViewHandle)hTarget;
        xRTViewToBitFromFloat64.setBit(hView.f_hSource.m_adValue, lIndex, ((ObjectHandle.JavaLong)hValue).getValue() != 0L);
        return -1;
    }

    @Override
    public byte[] getBits(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBits, boolean fReverse) {
        ViewHandle hView = (ViewHandle)hDelegate;
        byte[] abBits = xRTViewToBitFromFloat64.extractBits(hView.f_hSource.m_adValue, ofStart, cBits);
        if (fReverse) {
            abBits = BitBasedDelegate.reverseBits(abBits, cBits);
        }
        return abBits;
    }

    @Override
    public boolean extractBit(xRTDelegate.DelegateHandle hDelegate, long of) {
        ViewHandle hView = (ViewHandle)hDelegate;
        return xRTViewToBitFromFloat64.getBit(hView.f_hSource.m_adValue, of);
    }

    @Override
    public void assignBit(xRTDelegate.DelegateHandle hDelegate, long of, boolean fBit) {
        ViewHandle hView = (ViewHandle)hDelegate;
        xRTViewToBitFromFloat64.setBit(hView.f_hSource.m_adValue, of, fBit);
    }

    protected static byte getByte(double[] adValue, long of) {
        int ixVal = (int)(of / 8L);
        int ofByte = 7 - (int)(of & 7L);
        return (byte)(Double.doubleToRawLongBits(adValue[ixVal]) >>> ofByte * 8 & 0xFFL);
    }

    protected static void setByte(double[] adValue, long of, byte bValue) {
        int ixVal = (int)(of / 8L);
        int ofByte = 7 - (int)(of & 7L);
        long lMask = 255L << ofByte * 8;
        adValue[ixVal] = Double.doubleToRawLongBits(adValue[ixVal]) & (lMask ^ 0xFFFFFFFFFFFFFFFFL) | ((long)bValue & 0xFFL) << ofByte * 8;
    }

    protected static byte[] extractBits(double[] adValue, long ofStart, long cBits) {
        int cBytes = BitBasedDelegate.storage(cBits);
        byte[] abBits = new byte[cBytes];
        int ofDest = 0;
        if (ofStart % 64L == 0L) {
            int ixSource = (int)(ofStart / 64L);
            int cVals = (int)(cBits / 64L);
            int i = 0;
            while (i < cVals) {
                Handy.toByteArray(Double.doubleToRawLongBits(adValue[ixSource + i]), abBits, ofDest);
                ++i;
                ofDest += 8;
            }
            if (cBits % 64L == 0L) {
                return abBits;
            }
            ofStart += (long)cVals * 64L;
            cBits %= 64L;
        }
        for (long i = 0L; i < cBits; ++i) {
            BitBasedDelegate.setBit(abBits, (long)ofDest + i, xRTViewToBitFromFloat64.getBit(adValue, ofStart + i));
        }
        return abBits;
    }

    protected static boolean getBit(double[] adValue, long lIndex) {
        return (Double.doubleToRawLongBits(adValue[LongBasedDelegate.bitIndex(lIndex)]) & LongBasedDelegate.bitMask(lIndex)) != 0L;
    }

    protected static void setBit(double[] adValue, long lIndex, boolean fSet) {
        int nIndex = LongBasedDelegate.bitIndex(lIndex);
        long lValue = Double.doubleToRawLongBits(adValue[nIndex]);
        adValue[nIndex] = fSet ? Double.longBitsToDouble(lValue | LongBasedDelegate.bitMask(lIndex)) : Double.longBitsToDouble(lValue & (LongBasedDelegate.bitMask(lIndex) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public byte[] getBytes(xRTDelegate.DelegateHandle hDelegate, long ofStart, long cBytes, boolean fReverse) {
        return this.getBits(hDelegate, ofStart * 8L, cBytes * 8L, fReverse);
    }

    @Override
    public byte extractByte(xRTDelegate.DelegateHandle hDelegate, long of) {
        ViewHandle hView = (ViewHandle)hDelegate;
        return xRTViewToBitFromFloat64.getByte(hView.f_hSource.m_adValue, of);
    }

    @Override
    public void assignByte(xRTDelegate.DelegateHandle hDelegate, long of, byte bValue) {
        ViewHandle hView = (ViewHandle)hDelegate;
        xRTViewToBitFromFloat64.setByte(hView.f_hSource.m_adValue, of, bValue);
    }

    protected static class ViewHandle
    extends xRTView.ViewHandle {
        protected final xRTFloat64Delegate.DoubleArrayHandle f_hSource;

        protected ViewHandle(TypeComposition clazz, xRTFloat64Delegate.DoubleArrayHandle hSource, long cSize, xArray.Mutability mutability) {
            super(clazz, mutability);
            this.f_hSource = hSource;
            this.m_cSize = cSize;
        }

        @Override
        public xRTDelegate.DelegateHandle getSource() {
            return this.f_hSource;
        }
    }
}

