/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt8Delegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xObject;
import org.xvm.runtime.template.xService;

public class xRTAlgorithms
extends xService {
    public static xRTAlgorithms INSTANCE;
    private ObjectHandle m_hAlgorithms;

    public xRTAlgorithms(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("getAlgorithmInfo", null, null);
        this.invalidateTypeInfo();
    }

    public ObjectHandle ensureAlgorithms(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hAlgorithms = this.m_hAlgorithms;
        if (hAlgorithms == null) {
            this.m_hAlgorithms = hAlgorithms = this.instantiateAlgorithms(frame, hOpts);
        }
        return hAlgorithms;
    }

    protected ObjectHandle instantiateAlgorithms(Frame frame, ObjectHandle hOpts) {
        ClassComposition clz = this.getCanonicalClass();
        MethodStructure ctor = this.getStructure().findConstructor(new TypeConstant[0]);
        ServiceContext context = this.f_container.createServiceContext(this.f_sName);
        switch (context.sendConstructRequest(frame, clz, ctor, null, new ObjectHandle[ctor.getMaxVars()], -1)) {
            case -1: {
                return this.invokeCreateAlgorithms(frame);
            }
            case -5: {
                Frame frameNext = frame.m_frameNext;
                frameNext.addContinuation(frameCaller -> frameCaller.pushStack(this.invokeCreateAlgorithms(frameCaller)));
                return new ObjectHandle.DeferredCallHandle(frameNext);
            }
            case -3: {
                return new ObjectHandle.DeferredCallHandle(frame.clearException());
            }
        }
        throw new IllegalStateException();
    }

    private ObjectHandle invokeCreateAlgorithms(Frame frame) {
        ClassComposition clz = this.getCanonicalClass();
        MethodStructure method = this.getStructure().findMethod("createAlgorithms", 0, new TypeConstant[0]);
        CallChain chain = clz.getMethodCallChain(method.getIdentityConstant().getSignature());
        return frame.popResult(chain.invoke(frame, frame.popStack(), -1));
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "getAlgorithmInfo": {
                return this.invokeGetAlgorithmInfo(frame, (xString.StringHandle)ahArg[0], (xEnum.EnumHandle)ahArg[1], aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    private int invokeGetAlgorithmInfo(Frame frame, xString.StringHandle hName, xEnum.EnumHandle hMethod, int[] aiReturn) {
        String sName = hName.getStringValue();
        try {
            int nBlockSize;
            ObjectHandle hImpl = switch (hMethod.getOrdinal()) {
                case 0 -> {
                    MessageDigest digest = MessageDigest.getInstance(sName);
                    nBlockSize = 0;
                    yield new DigestHandle(digest);
                }
                case 1, 2 -> {
                    Cipher cipher = Cipher.getInstance(sName);
                    nBlockSize = cipher.getBlockSize();
                    yield new CipherHandle(cipher);
                }
                case 3 -> {
                    Signature sig = Signature.getInstance(sName);
                    nBlockSize = 0;
                    yield new SignatureHandle(sig);
                }
                case 4 -> {
                    KeyGenerator generator = KeyGenerator.getInstance(sName);
                    nBlockSize = 0;
                    yield new KeyGenHandle(generator);
                }
                default -> throw new IllegalArgumentException();
            };
            ArrayList<ObjectHandle> list = new ArrayList<ObjectHandle>(9);
            list.add(xInt64.makeHandle(nBlockSize));
            list.add(hImpl);
            return frame.assignValues(aiReturn, list.toArray(Utils.OBJECTS_NONE));
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Key extractKey(Frame frame, ObjectHandle hKey, String sAlgorithm, KeyForm keyForm) throws GeneralSecurityException {
        if (hKey instanceof SecretHandle) {
            SecretHandle hSecret = (SecretHandle)hKey;
            return hSecret.f_key;
        }
        ByteBasedDelegate.ByteArrayHandle hBytes = (ByteBasedDelegate.ByteArrayHandle)((xArray.ArrayHandle)hKey).m_hDelegate;
        byte[] abRaw = xRTUInt8Delegate.getBytes(hBytes);
        switch (sAlgorithm) {
            case "DES": {
                switch (keyForm.ordinal()) {
                    case 2: 
                    case 3: {
                        return SecretKeyFactory.getInstance(sAlgorithm).generateSecret(new DESKeySpec(abRaw));
                    }
                    default: {
                        throw new GeneralSecurityException(sAlgorithm + " algorithm only supports secret keys");
                    }
                }
            }
            case "DESede": {
                switch (keyForm.ordinal()) {
                    case 2: 
                    case 3: {
                        return SecretKeyFactory.getInstance(sAlgorithm).generateSecret(new DESedeKeySpec(abRaw));
                    }
                    default: {
                        throw new GeneralSecurityException(sAlgorithm + " algorithm only supports secret keys");
                    }
                }
            }
            case "RSA": {
                Key key;
                switch (keyForm.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: 
                    case 2: {
                        key = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(abRaw));
                        return key;
                    }
                    case 1: 
                    case 3: {
                        key = KeyFactory.getInstance("RSA").generatePrivate(new X509EncodedKeySpec(abRaw));
                    }
                }
                return key;
            }
        }
        throw new GeneralSecurityException("Cannot make a raw key for " + sAlgorithm);
    }

    public static class DigestHandle
    extends ObjectHandle {
        public final MessageDigest f_digest;

        protected DigestHandle(MessageDigest digest) {
            super(xObject.INSTANCE.getCanonicalClass());
            this.f_digest = digest;
        }
    }

    public static class CipherHandle
    extends ObjectHandle {
        public final Cipher f_cipher;

        protected CipherHandle(Cipher cipher) {
            super(xObject.INSTANCE.getCanonicalClass());
            this.f_cipher = cipher;
        }
    }

    public static class SignatureHandle
    extends ObjectHandle {
        public final Signature f_signature;

        protected SignatureHandle(Signature signature) {
            super(xObject.INSTANCE.getCanonicalClass());
            this.f_signature = signature;
        }
    }

    public static class KeyGenHandle
    extends ObjectHandle {
        public final KeyGenerator f_generator;

        protected KeyGenHandle(KeyGenerator generator) {
            super(xObject.INSTANCE.getCanonicalClass());
            this.f_generator = generator;
        }
    }

    public static class SecretHandle
    extends ObjectHandle {
        public final Key f_key;

        protected SecretHandle(Key key) {
            super(xObject.INSTANCE.getCanonicalClass());
            this.f_key = key;
        }
    }

    public static enum KeyForm {
        Public,
        Private,
        PublicOrSecret,
        PrivateOrSecret;

    }
}

