/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.crypto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.crypto.xRTKeyStore;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;

public class xRTCertificateManager
extends xService {
    public static xRTCertificateManager INSTANCE;
    private TypeConstant m_typeCanonical;

    public xRTCertificateManager(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("createCertificateImpl", null, VOID);
        this.markNativeMethod("revokeCertificateImpl", null, VOID);
        this.markNativeMethod("createSymmetricKeyImpl", null, VOID);
        this.markNativeMethod("createPasswordImpl", null, VOID);
        this.markNativeMethod("changeStorePasswordImpl", null, VOID);
        this.markNativeMethod("extractKeyImpl", null, BYTES);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        TypeConstant type = this.m_typeCanonical;
        if (type == null) {
            ConstantPool pool = this.pool();
            this.m_typeCanonical = type = pool.ensureTerminalTypeConstant(pool.ensureClassConstant(pool.ensureModuleConstant("crypto.xtclang.org"), "CertificateManager"));
        }
        return type;
    }

    public ObjectHandle ensureManager(Frame frame, ObjectHandle hOpts) {
        xString.StringHandle hS;
        xString.StringHandle hProvider = hOpts instanceof xString.StringHandle ? (hS = (xString.StringHandle)hOpts) : xString.makeHandle("self");
        ClassComposition clz = this.getCanonicalClass();
        xService.ServiceHandle hMgr = this.createServiceHandle(this.f_container.createServiceContext("CertificateManager"), clz, this.getCanonicalType());
        hMgr.setField(0, hProvider);
        return hMgr;
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "createCertificateImpl": {
                return this.invokeAsIOTask(frame, () -> this.invokeCreateCertificate(frame, (xService.ServiceHandle)hTarget, ahArg));
            }
            case "revokeCertificateImpl": {
                return this.invokeAsIOTask(frame, () -> this.invokeRevokeCertificate(frame, (xService.ServiceHandle)hTarget, ahArg));
            }
            case "createSymmetricKeyImpl": {
                return this.invokeAsIOTask(frame, () -> this.invokeCreateSymmetricKey(frame, ahArg));
            }
            case "createPasswordImpl": {
                return this.invokeAsIOTask(frame, () -> this.invokeCreatePassword(frame, ahArg));
            }
            case "changeStorePasswordImpl": {
                return this.invokeAsIOTask(frame, () -> this.invokeChangeStorePassword(frame, ahArg));
            }
            case "extractKeyImpl": {
                return this.invokeExtractKey(frame, ahArg, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    private int invokeAsIOTask(Frame frame, Callable<ObjectHandle.ExceptionHandle> task) {
        CompletableFuture<ObjectHandle.ExceptionHandle> cfResult = frame.f_context.f_container.scheduleIO(task);
        Frame.Continuation continuation = frameCaller -> {
            try {
                ObjectHandle.ExceptionHandle hFailure = (ObjectHandle.ExceptionHandle)cfResult.get();
                return hFailure == null ? -1 : frameCaller.raiseException(hFailure);
            }
            catch (Throwable e) {
                return frameCaller.raiseException("Unexpected execution failure " + String.valueOf(e));
            }
        };
        return frame.waitForIO(cfResult, continuation);
    }

    private ObjectHandle.ExceptionHandle invokeCreateCertificate(Frame frame, xService.ServiceHandle hMgr, ObjectHandle[] ahArg) {
        xString.StringHandle hStorePath = (xString.StringHandle)ahArg[0];
        xString.StringHandle hPwd = xRTKeyStore.getPassword(frame, ahArg[1]);
        xString.StringHandle hName = (xString.StringHandle)ahArg[2];
        xString.StringHandle hDName = (xString.StringHandle)ahArg[3];
        xString.StringHandle hProvider = (xString.StringHandle)hMgr.getField(0);
        this.runSilentCommand("keytool", "-delete", "-alias", hName.getStringValue(), "-keystore", hStorePath.getStringValue(), "-storepass", hPwd.getStringValue());
        switch (hProvider.getStringValue()) {
            case "self": {
                return this.runNoInputCommand(frame, "keytool", "-genkeypair", "-keyalg", "RSA", "-keysize", "2048", "-validity", "90", "-alias", hName.getStringValue(), "-dname", hDName.getStringValue(), "-storetype", "PKCS12", "-keystore", hStorePath.getStringValue(), "-storepass", hPwd.getStringValue());
            }
            case "certbot-staging": {
                return this.createCertificateWithCertbot(frame, hStorePath, hPwd, hName, hDName, true);
            }
            case "certbot": {
                return this.createCertificateWithCertbot(frame, hStorePath, hPwd, hName, hDName, false);
            }
        }
        return xException.makeHandle(frame, "Unsupported certificate provider: " + hProvider.getStringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectHandle.ExceptionHandle createCertificateWithCertbot(Frame frame, xString.StringHandle hStorePath, xString.StringHandle hPwd, xString.StringHandle hName, xString.StringHandle hDName, boolean fStaging) {
        String sDName = hDName.getStringValue();
        String sName = hName.getStringValue();
        File dirCerts = this.getCertsPath(hStorePath);
        String sCertsDir = dirCerts.getAbsolutePath();
        if (!dirCerts.exists()) {
            if (!dirCerts.mkdir()) return xException.ioException(frame, "Cannot create directory: " + sCertsDir);
        }
        if (!dirCerts.isDirectory()) {
            return xException.ioException(frame, "Cannot create directory: " + sCertsDir);
        }
        File dirChallenge = this.getChallengePath(hStorePath);
        String sChallengeDir = dirChallenge.getAbsolutePath();
        if (!dirChallenge.exists()) {
            if (!dirChallenge.mkdir()) return xException.ioException(frame, "Cannot create directory: " + sChallengeDir);
        }
        if (!dirChallenge.isDirectory()) {
            return xException.ioException(frame, "Cannot create directory: " + sChallengeDir);
        }
        int ofDomain = sDName.indexOf("CN=");
        assert (ofDomain >= 0);
        String sDomain = sDName.substring(ofDomain + 3);
        String sKeyPath = sCertsDir + File.separator + sDomain + ".key";
        String sCsrPath = sCertsDir + File.separator + sDomain + ".csr";
        try {
            ObjectHandle.ExceptionHandle hFailure = this.runCommand(frame, null, "openssl", "genpkey", "-algorithm", "RSA", "-out", sKeyPath, "-pkeyopt", "rsa_keygen_bits:2048");
            if (hFailure != null) {
                ObjectHandle.ExceptionHandle exceptionHandle = hFailure;
                return exceptionHandle;
            }
            hFailure = this.runCommand(frame, null, "openssl", "req", "-new", "-key", sKeyPath, "-out", sCsrPath, "-subj", "/" + sDName.replace(',', '/'));
            if (hFailure != null) {
                ObjectHandle.ExceptionHandle exceptionHandle = hFailure;
                return exceptionHandle;
            }
            String sConfigDir = sCertsDir + File.separator + "config";
            String sWorkDir = sCertsDir + File.separator + "work";
            String sLogDir = sCertsDir + File.separator + "logs";
            String sCertPath = sCertsDir + File.separator + "cert.pem";
            String sChainPath = sCertsDir + File.separator + "chain.pem";
            String sFullCertPath = sCertsDir + File.separator + "fullchain.pem";
            new File(sCertPath).delete();
            new File(sChainPath).delete();
            new File(sFullCertPath).delete();
            ObjectHandle.ExceptionHandle exceptionHandle = hFailure = fStaging ? this.runCommand(frame, "yes\nyes", "certbot", "certonly", "--staging", "--webroot", "--webroot-path", sChallengeDir, "--config-dir", sConfigDir, "--work-dir", sWorkDir, "--logs-dir", sLogDir, "--key-path", sKeyPath, "--cert-path", sCertPath, "--chain-path", sChainPath, "--fullchain-path", sFullCertPath, "-d", sDomain, "--csr", sCsrPath, "--register-unsafely-without-email") : this.runCommand(frame, "yes\nyes", "certbot", "certonly", "--webroot", "--webroot-path", sChallengeDir, "--config-dir", sConfigDir, "--work-dir", sWorkDir, "--logs-dir", sLogDir, "--key-path", sKeyPath, "--cert-path", sCertPath, "--chain-path", sChainPath, "--fullchain-path", sFullCertPath, "-d", sDomain, "--csr", sCsrPath, "--register-unsafely-without-email");
            if (hFailure != null) {
                ObjectHandle.ExceptionHandle exceptionHandle2 = hFailure;
                return exceptionHandle2;
            }
            String sTempStorePath = sCertsDir + File.separator + sName + ".p12";
            hFailure = this.runCommand(frame, null, "openssl", "pkcs12", "-export", "-out", sTempStorePath, "-inkey", sKeyPath, "-in", sFullCertPath, "-name", sName, "-passin", "pass:" + hPwd.getStringValue(), "-passout", "pass:" + hPwd.getStringValue());
            if (hFailure != null) {
                ObjectHandle.ExceptionHandle exceptionHandle3 = hFailure;
                return exceptionHandle3;
            }
            hFailure = this.runCommand(frame, null, "keytool", "-importkeystore", "-srckeystore", sTempStorePath, "-srcstoretype", "PKCS12", "-destkeystore", hStorePath.getStringValue(), "-deststoretype", "PKCS12", "-alias", sName, "-srcstorepass", hPwd.getStringValue(), "-deststorepass", hPwd.getStringValue());
            new File(sTempStorePath).delete();
            ObjectHandle.ExceptionHandle exceptionHandle4 = hFailure;
            return exceptionHandle4;
        }
        finally {
            try {
                new File(sKeyPath).delete();
            }
            catch (Exception exception) {}
        }
    }

    private ObjectHandle.ExceptionHandle invokeRevokeCertificate(Frame frame, xService.ServiceHandle hMgr, ObjectHandle[] ahArg) {
        xString.StringHandle hPath = (xString.StringHandle)ahArg[0];
        xString.StringHandle hPwd = xRTKeyStore.getPassword(frame, ahArg[1]);
        xString.StringHandle hName = (xString.StringHandle)ahArg[2];
        xString.StringHandle hProvider = (xString.StringHandle)hMgr.getField(0);
        File dirCerts = this.getCertsPath(hPath);
        if (dirCerts.isDirectory()) {
            String sCertsDir = dirCerts.getAbsolutePath();
            switch (hProvider.getStringValue()) {
                case "self": {
                    break;
                }
                case "certbot-staging": {
                    this.runCommand(frame, "yes\nyes", "certbot", "revoke", "--staging", "--config-dir", sCertsDir + File.separator + "config", "--work-dir", sCertsDir + File.separator + "work", "--logs-dir", sCertsDir + File.separator + "logs", "--cert-name", hName.getStringValue(), "--reason", "unspecified");
                    break;
                }
                case "certbot": {
                    this.runCommand(frame, "yes\nyes", "certbot", "revoke", "--config-dir", sCertsDir + File.separator + "config", "--work-dir", sCertsDir + File.separator + "work", "--logs-dir", sCertsDir + File.separator + "logs", "--cert-name", hName.getStringValue(), "--reason", "unspecified");
                    break;
                }
                default: {
                    return xException.makeHandle(frame, "Unsupported certificate provider: " + hProvider.getStringValue());
                }
            }
        }
        this.runSilentCommand("keytool", "-delete", "-alias", hName.getStringValue(), "-keystore", hPath.getStringValue(), "-storepass", hPwd.getStringValue());
        return null;
    }

    private File getCertsPath(xString.StringHandle hPath) {
        File fileKeystore = Path.of(hPath.getStringValue(), new String[0]).toFile();
        return new File(fileKeystore.getParentFile(), ".certs");
    }

    private File getChallengePath(xString.StringHandle hPath) {
        File fileKeystore = Path.of(hPath.getStringValue(), new String[0]).toFile();
        return new File(fileKeystore.getParentFile(), ".challenge");
    }

    private ObjectHandle.ExceptionHandle invokeCreateSymmetricKey(Frame frame, ObjectHandle[] ahArg) {
        xString.StringHandle hPath = (xString.StringHandle)ahArg[0];
        xString.StringHandle hPwd = xRTKeyStore.getPassword(frame, ahArg[1]);
        xString.StringHandle hName = (xString.StringHandle)ahArg[2];
        this.runSilentCommand("keytool", "-delete", "-alias", hName.getStringValue(), "-keystore", hPath.getStringValue(), "-storepass", hPwd.getStringValue());
        return this.runNoInputCommand(frame, "keytool", "-genseckey", "-keyalg", "AES", "-keysize", "256", "-alias", hName.getStringValue(), "-storetype", "PKCS12", "-keystore", hPath.getStringValue(), "-storepass", hPwd.getStringValue());
    }

    private ObjectHandle.ExceptionHandle invokeCreatePassword(Frame frame, ObjectHandle[] ahArg) {
        xString.StringHandle hPath = (xString.StringHandle)ahArg[0];
        xString.StringHandle hPwd = xRTKeyStore.getPassword(frame, ahArg[1]);
        xString.StringHandle hName = (xString.StringHandle)ahArg[2];
        xString.StringHandle hPwdValue = (xString.StringHandle)ahArg[3];
        this.runSilentCommand("keytool", "-delete", "-alias", hName.getStringValue(), "-keystore", hPath.getStringValue(), "-storepass", hPwd.getStringValue());
        return this.runCommand(frame, hPwdValue.getStringValue(), "keytool", "-importpass", "-alias", hName.getStringValue(), "-storetype", "PKCS12", "-keystore", hPath.getStringValue(), "-storepass", hPwd.getStringValue());
    }

    private int invokeExtractKey(Frame frame, ObjectHandle[] ahArg, int iReturn) {
        ObjectHandle hPathOrStore = ahArg[0];
        xString.StringHandle hPwd = xRTKeyStore.getPassword(frame, ahArg[1]);
        xString.StringHandle hName = (xString.StringHandle)ahArg[2];
        CompletableFuture<Key> cfResult = frame.f_context.f_container.scheduleIO(() -> this.loadKey(hPathOrStore, hPwd, hName));
        Frame.Continuation continuation = frameCaller -> {
            try {
                Key key = (Key)cfResult.get();
                return key == null ? frameCaller.raiseException(xException.ioException(frameCaller, "Invalid or inaccessible key \"" + hName.getStringValue() + "\"")) : frameCaller.assignValue(iReturn, xArray.makeByteArrayHandle(key.getEncoded(), xArray.Mutability.Constant));
            }
            catch (Throwable e) {
                return frameCaller.raiseException("Unexpected execution failure " + String.valueOf(e));
            }
        };
        return frame.waitForIO(cfResult, continuation);
    }

    private Key loadKey(ObjectHandle hPathOrStore, xString.StringHandle hPwd, xString.StringHandle hName) {
        try {
            KeyStore keyStore;
            char[] achPwd = hPwd.getValue();
            String sKey = hName.getStringValue();
            if (hPathOrStore instanceof xString.StringHandle) {
                xString.StringHandle hPath = (xString.StringHandle)hPathOrStore;
                File fileStore = new File(hPath.getStringValue());
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(new FileInputStream(fileStore), achPwd);
            } else {
                xRTKeyStore.KeyStoreHandle hKeyStore = (xRTKeyStore.KeyStoreHandle)hPathOrStore;
                keyStore = hKeyStore.f_keyStore;
            }
            return keyStore.getKey(sKey, achPwd);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ObjectHandle.ExceptionHandle invokeChangeStorePassword(Frame frame, ObjectHandle[] ahArg) {
        xString.StringHandle hPath = (xString.StringHandle)ahArg[0];
        xString.StringHandle hPwd = xRTKeyStore.getPassword(frame, ahArg[1]);
        xString.StringHandle hPwdNew = (xString.StringHandle)ahArg[2];
        return this.runNoInputCommand(frame, "keytool", "-storepasswd", "-keystore", hPath.getStringValue(), "-storepass", hPwd.getStringValue(), "-new ", hPwdNew.getStringValue());
    }

    private ObjectHandle.ExceptionHandle runSilentCommand(String ... cmd) {
        return this.runCommand(null, null, cmd);
    }

    private ObjectHandle.ExceptionHandle runNoInputCommand(Frame frame, String ... cmd) {
        return this.runCommand(frame, null, cmd);
    }

    private ObjectHandle.ExceptionHandle runCommand(Frame frame, String sInput, String ... cmd) {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        try {
            System.out.println("*** running command: " + this.toString(cmd));
            Process process = builder.start();
            if (sInput != null) {
                OutputStream out = process.getOutputStream();
                out.write(sInput.getBytes());
                out.close();
            }
            if (!process.waitFor(300L, TimeUnit.SECONDS)) {
                process.destroy();
                return xException.timedOut(frame, "Timed out: " + cmd[0], xNullable.NULL);
            }
            if (frame != null && process.exitValue() != 0) {
                String sOut = this.getOutput(process.getInputStream());
                String sErr = this.getOutput(process.getErrorStream());
                return xException.obscureIoException(frame, sOut + "\n" + sErr);
            }
            return null;
        }
        catch (Exception e) {
            return frame == null ? null : xException.makeObscure(frame, e.getMessage());
        }
    }

    private String getOutput(InputStream streamIn) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(streamIn));
        StringBuilder sb = new StringBuilder();
        try {
            String sLine;
            while ((sLine = reader.readLine()) != null) {
                if (!sb.isEmpty()) {
                    sb.append('\n');
                }
                sb.append(sLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    private String toString(String ... cmd) {
        StringBuilder sb = new StringBuilder();
        for (String s : cmd) {
            sb.append(' ').append(s);
        }
        return sb.substring(1);
    }
}

