/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt8Delegate;
import org.xvm.runtime.template._native.crypto.xRTAlgorithms;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;

public class xRTDecryptor
extends xService {
    public static xRTDecryptor INSTANCE;

    public xRTDecryptor(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("encrypt", new String[]{OBJECT[0], OBJECT[0], BYTES[0]}, BYTES);
        this.markNativeMethod("decrypt", new String[]{OBJECT[0], OBJECT[0], BYTES[0]}, BYTES);
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "encrypt": {
                return this.invokeEncrypt(frame, (xRTAlgorithms.CipherHandle)ahArg[0], ahArg[1], (ByteBasedDelegate.ByteArrayHandle)((xArray.ArrayHandle)ahArg[2]).m_hDelegate, iReturn);
            }
            case "decrypt": {
                return this.invokeDecrypt(frame, (xRTAlgorithms.CipherHandle)ahArg[0], ahArg[1], (ByteBasedDelegate.ByteArrayHandle)((xArray.ArrayHandle)ahArg[2]).m_hDelegate, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    private int invokeEncrypt(Frame frame, xRTAlgorithms.CipherHandle hCipher, ObjectHandle hKey, ByteBasedDelegate.ByteArrayHandle haData, int iReturn) {
        Cipher cipher = hCipher.f_cipher;
        byte[] abData = xRTUInt8Delegate.getBytes(haData);
        try {
            Key key = xRTAlgorithms.extractKey(frame, hKey, cipher.getAlgorithm(), xRTAlgorithms.KeyForm.PublicOrSecret);
            cipher.init(1, key);
            byte[] abEncoded = cipher.doFinal(abData);
            return frame.assignValue(iReturn, xArray.makeByteArrayHandle(abEncoded, xArray.Mutability.Constant));
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }

    private int invokeDecrypt(Frame frame, xRTAlgorithms.CipherHandle hCipher, ObjectHandle hKey, ByteBasedDelegate.ByteArrayHandle haData, int iReturn) {
        byte[] abData = xRTUInt8Delegate.getBytes(haData);
        Cipher cipher = hCipher.f_cipher;
        try {
            Key key = xRTAlgorithms.extractKey(frame, hKey, cipher.getAlgorithm(), xRTAlgorithms.KeyForm.PrivateOrSecret);
            cipher.init(2, key);
            byte[] abSig = cipher.doFinal(abData);
            return frame.assignValue(iReturn, xArray.makeByteArrayHandle(abSig, xArray.Mutability.Constant));
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }
}

