/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.crypto;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.crypto.interfaces.PBEKey;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.collections.arrays.xRTBooleanDelegate;
import org.xvm.runtime.template._native.crypto.xRTAlgorithms;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;

public class xRTKeyStore
extends xService {
    public static xRTKeyStore INSTANCE;
    private TypeConstant m_typeCanonical;
    private static TypeConstant s_typeNamedPassword;

    public xRTKeyStore(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("aliases");
        this.markNativeMethod("entryType", STRING, null);
        this.markNativeMethod("getKeyInfo", STRING, null);
        this.markNativeMethod("getCertificateInfo", null, null);
        this.markNativeMethod("getPasswordInfo", STRING, null);
        ConstantPool pool = this.pool();
        s_typeNamedPassword = pool.ensureClassConstant(pool.ensureModuleConstant("crypto.xtclang.org"), "CryptoPassword").getType();
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        TypeConstant type = this.m_typeCanonical;
        if (type == null) {
            ConstantPool pool = this.pool();
            this.m_typeCanonical = type = pool.ensureTerminalTypeConstant(pool.ensureClassConstant(pool.ensureModuleConstant("crypto.xtclang.org"), "KeyStore"));
        }
        return type;
    }

    public ObjectHandle ensureKeyStore(Frame frame, ObjectHandle hOpts) {
        try {
            ObjectHandle.GenericHandle hInfo = (ObjectHandle.GenericHandle)hOpts;
            xArray.ArrayHandle hContent = (xArray.ArrayHandle)hInfo.getField(frame, "content");
            xString.StringHandle hPwd = xRTKeyStore.getPassword(frame, hInfo.getField(frame, "password"));
            byte[] abStore = xByteArray.getBytes(hContent);
            char[] achPwd = hPwd.getValue();
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            ByteArrayInputStream in = new ByteArrayInputStream(abStore);
            keyStore.load(in, achPwd);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, achPwd);
            X509KeyManager keyManager = null;
            for (KeyManager mgr : keyManagerFactory.getKeyManagers()) {
                X509KeyManager m;
                if (!(mgr instanceof X509KeyManager)) continue;
                keyManager = m = (X509KeyManager)mgr;
                break;
            }
            if (keyManager == null) {
                return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "No X509KeyManager available"));
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore);
            X509TrustManager trustManager = null;
            for (TrustManager mgr : trustManagerFactory.getTrustManagers()) {
                X509TrustManager m;
                if (!(mgr instanceof X509TrustManager)) continue;
                trustManager = m = (X509TrustManager)mgr;
                break;
            }
            if (trustManager == null) {
                return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "No X509TrustManager available"));
            }
            ServiceContext context = this.f_container.createServiceContext("KeyStore");
            ClassComposition clzStore = this.getCanonicalClass(this.f_container);
            KeyStoreHandle hService = new KeyStoreHandle(clzStore, context, keyStore, achPwd, keyManager, trustManager);
            context.setService(hService);
            MethodStructure ctor = this.f_struct.findConstructor(new TypeConstant[0]);
            assert (ctor != null);
            CallChain chain = clzStore.getMethodCallChain(ctor.getIdentityConstant().getSignature());
            switch (this.invoke1(frame, chain, hService, Utils.OBJECTS_NONE, -2)) {
                case -1: {
                    return hService;
                }
                case -5: {
                    Frame frameNext = frame.m_frameNext;
                    frameNext.addContinuation(frameCaller -> frameCaller.pushStack(hService));
                    return new ObjectHandle.DeferredCallHandle(frameNext);
                }
            }
            throw new IllegalStateException();
        }
        catch (Exception e) {
            return new ObjectHandle.DeferredCallHandle(xException.makeObscure(frame, "Illegal KeyStore arguments: " + e.getMessage()));
        }
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "aliases": {
                KeyStoreHandle hStore = (KeyStoreHandle)hTarget;
                try {
                    ArrayList<String> listNames = Collections.list(hStore.f_keyStore.aliases());
                    return frame.assignValue(iReturn, xString.makeArrayHandle(listNames.toArray(Utils.NO_NAMES)));
                }
                catch (KeyStoreException e) {
                    return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
                }
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "entryType": {
                KeyStoreHandle hStore = (KeyStoreHandle)hTarget;
                xString.StringHandle hName = (xString.StringHandle)ahArg[0];
                return this.invokeEntryType(frame, hStore, hName, aiReturn);
            }
            case "getCertificateInfo": {
                KeyStoreHandle hStore = (KeyStoreHandle)hTarget;
                xString.StringHandle hName = (xString.StringHandle)ahArg[0];
                ObjectHandle.JavaLong hIndex = (ObjectHandle.JavaLong)ahArg[1];
                return this.invokeGetCertificateInfo(frame, hStore, hName, hIndex, aiReturn);
            }
            case "getKeyInfo": {
                KeyStoreHandle hStore = (KeyStoreHandle)hTarget;
                xString.StringHandle hName = (xString.StringHandle)ahArg[0];
                return this.invokeGetKeyInfo(frame, hStore, hName, aiReturn);
            }
            case "getPasswordInfo": {
                KeyStoreHandle hStore = (KeyStoreHandle)hTarget;
                xString.StringHandle hName = (xString.StringHandle)ahArg[0];
                return this.invokeGetPasswordInfo(frame, hStore, hName, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    private int invokeGetCertificateInfo(Frame frame, KeyStoreHandle hStore, xString.StringHandle hName, ObjectHandle.JavaLong hIndex, int[] aiReturn) {
        String sName = hName.getStringValue();
        int nIndex = (int)hIndex.getValue();
        try {
            Certificate[] aCert = hStore.f_keyStore.getCertificateChain(sName);
            if (aCert == null || aCert.length <= nIndex) {
                return frame.assignValue(aiReturn[0], xBoolean.FALSE);
            }
            Certificate certificate = aCert[nIndex];
            if (!(certificate instanceof X509Certificate)) {
                return frame.raiseException(xException.makeHandle(frame, "Unsupported standard: " + aCert[nIndex].getType()));
            }
            X509Certificate cert509 = (X509Certificate)certificate;
            Date dateNotBefore = cert509.getNotBefore();
            Date dateNotAfter = cert509.getNotAfter();
            if (dateNotBefore == null || dateNotAfter == null) {
                return frame.assignValue(aiReturn[0], xBoolean.FALSE);
            }
            String sIssuer = cert509.getIssuerX500Principal().toString();
            String sSubject = cert509.getSubjectX500Principal().toString();
            int nVersion = cert509.getVersion();
            boolean[] afUsage = cert509.getKeyUsage();
            if (afUsage == null) {
                afUsage = new boolean[]{};
            }
            int cUsage = afUsage.length;
            byte[] abUsage = xRTBooleanDelegate.toBytes(afUsage);
            String sSigAlgName = cert509.getSigAlgName();
            byte[] abSignature = cert509.getSignature();
            PublicKey publicKey = cert509.getPublicKey();
            String sAlgorithm = publicKey.getAlgorithm();
            int cKeyBits = xRTKeyStore.getPublicKeyLength(publicKey);
            byte[] abPublic = publicKey.getEncoded();
            byte[] abDer = cert509.getEncoded();
            ArrayList<ObjectHandle> list = new ArrayList<ObjectHandle>(9);
            list.add(xBoolean.TRUE);
            list.add(xString.makeHandle(sIssuer));
            list.add(xString.makeHandle(sSubject));
            list.add(xInt64.makeHandle(nVersion));
            xRTKeyStore.addDate(dateNotBefore, list);
            xRTKeyStore.addDate(dateNotAfter, list);
            list.add(xArray.makeBooleanArrayHandle(abUsage, cUsage, xArray.Mutability.Constant));
            list.add(xString.makeHandle(sSigAlgName));
            list.add(xByteArray.makeByteArrayHandle(abSignature, xArray.Mutability.Constant));
            list.add(xString.makeHandle(sAlgorithm));
            list.add(xInt64.makeHandle(cKeyBits >>> 3));
            list.add(xByteArray.makeByteArrayHandle(abPublic, xArray.Mutability.Constant));
            list.add(new xRTAlgorithms.SecretHandle(publicKey));
            list.add(xByteArray.makeByteArrayHandle(abDer, xArray.Mutability.Constant));
            return frame.assignValues(aiReturn, list.toArray(Utils.OBJECTS_NONE));
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }

    private static void addDate(Date date, List<ObjectHandle> list) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        list.add(xInt64.makeHandle(cal.get(1)));
        list.add(xInt64.makeHandle(cal.get(2) + 1));
        list.add(xInt64.makeHandle(cal.get(5)));
    }

    private static int getPublicKeyLength(PublicKey puk) throws InvalidKeyException {
        if (puk instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)puk;
            return rsaKey.getModulus().bitLength();
        }
        if (puk instanceof DSAPublicKey) {
            DSAPublicKey dsaKey = (DSAPublicKey)puk;
            DSAParams params = dsaKey.getParams();
            return params == null ? dsaKey.getY().bitLength() : params.getP().bitLength();
        }
        if (puk instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)puk;
            ECParameterSpec spec = ecKey.getParams();
            return spec == null ? 0 : spec.getOrder().bitLength();
        }
        throw new InvalidKeyException("Unsupported key: " + String.valueOf(puk));
    }

    private int invokeEntryType(Frame frame, KeyStoreHandle hStore, xString.StringHandle hName, int[] aiReturn) {
        KeyStore keyStore = hStore.f_keyStore;
        String sName = hName.getStringValue();
        try {
            if (keyStore.isKeyEntry(sName)) {
                int nType;
                if (keyStore.getCertificate(sName) == null) {
                    Key key = hStore.getKey(sName);
                    assert (key != null);
                    nType = key instanceof PBEKey || "PBEKey".equals(key.getClass().getSimpleName()) ? 3 : 1;
                } else {
                    nType = 1;
                }
                return frame.assignValues(aiReturn, xBoolean.TRUE, xInt64.makeHandle(nType));
            }
            if (keyStore.isCertificateEntry(sName)) {
                return frame.assignValues(aiReturn, xBoolean.TRUE, xInt64.makeHandle(1L));
            }
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }

    private int invokeGetKeyInfo(Frame frame, KeyStoreHandle hStore, xString.StringHandle hName, int[] aiReturn) {
        KeyStore keyStore = hStore.f_keyStore;
        String sName = hName.getStringValue();
        try {
            if (keyStore.isKeyEntry(sName)) {
                int n;
                Key key = hStore.getKey(sName);
                if (key == null) {
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                String sAlgorithm = key.getAlgorithm();
                PublicKey publicKey = null;
                byte[] abPublic = null;
                Certificate cert = keyStore.getCertificate(sName);
                if (cert != null) {
                    publicKey = cert.getPublicKey();
                    abPublic = publicKey.getEncoded();
                }
                if (key instanceof RSAPrivateKey) {
                    RSAPrivateKey privateKey = (RSAPrivateKey)key;
                    n = privateKey.getModulus().bitLength();
                } else {
                    n = key.getEncoded().length << 3;
                }
                int cKeyBits = n;
                ArrayList<ObjectHandle> list = new ArrayList<ObjectHandle>(9);
                list.add(xBoolean.TRUE);
                list.add(xString.makeHandle(sAlgorithm));
                list.add(xInt64.makeHandle(cKeyBits >>> 3));
                list.add(new xRTAlgorithms.SecretHandle(key));
                if (publicKey == null) {
                    list.add(xNullable.NULL);
                    list.add(xArray.ensureEmptyByteArray());
                } else {
                    list.add(new xRTAlgorithms.SecretHandle(publicKey));
                    list.add(xArray.makeByteArrayHandle(abPublic, xArray.Mutability.Constant));
                }
                return frame.assignValues(aiReturn, list.toArray(Utils.OBJECTS_NONE));
            }
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }

    private int invokeGetPasswordInfo(Frame frame, KeyStoreHandle hStore, xString.StringHandle hName, int[] aiReturn) {
        String sName = hName.getStringValue();
        try {
            Key key = hStore.getKey(sName);
            if (key instanceof PBEKey) {
                PBEKey keyPwd = (PBEKey)key;
                return frame.assignValues(aiReturn, xBoolean.TRUE, xString.makeHandle(keyPwd.getPassword()));
            }
            if ("PBEKey".equals(key.getClass().getSimpleName())) {
                return frame.assignValues(aiReturn, xBoolean.TRUE, xString.makeHandle(new String(key.getEncoded(), StandardCharsets.UTF_8)));
            }
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }

    public static xString.StringHandle getPassword(Frame frame, ObjectHandle hPwd) {
        if (hPwd instanceof xString.StringHandle) {
            xString.StringHandle hString = (xString.StringHandle)hPwd;
            return hString;
        }
        if ((hPwd = hPwd.revealAs(frame, s_typeNamedPassword)) instanceof ObjectHandle.GenericHandle) {
            ObjectHandle.GenericHandle hNamed = (ObjectHandle.GenericHandle)hPwd;
            return (xString.StringHandle)hNamed.getField(null, "password");
        }
        return xString.EMPTY_STRING;
    }

    public static class KeyStoreHandle
    extends xService.ServiceHandle {
        public final KeyStore f_keyStore;
        private final char[] f_achPwd;
        public final X509KeyManager f_keyManager;
        public final X509TrustManager f_trustManager;

        public KeyStoreHandle(TypeComposition clz, ServiceContext ctx, KeyStore keyStore, char[] achPwd, X509KeyManager keyManager, X509TrustManager trustManager) {
            super(clz, ctx);
            this.f_keyStore = keyStore;
            this.f_achPwd = achPwd;
            this.f_keyManager = keyManager;
            this.f_trustManager = trustManager;
        }

        public Key getKey(String sName) throws GeneralSecurityException {
            return this.f_keyStore.getKey(sName, this.f_achPwd);
        }
    }
}

